/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.slots.SlotBuzzSaw;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.helpers.TreeFarmHelper;
import gtPlusPlus.xmod.gregtech.common.helpers.treefarm.TreeGenerator;
import ic2.api.item.ElectricItem;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntityTreeFarm
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntityTreeFarm> {
    public static int CASING_TEXTURE_ID;
    public static String mCasingName;
    public static TreeGenerator mTreeData;
    private ItemStack mTreeType;
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntityTreeFarm> STRUCTURE_DEFINITION = null;
    private static HashMap<String, ItemStack> sLogCache;
    private SlotBuzzSaw.SAWTOOL mToolType;
    private ItemStack currSapling;
    private int currSlot = 0;
    private GT_MetaTileEntity_Hatch_InputBus currInputBus;
    private int mPossibleRecursion = 0;
    private static int sRecipeID;
    private static Fluid sFertFluid;

    public GregtechMetaTileEntityTreeFarm(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(1, 15);
    }

    public GregtechMetaTileEntityTreeFarm(String aName) {
        super(aName);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(1, 15);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntityTreeFarm(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Tree Farm";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Converts EU to Logs").addInfo("Eu Usage: 100% | Parallel: 1").addInfo("Requires a Saw or Chainsaw in GUI slot").addInfo("Output multiplier:").addInfo("Saw = 1x").addInfo("Buzzsaw = 2x").addInfo("Chainsaw = 4x").addInfo("Add a sapling in the input bus to change wood type output").addInfo("Tools can also be fed to the controller via input bus").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfo("Sterile Farm Casing", 8).addInputBus("Any casing", new int[]{1}).addOutputBus("Any casing", new int[]{1}).addEnergyHatch("Any casing", new int[]{1}).addMaintenanceHatch("Any casing", new int[]{1}).addMufflerHatch("Any casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)CASING_TEXTURE_ID), TextureFactory.of((IIconContainer)(aActive ? TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active : TexturesGtBlock.Overlay_Machine_Controller_Advanced))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)CASING_TEXTURE_ID)};
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    @Override
    public boolean requiresVanillaGtGUI() {
        return true;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "VacuumFreezer";
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return TreeFarmHelper.isValidForGUI(aStack) && !GT_ModHandler.isElectricItem((ItemStack)aStack) || GT_ModHandler.canUseElectricItem((ItemStack)aStack, (int)1);
    }

    public boolean checkRecipe(ItemStack aStack) {
        if (aStack == null && !this.replaceTool()) {
            return false;
        }
        if (!this.isCorrectMachinePart(aStack)) {
            return false;
        }
        this.mToolType = TreeFarmHelper.isCorrectMachinePart(aStack);
        int aModifier = this.mToolType == SlotBuzzSaw.SAWTOOL.SAW ? 1 : (this.mToolType == SlotBuzzSaw.SAWTOOL.BUZZSAW ? 2 : (this.mToolType == SlotBuzzSaw.SAWTOOL.CHAINSAW ? 4 : 0));
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        this.mMaxProgresstime = 100;
        this.mEUt = (int)tVoltage;
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mEUt <= 16) {
            this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
            this.mMaxProgresstime /= 1 << tTier - 1;
        } else {
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                this.mMaxProgresstime /= 2;
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.getWoodFromSapling();
        try {
            int i;
            int aFullStacks;
            int aOutputAmount;
            int aFert = this.hasLiquidFert();
            if (aFert > 0) {
                aOutputAmount = (2 * (tTier * tTier) - 2 * tTier + 5) * (this.mMaxProgresstime / 20) / 10;
                if (aFert < aOutputAmount) {
                    aOutputAmount /= 10;
                }
                if (aFert >= aOutputAmount && this.tryConsumeLiquidFert(aOutputAmount)) {
                    aFullStacks = aOutputAmount / 64;
                    for (i = 0; i < aFullStacks; ++i) {
                        this.addOutput(ItemUtils.getSimpleStack(this.currSapling, 64));
                        aOutputAmount -= 64;
                    }
                    this.addOutput(ItemUtils.getSimpleStack(this.currSapling, aOutputAmount));
                }
            }
            aOutputAmount = (2 * (tTier * tTier) - 2 * tTier + 5) * (this.mMaxProgresstime / 20) * aModifier;
            aFullStacks = aOutputAmount / 64;
            for (i = 0; i < aFullStacks; ++i) {
                this.addOutput(ItemUtils.getSimpleStack(this.mTreeType, 64));
                aOutputAmount -= 64;
            }
            this.addOutput(ItemUtils.getSimpleStack(this.mTreeType, aOutputAmount));
            this.updateSlots();
        }
        catch (Throwable t) {
            t.printStackTrace(GT_Log.err);
        }
        return true;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 8 && this.checkHatch();
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public IStructureDefinition<GregtechMetaTileEntityTreeFarm> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntityTreeFarm::addTreeFarmList, (int)CASING_TEXTURE_ID, (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)15))})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public final boolean addTreeFarmList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        return this.addToMachineList(aTileEntity, aBaseCasingIndex);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiTreeFarm;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return MathUtils.balance((int)(75L - GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)aStack).getMass()), 5, 120);
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public boolean replaceTool() {
        if (this.mPossibleRecursion > 32) {
            this.mPossibleRecursion = 0;
            return false;
        }
        ItemStack invItem = this.mInventory[1];
        if (invItem == null) {
            ArrayList aInputs = this.getStoredInputs();
            for (ItemStack aStack : aInputs) {
                if (aStack == null || !this.isCorrectMachinePart(aStack)) continue;
                this.setGUIItemStack(aStack.func_77946_l());
                this.depleteInput(aStack);
                this.mPossibleRecursion = 0;
                return true;
            }
        } else if (GT_ModHandler.isElectricItem((ItemStack)invItem) && ElectricItem.manager.getCharge(invItem) < 32.0) {
            this.addOutput(invItem.func_77946_l());
            this.setGUIItemStack(null);
            ++this.mPossibleRecursion;
            return this.replaceTool();
        }
        this.mPossibleRecursion = 0;
        return false;
    }

    public void getWoodFromSapling() {
        ItemStack uStack;
        if (sLogCache.size() == 0) {
            GregtechMetaTileEntityTreeFarm.loadMapWoodFromSapling();
        }
        if (this.currSapling != null && this.currInputBus != null && (uStack = this.currInputBus.mInventory[this.currSlot]) == this.currSapling) {
            return;
        }
        for (GT_MetaTileEntity_Hatch_InputBus mInputBus : this.mInputBusses) {
            for (int i = 0; i < mInputBus.mInventory.length; ++i) {
                String registryName;
                ItemStack aWood;
                ItemStack uStack2 = mInputBus.mInventory[i];
                if (uStack2 == null || (aWood = sLogCache.get((registryName = Item.field_150901_e.func_148750_c((Object)uStack2.func_77973_b())) + ":" + uStack2.func_77960_j())) == null) continue;
                this.currSapling = uStack2;
                this.currInputBus = mInputBus;
                this.currSlot = i;
                this.mTreeType = aWood;
                return;
            }
            this.mTreeType = new ItemStack(Blocks.field_150364_r, 1, 0);
        }
    }

    public static void loadMapWoodFromSapling() {
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("GalaxySpace:barnardaCsapling:0", GT_ModHandler.getModItem((String)"GalaxySpace", (String)"barnardaClog", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:sapling:0", new ItemStack(Blocks.field_150364_r, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:sapling:1", new ItemStack(Blocks.field_150364_r, 1, 1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:sapling:2", new ItemStack(Blocks.field_150364_r, 1, 2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:sapling:3", new ItemStack(Blocks.field_150364_r, 1, 3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:sapling:4", new ItemStack(Blocks.field_150363_s, 1, 0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:sapling:5", new ItemStack(Blocks.field_150363_s, 1, 1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("IC2:blockRubSapling:0", GT_ModHandler.getModItem((String)"IC2", (String)"blockRubWood", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:1", GT_ModHandler.getModItem((String)"Natura", (String)"tree", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:2", GT_ModHandler.getModItem((String)"Natura", (String)"tree", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:3", GT_ModHandler.getModItem((String)"Natura", (String)"tree", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:4", GT_ModHandler.getModItem((String)"Natura", (String)"tree", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:5", GT_ModHandler.getModItem((String)"Natura", (String)"bloodwood", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:6", GT_ModHandler.getModItem((String)"Natura", (String)"Dark Tree", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:florasapling:7", GT_ModHandler.getModItem((String)"Natura", (String)"Dark Tree", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:Rare Sapling:0", GT_ModHandler.getModItem((String)"Natura", (String)"Rare Tree", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:Rare Sapling:1", GT_ModHandler.getModItem((String)"Natura", (String)"Rare Tree", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:Rare Sapling:2", GT_ModHandler.getModItem((String)"Natura", (String)"Rare Tree", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:Rare Sapling:3", GT_ModHandler.getModItem((String)"Natura", (String)"Rare Tree", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Natura:Rare Sapling:4", GT_ModHandler.getModItem((String)"Natura", (String)"willow", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:0", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs1", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:1", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs2", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:2", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs2", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:3", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs3", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:4", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs3", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:5", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs4", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:colorizedSaplings:6", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs4", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:2", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"bamboo", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:3", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs2", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:4", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs1", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:5", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs3", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:6", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs1", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:7", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs2", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:10", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs1", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:12", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs1", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:13", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs4", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("BiomesOPlenty:saplings:14", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs4", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:yellow_flower:0", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs3", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("minecraft:red_flower:0", GT_ModHandler.getModItem((String)"BiomesOPlenty", (String)"logs3", (long)1L, (int)3));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("witchery:witchsapling:0", GT_ModHandler.getModItem((String)"witchery", (String)"witchlog", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("witchery:witchsapling:1", GT_ModHandler.getModItem((String)"witchery", (String)"witchlog", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("witchery:witchsapling:2", GT_ModHandler.getModItem((String)"witchery", (String)"witchlog", (long)1L, (int)2));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TConstruct:slime.sapling:0", GT_ModHandler.getModItem((String)"TConstruct", (String)"slime.gel", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("TaintedMagic:BlockWarpwoodSapling:0", GT_ModHandler.getModItem((String)"TaintedMagic", (String)"BlockWarpwoodLog", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Thaumcraft:blockCustomPlant:0", GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockMagicalLog", (long)1L, (int)0));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("Thaumcraft:blockCustomPlant:1", GT_ModHandler.getModItem((String)"Thaumcraft", (String)"blockMagicalLog", (long)1L, (int)1));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("miscutils:blockRainforestOakSapling:0", GT_ModHandler.getModItem((String)"miscutils", (String)"blockRainforestOakLog", (long)1L));
        GregtechMetaTileEntityTreeFarm.mapSaplingToLog("miscutils:blockPineSapling:0", GT_ModHandler.getModItem((String)"miscutils", (String)"blockPineLogLog", (long)1L));
    }

    public boolean tryDamageTool(ItemStack invItem) {
        long aDmgMax;
        long aDmg;
        if (invItem != null && invItem.func_77973_b() instanceof GT_MetaGenerated_Tool && (aDmg = GT_MetaGenerated_Tool.getToolDamage((ItemStack)invItem)) < (aDmgMax = GT_MetaGenerated_Tool.getToolMaxDamage((ItemStack)invItem)) && GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)invItem) != Materials._NULL) {
            return GT_ModHandler.damageOrDechargeItem((ItemStack)invItem, (int)1, (int)32, null);
        }
        return false;
    }

    public boolean doRandomMaintenanceDamage() {
        ItemStack tSaw = this.mInventory[1];
        if (!this.isCorrectMachinePart(tSaw) || this.getRepairStatus() == 0) {
            this.stopMachine();
            return false;
        }
        if (CORE.RANDOM.nextInt(200) == 0 && !this.tryDamageTool(tSaw)) {
            this.mInventory[1] = null;
            if (!this.replaceTool()) {
                this.getBaseMetaTileEntity().disableWorking();
            }
            this.tryDamageTool(tSaw);
        }
        return super.doRandomMaintenanceDamage();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        this.replaceTool();
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public static void mapSaplingToLog(String aSapling, ItemStack aLog) {
        ItemStack aSaplingStack = ItemUtils.getItemStackFromFQRN(aSapling, 1);
        if (aSaplingStack != null && aLog != null) {
            sLogCache.put(aSapling, aLog);
            GregtechMetaTileEntityTreeFarm.addFakeRecipeToNEI(aSaplingStack, aLog);
        } else {
            Logger.INFO("Unable to add Tree Growth Simulation for " + aSapling);
        }
    }

    public static boolean addFakeRecipeToNEI(ItemStack aSapling, ItemStack aLog) {
        if (sFertFluid == null) {
            sFertFluid = ModItems.fluidFertBasic;
        }
        int aRecipes = GTPP_Recipe.GTPP_Recipe_Map.sTreeSimFakeRecipes.mRecipeList.size();
        Logger.INFO("Adding Tree Growth Simulation for " + aSapling.func_82833_r() + " -> " + aLog.func_82833_r());
        ItemStack[] aOutput = new ItemStack[]{aLog, aSapling};
        GT_Recipe aRecipe = new GT_Recipe(false, new ItemStack[]{aSapling.func_77946_l()}, aOutput, null, new int[]{10000, 1000}, new FluidStack[]{FluidUtils.getFluidStack(sFertFluid, 1)}, new FluidStack[0], 1, sRecipeID++, 0);
        aRecipe.mOutputs = aOutput;
        String aOutputs = ItemUtils.getArrayStackNames(aRecipe.mOutputs);
        Logger.INFO("" + aOutputs);
        GTPP_Recipe.GTPP_Recipe_Map.sTreeSimFakeRecipes.addFakeRecipe(false, aRecipe);
        return GTPP_Recipe.GTPP_Recipe_Map.sTreeSimFakeRecipes.mRecipeList.size() > aRecipes;
    }

    public int hasLiquidFert() {
        if (sFertFluid == null) {
            sFertFluid = ModItems.fluidFertBasic;
        }
        ArrayList aFluids = this.getStoredFluids();
        for (FluidStack aFluid : aFluids) {
            if (aFluid.getFluid() != sFertFluid) continue;
            return aFluid.amount;
        }
        return 0;
    }

    public boolean tryConsumeLiquidFert(int aFluidAmount) {
        if (sFertFluid == null) {
            sFertFluid = ModItems.fluidFertBasic;
        }
        return this.depleteInput(FluidUtils.getFluidStack(sFertFluid, aFluidAmount));
    }

    static {
        mCasingName = "Sterile Farm Casing";
        sLogCache = new HashMap();
        sRecipeID = 0;
    }
}

