/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.gregtech.PollutionUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntityGeneratorArray
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntityGeneratorArray> {
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntityGeneratorArray> STRUCTURE_DEFINITION = null;
    public String mMachine = "";
    protected int fuelConsumption = 0;
    protected int fuelValue = 0;
    protected int fuelRemaining = 0;
    protected boolean boostEu = false;
    int mMode = 0;
    private static final int MODE_STEAM = 0;
    private static final int MODE_DIESEL = 1;
    private static final int MODE_GAS = 2;
    private static final int MODE_SEMIFLUID = 3;
    private static final int MODE_GEOTHERMAL = 4;
    private static final int MODE_ROCKETFUEL = 5;
    private static final int MODE_MAGIC_A = 6;
    private static final int MODE_MAGIC_B_DISABLED = 7;
    private static final int MODE_PLASMA = 8;
    private static final int MODE_NAQUADAH = 9;
    private static final int MODE_NONE = 100;
    private static final int[] ID_STEAM = new int[]{962, 1120, 1121, 1122};
    private static final int[] ID_GAS = new int[]{961, 1115, 1116, 1117};
    private static final int[] ID_DIESEL = new int[]{960, 1110, 1111, 1112};
    private static final int[] ID_SEMIFLUID = new int[]{837, 838, 839};
    private static final int[] ID_GEOTHERMAL = new int[]{830, 831, 832};
    private static final int[] ID_ROCKETFUEL = new int[]{793, 794, 795};
    private static final int[] ID_MAGIC_A = new int[]{1123, 1124, 1125};
    private static final int[] ID_MAGIC_B_DISABLED = new int[]{1127, 1128, 1129, 1130};
    private static final int[] ID_PLASMA = new int[]{1196, 1197, 1198};
    private static final int[] ID_NAQUADAH = new int[]{1190, 1191, 1192};

    public GregtechMetaTileEntityGeneratorArray(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntityGeneratorArray(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntityGeneratorArray(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Processing Array";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Generator Array").addInfo("Runs supplied generators as if placed in the world").addInfo("Place up to 16 Single Block GT Generators into the Controller").addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfo("Robust Tungstensteel Machine Casings", 10).addInputBus("Any casing", new int[]{1}).addOutputBus("Any casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addDynamoHatch("Any casing", new int[]{1}).addMaintenanceHatch("Any casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)48), new GT_RenderedTexture((IIconContainer)(aActive ? TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active : TexturesGtBlock.Overlay_Machine_Controller_Advanced))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)48)};
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "ProcessingArray";
    }

    @Override
    public boolean requiresVanillaGtGUI() {
        return true;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        this.mMode = GregtechMetaTileEntityGeneratorArray.getModeFromInventorySlot(this.getGUIItemStack());
        if (this.mMode == 100) {
            return null;
        }
        if (this.mMode == 0) {
            return GTPP_Recipe.GTPP_Recipe_Map.sSteamTurbineFuels;
        }
        if (this.mMode == 1) {
            return GT_Recipe.GT_Recipe_Map.sDieselFuels;
        }
        if (this.mMode == 2) {
            return GT_Recipe.GT_Recipe_Map.sTurbineFuels;
        }
        if (this.mMode == 3) {
            return GTPP_Recipe.GTPP_Recipe_Map.sSemiFluidLiquidFuels;
        }
        if (this.mMode == 4) {
            return GTPP_Recipe.GTPP_Recipe_Map.sThermalFuels;
        }
        if (this.mMode == 5) {
            return GTPP_Recipe.GTPP_Recipe_Map.sRocketFuels;
        }
        if (this.mMode == 6) {
            return GT_Recipe.GT_Recipe_Map.sMagicFuels;
        }
        if (this.mMode == 8) {
            return GT_Recipe.GT_Recipe_Map.sPlasmaFuels;
        }
        if (this.mMode == 9) {
            return GT_Recipe.GT_Recipe_Map.sFluidNaquadahReactorFuels;
        }
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return aStack != null && aStack.func_77977_a().startsWith("gt.blockmachines.");
    }

    private static final int getModeFromInventorySlot(ItemStack aStack) {
        String aItemStackName;
        if (aStack == null) {
            return 100;
        }
        String string = aItemStackName = aStack == null ? "" : aStack.func_77977_a();
        if (aItemStackName.toLowerCase().contains("gt.blockmachines")) {
            for (int g : ID_STEAM) {
                if (aStack.func_77960_j() != g) continue;
                return 0;
            }
            for (int g : ID_GAS) {
                if (aStack.func_77960_j() != g) continue;
                return 2;
            }
            for (int g : ID_DIESEL) {
                if (aStack.func_77960_j() != g) continue;
                return 1;
            }
            for (int g : ID_SEMIFLUID) {
                if (aStack.func_77960_j() != g) continue;
                return 3;
            }
            for (int g : ID_GEOTHERMAL) {
                if (aStack.func_77960_j() != g) continue;
                return 4;
            }
            for (int g : ID_ROCKETFUEL) {
                if (aStack.func_77960_j() != g) continue;
                return 5;
            }
            for (int g : ID_MAGIC_A) {
                if (aStack.func_77960_j() != g) continue;
                return 6;
            }
            for (int g : ID_PLASMA) {
                if (aStack.func_77960_j() != g) continue;
                return 8;
            }
            for (int g : ID_NAQUADAH) {
                if (aStack.func_77960_j() != g) continue;
                return 9;
            }
        }
        return 100;
    }

    public boolean checkRecipe(ItemStack aStack) {
        int aMulti;
        this.resetRecipeMapForAllInputHatches();
        this.mMode = GregtechMetaTileEntityGeneratorArray.getModeFromInventorySlot(aStack);
        if (this.mMode == 100) {
            Logger.INFO("Did not find valid generator.");
            return false;
        }
        Logger.INFO("Changed Mode to " + this.mMode);
        int n = aMulti = this.getGUIItemStack() != null ? this.getGUIItemStack().field_77994_a : 0;
        if (aMulti > 16 || aMulti == 0) {
            return false;
        }
        ArrayList tFluids = this.getStoredFluids();
        Collection tRecipeList = this.getRecipeMap().mRecipeList;
        Logger.INFO("Got Recipe Map");
        if (tFluids.size() > 0 && tRecipeList != null) {
            Logger.INFO("Found Fuels for Map.");
            Iterator arg3 = tFluids.iterator();
            int aCount = 0;
            while (arg3.hasNext()) {
                FluidStack hatchFluid1 = (FluidStack)arg3.next();
                Logger.INFO("Iterating Fluid Found " + aCount++ + " | " + hatchFluid1.getLocalizedName());
                Iterator arg5 = tRecipeList.iterator();
                int Hatch = 0;
                int totalFuelValue = 0;
                while (arg5.hasNext()) {
                    Logger.INFO("Iterating Recipe " + Hatch++);
                    GT_Recipe aFuel = (GT_Recipe)arg5.next();
                    boolean addedFuelOnce = false;
                    for (int a = 0; a < aMulti; ++a) {
                        FluidStack tLiquid = GT_Utility.getFluidForFilledItem((ItemStack)aFuel.getRepresentativeInput(0), (boolean)true);
                        if (tLiquid == null || !hatchFluid1.isFluidEqual(tLiquid)) continue;
                        tLiquid.amount = this.boostEu ? 4096 / aFuel.mSpecialValue : 2048 / aFuel.mSpecialValue;
                        this.fuelConsumption = tLiquid.amount;
                        if (!this.depleteInput(tLiquid)) continue;
                        Logger.INFO("Depleted Fuel");
                        this.boostEu = this.depleteInput(Materials.Oxygen.getGas(2L));
                        if (this.mRuntime % 72 == 0 || this.mRuntime == 0) {
                            this.depleteInput(Materials.Lubricant.getFluid(this.boostEu ? 2L : 1L));
                        }
                        Logger.INFO("ADDING POWER");
                        this.fuelRemaining = hatchFluid1.amount;
                        ++totalFuelValue;
                    }
                    if (totalFuelValue != aMulti) continue;
                    this.fuelValue = aFuel.mSpecialValue * aMulti;
                    this.mEUt = this.mEfficiency < 2000 ? 0 : aFuel.mSpecialValue * aMulti;
                    this.mProgresstime = aMulti;
                    this.mMaxProgresstime = aMulti;
                    this.mEfficiencyIncrease = 15 * aMulti;
                    return true;
                }
            }
        }
        this.mEUt = 0;
        this.mEfficiency = 0;
        return false;
    }

    public static ItemStack[] clean(ItemStack[] v) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(Arrays.asList(v));
        list.removeAll(Collections.singleton(null));
        return list.toArray(new ItemStack[list.size()]);
    }

    public IStructureDefinition<GregtechMetaTileEntityGeneratorArray> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntityGeneratorArray::addGeneratorArrayList, (int)48, (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings4, (int)0))})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 10;
    }

    public final boolean addGeneratorArrayList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public void tryProcessFuelItems(IGregTechTileEntity aBaseMetaTileEntity, ItemStack a) {
        ItemStack tEmptyContainer1;
        int tFuelValue;
        if (a != null && aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() * 20L + this.getMinimumStoredEU() && GT_Utility.getFluidForFilledItem((ItemStack)a, (boolean)true) == null && (tFuelValue = this.getFuelValue(a)) > 0 && this.addOutput(tEmptyContainer1 = this.getEmptyContainer(a))) {
            aBaseMetaTileEntity.increaseStoredEnergyUnits((long)tFuelValue, true);
            this.depleteInput(a);
            PollutionUtils.addPollution(this.getBaseMetaTileEntity(), 10 * this.getPollutionPerTick(null));
        }
    }

    public void tryProcessFuel(IGregTechTileEntity aBaseMetaTileEntity, long aTick, FluidStack mFluid) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && aTick % 10L == 0L && mFluid != null) {
            long tFluidAmountToUse;
            int tFuelValue = this.getFuelValue(mFluid);
            int tEmptyContainer = this.consumedFluidPerOperation(mFluid);
            if (tFuelValue > 0 && tEmptyContainer > 0 && mFluid.amount > tEmptyContainer && (tFluidAmountToUse = Math.min((long)(mFluid.amount / tEmptyContainer), (this.maxEUStore() - aBaseMetaTileEntity.getUniversalEnergyStored()) / (long)tFuelValue)) > 0L && aBaseMetaTileEntity.increaseStoredEnergyUnits(tFluidAmountToUse * (long)tFuelValue, true)) {
                PollutionUtils.addPollution(this.getBaseMetaTileEntity(), 10 * this.getPollutionPerTick(null));
                mFluid.amount = (int)((long)mFluid.amount - tFluidAmountToUse * (long)tEmptyContainer);
            }
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            aBaseMetaTileEntity.setActive(aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.getUniversalEnergyStored() >= this.maxEUOutput() + this.getMinimumStoredEU());
        }
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return this.getFuelValue(aFluid) > 0;
    }

    public int consumedFluidPerOperation(FluidStack aLiquid) {
        return 1;
    }

    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid != null && this.getRecipeMap() != null) {
            Collection tRecipeList = this.getRecipeMap().mRecipeList;
            if (tRecipeList != null) {
                for (GT_Recipe tFuel : tRecipeList) {
                    FluidStack tLiquid = GT_Utility.getFluidForFilledItem((ItemStack)tFuel.getRepresentativeInput(0), (boolean)true);
                    if (tLiquid == null || !aLiquid.isFluidEqual(tLiquid)) continue;
                    return (int)((long)tFuel.mSpecialValue * (long)this.mEfficiency * (long)this.consumedFluidPerOperation(tLiquid) / 100L);
                }
            }
            return 0;
        }
        return 0;
    }

    public int getFuelValue(ItemStack aStack) {
        if (!GT_Utility.isStackInvalid((Object)aStack) && this.getRecipeMap() != null) {
            GT_Recipe tFuel = this.getRecipeMap().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, (FluidStack[])null, new ItemStack[]{aStack});
            return tFuel != null ? (int)((long)tFuel.mSpecialValue * 1000L * (long)this.mEfficiency / 100L) : 0;
        }
        return 0;
    }

    public ItemStack getEmptyContainer(ItemStack aStack) {
        if (!GT_Utility.isStackInvalid((Object)aStack) && this.getRecipeMap() != null) {
            GT_Recipe tFuel = this.getRecipeMap().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, (FluidStack[])null, new ItemStack[]{aStack});
            return tFuel != null ? GT_Utility.copy((Object[])new Object[]{tFuel.getOutput(0)}) : GT_Utility.getContainerItem((ItemStack)aStack, (boolean)true);
        }
        return null;
    }
}

