/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.advanced;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_FusionComputer;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.lang.reflect.Method;
import net.minecraft.block.Block;

public class GregtechMetaTileEntity_Adv_Fusion_MK4
extends GT_MetaTileEntity_FusionComputer {
    public static final Method mUpdateHatchTexture = ReflectionUtils.getMethod(GT_MetaTileEntity_Hatch.class, "updateTexture", Integer.TYPE);

    public GregtechMetaTileEntity_Adv_Fusion_MK4(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 6);
    }

    public GregtechMetaTileEntity_Adv_Fusion_MK4(String aName) {
        super(aName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Fusion Reactor").addInfo("HARNESSING THE POWER OF A NEUTRON STAR").addSeparator().beginStructureBlock(15, 3, 15, false).addController("See diagram when placed").addCasingInfo("Fusion Machine Casings MK III", 79).addStructureInfo("Cover the coils with casing").addOtherStructurePart("Advanced Fusion Coils", "Center part of the ring").addEnergyHatch("1-16, Specified casings", new int[]{2}).addInputHatch("2-16, Specified casings", new int[]{1}).addOutputHatch("1-16, Specified casings", new int[]{3}).addStructureInfo("ALL Hatches must be UHV or better").toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public int tier() {
        return 9;
    }

    public long maxEUStore() {
        return 2560040000L * (long)Math.min(16, this.mEnergyHatches.size()) / 8L;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_Adv_Fusion_MK4(this.mName);
    }

    public Block getCasing() {
        return this.getFusionCoil();
    }

    public int getCasingMeta() {
        return 12;
    }

    public Block getFusionCoil() {
        return ModBlocks.blockCasings3Misc;
    }

    public int getFusionCoilMeta() {
        return 13;
    }

    public int tierOverclock() {
        return 8;
    }

    public int overclock(int mStartEnergy) {
        return mStartEnergy < 160000000 ? 16 : (mStartEnergy < 320000000 ? 8 : (mStartEnergy < 640000000 ? 4 : 1));
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] sTexture = aSide == aFacing ? new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa)), new GT_RenderedTexture(this.getIconOverlay())} : (!aActive ? new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS, Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa))} : new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.TEXTURE_CASING_FUSION_CASING_ULTRA, Dyes.getModulation((int)-1, (short[])Dyes._NULL.mRGBa))});
        return sTexture;
    }

    public ITexture getTextureOverlay() {
        return new GT_RenderedTexture((IIconContainer)(this.mMaxProgresstime > 0 ? TexturesGtBlock.Casing_Machine_Screen_3 : TexturesGtBlock.Casing_Machine_Screen_1));
    }

    public IIconContainer getIconOverlay() {
        return this.mMaxProgresstime > 0 ? TexturesGtBlock.Casing_Machine_Screen_3 : TexturesGtBlock.Casing_Machine_Screen_1;
    }

    public boolean turnCasingActive(boolean status) {
        try {
            if (this.mEnergyHatches != null) {
                for (GT_MetaTileEntity_Hatch_Energy hatch : this.mEnergyHatches) {
                    mUpdateHatchTexture.invoke((Object)hatch, status ? TAE.getIndexFromPage(2, 14) : 53);
                }
            }
            if (this.mOutputHatches != null) {
                for (GT_MetaTileEntity_Hatch_Output hatch2 : this.mOutputHatches) {
                    mUpdateHatchTexture.invoke((Object)hatch2, status ? TAE.getIndexFromPage(2, 14) : 53);
                }
            }
            if (this.mInputHatches != null) {
                for (GT_MetaTileEntity_Hatch_Input hatch3 : this.mInputHatches) {
                    mUpdateHatchTexture.invoke((Object)hatch3, status ? TAE.getIndexFromPage(2, 14) : 53);
                }
            }
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public String[] getInfoData() {
        String tier = "IV";
        float plasmaOut = 0.0f;
        int powerRequired = 0;
        if (this.mLastRecipe != null) {
            powerRequired = this.mLastRecipe.mEUt;
            if (this.mLastRecipe.getFluidOutput(0) != null) {
                plasmaOut = (float)this.mLastRecipe.getFluidOutput((int)0).amount / (float)this.mLastRecipe.mDuration;
            }
        }
        return new String[]{"Fusion Reactor MK " + tier, "EU Required: " + powerRequired + "EU/t", "Stored EU: " + this.mEUStore + " / " + this.maxEUStore(), "Plasma Output: " + plasmaOut + "L/t"};
    }
}

