/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing.advanced;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_Adv_DistillationTower
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_Adv_DistillationTower> {
    private byte mMode = 0;
    private boolean mUpgraded = false;
    private IStructureDefinition<GregtechMetaTileEntity_Adv_DistillationTower> STRUCTURE_DEFINITION = null;
    private int mCasingTier = 0;

    public GregtechMetaTileEntity_Adv_DistillationTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_Adv_DistillationTower(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_Adv_DistillationTower(this.mName);
    }

    public IStructureDefinition<GregtechMetaTileEntity_Adv_DistillationTower> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName + "bottom", StructureUtility.transpose((String[][])new String[][]{{"I~I", "III", "III"}})).addShape(this.mName + "mid", StructureUtility.transpose((String[][])new String[][]{{"CCC", "C-C", "CCC"}})).addShape(this.mName + "top", StructureUtility.transpose((String[][])new String[][]{{"MMM", "MMM", "MMM"}})).addElement(Character.valueOf('I'), GT_StructureUtility.ofHatchAdderOptional(GregtechMetaTileEntity_Adv_DistillationTower::addAdvDistillationTowerBottomList, (int)this.getCasingTextureID(), (int)1, (Block)GregTech_API.sBlockCasings4, (int)1)).addElement(Character.valueOf('C'), GT_StructureUtility.ofHatchAdderOptional(GregtechMetaTileEntity_Adv_DistillationTower::addAdvDistillationTowerMidList, (int)this.getCasingTextureID(), (int)2, (Block)GregTech_API.sBlockCasings4, (int)1)).addElement(Character.valueOf('M'), GT_StructureUtility.ofHatchAdderOptional(GregtechMetaTileEntity_Adv_DistillationTower::addAdvDistillationTowerTopList, (int)this.getCasingTextureID(), (int)3, (Block)GregTech_API.sBlockCasings4, (int)1)).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public final boolean addAdvDistillationTowerBottomList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public final boolean addAdvDistillationTowerMidList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public final boolean addAdvDistillationTowerTopList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Advanced Distillation Tower").addInfo("T1 and T2 constructed identical to standard DT").addInfo("Right click the controller with screwdriver to change mode.").addInfo("Max parallel dictated by tower tier and mode").addInfo("DTower Mode: T1=4, T2=12").addInfo("Distilery Mode: Tower Tier * (4*InputTier)").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().addCasingInfo("Clean Stainless Steel Machine Casing", 7).addInputBus("Bottom Casing", new int[]{1}).addOutputBus("Bottom Casing", new int[]{1}).addInputHatch("Bottom Casing", new int[]{1}).addMaintenanceHatch("Bottom Casing", new int[]{1}).addEnergyHatch("Bottom Casing", new int[]{1}).addOutputHatch("One per layer except bottom", new int[]{2}).addMufflerHatch("Top Casing", new int[]{3}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int layer = Math.min(stackSize.field_77994_a + 2, 12);
        this.buildPiece(this.mName + "bottom", stackSize, hintsOnly, 1, 0, 0);
        for (int i = 1; i < layer - 1; ++i) {
            this.buildPiece(this.mName + "mid", stackSize, hintsOnly, 1, i, 0);
        }
        this.buildPiece(this.mName + "top", stackSize, hintsOnly, 1, layer - 1, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!this.checkPiece(this.mName + "bottom", 1, 0, 0)) {
            return false;
        }
        int layer = 1;
        while (this.checkPiece(this.mName + "mid", 1, layer, 0)) {
            if (layer != this.mOutputHatches.size()) {
                return false;
            }
            ++layer;
        }
        if (layer > 12 || !this.checkPiece(this.mName + "top", 1, layer, 0)) {
            return false;
        }
        return layer == this.mOutputHatches.size() && this.checkHatch();
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName() + (this.mUpgraded ? " T2" : ""), "MultiblockDisplay.png");
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return this.mMode == 0 ? GT_Recipe.GT_Recipe_Map.sDistillationRecipes : GT_Recipe.GT_Recipe_Map.sDistilleryRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        if (this.mMode == 1) {
            return CORE.ConfigSwitches.pollutionPerSecondMultiAdvDistillationTower_ModeDistillery;
        }
        return CORE.ConfigSwitches.pollutionPerSecondMultiAdvDistillationTower_ModeDT;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74774_a("mMode", this.mMode);
        aNBT.func_74768_a("mCasingTier", this.mCasingTier);
        aNBT.func_74757_a("mUpgraded", this.mUpgraded);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mMode = aNBT.func_74771_c("mMode");
        this.mCasingTier = aNBT.func_74762_e("mCasingTier");
        this.mUpgraded = aNBT.func_74767_n("mUpgraded");
        super.loadNBTData(aNBT);
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(203);
    }

    @Override
    public void startProcess() {
        this.sendLoopStart((byte)1);
    }

    @Override
    public void onModeChangeByScrewdriver(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mMode = (byte)(this.mMode + 1);
        if (this.mMode > 1) {
            this.mMode = 0;
            PlayerUtils.messagePlayer(aPlayer, "Now running in Distillation Tower Mode.");
        } else {
            PlayerUtils.messagePlayer(aPlayer, "Now running in Distillery Mode.");
        }
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private short getControllerY() {
        return this.getBaseMetaTileEntity().getYCoord();
    }

    public boolean addOutput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        FluidStack tLiquid = aLiquid.copy();
        for (GT_MetaTileEntity_Hatch_Output tHatch : this.mOutputHatches) {
            if (!(GregtechMetaTileEntity_Adv_DistillationTower.isValidMetaTileEntity((MetaTileEntity)tHatch) && GT_ModHandler.isSteam((FluidStack)aLiquid) ? tHatch.outputsSteam() : tHatch.outputsLiquids()) || tHatch.getBaseMetaTileEntity().getYCoord() != this.getControllerY() + 1) continue;
            int tAmount = tHatch.fill(tLiquid, false);
            if (tAmount >= tLiquid.amount) {
                return tHatch.fill(tLiquid, true) >= tLiquid.amount;
            }
            if (tAmount <= 0) continue;
            tLiquid.amount -= tHatch.fill(tLiquid, true);
        }
        return false;
    }

    protected void addFluidOutputs(FluidStack[] mOutputFluids2) {
        for (int i = 0; i < mOutputFluids2.length; ++i) {
            if (this.mOutputHatches.size() <= i || this.mOutputHatches.get(i) == null || mOutputFluids2[i] == null || !GregtechMetaTileEntity_Adv_DistillationTower.isValidMetaTileEntity((MetaTileEntity)this.mOutputHatches.get(i)) || ((GT_MetaTileEntity_Hatch_Output)this.mOutputHatches.get(i)).getBaseMetaTileEntity().getYCoord() != this.getControllerY() + 1 + i) continue;
            ((GT_MetaTileEntity_Hatch_Output)this.mOutputHatches.get(i)).fill(mOutputFluids2[i], true);
        }
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    @Override
    public boolean requiresVanillaGtGUI() {
        return true;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "DistillationTower";
    }

    @Override
    public String getMachineType() {
        return "Distillery, Distillation Tower";
    }

    public boolean checkRecipe(ItemStack aStack) {
        if (this.mMode == 1) {
            return this.checkRecipeGeneric(this.getMaxParallelRecipes(), this.getEuDiscountForParallelism(), 100);
        }
        for (GT_MetaTileEntity_Hatch_Input hatch : this.mInputHatches) {
            FluidStack tFluid = hatch.getFluid();
            if (tFluid == null) continue;
            int para = 4 * GT_Utility.getTier((long)this.getMaxInputVoltage());
            if (!this.checkRecipeGeneric(null, new FluidStack[]{tFluid}, para, 100, 250, 10000)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        if (this.mMode == 0) {
            return this.getTierOfTower() == 1 ? 4 : (this.getTierOfTower() == 2 ? 12 : 0);
        }
        if (this.mMode == 1) {
            return this.getTierOfTower() * (4 * GT_Utility.getTier((long)this.getMaxInputVoltage()));
        }
        return 0;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 15;
    }

    private int getTierOfTower() {
        return this.mUpgraded ? 2 : 1;
    }

    private int getMachineCasingTier() {
        return this.mCasingTier;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        int aTier;
        if (aBaseMetaTileEntity.getWorld() != null) {
            // empty if block
        }
        ITexture aOriginalTexture = (aTier = this.mCasingTier) == 0 ? Textures.BlockIcons.getCasingTextureForId((int)49) : (aTier == 1 ? Textures.BlockIcons.getCasingTextureForId((int)43) : Textures.BlockIcons.getCasingTextureForId((int)49));
        if (aSide == aFacing) {
            return new ITexture[]{aOriginalTexture, new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_DISTILLATION_TOWER))};
        }
        return new ITexture[]{aOriginalTexture};
    }

    private int getCasingTextureID() {
        int aTier = this.mCasingTier;
        if (aTier == 1) {
            return 49;
        }
        if (aTier == 2) {
            return 43;
        }
        return 49;
    }

    public boolean addToMachineList(IGregTechTileEntity aTileEntity) {
        int aMaxTier = this.getMachineCasingTier();
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_TieredMachineBlock) {
            GT_MetaTileEntity_TieredMachineBlock aMachineBlock = (GT_MetaTileEntity_TieredMachineBlock)aMetaTileEntity;
            byte aTileTier = aMachineBlock.mTier;
            if (aTileTier > aMaxTier) {
                Logger.INFO("Hatch tier too high.");
                return false;
            }
            return this.addToMachineList(aTileEntity, this.getCasingTextureID());
        }
        Logger.INFO("Bad Tile Entity being added to hatch map.");
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        ItemStack aGuiStack;
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aTick % 20L == 0L && !this.mUpgraded && (aGuiStack = this.getGUIItemStack()) != null && GT_Utility.areStacksEqual((ItemStack)aGuiStack, (ItemStack)GregtechItemList.Distillus_Upgrade_Chip.get(1L, new Object[0]))) {
            this.mUpgraded = true;
            ItemUtils.depleteStack(aGuiStack);
        }
        if (aBaseMetaTileEntity.isClientSide()) {
            this.mCasingTier = this.getCasingTierOnClientSide();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private final int getCasingTierOnClientSide() {
        if (this == null || this.getBaseMetaTileEntity().getWorld() == null) {
            return 0;
        }
        try {
            IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
            if (aBaseMetaTileEntity == null || aBaseMetaTileEntity.getWorld() == null || aBaseMetaTileEntity.getWorld().func_72938_d(aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getZCoord()) == null) {
                return 0;
            }
            for (int i = 1; i < 10; ++i) {
                Block aInitStructureCheck = aBaseMetaTileEntity.getBlockOffset(0, i, 0);
                byte aInitStructureCheckMeta = aBaseMetaTileEntity.getMetaIDOffset(0, i, 0);
                if (aInitStructureCheck == null) continue;
                if (aInitStructureCheck == GregTech_API.sBlockCasings4 && aInitStructureCheckMeta == 1) {
                    return 0;
                }
                if (aInitStructureCheck != ModBlocks.blockCasingsTieredGTPP) continue;
                return 1;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 0;
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        aNBT.func_74757_a("mUpgraded", this.mUpgraded);
        super.setItemNBT(aNBT);
    }
}

