/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.GasSpargingRecipe;
import gregtech.api.util.GasSpargingRecipeMap;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_SpargeTower
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_SpargeTower> {
    protected static final String STRUCTURE_PIECE_BASE = "base";
    protected static final String STRUCTURE_PIECE_LAYER = "layer";
    protected static final String STRUCTURE_PIECE_LAYER_HINT = "layerHint";
    protected static final String STRUCTURE_PIECE_TOP_HINT = "topHint";
    private static final IStructureDefinition<GregtechMetaTileEntity_SpargeTower> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("base", StructureUtility.transpose((String[][])new String[][]{{"b~b", "bbb", "bbb"}})).addShape("layer", StructureUtility.transpose((String[][])new String[][]{{"lll", "lcl", "lll"}})).addShape("layerHint", StructureUtility.transpose((String[][])new String[][]{{"lll", "l-l", "lll"}})).addShape("topHint", StructureUtility.transpose((String[][])new String[][]{{"lll", "lll", "lll"}})).addElement(Character.valueOf('b'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addEnergyInputToMachineList, (int)GregtechMetaTileEntity_SpargeTower.getCasingIndex(), (int)1), GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addInputToMachineList, (int)GregtechMetaTileEntity_SpargeTower.getCasingIndex(), (int)1), GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addMaintenanceToMachineList, (int)GregtechMetaTileEntity_SpargeTower.getCasingIndex(), (int)1), StructureUtility.onElementPass(GregtechMetaTileEntity_SpargeTower::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)4))})).addElement(Character.valueOf('l'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addEnergyInputToMachineList, (int)GregtechMetaTileEntity_SpargeTower.getCasingIndex(), (int)2), GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_SpargeTower::addLayerOutputHatch, (int)GregtechMetaTileEntity_SpargeTower.getCasingIndex(), (int)2), GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addMaintenanceToMachineList, (int)GregtechMetaTileEntity_SpargeTower.getCasingIndex(), (int)2), StructureUtility.onElementPass(GregtechMetaTileEntity_SpargeTower::onCasingFound, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)4))})).addElement(Character.valueOf('c'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.onElementPass(t -> t.onTopLayerFound(false), (IStructureElement)GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addOutputToMachineList, (int)GregtechMetaTileEntity_SpargeTower.getCasingIndex(), (int)3)), StructureUtility.onElementPass(t -> t.onTopLayerFound(false), (IStructureElement)GT_StructureUtility.ofHatchAdder(GregtechMeta_MultiBlockBase::addMaintenanceToMachineList, (int)GregtechMetaTileEntity_SpargeTower.getCasingIndex(), (int)3)), StructureUtility.onElementPass(t -> t.onTopLayerFound(true), (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)4)), StructureUtility.isAir()})).build();
    protected final List<List<GT_MetaTileEntity_Hatch_Output>> mOutputHatchesByLayer = new ArrayList<List<GT_MetaTileEntity_Hatch_Output>>();
    protected int mHeight;
    protected int mCasing;
    protected boolean mTopLayerFound;

    public GregtechMetaTileEntity_SpargeTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_SpargeTower(String aName) {
        super(aName);
    }

    public static int getCasingIndex() {
        return 68;
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_SpargeTower(this.mName);
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Gas Sparge Tower").addInfo("Controller block for the Sparging Tower").addInfo("Fluids are only put out at the correct height").addInfo("The correct height equals the slot number in the NEI recipe").addSeparator().beginStructureBlock(3, 8, 3, true).addController("Front bottom").addOtherStructurePart("Sparge Tower Exterior Casing", "45 (minimum)").addEnergyHatch("Any casing", new int[]{1, 2}).addMaintenanceHatch("Any casing", new int[]{1, 2, 3}).addInputHatch("2x Input Hatches (Any bottom layer casing)", new int[]{1}).addOutputHatch("6x Output Hatches (At least one per layer except bottom layer)", new int[]{2, 3}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GregtechMetaTileEntity_SpargeTower.getCasingIndex()), TextureFactory.builder().addIcon(new IIconContainer[]{TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active}).extFacing().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GregtechMetaTileEntity_SpargeTower.getCasingIndex()), TextureFactory.builder().addIcon(new IIconContainer[]{TexturesGtBlock.Overlay_Machine_Controller_Advanced}).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)GregtechMetaTileEntity_SpargeTower.getCasingIndex())};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "DistillationTower.png");
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        if (GTPP_Recipe.GTPP_Recipe_Map.sSpargeTowerRecipes.mRecipeList.isEmpty()) {
            GregtechMetaTileEntity_SpargeTower.generateRecipes();
        }
        return GTPP_Recipe.GTPP_Recipe_Map.sSpargeTowerRecipes;
    }

    private static boolean generateRecipes() {
        for (GasSpargingRecipe aRecipe : GasSpargingRecipeMap.mRecipes) {
            GTPP_Recipe newRecipe = new GTPP_Recipe(false, new ItemStack[0], new ItemStack[0], null, null, (FluidStack[])aRecipe.mFluidInputs.clone(), new FluidStack[0], aRecipe.mDuration, aRecipe.mEUt, 0);
            GTPP_Recipe.GTPP_Recipe_Map.sSpargeTowerRecipes.add(newRecipe);
        }
        return !GTPP_Recipe.GTPP_Recipe_Map.sSpargeTowerRecipes.mRecipeList.isEmpty();
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public boolean checkRecipe(ItemStack aStack) {
        ArrayList tFluidList = this.getStoredFluids();
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(0, GT_Utility.getTier((long)tVoltage));
        FluidStack[] tFluids = tFluidList.toArray(new FluidStack[0]);
        if (tFluids.length > 0) {
            Logger.INFO("Found " + tFluids.length + " input fluids. Searching " + GTPP_Recipe.GTPP_Recipe_Map.sSpargeTowerRecipes.mRecipeList.size() + " recipes.");
            GT_Recipe tRecipe = this.getRecipeMap().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, GT_Values.V[tTier], tFluids, new ItemStack[0]);
            if (tRecipe != null) {
                Logger.INFO("Found recipe!");
                if (tRecipe.isRecipeInputEqual(true, tFluids, new ItemStack[0])) {
                    Logger.INFO("Found recipe that matches!");
                    this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
                    this.mEfficiencyIncrease = 10000;
                    this.mEUt = 0;
                    this.mProgresstime = 0;
                    this.mMaxProgresstime = 0;
                    this.mOutputItems = new ItemStack[0];
                    this.mOutputFluids = new FluidStack[0];
                    this.mLastRecipe = tRecipe;
                    this.calculateOverclockedNessMulti(tRecipe.mEUt, tRecipe.mDuration, 1, tVoltage);
                    int aDevProgress = this.mMaxProgresstime / 10;
                    this.mMaxProgresstime = Math.max(1, aDevProgress);
                    this.mOutputItems = new ItemStack[0];
                    ArrayList<FluidStack> aFluidOutputs = GregtechMetaTileEntity_SpargeTower.getByproductsOfSparge(tRecipe.mFluidInputs[0], tRecipe.mFluidInputs[1]);
                    this.mOutputFluids = aFluidOutputs.toArray(new FluidStack[0]);
                    this.updateSlots();
                    Logger.INFO("Done!");
                    return true;
                }
            } else {
                Logger.INFO("Did not find recipe!");
            }
        }
        this.mEUt = 0;
        this.mEfficiency = 0;
        Logger.INFO("Did not find recipe! (2)");
        return false;
    }

    private static ArrayList<FluidStack> getByproductsOfSparge(FluidStack aSpargeGas, FluidStack aSpentFuel) {
        GasSpargingRecipe aSpargeRecipe = GasSpargingRecipeMap.findRecipe(aSpargeGas, aSpentFuel);
        ArrayList<FluidStack> aOutputGases = new ArrayList<FluidStack>();
        if (aSpargeRecipe == null) {
            Logger.INFO("Did not find sparge recipe!");
            return aOutputGases;
        }
        int aSpargeGasAmount = aSpargeRecipe.mInputGas.amount;
        aOutputGases.add(aSpargeRecipe.mOutputSpargedFuel.copy());
        ArrayList<FluidStack> aTempMap = new ArrayList<FluidStack>();
        for (int i = 2; i < aSpargeRecipe.mFluidOutputs.length; ++i) {
            int aGasAmount = MathUtils.randInt(0, aSpargeRecipe.mMaxOutputQuantity[i - 2] / 100);
            FluidStack aOutput = aSpargeRecipe.mFluidOutputs[i].copy();
            aSpargeGasAmount -= aGasAmount;
            FluidStack aSpargeOutput = null;
            if (aGasAmount > 0) {
                aSpargeOutput = new FluidStack(aOutput.getFluid(), aGasAmount);
            }
            aTempMap.add(aSpargeOutput);
        }
        Logger.INFO("Sparge gas left: " + aSpargeGasAmount);
        if (aSpargeGasAmount > 0) {
            aOutputGases.add(new FluidStack(aSpargeRecipe.mInputGas.getFluid(), aSpargeGasAmount));
        }
        aOutputGases.addAll(aTempMap);
        Logger.INFO("Sparge output size: " + aOutputGases.size());
        return aOutputGases;
    }

    protected void onCasingFound() {
        ++this.mCasing;
    }

    protected void onTopLayerFound(boolean aIsCasing) {
        this.mTopLayerFound = true;
        if (aIsCasing) {
            this.onCasingFound();
        }
    }

    protected boolean addLayerOutputHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null || aTileEntity.isDead() || !(aTileEntity.getMetaTileEntity() instanceof GT_MetaTileEntity_Hatch_Output)) {
            Logger.INFO("Bad Output Hatch");
            return false;
        }
        while (this.mOutputHatchesByLayer.size() < this.mHeight) {
            this.mOutputHatchesByLayer.add(new ArrayList());
        }
        GT_MetaTileEntity_Hatch_Output tHatch = (GT_MetaTileEntity_Hatch_Output)aTileEntity.getMetaTileEntity();
        tHatch.updateTexture(aBaseCasingIndex);
        boolean addedHatch = this.mOutputHatchesByLayer.get(this.mHeight - 1).add(tHatch);
        Logger.INFO("Added Hatch: " + addedHatch);
        return addedHatch;
    }

    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    public IStructureDefinition<GregtechMetaTileEntity_SpargeTower> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mOutputHatchesByLayer.forEach(List::clear);
        this.mHeight = 1;
        this.mTopLayerFound = false;
        this.mCasing = 0;
        if (!this.checkPiece(STRUCTURE_PIECE_BASE, 1, 0, 0)) {
            Logger.INFO("Bad Base. Height: " + this.mHeight);
            return false;
        }
        while (this.mHeight < 8 && this.checkPiece(STRUCTURE_PIECE_LAYER, 1, this.mHeight, 0) && !this.mTopLayerFound) {
            if (this.mOutputHatchesByLayer.get(this.mHeight - 1).isEmpty()) {
                Logger.INFO("Height: " + this.mHeight + " - Missing output on " + (this.mHeight - 1));
                return false;
            }
            ++this.mHeight;
        }
        Logger.INFO("Height: " + this.mHeight);
        Logger.INFO("Casings: " + this.mCasing);
        Logger.INFO("Required: " + (7 * this.mHeight - 5));
        Logger.INFO("Found Top: " + this.mTopLayerFound);
        return this.mCasing >= 45 && this.mTopLayerFound && this.mMaintenanceHatches.size() == 1;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    protected void addFluidOutputs(FluidStack[] mOutputFluids2) {
        for (int i = 0; i < mOutputFluids2.length && i < this.mOutputHatchesByLayer.size(); ++i) {
            FluidStack tStack;
            FluidStack fluidStack = tStack = mOutputFluids2[i] != null ? mOutputFluids2[i].copy() : null;
            if (tStack == null || GregtechMetaTileEntity_SpargeTower.dumpFluid(this.mOutputHatchesByLayer.get(i), (FluidStack)tStack, (boolean)true)) continue;
            GregtechMetaTileEntity_SpargeTower.dumpFluid(this.mOutputHatchesByLayer.get(i), (FluidStack)tStack, (boolean)false);
        }
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_BASE, stackSize, hintsOnly, 1, 0, 0);
        int tTotalHeight = 8;
        for (int i = 1; i < tTotalHeight - 1; ++i) {
            this.buildPiece(STRUCTURE_PIECE_LAYER_HINT, stackSize, hintsOnly, 1, i, 0);
        }
        this.buildPiece(STRUCTURE_PIECE_TOP_HINT, stackSize, hintsOnly, 1, tTotalHeight - 1, 0);
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return null;
    }

    @Override
    public boolean requiresVanillaGtGUI() {
        return true;
    }

    @Override
    public String getMachineType() {
        return "Gas Sparger";
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    @Override
    public boolean onPlungerRightClick(EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        int aLayerIndex = 0;
        PlayerUtils.messagePlayer(aPlayer, "Trying to clear " + this.mOutputHatchesByLayer.size() + " layers of output hatches.");
        for (List<GT_MetaTileEntity_Hatch_Output> layer : this.mOutputHatchesByLayer) {
            int aHatchIndex = 0;
            for (GT_MetaTileEntity_Hatch_Output hatch : layer) {
                if (hatch.mFluid != null) {
                    PlayerUtils.messagePlayer(aPlayer, "Clearing " + hatch.mFluid.amount + "L of " + hatch.mFluid.getLocalizedName() + " from hatch " + aHatchIndex + " on layer " + aLayerIndex + ".");
                    hatch.mFluid = null;
                }
                ++aHatchIndex;
            }
            ++aLayerIndex;
        }
        return aLayerIndex > 0;
    }
}

