/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.gui.CONTAINER_IronBlastFurnace;
import gtPlusPlus.xmod.gregtech.api.gui.GUI_IronBlastFurnace;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class GregtechMetaTileEntity_IronBlastFurnace
extends MetaTileEntity {
    private static final ITexture[] FACING_SIDE = new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Simple_Top)};
    private static final ITexture[] FACING_FRONT = new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Redstone_Off)};
    private static final ITexture[] FACING_ACTIVE = new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Redstone_On)};
    public int mMaxProgresstime = 0;
    public int mUpdate = 30;
    public int mProgresstime = 0;
    public boolean mMachine = false;
    public ItemStack mOutputItem1;
    public ItemStack mOutputItem2;

    public GregtechMetaTileEntity_IronBlastFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 4);
    }

    public GregtechMetaTileEntity_IronBlastFurnace(String aName) {
        super(aName, 4);
    }

    public String[] getDescription() {
        if (CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK) {
            return new String[]{"Iron is a much better furnace material!", "Can be Automated", "Multiblock: 3x3x5 hollow with opening on top", "Same shape as Bronze/Bricked blast furnace, except one ring of 8 taller.", "40 Iron Plated Bricks required"};
        }
        return new String[]{"Sloooowly, Skip the Bronze age, Get some Steel!", "Multiblock: 3x3x5 hollow with opening on top", "40 Iron Plated Bricks required", "----", "Even though Iron melts hotter than bronze,", "this machine is to help players skip looking", "for tin and copper, which are not as common", "as Iron is. This machine takes 5x longer than the bronze", "blast furnace as a result.", "----"};
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return aActive ? FACING_ACTIVE : FACING_FRONT;
        }
        return FACING_SIDE;
    }

    public boolean isSteampowered() {
        return false;
    }

    public boolean isElectric() {
        return false;
    }

    public boolean isPneumatic() {
        return false;
    }

    public boolean isEnetInput() {
        return false;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public boolean isInputFacing(byte aSide) {
        return false;
    }

    public boolean isOutputFacing(byte aSide) {
        return false;
    }

    public boolean isTeleporterCompatible() {
        return false;
    }

    public boolean isFacingValid(byte aFacing) {
        return aFacing > 1;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public int getProgresstime() {
        return this.mProgresstime;
    }

    public int maxProgresstime() {
        return this.mMaxProgresstime;
    }

    public int increaseProgress(int aProgress) {
        this.mProgresstime += aProgress;
        return this.mMaxProgresstime - this.mProgresstime;
    }

    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aCoverID) {
        return GregTech_API.getCoverBehavior((ItemStack)aCoverID.toStack()).isSimpleCover() && super.allowCoverOnSide(aSide, aCoverID);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IronBlastFurnace(this.mName);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        NBTTagCompound tNBT;
        aNBT.func_74768_a("mProgresstime", this.mProgresstime);
        aNBT.func_74768_a("mMaxProgresstime", this.mMaxProgresstime);
        if (this.mOutputItem1 != null) {
            tNBT = new NBTTagCompound();
            this.mOutputItem1.func_77955_b(tNBT);
            aNBT.func_74782_a("mOutputItem1", (NBTBase)tNBT);
        }
        if (this.mOutputItem2 != null) {
            tNBT = new NBTTagCompound();
            this.mOutputItem2.func_77955_b(tNBT);
            aNBT.func_74782_a("mOutputItem2", (NBTBase)tNBT);
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.mUpdate = 30;
        this.mProgresstime = aNBT.func_74762_e("mProgresstime");
        this.mMaxProgresstime = aNBT.func_74762_e("mMaxProgresstime");
        this.mOutputItem1 = GT_Utility.loadItem((NBTTagCompound)aNBT, (String)"mOutputItem1");
        this.mOutputItem2 = GT_Utility.loadItem((NBTTagCompound)aNBT, (String)"mOutputItem2");
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new CONTAINER_IronBlastFurnace(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GUI_IronBlastFurnace(aPlayerInventory, aBaseMetaTileEntity);
    }

    private boolean checkMachine() {
        int xDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetX;
        int zDir = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing()).offsetZ;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 4; ++j) {
                for (int k = -1; k < 2; ++k) {
                    if (xDir + i == 0 && j == 0 && zDir + k == 0 || !(i != 0 || j == -1 || k != 0 ? this.getBaseMetaTileEntity().getBlockOffset(xDir + i, j, zDir + k) != ModBlocks.blockCasingsMisc || this.getBaseMetaTileEntity().getMetaIDOffset(xDir + i, j, zDir + k) != 10 : !GT_Utility.arrayContains((Object)this.getBaseMetaTileEntity().getBlockOffset(xDir + i, j, zDir + k), (Object[])new Object[]{Blocks.field_150353_l, Blocks.field_150356_k, null}) && !this.getBaseMetaTileEntity().getAirOffset(xDir + i, j, zDir + k))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public void onMachineBlockUpdate() {
        this.mUpdate = 30;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive()) {
            aBaseMetaTileEntity.getWorld().func_72869_a("cloud", (double)aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1) + Math.random(), (double)aBaseMetaTileEntity.getOffsetY(aBaseMetaTileEntity.getBackFacing(), 1), (double)aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1) + Math.random(), 0.0, 0.3, 0.0);
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mUpdate-- == 0) {
                this.mMachine = this.checkMachine();
            }
            if (this.mMachine) {
                if (this.mMaxProgresstime > 0) {
                    if (++this.mProgresstime >= this.mMaxProgresstime) {
                        this.addOutputProducts();
                        this.mOutputItem1 = null;
                        this.mOutputItem2 = null;
                        this.mProgresstime = 0;
                        this.mMaxProgresstime = 0;
                        try {
                            GT_Mod.achievements.issueAchievement(aBaseMetaTileEntity.getWorld().func_72924_a(aBaseMetaTileEntity.getOwnerName()), "steel");
                        }
                        catch (Exception exception) {}
                    }
                } else if (aBaseMetaTileEntity.isAllowedToWork()) {
                    this.checkRecipe();
                }
            }
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0 && this.mMachine);
            if (aBaseMetaTileEntity.isActive()) {
                if (aBaseMetaTileEntity.getAir(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1))) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1), Blocks.field_150353_l, 1, 2);
                    this.mUpdate = 1;
                }
                if (aBaseMetaTileEntity.getAir(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord() + 1, aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1))) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord() + 1, aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1), Blocks.field_150353_l, 1, 2);
                    this.mUpdate = 1;
                }
            } else {
                if (aBaseMetaTileEntity.getBlock(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1)) == Blocks.field_150353_l) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), (int)aBaseMetaTileEntity.getYCoord(), aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1), Blocks.field_150350_a, 0, 2);
                    this.mUpdate = 1;
                }
                if (aBaseMetaTileEntity.getBlock(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord() + 1, aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1)) == Blocks.field_150353_l) {
                    aBaseMetaTileEntity.getWorld().func_147465_d(aBaseMetaTileEntity.getOffsetX(aBaseMetaTileEntity.getBackFacing(), 1), aBaseMetaTileEntity.getYCoord() + 1, aBaseMetaTileEntity.getOffsetZ(aBaseMetaTileEntity.getBackFacing(), 1), Blocks.field_150350_a, 0, 2);
                    this.mUpdate = 1;
                }
            }
        }
    }

    private void addOutputProducts() {
        if (this.mOutputItem1 != null) {
            if (this.mInventory[2] == null) {
                this.mInventory[2] = GT_Utility.copy((Object[])new Object[]{this.mOutputItem1});
            } else if (GT_Utility.areStacksEqual((ItemStack)this.mInventory[2], (ItemStack)this.mOutputItem1)) {
                this.mInventory[2].field_77994_a = Math.min(this.mOutputItem1.func_77976_d(), this.mOutputItem1.field_77994_a + this.mInventory[2].field_77994_a);
            }
        }
        if (this.mOutputItem2 != null) {
            if (this.mInventory[3] == null) {
                this.mInventory[3] = GT_Utility.copy((Object[])new Object[]{this.mOutputItem2});
            } else if (GT_Utility.areStacksEqual((ItemStack)this.mInventory[3], (ItemStack)this.mOutputItem2)) {
                this.mInventory[3].field_77994_a = Math.min(this.mOutputItem2.func_77976_d(), this.mOutputItem2.field_77994_a + this.mInventory[3].field_77994_a);
            }
        }
    }

    private boolean spaceForOutput(ItemStack aStack1, ItemStack aStack2) {
        return (this.mInventory[2] == null || aStack1 == null || this.mInventory[2].field_77994_a + aStack1.field_77994_a <= this.mInventory[2].func_77976_d() && GT_Utility.areStacksEqual((ItemStack)this.mInventory[2], (ItemStack)aStack1)) && (this.mInventory[3] == null || aStack2 == null || this.mInventory[3].field_77994_a + aStack2.field_77994_a <= this.mInventory[3].func_77976_d() && GT_Utility.areStacksEqual((ItemStack)this.mInventory[3], (ItemStack)aStack2));
    }

    private int getProperTime(int time) {
        if (CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK) {
            return time / 3;
        }
        return time;
    }

    private boolean checkRecipe() {
        if (!this.mMachine) {
            return false;
        }
        if (this.mInventory[0] != null && this.mInventory[1] != null && this.mInventory[0].field_77994_a >= 1) {
            if (GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[0], (Object)"dustIron") || GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[0], (Object)"ingotIron")) {
                if (this.mInventory[1].func_77973_b() == Items.field_151044_h && this.mInventory[1].field_77994_a >= 4 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Steel, (long)1L), this.mOutputItem2 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.DarkAsh, (long)4L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 12);
                    this.mMaxProgresstime = this.getProperTime(36000);
                    return true;
                }
                if (GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[1], (Object)"fuelCoke") && this.mInventory[1].field_77994_a >= 2 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Steel, (long)1L), this.mOutputItem2 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.Ash, (long)4L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 6);
                    this.mMaxProgresstime = this.getProperTime(4800);
                    return true;
                }
                if (this.mInventory[0].field_77994_a >= 9 && (GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[1], (Object)"blockCoal") || GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[1], (Object)"blockCharcoal")) && this.mInventory[1].field_77994_a >= 4 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Steel, (long)9L), this.mOutputItem2 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.DarkAsh, (long)4L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 9);
                    this.getBaseMetaTileEntity().func_70298_a(1, 12);
                    this.mMaxProgresstime = this.getProperTime(64800);
                    return true;
                }
            } else if (GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[0], (Object)"dustSteel")) {
                if (this.mInventory[1].func_77973_b() == Items.field_151044_h && this.mInventory[1].field_77994_a >= 2 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Steel, (long)1L), this.mOutputItem2 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.DarkAsh, (long)2L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 6);
                    this.mMaxProgresstime = this.getProperTime(3600);
                    return true;
                }
                if (GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[1], (Object)"fuelCoke") && this.mInventory[1].field_77994_a >= 1 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Steel, (long)1L), this.mOutputItem2 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dustTiny, (Object)Materials.Ash, (long)2L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 3);
                    this.mMaxProgresstime = this.getProperTime(2400);
                    return true;
                }
                if (this.mInventory[0].field_77994_a >= 9 && (GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[1], (Object)"blockCoal") || GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[1], (Object)"blockCharcoal")) && this.mInventory[1].field_77994_a >= 2 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Steel, (long)9L), this.mOutputItem2 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.DarkAsh, (long)2L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 9);
                    this.getBaseMetaTileEntity().func_70298_a(1, 6);
                    this.mMaxProgresstime = this.getProperTime(32400);
                    return true;
                }
            } else if (GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[0], (Object)"blockIron")) {
                if (this.mInventory[1].func_77973_b() == Items.field_151044_h && this.mInventory[1].field_77994_a >= 36 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Steel, (long)9L), this.mOutputItem2 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.DarkAsh, (long)4L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 64);
                    this.mMaxProgresstime = this.getProperTime(64800);
                    return true;
                }
                if (GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[1], (Object)"fuelCoke") && this.mInventory[1].field_77994_a >= 18 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Steel, (long)9L), this.mOutputItem2 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Ash, (long)4L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 54);
                    this.mMaxProgresstime = this.getProperTime(43200);
                    return true;
                }
                if ((GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[1], (Object)"blockCoal") || GT_OreDictUnificator.isItemStackInstanceOf((ItemStack)this.mInventory[1], (Object)"blockCharcoal")) && this.mInventory[1].field_77994_a >= 4 && this.spaceForOutput(this.mOutputItem1 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Steel, (long)9L), this.mOutputItem2 = GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.DarkAsh, (long)4L))) {
                    this.getBaseMetaTileEntity().func_70298_a(0, 1);
                    this.getBaseMetaTileEntity().func_70298_a(1, 12);
                    this.mMaxProgresstime = this.getProperTime(64800);
                    return true;
                }
            }
        }
        this.mOutputItem1 = null;
        this.mOutputItem2 = null;
        return false;
    }

    public boolean isGivingInformation() {
        return false;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aIndex > 1;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (aIndex < 2) {
            // empty if block
        }
        return !GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.mInventory[0]);
    }

    public byte getTileEntityBaseType() {
        return 0;
    }
}

