/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GT_MetaTileEntity_Hatch_CustomFluidBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_IndustrialVacuumFreezer
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialVacuumFreezer> {
    public static int CASING_TEXTURE_ID;
    public static String mCryoFuelName;
    public static String mCasingName;
    public static String mHatchName;
    public static FluidStack mFuelStack;
    private boolean mHaveHatch;
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_IndustrialVacuumFreezer> STRUCTURE_DEFINITION = null;
    private volatile int mGraceTimer = 2;

    public GregtechMetaTileEntity_IndustrialVacuumFreezer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        mFuelStack = FluidUtils.getFluidStack("cryotheum", 1);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(2, 10);
    }

    public GregtechMetaTileEntity_IndustrialVacuumFreezer(String aName) {
        super(aName);
        mFuelStack = FluidUtils.getFluidStack("cryotheum", 1);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(2, 10);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialVacuumFreezer(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Vacuum Freezer";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Factory Grade Advanced Vacuum Freezer").addInfo("Speed: 200% | Eu Usage: 100% | Parallel: 4").addInfo("Consumes 1L of " + mCryoFuelName + "/t during operation").addInfo("Constructed exactly the same as a normal Vacuum Freezer").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfo(mCasingName, 10).addStructureHint(mHatchName, new int[]{1}).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialVacuumFreezer> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_IndustrialVacuumFreezer::addIndustrialVacuumFreezerList, (int)CASING_TEXTURE_ID, (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)10))})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mHaveHatch = false;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 10 && this.mHaveHatch && this.checkHatch();
    }

    public final boolean addIndustrialVacuumFreezerList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_CustomFluidBase && aMetaTileEntity.getBaseMetaTileEntity().getMetaTileID() == 967) {
            this.mHaveHatch = true;
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)CASING_TEXTURE_ID), new GT_RenderedTexture((IIconContainer)(aActive ? TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active : TexturesGtBlock.Overlay_Machine_Controller_Advanced))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)CASING_TEXTURE_ID)};
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    @Override
    public boolean requiresVanillaGtGUI() {
        return true;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "VacuumFreezer";
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GTPP_Recipe.GTPP_Recipe_Map.sAdvFreezerRecipes_GT;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public boolean checkRecipe(ItemStack aStack) {
        return this.checkRecipeGeneric(4, 100, 100);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 4;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialVacuumFreezer;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.mStartUpCheck < 0 && (this.mMaxProgresstime > 0 && this.mProgresstime != 0 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled()) && (aTick % 10L == 0L || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled()) && !this.depleteInput(FluidUtils.getFluidStack("cryotheum", 10)) && this.mGraceTimer-- == 0) {
            this.causeMaintenanceIssue();
            this.stopMachine();
            this.mGraceTimer = 2;
        }
    }

    static {
        mCryoFuelName = "Gelid Cryotheum";
        mCasingName = "Advanced Cryogenic Casing";
        mHatchName = "Cryotheum Hatch";
    }
}

