/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class GregtechMetaTileEntity_IndustrialMolecularTransformer
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialMolecularTransformer> {
    private static final int CASING_TEXTURE_ID = 48;
    private int mCasing = 0;
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private IStructureDefinition<GregtechMetaTileEntity_IndustrialMolecularTransformer> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_IndustrialMolecularTransformer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialMolecularTransformer(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialMolecularTransformer(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Molecular Transformer";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Changes the structure of items to produce new ones").addInfo("Speed: 100% | Eu Usage: 100%").addInfo("This multiblock cannot be overclocked").addInfo("Maximum 1x of each bus/hatch.").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(7, 7, 7, false).addController("Top Center").addCasingInfo("Robust Tungstensteel Machine Casing", 40).addCasingInfo("Tungstensteel Coils", 16).addCasingInfo("Molecular Containment Casing", 52).addCasingInfo("High Voltage Current Capacitor", 32).addCasingInfo("Particle Containment Casing", 4).addCasingInfo("Resonance Chamber I", 5).addCasingInfo("Modulator I", 4).addInputBus("Any Robust Tungstensteel Machine Casing", new int[]{1}).addOutputBus("Any Robust Tungstensteel Machine Casing", new int[]{1}).addEnergyHatch("Any Robust Tungstensteel Machine Casing", new int[]{1}).addMaintenanceHatch("Any Robust Tungstensteel Machine Casing", new int[]{1}).addMufflerHatch("Any Robust Tungstensteel Machine Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialMolecularTransformer> getStructureDefinition() {
        this.STRUCTURE_DEFINITION = null;
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(STRUCTURE_PIECE_MAIN, (String[][])new String[][]{{"       ", "       ", "  xxx  ", "  x~x  ", "  xxx  ", "       ", "       "}, {"       ", "  xxx  ", " xyyyx ", " xyzyx ", " xyyyx ", "  xxx  ", "       "}, {"       ", "  xxx  ", " xyyyx ", " xyzyx ", " xyyyx ", "  xxx  ", "       "}, {"       ", "  xxx  ", " xyyyx ", " xyzyx ", " xyyyx ", "  xxx  ", "       "}, {"   t   ", " ttxtt ", " tyyyt ", "txyzyxt", " tyyyt ", " ttxtt ", "   t   "}, {"   c   ", " ccecc ", " cxfxc ", "cefefec", " cxfxc ", " ccecc ", "   c   "}, {"   h   ", " hhhhh ", " hhhhh ", "hhhhhhh", " hhhhh ", " hhhhh ", "   h   "}}).addElement(Character.valueOf('x'), StructureUtility.ofBlock((Block)GregtechMetaTileEntity_IndustrialMolecularTransformer.getCasingBlock(), (int)GregtechMetaTileEntity_IndustrialMolecularTransformer.getCasingMeta())).addElement(Character.valueOf('y'), StructureUtility.ofBlock((Block)GregtechMetaTileEntity_IndustrialMolecularTransformer.getCasingBlock(), (int)GregtechMetaTileEntity_IndustrialMolecularTransformer.getCasingMeta2())).addElement(Character.valueOf('z'), StructureUtility.ofBlock((Block)GregtechMetaTileEntity_IndustrialMolecularTransformer.getCasingBlock(), (int)GregtechMetaTileEntity_IndustrialMolecularTransformer.getCasingMeta3())).addElement(Character.valueOf('e'), StructureUtility.ofBlock((Block)GregtechMetaTileEntity_IndustrialMolecularTransformer.getCasingBlock2(), (int)0)).addElement(Character.valueOf('f'), StructureUtility.ofBlock((Block)GregtechMetaTileEntity_IndustrialMolecularTransformer.getCasingBlock2(), (int)4)).addElement(Character.valueOf('c'), StructureUtility.ofBlock((Block)GregtechMetaTileEntity_IndustrialMolecularTransformer.getCoilBlock(), (int)3)).addElement(Character.valueOf('t'), (IStructureElement)StructureUtility.lazy(t -> StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregtechMetaTileEntity_IndustrialMolecularTransformer.getCasingBlock3(), (int)GregtechMetaTileEntity_IndustrialMolecularTransformer.getTungstenCasingMeta())))).addElement(Character.valueOf('h'), (IStructureElement)StructureUtility.lazy(t -> StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_IndustrialMolecularTransformer::addGenericHatch, (int)GregtechMetaTileEntity_IndustrialMolecularTransformer.getCasingTextureIndex(), (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)GregtechMetaTileEntity_IndustrialMolecularTransformer.getCasingBlock3(), (int)GregtechMetaTileEntity_IndustrialMolecularTransformer.getTungstenCasingMeta()))}))).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 3, 3, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        boolean aDidBuild = this.checkPiece(STRUCTURE_PIECE_MAIN, 3, 3, 0);
        if (this.mInputBusses.size() != 1 || this.mOutputBusses.size() != 1 || this.mEnergyHatches.size() != 1) {
            return false;
        }
        return aDidBuild && this.mCasing >= 40 && this.checkHatch();
    }

    protected static int getCasingTextureIndex() {
        return 48;
    }

    protected static Block getCasingBlock() {
        return ModBlocks.blockSpecialMultiCasings;
    }

    protected static Block getCasingBlock2() {
        return ModBlocks.blockSpecialMultiCasings2;
    }

    protected static Block getCasingBlock3() {
        return GregTech_API.sBlockCasings4;
    }

    protected static Block getCoilBlock() {
        return GregTech_API.sBlockCasings5;
    }

    protected static int getCasingMeta() {
        return 11;
    }

    protected static int getCasingMeta2() {
        return 12;
    }

    protected static int getCasingMeta3() {
        return 13;
    }

    protected static int getTungstenCasingMeta() {
        return 0;
    }

    public final boolean addGenericHatch(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        this.log("Bad Hatch");
        return false;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)44), new GT_RenderedTexture((IIconContainer)(aActive ? TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active : TexturesGtBlock.Overlay_Machine_Controller_Advanced))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)44)};
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    @Override
    public boolean requiresVanillaGtGUI() {
        return true;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "VacuumFreezer";
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GTPP_Recipe.GTPP_Recipe_Map.sMolecularTransformerRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public boolean checkRecipe(ItemStack aStack) {
        return this.checkRecipeGeneric(1, 100, 100);
    }

    @Override
    public int getMaxParallelRecipes() {
        return 1;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiMolecularTransformer;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().getFrontFacing() != 1) {
            this.getBaseMetaTileEntity().setFrontFacing((byte)1);
        }
    }
}

