/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class GregtechMetaTileEntity_IndustrialMacerator
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialMacerator> {
    private int mCasing;
    private int mPerLayer;
    private IStructureDefinition<GregtechMetaTileEntity_IndustrialMacerator> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_IndustrialMacerator(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialMacerator(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialMacerator(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Macerator/Pulverizer";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Industrial Maceration Stack").addInfo("60% faster than using single block machines of the same voltage").addInfo("Processes 8*tier materials at a time").addInfo("ULV = Tier 0, LV = Tier 1, etc.").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 6, 3, true).addController("Bottom Center").addCasingInfo("Maceration Stack Casings", 26).addInputBus("Bottom Casing", new int[]{1}).addEnergyHatch("Bottom Casing", new int[]{1}).addMaintenanceHatch("Bottom Casing", new int[]{1}).addOutputBus("One per layer except bottom layer", new int[]{2}).addMufflerHatch("Any Casing", new int[]{2}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialMacerator> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName + "top", StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}})).addShape(this.mName + "mid", StructureUtility.transpose((String[][])new String[][]{{"CCC", "C-C", "CCC"}})).addShape(this.mName + "bottom", StructureUtility.transpose((String[][])new String[][]{{"B~B", "BBB", "BBB"}})).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_IndustrialMacerator::addIndustrialMaceratorMidList, (int)TAE.GTPP_INDEX(7), (int)2), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)7))})).addElement(Character.valueOf('B'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_IndustrialMacerator::addIndustrialMaceratorBottomList, (int)TAE.GTPP_INDEX(7), (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasingsMisc, (int)7))})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName + "bottom", stackSize, hintsOnly, 1, 0, 0);
        this.buildPiece(this.mName + "mid", stackSize, hintsOnly, 1, 1, 0);
        this.buildPiece(this.mName + "mid", stackSize, hintsOnly, 1, 2, 0);
        this.buildPiece(this.mName + "mid", stackSize, hintsOnly, 1, 3, 0);
        this.buildPiece(this.mName + "mid", stackSize, hintsOnly, 1, 4, 0);
        this.buildPiece(this.mName + "top", stackSize, hintsOnly, 1, 5, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mPerLayer = 0;
        if (this.checkPiece(this.mName + "bottom", 1, 0, 0)) {
            while (this.mPerLayer < 4) {
                if (!this.checkPiece(this.mName + "mid", 1, this.mPerLayer + 1, 0) || this.mPerLayer + 1 != this.mOutputBusses.size()) {
                    return false;
                }
                ++this.mPerLayer;
            }
            return this.checkPiece(this.mName + "top", 1, 5, 0) && this.mOutputBusses.size() == 5 && this.mCasing >= 26 && this.checkHatch();
        }
        return false;
    }

    public final boolean addIndustrialMaceratorBottomList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public final boolean addIndustrialMaceratorMidList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(201);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(7)), new GT_RenderedTexture((IIconContainer)(aActive ? TexturesGtBlock.Overlay_MatterFab_Active : TexturesGtBlock.Overlay_MatterFab))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.GTPP_INDEX(7))};
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "MacerationStack";
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sMaceratorRecipes;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive() && aBaseMetaTileEntity.getFrontFacing() != 1 && aBaseMetaTileEntity.getCoverIDAtSide((byte)1) == 0 && !aBaseMetaTileEntity.getOpacityAtSide((byte)1)) {
            Random tRandom = aBaseMetaTileEntity.getWorld().field_73012_v;
            aBaseMetaTileEntity.getWorld().func_72869_a("smoke", (double)((float)aBaseMetaTileEntity.getXCoord() + 0.8f - tRandom.nextFloat() * 0.6f), (double)((float)aBaseMetaTileEntity.getYCoord() + 0.3f + tRandom.nextFloat() * 0.2f), (double)((float)aBaseMetaTileEntity.getZCoord() + 1.2f - tRandom.nextFloat() * 1.6f), 0.0, 0.0, 0.0);
        }
    }

    public boolean checkRecipe(ItemStack aStack) {
        return this.checkRecipeGeneric(this.getMaxParallelRecipes(), this.getEuDiscountForParallelism(), 60, 7500);
    }

    @Override
    protected boolean doesMachineBoostOutput() {
        return true;
    }

    @Override
    public int getMaxParallelRecipes() {
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        return Math.max(1, 8 * tTier);
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialMacerator;
    }

    @Override
    public int getAmountOfOutputs() {
        return 16;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public boolean isOverclockerUpgradable() {
        return true;
    }
}

