/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.GregTech_API;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_IndustrialForgeHammer
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialForgeHammer> {
    private int mCasing;
    private int mAnvil;
    private IStructureDefinition<GregtechMetaTileEntity_IndustrialForgeHammer> STRUCTURE_DEFINITION = null;
    private static Block sAnvil;
    private static Block sSteelAnvil;
    private static Block sDarkSteelAnvil;
    private static Block sThaumiumAnvil;
    private static Block sVoidAnvil;

    public GregtechMetaTileEntity_IndustrialForgeHammer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialForgeHammer(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        GregtechMetaTileEntity_IndustrialForgeHammer.setAnvilBlocks();
        return new GregtechMetaTileEntity_IndustrialForgeHammer(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Forge Hammer";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Industrial Forge Hammer").addInfo("Speed: 100% x Anvil Tier | Eu Usage: 100% | Parallel: Tier x 8").addInfo("T1 - Vanilla Anvil");
        if (LoadedMods.Railcraft) {
            tt.addInfo("T2 - Steel Anvil");
        }
        if (LoadedMods.EnderIO) {
            tt.addInfo("T3 - Dark Steel Anvil");
        }
        if (LoadedMods.ThaumicBases) {
            tt.addInfo("T3 - Thaumic Anvil");
            tt.addInfo("T4 - Void Anvil");
        }
        tt.addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front Center").addCasingInfo("Forge Casing", 10).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialForgeHammer> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            HashMap<Block, Integer> aBlockMap = new HashMap<Block, Integer>();
            aBlockMap.put(sAnvil, 0);
            if (LoadedMods.Railcraft) {
                aBlockMap.put(sSteelAnvil, 0);
            }
            if (LoadedMods.EnderIO) {
                aBlockMap.put(sDarkSteelAnvil, 0);
            }
            if (LoadedMods.ThaumicBases) {
                aBlockMap.put(sThaumiumAnvil, 0);
                aBlockMap.put(sVoidAnvil, 0);
            }
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "CAC", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_IndustrialForgeHammer::addIndustrialForgeHammerList, (int)TAE.getIndexFromPage(1, 11), (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)6))})).addElement(Character.valueOf('A'), StructureUtility.onElementPass(x -> ++x.mAnvil, (IStructureElement)StructureUtility.ofBlocksFlat(aBlockMap, (Block)sAnvil, (int)0))).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        GregtechMetaTileEntity_IndustrialForgeHammer.setAnvilBlocks();
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        GregtechMetaTileEntity_IndustrialForgeHammer.setAnvilBlocks();
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 10 && this.checkHatch();
    }

    public final boolean addIndustrialForgeHammerList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(1);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.getIndexFromPage(1, 11)), new GT_RenderedTexture((IIconContainer)(aActive ? TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active : TexturesGtBlock.Overlay_Machine_Controller_Advanced))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.getIndexFromPage(1, 11))};
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "MaterialPress";
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sHammerRecipes;
    }

    public boolean checkRecipe(ItemStack aStack) {
        int aAnvilTier;
        Block aAnvil = this.getBaseMetaTileEntity().getBlockAtSide(this.getBaseMetaTileEntity().getBackFacing());
        if (aAnvil != null && (aAnvilTier = GregtechMetaTileEntity_IndustrialForgeHammer.getAnvilTier(aAnvil)) > 0) {
            for (GT_MetaTileEntity_Hatch_InputBus tBus : this.mInputBusses) {
                ArrayList<ItemStack> tBusItems = new ArrayList<ItemStack>();
                tBus.mRecipeMap = this.getRecipeMap();
                if (GregtechMetaTileEntity_IndustrialForgeHammer.isValidMetaTileEntity((MetaTileEntity)tBus)) {
                    for (int i = tBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                        if (tBus.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                        tBusItems.add(tBus.getBaseMetaTileEntity().func_70301_a(i));
                    }
                }
                if (!this.checkRecipeGeneric(tBusItems.toArray(new ItemStack[0]), new FluidStack[0], this.getMaxParallelRecipes() * aAnvilTier, 100, 100, 10000)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 8 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    @Override
    public void startProcess() {
        this.sendLoopStart((byte)1);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialForgeHammer;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    private static void setAnvilBlocks() {
        if (sAnvil == null) {
            sAnvil = Blocks.field_150467_bQ;
            if (LoadedMods.Railcraft) {
                sSteelAnvil = GameRegistry.findBlock((String)"Railcraft", (String)"anvil");
            }
            if (LoadedMods.EnderIO) {
                sDarkSteelAnvil = GameRegistry.findBlock((String)"EnderIO", (String)"blockDarkSteelAnvil");
            }
            if (LoadedMods.ThaumicBases) {
                sThaumiumAnvil = GameRegistry.findBlock((String)"thaumicbases", (String)"thaumicAnvil");
                sVoidAnvil = GameRegistry.findBlock((String)"thaumicbases", (String)"voidAnvil");
            }
        }
    }

    public static boolean isBlockAnvil(Block aBlock) {
        GregtechMetaTileEntity_IndustrialForgeHammer.setAnvilBlocks();
        if (sAnvil == aBlock) {
            return true;
        }
        if (LoadedMods.Railcraft && sSteelAnvil == aBlock) {
            return true;
        }
        if (LoadedMods.EnderIO && sDarkSteelAnvil == aBlock) {
            return true;
        }
        return LoadedMods.ThaumicBases && (sThaumiumAnvil == aBlock || sVoidAnvil == aBlock);
    }

    public static int getAnvilTier(Block aBlock) {
        if (GregtechMetaTileEntity_IndustrialForgeHammer.isBlockAnvil(aBlock)) {
            if (sAnvil == aBlock) {
                return 1;
            }
            if (LoadedMods.Railcraft && sSteelAnvil == aBlock) {
                return 2;
            }
            if (LoadedMods.EnderIO && sDarkSteelAnvil == aBlock) {
                return 3;
            }
            if (LoadedMods.ThaumicBases) {
                if (sThaumiumAnvil == aBlock) {
                    return 3;
                }
                if (sVoidAnvil == aBlock) {
                    return 4;
                }
            }
        }
        return 0;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        GregtechMetaTileEntity_IndustrialForgeHammer.setAnvilBlocks();
        super.onFirstTick(aBaseMetaTileEntity);
    }
}

