/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import team.chisel.carving.Carving;

public class GregtechMetaTileEntity_IndustrialChisel
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialChisel> {
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_IndustrialChisel> STRUCTURE_DEFINITION = null;
    private ItemStack mInputCache;
    private ItemStack mOutputCache;
    private GTPP_Recipe mCachedRecipe;
    private static String sChiselSound = null;

    public GregtechMetaTileEntity_IndustrialChisel(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialChisel(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialChisel(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Chisel";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Factory Grade Auto Chisel").addInfo("Target block goes in GUI slot").addInfo("If no target provided, firdt chisel result is used").addInfo("Speed: 200% | Eu Usage: 75% | Parallel: Tier x 16").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfo("Sturdy Printer Casing", 10).addInputBus("Any casing", new int[]{1}).addOutputBus("Any casing", new int[]{1}).addEnergyHatch("Any casing", new int[]{1}).addMaintenanceHatch("Any casing", new int[]{1}).addMufflerHatch("Any casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialChisel> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_IndustrialChisel::addAdvChiselList, (int)90, (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings5Misc, (int)5))})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public final boolean addAdvChiselList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 10 && this.checkHatch();
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)90), new GT_RenderedTexture((IIconContainer)(aActive ? TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active : TexturesGtBlock.Overlay_Machine_Controller_Advanced))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)90)};
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "ImplosionCompressor";
    }

    @Override
    public boolean requiresVanillaGtGUI() {
        return true;
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return null;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    private boolean hasValidCache(ItemStack aStack, ItemStack aSpecialSlot, boolean aClearOnFailure) {
        if (this.mInputCache != null && this.mOutputCache != null && this.mCachedRecipe != null && GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.mInputCache) && GT_Utility.areStacksEqual((ItemStack)aSpecialSlot, (ItemStack)this.mOutputCache)) {
            return true;
        }
        if (aClearOnFailure) {
            this.mInputCache = null;
            this.mOutputCache = null;
            this.mCachedRecipe = null;
        }
        return false;
    }

    private void cacheItem(ItemStack aInputItem, ItemStack aOutputItem, GTPP_Recipe aRecipe) {
        this.mInputCache = aInputItem.func_77946_l();
        this.mOutputCache = aOutputItem.func_77946_l();
        this.mCachedRecipe = aRecipe;
    }

    private static boolean canBeMadeFrom(ItemStack from, ItemStack to) {
        List<ItemStack> results = GregtechMetaTileEntity_IndustrialChisel.getItemsForChiseling(from);
        for (ItemStack s : results) {
            if (s.func_77973_b() != to.func_77973_b() || s.func_77960_j() != to.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChiselResults(ItemStack from) {
        List<ItemStack> results = GregtechMetaTileEntity_IndustrialChisel.getItemsForChiseling(from);
        return results.size() > 0;
    }

    private static List<ItemStack> getItemsForChiseling(ItemStack aStack) {
        return Carving.chisel.getItemsForChiseling(aStack);
    }

    private static ItemStack getChiselOutput(ItemStack aInput, ItemStack aTarget) {
        Object tOutput = null;
        tOutput = aTarget != null && GregtechMetaTileEntity_IndustrialChisel.canBeMadeFrom(aInput, aTarget) ? aTarget : (aTarget != null && !GregtechMetaTileEntity_IndustrialChisel.canBeMadeFrom(aInput, aTarget) ? null : GregtechMetaTileEntity_IndustrialChisel.getItemsForChiseling(aInput).get(0));
        return tOutput;
    }

    private GTPP_Recipe generateChiselRecipe(ItemStack aInput, ItemStack aTarget) {
        boolean tIsCached = this.hasValidCache(aInput, aTarget, true);
        if (tIsCached || aInput != null && GregtechMetaTileEntity_IndustrialChisel.hasChiselResults(aInput)) {
            ItemStack tOutput;
            ItemStack itemStack = tOutput = tIsCached ? this.mOutputCache.func_77946_l() : GregtechMetaTileEntity_IndustrialChisel.getChiselOutput(aInput, aTarget);
            if (tOutput != null) {
                if (this.mCachedRecipe != null && GT_Utility.areStacksEqual((ItemStack)aInput, (ItemStack)this.mInputCache) && GT_Utility.areStacksEqual((ItemStack)tOutput, (ItemStack)this.mOutputCache)) {
                    return this.mCachedRecipe;
                }
                GTPP_Recipe aRecipe = new GTPP_Recipe(false, new ItemStack[]{ItemUtils.getSimpleStack(aInput, 1)}, new ItemStack[]{ItemUtils.getSimpleStack(tOutput, 1)}, null, new int[]{10000}, new FluidStack[0], new FluidStack[0], 20, 16, 0);
                this.cacheItem(aInput, tOutput, aRecipe);
                return aRecipe;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkRecipe(ItemStack aStack) {
        ArrayList aItems = this.getStoredInputs();
        if (!aItems.isEmpty()) {
            void var24_28;
            int parallelRecipes;
            GTPP_Recipe tRecipe = this.generateChiselRecipe((ItemStack)aItems.get(0), this.getGUIItemStack());
            if (tRecipe == null) {
                this.log("BAD RETURN - 0");
                return false;
            }
            ItemStack[] aItemInputs = aItems.toArray(new ItemStack[aItems.size()]);
            FluidStack[] aFluidInputs = new FluidStack[]{};
            this.mEUt = 0;
            this.mMaxProgresstime = 0;
            this.mOutputItems = new ItemStack[0];
            this.mOutputFluids = new FluidStack[0];
            long tVoltage = this.getMaxInputVoltage();
            byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
            long tEnergy = this.getMaxInputEnergy();
            this.log("Running checkRecipeGeneric(0)");
            this.log("Running checkRecipeGeneric(1)");
            this.mLastRecipe = tRecipe;
            int aMaxParallelRecipes = this.getMaxParallelRecipes();
            int aEUPercent = this.getEuDiscountForParallelism();
            int aSpeedBonusPercent = 200;
            aMaxParallelRecipes = this.canBufferOutputs(tRecipe, aMaxParallelRecipes);
            if (aMaxParallelRecipes == 0) {
                this.log("BAD RETURN - 2");
                return false;
            }
            float tRecipeEUt = (float)(tRecipe.mEUt * aEUPercent) / 100.0f;
            float tTotalEUt = 0.0f;
            this.log("parallelRecipes: " + parallelRecipes);
            this.log("aMaxParallelRecipes: " + aMaxParallelRecipes);
            this.log("tTotalEUt: " + tTotalEUt);
            this.log("tVoltage: " + tVoltage);
            this.log("tRecipeEUt: " + tRecipeEUt);
            for (parallelRecipes = 0; parallelRecipes < aMaxParallelRecipes && tTotalEUt < (float)tEnergy - tRecipeEUt; tTotalEUt += tRecipeEUt, ++parallelRecipes) {
                if (!tRecipe.isRecipeInputEqual(true, aFluidInputs, aItemInputs)) {
                    this.log("Broke at " + parallelRecipes + ".");
                    break;
                }
                this.log("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ".");
            }
            if (parallelRecipes == 0) {
                this.log("BAD RETURN - 3");
                return false;
            }
            this.log("parallelRecipes: " + parallelRecipes);
            this.log("aMaxParallelRecipes: " + aMaxParallelRecipes);
            this.log("tTotalEUt: " + tTotalEUt);
            this.log("tVoltage: " + tVoltage);
            this.log("tRecipeEUt: " + tRecipeEUt);
            aSpeedBonusPercent = Math.max(-99, aSpeedBonusPercent);
            float tTimeFactor = 100.0f / (100.0f + (float)aSpeedBonusPercent);
            this.mMaxProgresstime = (int)((float)tRecipe.mDuration * tTimeFactor);
            this.mEUt = (int)Math.ceil(tTotalEUt);
            this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
            this.mEfficiencyIncrease = 10000;
            if (this.mEUt <= 16) {
                this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
                this.mMaxProgresstime /= 1 << tTier - 1;
            } else {
                while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                    this.mEUt *= 4;
                    this.mMaxProgresstime /= 2;
                }
            }
            if (this.mEUt > 0) {
                this.mEUt = -this.mEUt;
            }
            this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
            FluidStack[] tOutputFluids = new FluidStack[tRecipe.mFluidOutputs.length];
            for (int h = 0; h < tRecipe.mFluidOutputs.length; ++h) {
                if (tRecipe.getFluidOutput(h) == null) continue;
                tOutputFluids[h] = tRecipe.getFluidOutput(h).copy();
                tOutputFluids[h].amount *= parallelRecipes;
            }
            Object[] tOutputItems = new ItemStack[tRecipe.mOutputs.length];
            for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
                if (tRecipe.getOutput(h) == null) continue;
                tOutputItems[h] = tRecipe.getOutput(h).func_77946_l();
                tOutputItems[h].field_77994_a = 0;
            }
            for (int f = 0; f < tOutputItems.length; ++f) {
                if (tRecipe.mOutputs[f] == null || tOutputItems[f] == null) continue;
                for (int g = 0; g < parallelRecipes; ++g) {
                    if (this.getBaseMetaTileEntity().getRandomNumber(10000) > tRecipe.getOutputChance(f)) continue;
                    tOutputItems[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
                }
            }
            tOutputItems = ArrayUtils.removeNulls((ItemStack[])tOutputItems);
            ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
            for (ItemStack itemStack : tOutputItems) {
                while (itemStack.func_77976_d() < itemStack.field_77994_a) {
                    ItemStack tmp = itemStack.func_77946_l();
                    tmp.field_77994_a = tmp.func_77976_d();
                    itemStack.field_77994_a -= itemStack.func_77976_d();
                    splitStacks.add(tmp);
                }
            }
            if (splitStacks.size() > 0) {
                Object[] tmp = new ItemStack[splitStacks.size()];
                tmp = splitStacks.toArray(tmp);
                tOutputItems = (ItemStack[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])tOutputItems, (Object[])tmp);
            }
            ArrayList<Object> tSList = new ArrayList<Object>();
            Object[] objectArray = tOutputItems;
            int n = objectArray.length;
            boolean bl = false;
            while (var24_28 < n) {
                Object tS = objectArray[var24_28];
                if (((ItemStack)tS).field_77994_a > 0) {
                    tSList.add(tS);
                }
                ++var24_28;
            }
            tOutputItems = tSList.toArray(new ItemStack[tSList.size()]);
            this.mOutputItems = tOutputItems;
            this.mOutputFluids = tOutputFluids;
            this.updateSlots();
            this.startProcess();
            this.log("GOOD RETURN - 1");
            return true;
        }
        return false;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 16 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 75;
    }

    private static final String getChiselSound() {
        if (sChiselSound == null) {
            sChiselSound = Carving.chisel.getVariationSound(Blocks.field_150348_b, 0);
        }
        return sChiselSound;
    }

    @Override
    public String getSound() {
        return GregtechMetaTileEntity_IndustrialChisel.getChiselSound();
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialChisel;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }
}

