/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;

public class GregtechMetaTileEntity_IndustrialArcFurnace
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialArcFurnace> {
    private static final int mCasingTextureID = TAE.getIndexFromPage(3, 3);
    public static String mCasingName = "Tempered Arc Furnace Casing";
    private boolean mPlasmaMode = false;
    private int mSize = 0;
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_IndustrialArcFurnace> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_IndustrialArcFurnace(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMetaTileEntity_IndustrialArcFurnace(String aName) {
        super(aName);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialArcFurnace(this.mName);
    }

    @Override
    public String getMachineType() {
        return "(Plasma/Electric) Arc Furnace";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for Industrial Arc Furnace").addInfo("250% faster than using single block machines of the same voltage").addInfo("Processes 8 items per voltage tier * W/L").addInfo("Max Size required to process Plasma recipes").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().addController("Top center").addStructureInfo("Size: nx3xn [WxHxL] (Hollow)").addStructureInfo("n can be 3, 5 or 7").addCasingInfo(mCasingName, 10).addInputBus("Any Casing", new int[]{1}).addOutputBus("Any Casing", new int[]{1}).addInputHatch("Any Casing", new int[]{1}).addOutputHatch("Any Casing", new int[]{1}).addEnergyHatch("Any Casing", new int[]{1}).addMaintenanceHatch("Any Casing", new int[]{1}).addMufflerHatch("Any Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialArcFurnace> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName + "3", (String[][])new String[][]{{"CCC", "C~C", "CCC"}, {"CCC", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}}).addShape(this.mName + "5", (String[][])new String[][]{{"CCCCC", "CCCCC", "CC~CC", "CCCCC", "CCCCC"}, {"CCCCC", "C---C", "C---C", "C---C", "CCCCC"}, {"CCCCC", "CCCCC", "CCCCC", "CCCCC", "CCCCC"}}).addShape(this.mName + "7", (String[][])new String[][]{{"CCCCCCC", "CCCCCCC", "CCCCCCC", "CCC~CCC", "CCCCCCC", "CCCCCCC", "CCCCCCC"}, {"CCCCCCC", "C-----C", "C-----C", "C-----C", "C-----C", "C-----C", "CCCCCCC"}, {"CCCCCCC", "CCCCCCC", "CCCCCCC", "CCCCCCC", "CCCCCCC", "CCCCCCC", "CCCCCCC"}}).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_IndustrialArcFurnace::addIndustrialArcFurnaceList, (int)mCasingTextureID, (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings4Misc, (int)3))})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public void clearHatches() {
        this.mOutputHatches.clear();
        this.mInputHatches.clear();
        this.mOutputBusses.clear();
        this.mInputBusses.clear();
        this.mEnergyHatches.clear();
        this.mMaintenanceHatches.clear();
        this.mMufflerHatches.clear();
    }

    public final boolean addIndustrialArcFurnaceList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        int size;
        switch (stackSize.field_77994_a) {
            case 1: {
                size = 3;
                break;
            }
            case 2: {
                size = 5;
                break;
            }
            default: {
                size = 7;
            }
        }
        this.buildPiece(this.mName + size, stackSize, hintsOnly, (size - 1) / 2, (size - 1) / 2, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mSize = 0;
        if (this.checkPiece(this.mName + "3", 1, 1, 0)) {
            this.mSize = 3;
            return this.mCasing >= 10 && this.checkHatch();
        }
        this.mCasing = 0;
        this.clearHatches();
        if (this.checkPiece(this.mName + "5", 2, 2, 0)) {
            this.mSize = 5;
            return this.mCasing >= 10 && this.checkHatch();
        }
        this.mCasing = 0;
        this.clearHatches();
        if (this.checkPiece(this.mName + "7", 3, 3, 0)) {
            this.mSize = 7;
            return this.mCasing >= 10 && this.checkHatch();
        }
        return false;
    }

    @Override
    public String getSound() {
        return (String)GregTech_API.sSoundList.get(207);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)mCasingTextureID), new GT_RenderedTexture((IIconContainer)(aActive ? TexturesGtBlock.Overlay_Machine_Controller_Default_Active : TexturesGtBlock.Overlay_Machine_Controller_Default))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)mCasingTextureID)};
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "IndustrialExtruder";
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return this.mPlasmaMode ? GT_Recipe.GT_Recipe_Map.sPlasmaArcFurnaceRecipes : GT_Recipe.GT_Recipe_Map.sArcFurnaceRecipes;
    }

    public boolean checkRecipe(ItemStack aStack) {
        return this.checkRecipeGeneric(this.getMaxParallelRecipes(), 100, 250);
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.mSize * 8 * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    @Override
    public void startProcess() {
        this.sendLoopStart((byte)1);
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialArcFurnace;
    }

    @Override
    public int getAmountOfOutputs() {
        return 1;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    public Block getCasingBlock() {
        return ModBlocks.blockCasings4Misc;
    }

    public byte getCasingMeta() {
        return 3;
    }

    public Block getCasingBlock2() {
        return ModBlocks.blockCasings3Misc;
    }

    public byte getCasingMeta2() {
        return 15;
    }

    public byte getCasingTextureIndex() {
        return (byte)mCasingTextureID;
    }

    @Override
    public void onModeChangeByScrewdriver(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.mSize > 5) {
            this.mPlasmaMode = Utils.invertBoolean(this.mPlasmaMode);
            if (this.mPlasmaMode) {
                PlayerUtils.messagePlayer(aPlayer, "[" + EnumChatFormatting.RED + "MODE" + EnumChatFormatting.RESET + "] " + EnumChatFormatting.LIGHT_PURPLE + "Plasma" + EnumChatFormatting.RESET);
            } else {
                PlayerUtils.messagePlayer(aPlayer, "[" + EnumChatFormatting.RED + "MODE" + EnumChatFormatting.RESET + "] " + EnumChatFormatting.YELLOW + "Electric" + EnumChatFormatting.RESET);
            }
        } else {
            PlayerUtils.messagePlayer(aPlayer, "[" + EnumChatFormatting.RED + "MODE" + EnumChatFormatting.RESET + "] " + EnumChatFormatting.GRAY + "Cannot change mode, structure not large enough." + EnumChatFormatting.RESET);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mPlasmaMode", this.mPlasmaMode);
        aNBT.func_74768_a("mSize", this.mSize);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mPlasmaMode = aNBT.func_74767_n("mPlasmaMode");
        this.mSize = aNBT.func_74762_e("mSize");
    }

    public void onMachineBlockUpdate() {
        this.mUpdate = 100;
    }
}

