/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.processing;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_IndustrialAlloySmelter
extends GregtechMeta_MultiBlockBase<GregtechMetaTileEntity_IndustrialAlloySmelter> {
    public static int CASING_TEXTURE_ID;
    private HeatingCoilLevel mHeatingCapacity;
    private int mLevel = 0;
    private int mCasing;
    private IStructureDefinition<GregtechMetaTileEntity_IndustrialAlloySmelter> STRUCTURE_DEFINITION = null;

    public GregtechMetaTileEntity_IndustrialAlloySmelter(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(2, 1);
    }

    public GregtechMetaTileEntity_IndustrialAlloySmelter(String aName) {
        super(aName);
        CASING_TEXTURE_ID = TAE.getIndexFromPage(2, 1);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_IndustrialAlloySmelter(this.mName);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)CASING_TEXTURE_ID), new GT_RenderedTexture((IIconContainer)(aActive ? Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER_ACTIVE : Textures.BlockIcons.OVERLAY_FRONT_MULTI_SMELTER))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)CASING_TEXTURE_ID)};
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), "MultiFurnace.png");
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sAlloySmelterRecipes;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack aStack) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiIndustrialAlloySmelter;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return null;
    }

    @Override
    public String getMachineType() {
        return "Alloy Smelter";
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Industrial Alloy Smelter").addInfo("Gains one parallel per voltage tier").addInfo("Gains one multiplier per coil tier").addInfo("parallel = tier * coil tier").addInfo("Gains 5% speed bonus per coil tier").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 5, 3, true).addController("Bottom center").addCasingInfo("Inconel Reinforced Casings", 10).addCasingInfo("Integral Encasement V", 8).addCasingInfo("Heating Coils", 16).addInputBus("Any Inconel Reinforced Casing", new int[]{1}).addOutputBus("Any Inconel Reinforced Casing", new int[]{1}).addEnergyHatch("Any Inconel Reinforced Casing", new int[]{1}).addMaintenanceHatch("Any Inconel Reinforced Casing", new int[]{1}).addMufflerHatch("Any Inconel Reinforced Casing", new int[]{1}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    public IStructureDefinition<GregtechMetaTileEntity_IndustrialAlloySmelter> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"HHH", "H-H", "HHH"}, {"VVV", "V-V", "VVV"}, {"HHH", "H-H", "HHH"}, {"C~C", "CCC", "CCC"}})).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GregtechMetaTileEntity_IndustrialAlloySmelter::addIndustrialAlloySmelterList, (int)CASING_TEXTURE_ID, (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)1))})).addElement(Character.valueOf('H'), GT_StructureUtility.ofCoil(GregtechMetaTileEntity_IndustrialAlloySmelter::setCoilLevel, GregtechMetaTileEntity_IndustrialAlloySmelter::getCoilLevel)).addElement(Character.valueOf('V'), StructureUtility.ofBlock((Block)ModBlocks.blockCasingsTieredGTPP, (int)4)).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public final boolean addIndustrialAlloySmelterList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 4, 0);
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mLevel = 0;
        this.setCoilLevel(HeatingCoilLevel.None);
        return this.checkPiece(this.mName, 1, 4, 0) && this.mCasing >= 10 && this.getCoilLevel() != HeatingCoilLevel.None && (this.mLevel = this.getCoilLevel().getTier() + 1) > 0 && this.checkHatch();
    }

    @Override
    public int getMaxParallelRecipes() {
        return this.mLevel * GT_Utility.getTier((long)this.getMaxInputVoltage());
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 100;
    }

    public boolean checkRecipe(ItemStack aStack) {
        FluidStack[] tFluids = this.getStoredFluids().toArray(new FluidStack[0]);
        for (GT_MetaTileEntity_Hatch_InputBus tBus : this.mInputBusses) {
            ItemStack[] tItems;
            ArrayList<ItemStack> tInputs = new ArrayList<ItemStack>();
            if (GregtechMetaTileEntity_IndustrialAlloySmelter.isValidMetaTileEntity((MetaTileEntity)tBus)) {
                for (int i = tBus.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                    if (tBus.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                    tInputs.add(tBus.getBaseMetaTileEntity().func_70301_a(i));
                }
            }
            if (tInputs.size() <= 1 || !this.checkRecipeGeneric(tItems = tInputs.toArray(new ItemStack[0]), tFluids, this.getMaxParallelRecipes(), 100, 5 * this.mLevel, 10000)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        void var25_29;
        int parallelRecipes;
        this.mEUt = 0;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = this.getMaxInputEnergy();
        Logger.WARNING("Running checkRecipeGeneric(0)");
        GT_Recipe tRecipe = this.getRecipeMap().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[tTier], aFluidInputs, aItemInputs);
        Logger.WARNING("Running checkRecipeGeneric(1)");
        this.mLastRecipe = tRecipe;
        if (tRecipe == null) {
            Logger.WARNING("BAD RETURN - 1");
            return false;
        }
        if ((aMaxParallelRecipes = this.canBufferOutputs(tRecipe, aMaxParallelRecipes)) == 0) {
            Logger.WARNING("BAD RETURN - 2");
            return false;
        }
        float tRecipeEUt = (float)(tRecipe.mEUt * aEUPercent) / 100.0f;
        int tHeatCapacityDivTiers = (int)this.mHeatingCapacity.getHeat() / 900;
        float tTotalEUt = 0.0f;
        for (parallelRecipes = 0; parallelRecipes < aMaxParallelRecipes && tTotalEUt < (float)tEnergy - tRecipeEUt; tTotalEUt += tRecipeEUt, ++parallelRecipes) {
            if (!tRecipe.isRecipeInputEqual(true, aFluidInputs, aItemInputs)) {
                Logger.WARNING("Broke at " + parallelRecipes + ".");
                break;
            }
            Logger.WARNING("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ".");
        }
        if (parallelRecipes == 0) {
            Logger.WARNING("BAD RETURN - 3");
            return false;
        }
        aSpeedBonusPercent = this.mLevel * 5;
        float tTimeFactor = 100.0f / (100.0f + (float)aSpeedBonusPercent);
        this.mMaxProgresstime = (int)((float)tRecipe.mDuration * tTimeFactor);
        int rInt = 2;
        this.mEUt = (int)Math.max(Math.ceil(tTotalEUt), 1.0);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mEUt <= 16) {
            this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
            this.mMaxProgresstime /= 1 << tTier - 1;
        } else {
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                this.mMaxProgresstime /= tHeatCapacityDivTiers >= rInt ? 4 : 2;
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        FluidStack[] tOutputFluids = new FluidStack[tRecipe.mFluidOutputs.length];
        for (int h = 0; h < tRecipe.mFluidOutputs.length; ++h) {
            if (tRecipe.getFluidOutput(h) == null) continue;
            tOutputFluids[h] = tRecipe.getFluidOutput(h).copy();
            tOutputFluids[h].amount *= parallelRecipes;
        }
        Object[] tOutputItems = new ItemStack[tRecipe.mOutputs.length];
        for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
            if (tRecipe.getOutput(h) == null) continue;
            tOutputItems[h] = tRecipe.getOutput(h).func_77946_l();
            tOutputItems[h].field_77994_a = 0;
        }
        for (int f = 0; f < tOutputItems.length; ++f) {
            if (tRecipe.mOutputs[f] == null || tOutputItems[f] == null) continue;
            for (int g = 0; g < parallelRecipes; ++g) {
                if (this.getBaseMetaTileEntity().getRandomNumber(aOutputChanceRoll) >= tRecipe.getOutputChance(f)) continue;
                tOutputItems[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
            }
        }
        tOutputItems = ArrayUtils.removeNulls((ItemStack[])tOutputItems);
        ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : tOutputItems) {
            while (itemStack.func_77976_d() < itemStack.field_77994_a) {
                ItemStack tmp = itemStack.func_77946_l();
                tmp.field_77994_a = tmp.func_77976_d();
                itemStack.field_77994_a -= itemStack.func_77976_d();
                splitStacks.add(tmp);
            }
        }
        if (splitStacks.size() > 0) {
            Object[] tmp = new ItemStack[splitStacks.size()];
            tmp = splitStacks.toArray(tmp);
            tOutputItems = (ItemStack[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])tOutputItems, (Object[])tmp);
        }
        ArrayList<Object> tSList = new ArrayList<Object>();
        Object[] objectArray = tOutputItems;
        int n = objectArray.length;
        boolean bl = false;
        while (var25_29 < n) {
            Object tS = objectArray[var25_29];
            if (((ItemStack)tS).field_77994_a > 0) {
                tSList.add(tS);
            }
            ++var25_29;
        }
        tOutputItems = tSList.toArray(new ItemStack[tSList.size()]);
        this.mOutputItems = tOutputItems;
        this.mOutputFluids = tOutputFluids;
        this.updateSlots();
        this.startProcess();
        Logger.WARNING("GOOD RETURN - 1");
        return true;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.mHeatingCapacity;
    }

    public void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.mHeatingCapacity = aCoilLevel;
    }
}

