/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.misc;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import gregtech.api.GregTech_API;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.entity.EntityTeslaTowerLightning;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class GregtechMTE_TeslaTower
extends GregtechMeta_MultiBlockBase<GregtechMTE_TeslaTower> {
    private Block casingBlock;
    private int casingMeta;
    private int frameMeta;
    private int casingTextureIndex;
    private ForgeDirection back;
    private int xLoc;
    private int yLoc;
    private int zLoc;
    protected int mRange;
    protected volatile boolean mMode = false;
    private Map<Pair<Long, Long>, Entity> mInRange = new HashMap<Pair<Long, Long>, Entity>();

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMTE_TeslaTower(this.mName);
    }

    public GregtechMTE_TeslaTower(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.initFields();
    }

    public GregtechMTE_TeslaTower(String aName) {
        super(aName);
        this.initFields();
    }

    @Override
    public String getMachineType() {
        return "Weaponized Lighting Rod";
    }

    @Override
    public boolean hasSlotInGUI() {
        return false;
    }

    @Override
    public String getCustomGUIResourceName() {
        return null;
    }

    protected final GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Tesla Defence Tower Mk3200").addInfo("Enemies within " + this.mRange + "m are blasted with a high energy plasma.").addInfo("This uses 5,000,000EU per blast.").addInfo("Can screwdriver to toggle mode between Players and all Entities.").addSeparator().beginStructureBlock(1, 7, 1, false).addController("Top Middle").addCasingInfo("Casing", 360).addOtherStructurePart("Rotor Assembly", "Any 1 dot hint", new int[]{1}).addInputBus("Any 4 dot hint (min 1)", new int[]{4}).addInputHatch("Any 4 dot hint(min 1)", new int[]{4}).addOutputHatch("Any 4 dot hint(min 1)", new int[]{4}).addEnergyHatch("Any 4 dot hint(min 1)", new int[]{4}).addMaintenanceHatch("Any 4 dot hint(min 1)", new int[]{4}).toolTipFinisher(CORE.GT_Tooltip_Builder);
        return tt;
    }

    private final void initFields() {
        this.casingBlock = ModBlocks.blockCasings2Misc;
        this.casingMeta = this.getCasingBlockItem().get(0L, new Object[0]).func_77960_j();
        this.casingTextureIndex = this.getCasingTextureIndex();
        this.mRange = 50;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureIndex()), new GT_RenderedTexture((IIconContainer)(aActive ? TexturesGtBlock.Overlay_Machine_Controller_Advanced_Active : TexturesGtBlock.Overlay_Machine_Controller_Advanced))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureIndex())};
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("mMode", this.mMode);
        aNBT.func_74768_a("mRange", this.mRange);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mMode = aNBT.func_74767_n("mMode");
        this.mRange = aNBT.func_74762_e("mRange");
        super.loadNBTData(aNBT);
    }

    private boolean isEnergyEnough() {
        return this.getEUVar() >= 5000000L;
    }

    public boolean checkRecipe(ItemStack aStack) {
        if (!this.isEnergyEnough()) {
            this.mProgresstime = 0;
            this.mMaxProgresstime = 20;
            this.getBaseMetaTileEntity().setActive(false);
            this.stopMachine();
        } else {
            this.mProgresstime = 1;
            this.mMaxProgresstime = 100;
            this.getBaseMetaTileEntity().setActive(true);
        }
        return false;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.updateCoordinates();
        for (int xOff = -1 + this.back.offsetX; xOff <= 1 + this.back.offsetX; ++xOff) {
            for (int zOff = -1 + this.back.offsetZ; zOff <= 1 + this.back.offsetZ; ++zOff) {
                if (xOff == 0 && zOff == 0) continue;
                IGregTechTileEntity tTileEntity = aBaseMetaTileEntity.getIGregTechTileEntityOffset(xOff, 0, zOff);
                if (this.checkCasingBlock(xOff, 0, zOff) || this.addMaintenanceToMachineList(tTileEntity, this.casingTextureIndex) || this.addEnergyInputToMachineList(tTileEntity, this.casingTextureIndex)) continue;
                Logger.INFO("bad block");
                return false;
            }
        }
        if (!this.checkHatches()) {
            Logger.INFO("bad Hatches");
            return false;
        }
        if (GT_Utility.getTier((long)this.getMaxInputVoltage()) < this.getMinTier()) {
            Logger.INFO("bad Voltage");
            return false;
        }
        for (int yOff = 1; yOff < 4; ++yOff) {
            if (this.checkCasingBlock(this.back.offsetX, yOff, this.back.offsetZ) && this.checkFrameBlock(this.back.offsetX + 1, yOff, this.back.offsetZ) && this.checkFrameBlock(this.back.offsetX - 1, yOff, this.back.offsetZ) && this.checkFrameBlock(this.back.offsetX, yOff, this.back.offsetZ + 1) && this.checkFrameBlock(this.back.offsetX, yOff, this.back.offsetZ - 1) && this.checkFrameBlock(this.back.offsetX, yOff + 3, this.back.offsetZ)) continue;
            Logger.INFO("bad frame?");
            return false;
        }
        Logger.INFO("good");
        return true;
    }

    private void updateCoordinates() {
        this.casingTextureIndex = this.getCasingTextureIndex();
        this.mRange = 50;
        this.xLoc = this.getBaseMetaTileEntity().getXCoord();
        this.yLoc = this.getBaseMetaTileEntity().getYCoord();
        this.zLoc = this.getBaseMetaTileEntity().getZCoord();
        this.back = ForgeDirection.getOrientation((int)this.getBaseMetaTileEntity().getBackFacing());
    }

    protected boolean checkCasingBlock(int xOff, int yOff, int zOff) {
        Logger.INFO("Looking For Casing.");
        return this.checkBlockAndMetaOffset(xOff, yOff, zOff, this.casingBlock, this.casingMeta);
    }

    protected boolean checkFrameBlock(int xOff, int yOff, int zOff) {
        Logger.INFO("Looking For Frame.");
        return this.checkBlockAndMetaOffset(xOff, yOff, zOff, GregTech_API.sBlockMachines, this.frameMeta);
    }

    protected boolean checkBlockAndMetaOffset(int xOff, int yOff, int zOff, Block block, int meta) {
        return this.checkBlockAndMeta(this.xLoc + xOff, this.yLoc + yOff, this.zLoc + zOff, block, meta);
    }

    private boolean checkBlockAndMeta(int x, int y, int z, Block block, int meta) {
        Logger.INFO("Found: " + this.getBaseMetaTileEntity().getBlock(x, y, z).func_149732_F() + " | Meta: " + this.getBaseMetaTileEntity().getMetaID(x, y, z));
        Logger.INFO("Expected: " + block.func_149732_F() + " | Meta: " + meta);
        return (meta == Short.MAX_VALUE || this.getBaseMetaTileEntity().getMetaID(x, y, z) == meta) && this.getBaseMetaTileEntity().getBlock(x, y, z) == block;
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    public int getPollutionPerTick(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    protected int getMinTier() {
        return 7;
    }

    protected boolean checkHatches() {
        return !this.mMaintenanceHatches.isEmpty() && !this.mEnergyHatches.isEmpty();
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        try {
            if (this.getBaseMetaTileEntity().isServerSide()) {
                if (this.mEnergyHatches.size() > 0) {
                    for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
                        if (!GregtechMTE_TeslaTower.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
                        long mHT = tHatch.getBaseMetaTileEntity().getInputVoltage();
                        if (tHatch.getEUVar() < mHT) continue;
                        int o = 0;
                        while ((long)o < tHatch.getEUVar() / mHT) {
                            if (this.getEUVar() < this.maxEUStore() - mHT) {
                                tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(mHT, false);
                                this.setEUVar(this.getEUVar() + mHT);
                            }
                            if (this.getEUVar() < this.maxEUStore() - mHT) {
                                tHatch.getBaseMetaTileEntity().decreaseStoredEnergyUnits(mHT, false);
                                this.setEUVar(this.getEUVar() + mHT);
                            }
                            ++o;
                        }
                    }
                }
                if (aTick % 10L == 0L && this.getEUVar() >= 5000000L) {
                    this.getBaseMetaTileEntity().enableWorking();
                    this.getBaseMetaTileEntity().setActive(true);
                    if (this.mProgresstime <= 0) {
                        ++this.mProgresstime;
                    } else if (this.mProgresstime >= 100) {
                        this.mProgresstime = 0;
                    }
                    this.mMaxProgresstime = 10000;
                }
                if (aTick % 20L == 0L) {
                    List o = aBaseMetaTileEntity.getWorld().field_72996_f;
                    if (this.mInRange.size() > 0) {
                        for (Entity j : this.mInRange.values()) {
                            if (!(j.func_70011_f((double)this.xLoc, (double)this.yLoc, (double)this.zLoc) > (double)this.mRange)) continue;
                            this.mInRange.remove(new Pair<Long, Long>(j.func_110124_au().getMostSignificantBits(), j.func_110124_au().getLeastSignificantBits()), j);
                        }
                    }
                    if (o.size() > 0) {
                        for (Object r : o) {
                            if (!(r instanceof Entity) || ((Entity)r).func_110124_au().equals(this.getOwner()) || !((Entity)r).func_70089_S() && !(r instanceof EntityLiving) || !(((Entity)r).func_70011_f((double)this.xLoc, (double)this.yLoc, (double)this.zLoc) <= (double)this.mRange) || r instanceof EntityItem) continue;
                            if (!this.mMode) {
                                this.mInRange.put(new Pair<Long, Long>(((Entity)r).func_110124_au().getMostSignificantBits(), ((Entity)r).func_110124_au().getLeastSignificantBits()), (Entity)r);
                                continue;
                            }
                            if (!(r instanceof EntityPlayer)) continue;
                            this.mInRange.put(new Pair<Long, Long>(((Entity)r).func_110124_au().getMostSignificantBits(), ((Entity)r).func_110124_au().getLeastSignificantBits()), (Entity)r);
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        try {
            if (this.getBaseMetaTileEntity().isServerSide()) {
                if (this.getEUVar() >= 0L && !this.getBaseMetaTileEntity().isAllowedToWork()) {
                    this.mProgresstime = 20;
                    this.mMaxProgresstime = 40;
                } else if (this.getEUVar() >= 0L && this.getBaseMetaTileEntity().isAllowedToWork()) {
                    this.mProgresstime = 20;
                    this.mMaxProgresstime = 40;
                }
                if (aTick % 10L == 0L && this.mInRange.size() > 0 && this.getEUVar() >= 5000000L) {
                    for (Entity f : this.mInRange.values()) {
                        if (!(f instanceof EntityLiving)) continue;
                        int j1 = (int)f.field_70165_t;
                        int l1 = (int)f.field_70163_u;
                        int k1 = (int)f.field_70161_v;
                        World world = aBaseMetaTileEntity.getWorld();
                        if (!f.func_70089_S() || f.func_110124_au().equals(this.getOwner()) || !this.isEnergyEnough() || !world.func_72942_c((Entity)new EntityTeslaTowerLightning(world, j1, l1, k1, f, this.getOwner()))) continue;
                        if (f == null || f.field_70128_L || !f.func_70089_S()) {
                            this.mInRange.remove(new Pair<Long, Long>(f.func_110124_au().getMostSignificantBits(), f.func_110124_au().getLeastSignificantBits()));
                        }
                        this.setEUVar(this.getEUVar() - 5000000L);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    protected GregtechItemList getCasingBlockItem() {
        return GregtechItemList.Casing_TeslaTower;
    }

    protected int getCasingTextureIndex() {
        return TAE.GTPP_INDEX(30);
    }

    public UUID getOwner() {
        return PlayerUtils.getPlayersUUIDByName(this.getBaseMetaTileEntity().getOwnerName());
    }

    public boolean isEnetInput() {
        return false;
    }

    public long maxAmperesIn() {
        return 32L;
    }

    public long maxEUInput() {
        return 131072L;
    }

    public long maxEUStore() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onModeChangeByScrewdriver(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mMode = Utils.invertBoolean(this.mMode);
        this.mInRange.clear();
        if (this.mMode) {
            PlayerUtils.messagePlayer(aPlayer, "[Tesla Tower] Now only targetting players.");
        } else {
            PlayerUtils.messagePlayer(aPlayer, "[Tesla Tower] Targetting all types of entities.");
        }
    }

    @Override
    public int getMaxParallelRecipes() {
        return 0;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
    }

    public IStructureDefinition getStructureDefinition() {
        return null;
    }
}

