/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.misc;

import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TAE;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.ItemStackData;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GMTE_AmazonPackager
extends GregtechMeta_MultiBlockBase<GMTE_AmazonPackager> {
    private long mVoltage;
    private byte mTier;
    private int mCasing;
    private ItemStack mSchematicCache;
    private ItemStack mInputCache;
    private ItemStack mOutputCache;
    private GT_Recipe mCachedRecipe;
    private IStructureDefinition<GMTE_AmazonPackager> STRUCTURE_DEFINITION = null;
    private static final FluidStack[] sNoFluids = new FluidStack[0];

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GMTE_AmazonPackager(this.mName);
    }

    public GMTE_AmazonPackager(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GMTE_AmazonPackager(String aName) {
        super(aName);
    }

    @Override
    public String getMachineType() {
        return "Packager";
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    @Override
    public String getCustomGUIResourceName() {
        return "Generic3By3";
    }

    public IStructureDefinition<GMTE_AmazonPackager> getStructureDefinition() {
        if (this.STRUCTURE_DEFINITION == null) {
            this.STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"CCC", "CCC", "CCC"}, {"C~C", "C-C", "CCC"}, {"CCC", "CCC", "CCC"}})).addElement(Character.valueOf('C'), (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GT_StructureUtility.ofHatchAdder(GMTE_AmazonPackager::addAmazonPackagerList, (int)TAE.getIndexFromPage(2, 9), (int)1), StructureUtility.onElementPass(x -> ++x.mCasing, (IStructureElement)StructureUtility.ofBlock((Block)ModBlocks.blockCasings3Misc, (int)9))})).build();
        }
        return this.STRUCTURE_DEFINITION;
    }

    public final boolean addAmazonPackagerList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType(this.getMachineType()).addInfo("Controller Block for the Amazon Warehouse").addInfo("This Multiblock is used for EXTREME packaging requirements").addInfo("Dust Schematics are inserted into the input busses").addInfo("If inserted into the controller, it is shared across all busses").addInfo("1x, 2x, 3x & Other Schematics are to be placed into the controller GUI slot").addInfo("Uncomparably fast compared to a single packager of the same tier").addInfo("Only uses 75% of the eu/t normally required").addInfo("Processes 16 items per voltage tier").addPollutionAmount(this.getPollutionPerSecond(null)).addSeparator().beginStructureBlock(3, 3, 3, true).addController("Front center").addCasingInfo("Supply Depot Casings", 10).addInputBus("Any casing", new int[]{1}).addOutputBus("Any casing", new int[]{1}).addEnergyHatch("Any casing", new int[]{1}).addMaintenanceHatch("Any casing", new int[]{1}).addMufflerHatch("Any casing", new int[]{1}).toolTipFinisher("GT++");
        return tt;
    }

    private final void initFields() {
        this.mVoltage = this.getMaxInputVoltage();
        this.mTier = (byte)Math.max(1, GT_Utility.getTier((long)this.mVoltage));
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.getIndexFromPage(2, 9)), new GT_RenderedTexture((IIconContainer)(aActive ? TexturesGtBlock.Overlay_Machine_Controller_Default_Active : TexturesGtBlock.Overlay_Machine_Controller_Default))};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)TAE.getIndexFromPage(2, 9))};
    }

    public GT_Recipe.GT_Recipe_Map getRecipeMap() {
        return GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes;
    }

    public void sortInputBusses() {
        for (GT_MetaTileEntity_Hatch_InputBus h : this.mInputBusses) {
            h.updateSlots();
        }
    }

    public boolean checkRecipe(ItemStack aStack) {
        ItemStack[] tItemInputs;
        boolean state;
        this.initFields();
        ArrayList tItems = this.getStoredInputs();
        if (this.getGUIItemStack() != null) {
            tItems.add(this.getGUIItemStack());
        }
        if (state = this.checkRecipeGeneric(tItemInputs = tItems.toArray(new ItemStack[tItems.size()]), sNoFluids, 16 * GT_Utility.getTier((long)this.getMaxInputVoltage()), 75, 500, 10000)) {
            return true;
        }
        tItems = this.getStoredInputs();
        AutoMap<ItemStackData> mCompleted = new AutoMap<ItemStackData>();
        AutoMap<ItemStackData> mSchematics = new AutoMap<ItemStackData>();
        for (ItemStack tInputItem : tItems) {
            if (tInputItem == null || !ItemList.Schematic_1by1.isStackEqual((Object)tInputItem) && !ItemList.Schematic_2by2.isStackEqual((Object)tInputItem) && !ItemList.Schematic_3by3.isStackEqual((Object)tInputItem)) continue;
            mSchematics.put(new ItemStackData(tInputItem));
        }
        if (mSchematics.size() > 0) {
            for (ItemStackData g : mSchematics) {
                for (ItemStack tInputItem : tItems) {
                    if (tInputItem == null) continue;
                    mCompleted.put(new ItemStackData(tInputItem));
                    this.checkRecipe(tInputItem, g.getStack());
                }
            }
        }
        return mCompleted != null && mCompleted.size() > 0;
    }

    public boolean checkRecipe(ItemStack inputStack, ItemStack schematicStack) {
        if (GT_Utility.isStackValid((Object)inputStack) && GT_Utility.isStackValid((Object)schematicStack) && GT_Utility.getContainerItem((ItemStack)inputStack, (boolean)true) == null) {
            if (ItemList.Schematic_1by1.isStackEqual((Object)schematicStack) && inputStack.field_77994_a >= 1) {
                ItemStack tOutputStack = GT_ModHandler.getRecipeOutput((ItemStack[])new ItemStack[]{inputStack});
                if (tOutputStack != null && this.allowPutStack(tOutputStack, schematicStack)) {
                    ItemStack input = inputStack;
                    --input.field_77994_a;
                    this.mEUt = 32 * (1 << this.mTier - 1) * (1 << this.mTier - 1);
                    this.mMaxProgresstime = 2;
                    this.addOutput(tOutputStack);
                    this.updateSlots();
                    return true;
                }
                return false;
            }
            if (ItemList.Schematic_2by2.isStackEqual((Object)schematicStack) && inputStack.field_77994_a >= 4) {
                ItemStack tOutputStack = GT_ModHandler.getRecipeOutput((ItemStack[])new ItemStack[]{inputStack, inputStack, null, inputStack, inputStack});
                if (tOutputStack != null && this.allowPutStack(tOutputStack, schematicStack)) {
                    ItemStack input2 = inputStack;
                    input2.field_77994_a -= 4;
                    this.mEUt = 32 * (1 << this.mTier - 1) * (1 << this.mTier - 1);
                    this.mMaxProgresstime = 4;
                    this.addOutput(tOutputStack);
                    this.updateSlots();
                    return true;
                }
                return false;
            }
            if (ItemList.Schematic_3by3.isStackEqual((Object)schematicStack) && inputStack.field_77994_a >= 9) {
                ItemStack tOutputStack = GT_ModHandler.getRecipeOutput((ItemStack[])new ItemStack[]{inputStack, inputStack, inputStack, inputStack, inputStack, inputStack, inputStack, inputStack, inputStack});
                if (tOutputStack != null && this.allowPutStack(tOutputStack, schematicStack)) {
                    ItemStack input3 = inputStack;
                    input3.field_77994_a -= 9;
                    this.mEUt = 32 * (1 << this.mTier - 1) * (1 << this.mTier - 1);
                    this.mMaxProgresstime = 6;
                    this.addOutput(tOutputStack);
                    this.updateSlots();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private ItemStack getSchematic(ItemStack[] aInputs) {
        for (ItemStack aStack : aInputs) {
            if (!ItemList.Schematic_Dust.isStackEqual((Object)aStack) && !ItemList.Schematic_1by1.isStackEqual((Object)aStack) && !ItemList.Schematic_2by2.isStackEqual((Object)aStack) && !ItemList.Schematic_3by3.isStackEqual((Object)aStack)) continue;
            return aStack;
        }
        return null;
    }

    private ItemStack getRecipeInput(ItemStack[] aInputs) {
        for (ItemStack aStack : aInputs) {
            if (ItemList.Schematic_Dust.isStackEqual((Object)aStack) || ItemList.Schematic_1by1.isStackEqual((Object)aStack) || ItemList.Schematic_2by2.isStackEqual((Object)aStack) || ItemList.Schematic_3by3.isStackEqual((Object)aStack)) continue;
            return aStack;
        }
        return null;
    }

    private boolean hasValidCache(ItemStack aStack, ItemStack aSchematic, boolean aClearOnFailure) {
        if (this.mSchematicCache != null && this.mInputCache != null && this.mOutputCache != null && this.mCachedRecipe != null && GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.mInputCache) && GT_Utility.areStacksEqual((ItemStack)aSchematic, (ItemStack)this.mSchematicCache)) {
            return true;
        }
        if (aClearOnFailure) {
            this.mSchematicCache = null;
            this.mInputCache = null;
            this.mOutputCache = null;
            this.mCachedRecipe = null;
        }
        return false;
    }

    private void cacheItem(ItemStack aSchematic, ItemStack aInputItem, ItemStack aOutputItem, GT_Recipe aRecipe) {
        this.mSchematicCache = aSchematic.func_77946_l();
        this.mInputCache = aInputItem.func_77946_l();
        this.mOutputCache = aOutputItem.func_77946_l();
        this.mCachedRecipe = aRecipe;
    }

    private GT_Recipe generatePackageRecipe(ItemStack aSchematic, ItemStack aInput) {
        ItemStack tOutput;
        boolean tIsCached = this.hasValidCache(aInput, aSchematic, true);
        if (tIsCached && (tOutput = this.mOutputCache.func_77946_l()) != null && this.mCachedRecipe != null && GT_Utility.areStacksEqual((ItemStack)aInput, (ItemStack)this.mInputCache) && GT_Utility.areStacksEqual((ItemStack)tOutput, (ItemStack)this.mOutputCache)) {
            int aRequiredInputSize = 0;
            if (ItemList.Schematic_Dust.isStackEqual((Object)aSchematic)) {
                if (OrePrefixes.dustTiny.contains(aInput)) {
                    aRequiredInputSize = 9;
                }
                if (OrePrefixes.dustSmall.contains(aInput)) {
                    aRequiredInputSize = 4;
                }
                if (OrePrefixes.dust.contains(aInput)) {
                    aRequiredInputSize = 1;
                }
            }
            if (ItemList.Schematic_1by1.isStackEqual((Object)aSchematic)) {
                aRequiredInputSize = 1;
            }
            if (ItemList.Schematic_2by2.isStackEqual((Object)aSchematic)) {
                aRequiredInputSize = 4;
            }
            if (ItemList.Schematic_3by3.isStackEqual((Object)aSchematic)) {
                aRequiredInputSize = 9;
            }
            if (aInput.field_77994_a >= aRequiredInputSize) {
                this.log("Using Cached Recipe. Require: " + aRequiredInputSize + ", Found: " + aInput.field_77994_a);
                return this.mCachedRecipe;
            }
            this.log("Not enough input");
        }
        GT_Recipe aRecipe = this.lookupRecipe();
        this.log("Looking up new recipe");
        if (aRecipe != null) {
            aInput = aInput != null ? aInput : this.getRecipeInput(aRecipe.mInputs);
            this.cacheItem(aSchematic, aInput, aRecipe.mOutputs[0], aRecipe);
            if (this.hasValidCache(aInput, aSchematic, false)) {
                this.log("Caching Recipe");
                return aRecipe;
            }
        }
        return null;
    }

    private GT_Recipe lookupRecipe() {
        ArrayList aItems = this.getStoredInputs();
        if (this.getGUIItemStack() != null) {
            aItems.add(this.getGUIItemStack());
        }
        ItemStack[] aItemInputs = aItems.toArray(new ItemStack[aItems.size()]);
        GT_Recipe tRecipe = this.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, false, GT_Values.V[this.mTier], sNoFluids, aItemInputs);
        if (tRecipe != null) {
            return tRecipe;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll, GT_Recipe aRecipe) {
        void var27_31;
        int parallelRecipes;
        this.mEUt = 0;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = this.getMaxInputEnergy();
        this.log("Running checkRecipeGeneric(0)");
        ItemStack aInput = this.getRecipeInput(aItemInputs);
        ItemStack aSchematic = this.getSchematic(aItemInputs);
        GT_Recipe tRecipe = this.generatePackageRecipe(aSchematic, aInput);
        ItemStack[] aRealInputs = new ItemStack[]{aSchematic, aInput};
        this.log("Running checkRecipeGeneric(1)");
        this.mLastRecipe = tRecipe;
        if (tRecipe == null) {
            this.log("BAD RETURN - 1");
            return false;
        }
        if ((aMaxParallelRecipes = this.canBufferOutputs(tRecipe, aMaxParallelRecipes)) == 0) {
            this.log("BAD RETURN - 2");
            return false;
        }
        float tRecipeEUt = (float)(tRecipe.mEUt * aEUPercent) / 100.0f;
        float tTotalEUt = 0.0f;
        this.log("parallelRecipes: " + parallelRecipes);
        this.log("aMaxParallelRecipes: " + aMaxParallelRecipes);
        this.log("tTotalEUt: " + tTotalEUt);
        this.log("tVoltage: " + tVoltage);
        this.log("tRecipeEUt: " + tRecipeEUt);
        for (parallelRecipes = 0; parallelRecipes < aMaxParallelRecipes && tTotalEUt < (float)tEnergy - tRecipeEUt; tTotalEUt += tRecipeEUt, ++parallelRecipes) {
            if (!tRecipe.isRecipeInputEqual(true, sNoFluids, aItemInputs)) {
                this.log("Broke at " + parallelRecipes + ".");
                break;
            }
            this.log("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ".");
        }
        if (parallelRecipes == 0) {
            this.mCachedRecipe = null;
            this.log("BAD RETURN - 3 - Reset Cached Recipe");
            return false;
        }
        aSpeedBonusPercent = Math.max(-99, aSpeedBonusPercent);
        float tTimeFactor = 100.0f / (100.0f + (float)aSpeedBonusPercent);
        this.mMaxProgresstime = (int)((float)tRecipe.mDuration * tTimeFactor);
        this.mEUt = (int)Math.ceil(tTotalEUt);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mEUt <= 16) {
            this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
            this.mMaxProgresstime /= 1 << tTier - 1;
        } else {
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                if (this.hasPerfectOverclock()) {
                    this.mMaxProgresstime /= 4;
                    continue;
                }
                this.mMaxProgresstime /= 2;
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        FluidStack[] tOutputFluids = new FluidStack[tRecipe.mFluidOutputs.length];
        for (int h = 0; h < tRecipe.mFluidOutputs.length; ++h) {
            if (tRecipe.getFluidOutput(h) == null) continue;
            tOutputFluids[h] = tRecipe.getFluidOutput(h).copy();
            tOutputFluids[h].amount *= parallelRecipes;
        }
        Object[] tOutputItems = new ItemStack[tRecipe.mOutputs.length];
        for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
            if (tRecipe.getOutput(h) == null) continue;
            tOutputItems[h] = tRecipe.getOutput(h).func_77946_l();
            tOutputItems[h].field_77994_a = 0;
        }
        for (int f = 0; f < tOutputItems.length; ++f) {
            if (tRecipe.mOutputs[f] == null || tOutputItems[f] == null) continue;
            for (int g = 0; g < parallelRecipes; ++g) {
                if (this.getBaseMetaTileEntity().getRandomNumber(aOutputChanceRoll) >= tRecipe.getOutputChance(f)) continue;
                tOutputItems[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
            }
        }
        tOutputItems = ArrayUtils.removeNulls((ItemStack[])tOutputItems);
        ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : tOutputItems) {
            while (itemStack.func_77976_d() < itemStack.field_77994_a) {
                ItemStack tmp = itemStack.func_77946_l();
                tmp.field_77994_a = tmp.func_77976_d();
                itemStack.field_77994_a -= itemStack.func_77976_d();
                splitStacks.add(tmp);
            }
        }
        if (splitStacks.size() > 0) {
            Object[] tmp = new ItemStack[splitStacks.size()];
            tmp = splitStacks.toArray(tmp);
            tOutputItems = (ItemStack[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])tOutputItems, (Object[])tmp);
        }
        ArrayList<Object> tSList = new ArrayList<Object>();
        Object[] objectArray = tOutputItems;
        int n = objectArray.length;
        boolean bl = false;
        while (var27_31 < n) {
            Object tS = objectArray[var27_31];
            if (((ItemStack)tS).field_77994_a > 0) {
                tSList.add(tS);
            }
            ++var27_31;
        }
        tOutputItems = tSList.toArray(new ItemStack[tSList.size()]);
        this.mOutputItems = tOutputItems;
        this.mOutputFluids = tOutputFluids;
        this.updateSlots();
        this.startProcess();
        this.log("GOOD RETURN - 1");
        return true;
    }

    public boolean allowPutStack(ItemStack aStack, ItemStack schematicStack) {
        if (!(ItemList.Schematic_1by1.isStackEqual((Object)schematicStack) || ItemList.Schematic_2by2.isStackEqual((Object)schematicStack) || ItemList.Schematic_3by3.isStackEqual((Object)schematicStack))) {
            return GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes.containsInput(aStack);
        }
        if (GT_Recipe.GT_Recipe_Map.sBoxinatorRecipes.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), true, GT_Values.V[this.mTier], (FluidStack[])null, new ItemStack[]{GT_Utility.copyAmount((long)64L, (Object[])new Object[]{aStack}), schematicStack}) != null) {
            return true;
        }
        if (ItemList.Schematic_1by1.isStackEqual((Object)schematicStack) && GT_ModHandler.getRecipeOutput((ItemStack[])new ItemStack[]{aStack}) != null) {
            return true;
        }
        if (ItemList.Schematic_2by2.isStackEqual((Object)schematicStack) && GT_ModHandler.getRecipeOutput((ItemStack[])new ItemStack[]{aStack, aStack, null, aStack, aStack}) != null) {
            return true;
        }
        return ItemList.Schematic_3by3.isStackEqual((Object)schematicStack) && GT_ModHandler.getRecipeOutput((ItemStack[])new ItemStack[]{aStack, aStack, aStack, aStack, aStack, aStack, aStack, aStack, aStack}) != null;
    }

    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        return this.checkPiece(this.mName, 1, 1, 0) && this.mCasing >= 10 && this.checkHatch();
    }

    public int getMaxEfficiency(ItemStack p0) {
        return 10000;
    }

    public int getPollutionPerSecond(ItemStack arg0) {
        return CORE.ConfigSwitches.pollutionPerSecondMultiPackager;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 9;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 1, 1, 0);
    }
}

