/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_DeluxeMachine;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_PocketFusion
extends GT_MetaTileEntity_DeluxeMachine {
    private boolean mCanProcessRecipe = false;
    private boolean mCharging = false;
    private long mChargeConsumed = 0L;
    private GT_Recipe mLastRecipe;
    private long mEUStore;
    private boolean mRunningOnLoad = false;
    private boolean mMachine = false;
    private int mEfficiency;
    private int mEfficiencyIncrease;
    private int mEfficiencyMax = 0;
    private int mStartUpCheck = 100;
    private int mUpdate = 0;
    private FluidStack[] mOutputFluids = null;
    long mFusionPoint = 20000000L;

    public GregtechMetaTileEntity_PocketFusion(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "It's like a midget Ra.", 1, 1, "PotionBrewer.png", "", new ITexture[0]);
    }

    public GregtechMetaTileEntity_PocketFusion(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
    }

    public String[] getDescription() {
        return new String[]{this.mDescription, "Not Very Fast, but not very big either.", "Each side pair in/out puts to different slots.", "Top & Bottom Sides are Outputs.", "Front & Back are Input Plasma 1.", "Sides are Input Plasma 2.", CORE.GT_Tooltip};
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_PocketFusion(this.mName, this.mTier, this.mDescription, this.mTextures, this.mGUIName, this.mNEIName);
    }

    public int tier() {
        return this.mTier;
    }

    public int tierOverclock() {
        return this.mTier == 6 ? 0 : (this.mTier == 7 ? 1 : 2);
    }

    private GT_RenderedTexture getCasingTexture() {
        return new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Machine_Advanced);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (aSide == aFacing ? 0 : (aSide == GT_Utility.getOppositeSide((int)aFacing) ? 1 : (aSide == 0 ? 2 : (aSide == 1 ? 3 : 4))))][aColorIndex + 1];
    }

    @Override
    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return GTPP_Recipe.GTPP_Recipe_Map.sSlowFusionRecipes;
    }

    @Override
    public boolean isOutputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getBackFacing();
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.getFluid().getName().contains("plasma") || super.isFluidInputAllowed(aFluid);
    }

    public int getCapacity() {
        return 32000;
    }

    @Override
    public void abortProcess() {
        super.abortProcess();
    }

    @Override
    public int checkRecipe() {
        Logger.MACHINE_INFO("Recipe Tick 1.", new Object[0]);
        if (!this.mCanProcessRecipe) {
            Logger.MACHINE_INFO("Recipe Tick 1.1 - Cannot Process Recipe.", new Object[0]);
            if (this.mChargeConsumed < this.mFusionPoint) {
                Logger.MACHINE_INFO("Recipe Tick 1.2 - Cannot Ignite Fusion, Charge too low.", new Object[0]);
                this.mCharging = true;
                this.mCanProcessRecipe = false;
                if (this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.mFusionPoint / 100L, false)) {
                    Logger.MACHINE_INFO("Recipe Tick 1.3 - Charging Internal storage. " + this.mFusionPoint / 100L + "/" + this.mFusionPoint, new Object[0]);
                    this.mChargeConsumed += this.mFusionPoint / 100L;
                }
            } else {
                this.mChargeConsumed = 0L;
                this.mCharging = false;
                this.mCanProcessRecipe = true;
            }
        } else {
            Logger.MACHINE_INFO("Recipe Tick 1.1 - Try to Process Recipe.", new Object[0]);
            if (this.checkRecipeMulti()) {
                Logger.MACHINE_INFO("Recipe Tick 1.2 - Process Recipe was Successful.", new Object[0]);
                return 2;
            }
        }
        Logger.MACHINE_INFO("Recipe Tick 2. - Process Recipe failed.", new Object[0]);
        return 0;
    }

    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> mList = new ArrayList<FluidStack>();
        mList.add(this.mFluid);
        mList.add(this.mFluid2);
        return mList;
    }

    public boolean checkRecipeMulti() {
        ArrayList<FluidStack> tFluidList = this.getStoredFluids();
        int tFluidList_sS = tFluidList.size();
        block0: for (int i = 0; i < tFluidList_sS - 1; ++i) {
            for (int j = i + 1; j < tFluidList_sS; ++j) {
                if (!GT_Utility.areFluidsEqual((FluidStack)tFluidList.get(i), (FluidStack)tFluidList.get(j))) continue;
                if (tFluidList.get((int)i).amount >= tFluidList.get((int)j).amount) {
                    tFluidList.remove(j--);
                    tFluidList_sS = tFluidList.size();
                    continue;
                }
                tFluidList.remove(i--);
                tFluidList_sS = tFluidList.size();
                continue block0;
            }
        }
        if (tFluidList.size() > 1) {
            FluidStack[] tFluids = tFluidList.toArray(new FluidStack[tFluidList.size()]);
            GT_Recipe tRecipe = this.getRecipeList().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[8], tFluids, new ItemStack[0]);
            if (tRecipe == null) {
                return false;
            }
            if (tRecipe == null && !this.mRunningOnLoad || tRecipe != null && this.maxEUStore() < (long)tRecipe.mSpecialValue) {
                this.mLastRecipe = null;
                Logger.MACHINE_INFO("Just plain bad.", new Object[0]);
                return false;
            }
            if (this.mRunningOnLoad || tRecipe.isRecipeInputEqual(true, tFluids, new ItemStack[0])) {
                this.mLastRecipe = tRecipe;
                this.mEUt = this.mLastRecipe.mEUt * this.overclock(this.mLastRecipe.mSpecialValue);
                this.mMaxProgresstime = this.mLastRecipe.mDuration / this.overclock(this.mLastRecipe.mSpecialValue);
                this.mEfficiencyIncrease = 10000;
                this.mOutputFluids = this.mLastRecipe.mFluidOutputs;
                this.mRunningOnLoad = false;
                return true;
            }
        }
        return false;
    }

    public int overclock(int mStartEnergy) {
        if (this.tierOverclock() == 1) {
            return 1;
        }
        if (this.tierOverclock() == 2) {
            return mStartEnergy < 160000000 ? 2 : 1;
        }
        return mStartEnergy < 160000000 ? 4 : (mStartEnergy < 320000000 ? 2 : 1);
    }

    @Override
    public boolean displaysItemStack() {
        return false;
    }

    @Override
    public boolean doesAutoOutputFluids() {
        return true;
    }

    @Override
    public boolean doesEmptyContainers() {
        return true;
    }

    @Override
    public boolean doesFillContainers() {
        return true;
    }

    @Override
    public long maxAmperesIn() {
        return 16L;
    }

    @Override
    public long maxEUStore() {
        return Long.MAX_VALUE;
    }

    public void doExplosion(long aExplosionPower) {
        super.doExplosion(aExplosionPower * 2L);
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        this.onRunningTickMulti();
        if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive() && aBaseMetaTileEntity.getFrontFacing() != 1 && aBaseMetaTileEntity.getCoverIDAtSide((byte)1) == 0 && !aBaseMetaTileEntity.getOpacityAtSide((byte)1) && MathUtils.randInt(0, 4) == 4) {
            Random tRandom = aBaseMetaTileEntity.getWorld().field_73012_v;
            aBaseMetaTileEntity.getWorld().func_72869_a("magicCrit", (double)((float)aBaseMetaTileEntity.getXCoord() + 0.8f - tRandom.nextFloat() * 0.6f), (double)((float)aBaseMetaTileEntity.getYCoord() + 0.3f + tRandom.nextFloat() * 0.2f), (double)((float)aBaseMetaTileEntity.getZCoord() + 1.2f - tRandom.nextFloat() * 1.6f), 0.0, 0.0, 0.0);
            aBaseMetaTileEntity.getWorld().func_72869_a("magicCrit", (double)((float)aBaseMetaTileEntity.getXCoord() + 0.4f - tRandom.nextFloat() * 0.3f), (double)((float)aBaseMetaTileEntity.getYCoord() + 0.2f + tRandom.nextFloat() * 0.1f), (double)((float)aBaseMetaTileEntity.getZCoord() + 0.8f - tRandom.nextFloat() * 0.6f), 0.0, 0.0, 0.0);
            aBaseMetaTileEntity.getWorld().func_72869_a("magicCrit", (double)((float)aBaseMetaTileEntity.getXCoord() + 0.6f - tRandom.nextFloat() * 0.9f), (double)((float)aBaseMetaTileEntity.getYCoord() + 0.4f + tRandom.nextFloat() * 0.3f), (double)((float)aBaseMetaTileEntity.getZCoord() + 1.8f - tRandom.nextFloat() * 2.6f), 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("mCanProcessRecipe", this.mCanProcessRecipe);
        aNBT.func_74757_a("mCharging", this.mCharging);
        aNBT.func_74772_a("mChargeConsumed", this.mChargeConsumed);
        aNBT.func_74768_a("mEfficiency", this.mEfficiency);
        aNBT.func_74768_a("mEfficiencyIncrease", this.mEfficiencyIncrease);
        aNBT.func_74768_a("mEfficiencyMax", this.mEfficiencyMax);
        aNBT.func_74768_a("mStartUpCheck", this.mStartUpCheck);
        aNBT.func_74768_a("mUpdate", this.mUpdate);
        aNBT.func_74768_a("mEfficiencyIncrease", this.mEfficiencyIncrease);
        aNBT.func_74757_a("mRunningOnLoad", this.mRunningOnLoad);
        aNBT.func_74757_a("mMachine", this.mMachine);
        aNBT.func_74772_a("mEUStore", this.mEUStore);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        if (this.mMaxProgresstime > 0) {
            this.mRunningOnLoad = true;
        }
        this.mCanProcessRecipe = aNBT.func_74767_n("mCanProcessRecipe");
        this.mCharging = aNBT.func_74767_n("mCharging");
        this.mChargeConsumed = aNBT.func_74763_f("mChargeConsumed");
        this.mEfficiency = aNBT.func_74762_e("mEfficiency");
        this.mEfficiencyIncrease = aNBT.func_74762_e("mEfficiencyIncrease");
        this.mEfficiencyMax = aNBT.func_74762_e("mEfficiencyMax");
        this.mStartUpCheck = aNBT.func_74762_e("mStartUpCheck");
        this.mUpdate = aNBT.func_74762_e("mUpdate");
        this.mEfficiencyIncrease = aNBT.func_74762_e("mEfficiencyIncrease");
        this.mEfficiencyIncrease = aNBT.func_74762_e("mEfficiencyIncrease");
        this.mRunningOnLoad = aNBT.func_74767_n("mRunningOnLoad");
        this.mMachine = aNBT.func_74767_n("mMachine");
        this.mEUStore = aNBT.func_74763_f("mEUStore");
        super.loadNBTData(aNBT);
    }

    @Override
    public String[] getInfoData() {
        String tier = this.tier() == 6 ? "I" : (this.tier() == 7 ? "II" : "III");
        float plasmaOut = 0.0f;
        String fusionName = "";
        int powerRequired = 0;
        if (this.mLastRecipe != null) {
            fusionName = this.mLastRecipe.mFluidOutputs[0].getLocalizedName() + " Fusion.";
            powerRequired = this.mLastRecipe.mEUt;
            if (this.mLastRecipe.getFluidOutput(0) != null) {
                plasmaOut = (float)this.mLastRecipe.getFluidOutput((int)0).amount / (float)this.mLastRecipe.mDuration;
            }
        }
        return new String[]{"Fusion Reactor MK " + tier, "EU Required: " + powerRequired + "EU/t", "Stored EU: " + this.getEUVar() + " / " + this.maxEUStore(), "Plasma Output: " + plasmaOut + "L/t", "Current Recipe: " + fusionName};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{this.getCasingTexture(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_MatterFab)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{this.getCasingTexture(), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{this.getCasingTexture(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Machine_Dimensional_Orange)};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{this.getCasingTexture(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_MatterFab_Active)};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{this.getCasingTexture(), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PIPE_OUT)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.MACHINE_CASING_FUSION_GLASS_YELLOW)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{this.getCasingTexture(), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Machine_Dimensional_Blue)};
    }

    public void onMachineBlockUpdate() {
        this.mUpdate = 50;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mEfficiency < 0) {
                this.mEfficiency = 0;
            }
            if (this.mRunningOnLoad) {
                Logger.MACHINE_INFO("2", new Object[0]);
                this.mEUStore = (int)aBaseMetaTileEntity.getStoredEU();
                this.checkRecipeMulti();
            }
            if (--this.mUpdate == 0 || --this.mStartUpCheck == 0) {
                Logger.MACHINE_INFO("3", new Object[0]);
                this.mMachine = true;
            }
            if (this.mStartUpCheck < 0) {
                if (this.mMachine) {
                    if (aBaseMetaTileEntity.getStoredEU() + (long)(2048 * this.tierOverclock()) >= this.maxEUStore() || aBaseMetaTileEntity.increaseStoredEnergyUnits((long)(2048 * this.tierOverclock()), true)) {
                        // empty if block
                    }
                    if (this.mEUStore <= 0L && this.mMaxProgresstime > 0) {
                        Logger.MACHINE_INFO("6", new Object[0]);
                        this.stopMachine();
                        this.mLastRecipe = null;
                    }
                    if (this.mMaxProgresstime > 0) {
                        Logger.MACHINE_INFO("7", new Object[0]);
                        this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((long)this.mEUt, true);
                        if (this.mMaxProgresstime > 0 && ++this.mProgresstime >= this.mMaxProgresstime) {
                            if (this.mOutputFluids != null) {
                                for (FluidStack tStack : this.mOutputFluids) {
                                    if (tStack == null) continue;
                                    this.addOutput(tStack);
                                }
                            }
                            this.mEfficiency = Math.max(0, this.mEfficiency + this.mEfficiencyIncrease);
                            this.mProgresstime = 0;
                            this.mMaxProgresstime = 0;
                            this.mEfficiencyIncrease = 0;
                            if (this.mOutputFluids == null || this.mOutputFluids.length > 0) {
                                // empty if block
                            }
                            this.mEUStore = (int)aBaseMetaTileEntity.getStoredEU();
                            if (aBaseMetaTileEntity.isAllowedToWork()) {
                                this.checkRecipeMulti();
                            }
                        }
                    } else {
                        this.mEUStore = (int)aBaseMetaTileEntity.getStoredEU();
                        if (aTick % 100L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled() || aBaseMetaTileEntity.hasInventoryBeenModified()) {
                            Logger.MACHINE_INFO("9", new Object[0]);
                            if (aBaseMetaTileEntity.isAllowedToWork()) {
                                Logger.MACHINE_INFO("10", new Object[0]);
                                if (this.checkRecipeMulti()) {
                                    Logger.MACHINE_INFO("11", new Object[0]);
                                    if (this.mEUStore < (long)this.mLastRecipe.mSpecialValue) {
                                        Logger.MACHINE_INFO("12", new Object[0]);
                                        this.mMaxProgresstime = 0;
                                    }
                                    aBaseMetaTileEntity.decreaseStoredEnergyUnits((long)this.mLastRecipe.mSpecialValue, true);
                                }
                            }
                            if (this.mMaxProgresstime <= 0) {
                                this.mEfficiency = Math.max(0, this.mEfficiency - 1000);
                            }
                        }
                    }
                } else {
                    Logger.MACHINE_INFO("Bad", new Object[0]);
                    this.mLastRecipe = null;
                    this.stopMachine();
                }
            }
            Logger.MACHINE_INFO("Good | " + this.mMaxProgresstime, new Object[0]);
            aBaseMetaTileEntity.setActive(this.mMaxProgresstime > 0);
        }
    }

    public boolean onRunningTickMulti() {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            if (this.mEUt < 0 && !this.drainEnergyInput((long)(-this.mEUt) * 10000L / (long)Math.max(1000, this.mEfficiency))) {
                this.mLastRecipe = null;
                this.stopMachine();
                Logger.MACHINE_INFO("a1", new Object[0]);
                return false;
            }
            if (this.mEUStore <= 0L) {
                this.mLastRecipe = null;
                this.stopMachine();
                Logger.MACHINE_INFO("a2", new Object[0]);
                return false;
            }
        }
        return true;
    }

    public boolean drainEnergyInput(long aEU) {
        return false;
    }

    public boolean addOutput(FluidStack aLiquid) {
        FluidStack copiedFluidStack;
        if (aLiquid == null) {
            return false;
        }
        this.mOutputFluid = copiedFluidStack = aLiquid.copy();
        return false;
    }

    public void stopMachine() {
        this.mEUt = 0;
        this.mEfficiency = 0;
        this.mProgresstime = 0;
        this.mMaxProgresstime = 0;
        this.mEfficiencyIncrease = 0;
        this.getBaseMetaTileEntity().disableWorking();
    }

    @Override
    public boolean isLiquidInput(byte aSide) {
        switch (aSide) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isLiquidOutput(byte aSide) {
        switch (aSide) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
        }
        return true;
    }

    @Override
    public int fill(FluidStack aFluid, boolean doFill) {
        return super.fill(aFluid, doFill);
    }

    @Override
    public FluidStack drain(int maxDrain, boolean doDrain) {
        return super.drain(maxDrain, doDrain);
    }

    public int getTankPressure() {
        return 500;
    }

    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        if (aSide == ForgeDirection.UP || aSide == ForgeDirection.DOWN) {
            return false;
        }
        return super.canFill(aSide, aFluid);
    }

    public boolean canDrain(ForgeDirection aSide, Fluid aFluid) {
        if (aSide == ForgeDirection.UP || aSide == ForgeDirection.DOWN) {
            return super.canDrain(aSide, aFluid);
        }
        return false;
    }

    public int fill_default(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        if (aSide == ForgeDirection.UP || aSide == ForgeDirection.DOWN) {
            return 0;
        }
        return super.fill_default(aSide, aFluid, doFill);
    }

    public int fill(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        if (aSide == ForgeDirection.UP || aSide == ForgeDirection.DOWN) {
            return super.fill(aSide, aFluid, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        if (aSide == ForgeDirection.UP || aSide == ForgeDirection.DOWN) {
            return super.drain(aSide, aFluid, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection aSide, int maxDrain, boolean doDrain) {
        if (aSide == ForgeDirection.UP || aSide == ForgeDirection.DOWN) {
            return super.drain(aSide, maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public boolean isOverclockerUpgradable() {
        return true;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        return super.onRightclick(aBaseMetaTileEntity, aPlayer);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        return super.onRightclick(aBaseMetaTileEntity, aPlayer, aSide, aX, aY, aZ);
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return super.getServerGUI(aID, aPlayerInventory, aBaseMetaTileEntity);
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        return false;
    }

    public void onExplosion() {
        super.onExplosion();
    }

    @Override
    public void startProcess() {
        this.sendLoopStart((byte)1);
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1) {
            GT_Utility.doSoundAtClient((String)((String)GregTech_API.sSoundList.get(212)), (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        }
    }
}

