/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.slots.SlotChemicalPlantInput;
import gtPlusPlus.xmod.gregtech.api.gui.fluidreactor.Container_FluidReactor;
import gtPlusPlus.xmod.gregtech.api.gui.fluidreactor.GUI_FluidReactor;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.List;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class GregtechMetaTileEntity_ChemicalReactor
extends GT_MetaTileEntity_BasicMachine {
    public boolean mFluidTransfer_1 = false;
    public boolean mFluidTransfer_2 = false;
    public FluidStack[] mInputFluids = new FluidStack[4];
    public FluidStack[] mOutputFluids = new FluidStack[2];

    public GregtechMetaTileEntity_ChemicalReactor(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, "For mixing fluids", 4, 4, "ChemicalReactor.png", "", new ITexture[]{new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_FluidReactor_Side_Active), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_FluidReactor_Side), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_FluidReactor_Front_Active), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_FluidReactor_Front), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_FluidReactor_Top_Active), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_FluidReactor_Top), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_FluidReactor_Top_Active), new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_FluidReactor_Top)});
    }

    public GregtechMetaTileEntity_ChemicalReactor(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 1, aDescription, aTextures, 1, 1, aGUIName, aNEIName);
    }

    public String[] getDescription() {
        return new String[]{this.mDescription, "Because why not?", CORE.GT_Tooltip};
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        try {
            GregtechMetaTileEntity_ChemicalReactor y = new GregtechMetaTileEntity_ChemicalReactor(this.mName, this.mTier, this.mDescription, this.mTextures, this.mGUIName, this.mNEIName);
            return y;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        try {
            Container_FluidReactor y = new Container_FluidReactor(aPlayerInventory, aBaseMetaTileEntity);
            return y;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GUI_FluidReactor(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), this.mGUIName, GT_Utility.isStringValid((Object)this.mNEIName) ? this.mNEIName : (this.getRecipeList() != null ? this.getRecipeList().mUnlocalizedName : ""));
    }

    public GT_Recipe.GT_Recipe_Map getRecipeList() {
        return null;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, aSide, aStack) && this.getRecipeList().containsInput(aStack);
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return super.isFluidInputAllowed(aFluid);
    }

    public int getCapacity() {
        return 32000 * Math.max(1, this.mTier) / 4;
    }

    public int getInputSlot() {
        return 3;
    }

    public boolean isLiquidInput(byte aSide) {
        return aSide > 1;
    }

    public boolean isLiquidOutput(byte aSide) {
        return aSide < 2;
    }

    public int getOutputSlot() {
        return super.getOutputSlot();
    }

    public int getStackDisplaySlot() {
        return super.getStackDisplaySlot();
    }

    public boolean doesEmptyContainers() {
        return true;
    }

    public boolean canTankBeFilled() {
        return super.canTankBeFilled();
    }

    public boolean canTankBeEmptied() {
        return super.canTankBeEmptied();
    }

    public FluidStack getDisplayedFluid() {
        return super.getDisplayedFluid();
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        int i;
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mFluidTransfer_1", this.mFluidTransfer_1);
        aNBT.func_74757_a("mFluidTransfer_2", this.mFluidTransfer_2);
        for (i = 0; i < 4; ++i) {
            if (this.mInputFluids[i] == null) continue;
            aNBT.func_74782_a("mInputFluid" + i, (NBTBase)this.mInputFluids[i].writeToNBT(new NBTTagCompound()));
        }
        for (i = 0; i < 2; ++i) {
            if (this.mOutputFluids[i] == null) continue;
            aNBT.func_74782_a("mOutputFluid" + i, (NBTBase)this.mOutputFluids[i].writeToNBT(new NBTTagCompound()));
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        int i;
        super.loadNBTData(aNBT);
        this.mFluidTransfer_1 = aNBT.func_74767_n("mFluidTransfer_1");
        this.mFluidTransfer_2 = aNBT.func_74767_n("mFluidTransfer_2");
        for (i = 0; i < 4; ++i) {
            if (this.mInputFluids[i] != null) continue;
            this.mInputFluids[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mInputFluid" + i));
        }
        for (i = 0; i < 2; ++i) {
            if (this.mOutputFluids[i] != null) continue;
            this.mOutputFluids[i] = FluidStack.loadFluidStackFromNBT((NBTTagCompound)aNBT.func_74775_l("mOutputFluid" + i));
        }
    }

    public FluidStack getFillableStack() {
        return this.mFluid;
    }

    public FluidStack setFillableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        return this.mFluid;
    }

    public FluidStack getDrainableStack() {
        return this.mFluid;
    }

    public FluidStack setDrainableStack(FluidStack aFluid) {
        this.mFluid = aFluid;
        return this.mFluid;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            int i;
            this.mCharge = aBaseMetaTileEntity.getStoredEU() / 2L > aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.mDecharge = aBaseMetaTileEntity.getStoredEU() < aBaseMetaTileEntity.getEUCapacity() / 3L;
            this.doDisplayThings();
            boolean tSucceeded = false;
            if (this.mMaxProgresstime > 0 && (this.mProgresstime >= 0 || aBaseMetaTileEntity.isAllowedToWork())) {
                aBaseMetaTileEntity.setActive(true);
                if (this.mProgresstime >= 0 && !this.drainEnergyForProcess(this.mEUt)) {
                    if (!this.mStuttering) {
                        this.stutterProcess();
                        if (this.canHaveInsufficientEnergy()) {
                            this.mProgresstime = -100;
                        }
                        this.mStuttering = true;
                    }
                } else {
                    if (++this.mProgresstime >= this.mMaxProgresstime) {
                        for (i = 0; i < this.mOutputItems.length; ++i) {
                            for (i = 0; i < this.mOutputItems.length && !aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot() + (i + i) % this.mOutputItems.length, this.mOutputItems[i]); ++i) {
                            }
                        }
                        if (this.mOutputFluid != null) {
                            if (this.getDrainableStack() == null) {
                                this.setDrainableStack(this.mOutputFluid.copy());
                            } else if (this.mOutputFluid.isFluidEqual(this.getDrainableStack())) {
                                FluidStack var10000 = this.getDrainableStack();
                                var10000.amount += this.mOutputFluid.amount;
                            }
                        }
                        for (i = 0; i < this.mOutputItems.length; ++i) {
                            this.mOutputItems[i] = null;
                        }
                        this.mOutputFluid = null;
                        this.mEUt = 0;
                        this.mProgresstime = 0;
                        this.mMaxProgresstime = 0;
                        this.mStuttering = false;
                        tSucceeded = true;
                        this.endProcess();
                    }
                    if (this.mProgresstime > 5) {
                        this.mStuttering = false;
                    }
                }
            } else {
                aBaseMetaTileEntity.setActive(false);
            }
            boolean tRemovedOutputFluid = false;
            if (this.doesAutoOutputFluids() && this.getDrainableStack() != null && aBaseMetaTileEntity.getFrontFacing() != this.mMainFacing && (tSucceeded || aTick % 20L == 0L)) {
                int tFilledAmount;
                FluidStack tDrained;
                IFluidHandler tTank = aBaseMetaTileEntity.getITankContainerAtSide(aBaseMetaTileEntity.getFrontFacing());
                if (tTank != null && (tDrained = this.drain(1000, false)) != null && (tFilledAmount = tTank.fill(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()), tDrained, false)) > 0) {
                    tTank.fill(ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()), this.drain(tFilledAmount, true), true);
                }
                if (this.getDrainableStack() == null) {
                    tRemovedOutputFluid = true;
                }
            }
            if (this.doesAutoOutput() && !this.isOutputEmpty() && aBaseMetaTileEntity.getFrontFacing() != this.mMainFacing && (tSucceeded || this.mOutputBlocked % 300 == 1 || aBaseMetaTileEntity.hasInventoryBeenModified() || aTick % 600L == 0L)) {
                TileEntity tTileEntity2 = aBaseMetaTileEntity.getTileEntityAtSide(aBaseMetaTileEntity.getFrontFacing());
                int tCosts = 1;
                for (int j = 0; j < this.mOutputItems.length && tCosts > 0 && aBaseMetaTileEntity.isUniversalEnergyStored(128L); ++j) {
                    tCosts = GT_Utility.moveOneItemStack((Object)aBaseMetaTileEntity, (Object)tTileEntity2, (byte)aBaseMetaTileEntity.getFrontFacing(), (byte)aBaseMetaTileEntity.getBackFacing(), (List)null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1);
                    if (tCosts <= 0) continue;
                    aBaseMetaTileEntity.decreaseStoredEnergyUnits((long)tCosts, true);
                }
            }
            if (this.mOutputBlocked != 0) {
                this.mOutputBlocked = this.isOutputEmpty() ? 0 : ++this.mOutputBlocked;
            }
            if (this.allowToCheckRecipe()) {
                if (this.mMaxProgresstime <= 0 && aBaseMetaTileEntity.isAllowedToWork() && (tRemovedOutputFluid || tSucceeded || aBaseMetaTileEntity.hasInventoryBeenModified() || aTick % 600L == 0L || aBaseMetaTileEntity.hasWorkJustBeenEnabled()) && this.hasEnoughEnergyToCheckRecipe()) {
                    if (this.checkRecipe() == 2) {
                        if (this.mInventory[3] != null && this.mInventory[3].field_77994_a <= 0) {
                            this.mInventory[3] = null;
                        }
                        int j = i + this.mInputSlotCount;
                        for (i = this.getInputSlot(); i < j; ++i) {
                            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
                            this.mInventory[i] = null;
                        }
                        for (i = 0; i < this.mOutputItems.length; ++i) {
                            this.mOutputItems[i] = GT_Utility.copy((Object[])new Object[]{this.mOutputItems[i]});
                            if (this.mOutputItems[i] != null && this.mOutputItems[i].field_77994_a > 64) {
                                this.mOutputItems[i].field_77994_a = 64;
                            }
                            this.mOutputItems[i] = GT_OreDictUnificator.get((boolean)true, (ItemStack)this.mOutputItems[i]);
                        }
                        if (this.mFluid != null && this.mFluid.amount <= 0) {
                            this.mFluid = null;
                        }
                        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
                        if (GT_Utility.isDebugItem((ItemStack)this.mInventory[this.dechargerSlotStartIndex()])) {
                            this.mMaxProgresstime = 1;
                            this.mEUt = 1;
                        }
                        this.startProcess();
                    } else {
                        this.mMaxProgresstime = 0;
                        for (i = 0; i < this.mOutputItems.length; ++i) {
                            this.mOutputItems[i] = null;
                        }
                        this.mOutputFluid = null;
                    }
                }
            } else if (!this.mStuttering) {
                this.stutterProcess();
                this.mStuttering = true;
            }
        }
    }

    protected void doDisplayThings() {
        super.doDisplayThings();
    }

    protected ItemStack getSpecialSlot() {
        return super.getSpecialSlot();
    }

    protected ItemStack getOutputAt(int aIndex) {
        return super.getOutputAt(aIndex);
    }

    protected ItemStack[] getAllOutputs() {
        return super.getAllOutputs();
    }

    protected ItemStack getInputAt(int aIndex) {
        return super.getInputAt(aIndex);
    }

    protected ItemStack[] getAllInputs() {
        return super.getAllInputs();
    }

    protected boolean displaysInputFluid() {
        return true;
    }

    protected boolean displaysOutputFluid() {
        return true;
    }

    public boolean doesAutoOutput() {
        return super.doesAutoOutput();
    }

    public boolean doesAutoOutputFluids() {
        return this.mFluidTransfer_1 && this.mFluidTransfer_2;
    }

    public void startProcess() {
        super.startProcess();
    }

    public void endProcess() {
        super.endProcess();
    }

    public String[] getInfoData() {
        return super.getInfoData();
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return super.allowPullStack(aBaseMetaTileEntity, aIndex, aSide, aStack);
    }

    public int checkRecipe() {
        return super.checkRecipe();
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
    }

    public FluidStack getFluid() {
        return super.getFluid();
    }

    public int getFluidAmount() {
        return super.getFluidAmount();
    }

    public int fill(FluidStack aFluid, boolean doFill) {
        return super.fill(aFluid, doFill);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return super.drain(maxDrain, doDrain);
    }

    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        if (aIndex >= 3 && aIndex <= 6) {
            return SlotChemicalPlantInput.isItemValidForChemicalPlantSlot(aStack);
        }
        return false;
    }

    public int[] func_94128_d(int aSide) {
        return super.func_94128_d(aSide);
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int aSide) {
        if (aIndex >= 3 && aIndex <= 6) {
            return super.func_102007_a(aIndex, aStack, aSide);
        }
        return false;
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int aSide) {
        if (aIndex >= 7 && aIndex <= 11) {
            return super.func_102008_b(aIndex, aStack, aSide);
        }
        return false;
    }

    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        return super.canFill(aSide, aFluid);
    }

    public boolean canDrain(ForgeDirection aSide, Fluid aFluid) {
        return super.canDrain(aSide, aFluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        return super.getTankInfo(aSide);
    }

    public int fill_default(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        return super.fill_default(aSide, aFluid, doFill);
    }

    public int fill(ForgeDirection aSide, FluidStack aFluid, boolean doFill) {
        return super.fill(aSide, aFluid, doFill);
    }

    public FluidStack drain(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        return super.drain(aSide, aFluid, doDrain);
    }

    public FluidStack drain(ForgeDirection aSide, int maxDrain, boolean doDrain) {
        return super.drain(aSide, maxDrain, doDrain);
    }
}

