/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicMachine;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.interfaces.IChunkLoader;
import gtPlusPlus.core.chunkloading.GTPP_ChunkManager;
import gtPlusPlus.core.chunkloading.StaticChunkFunctions;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class GregtechMetaTileEntityChunkLoader
extends GT_MetaTileEntity_BasicMachine
implements IChunkLoader {
    private long mTicksRemainingForChunkloading = -1L;
    private ChunkCoordIntPair mCurrentChunk;
    private Set<ChunkCoordIntPair> mLoadedChunks = new HashSet<ChunkCoordIntPair>();
    private boolean mRefreshChunkTickets = false;

    public GregtechMetaTileEntityChunkLoader(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 2, "Loads " + GregtechMetaTileEntityChunkLoader.getMaxChunksToLoadForTier(aTier) + " chunks when powered", 0, 0, "Recycler.png", "", new ITexture[0]);
    }

    public GregtechMetaTileEntityChunkLoader(String aName, int aTier, String aDescription, ITexture[][][] aTextures, String aGUIName, String aNEIName) {
        super(aName, aTier, 2, aDescription, aTextures, 0, 0, aGUIName, aNEIName);
    }

    public static int getMaxChunksToLoadForTier(int aTier) {
        if (aTier < 4) {
            return 9;
        }
        if (aTier < 6) {
            return 49;
        }
        if (aTier < 8) {
            return 225;
        }
        return 0;
    }

    public String[] getDescription() {
        return new String[]{"Loads " + GregtechMetaTileEntityChunkLoader.getMaxChunksToLoadForTier(this.mTier) + " chunks when powered", "Consumes 2A", "Behaves Identically to a Railcraft World Anchor", CORE.GT_Tooltip};
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[(aActive ? 5 : 0) + (aSide == aFacing ? 0 : (aSide == GT_Utility.getOppositeSide((int)aFacing) ? 1 : (aSide == 0 ? 2 : (aSide == 1 ? 3 : 4))))][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier])};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier])};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier])};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier])};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier])};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier + 1])};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier + 1])};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier + 1])};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier + 1])};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_Material_MaragingSteel), new GT_RenderedTexture(TexturesGtBlock.TIERED_MACHINE_HULLS[this.mTier + 1])};
    }

    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntityChunkLoader(this.mName, this.mTier, this.mDescription, this.mTextures, this.mGUIName, this.mNEIName);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        this.showPollution(aPlayer.func_130014_f_(), aPlayer);
        return true;
    }

    private void showPollution(World worldIn, EntityPlayer playerIn) {
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public String[] getInfoData() {
        return super.getInfoData();
    }

    public boolean isGivingInformation() {
        return true;
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public int func_70302_i_() {
        return 0;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.mCurrentChunk == null) {
            int xTile = this.getBaseMetaTileEntity().getXCoord();
            int zTile = this.getBaseMetaTileEntity().getZCoord();
            this.createInitialWorkingChunk(aBaseMetaTileEntity, xTile, zTile);
        }
        if (StaticChunkFunctions.onPostTick(aBaseMetaTileEntity, aTick) && this.getChunkLoadingActive()) {
            this.setEUVar(this.getEUVar() - this.maxEUInput() * this.maxAmperesIn());
            if (this.getDoesWorkChunkNeedReload()) {
                GTPP_ChunkManager.requestChunkLoad((TileEntity)this.getBaseMetaTileEntity(), this.mCurrentChunk);
                if (!this.mLoadedChunks.isEmpty()) {
                    for (ChunkCoordIntPair Y : this.mLoadedChunks) {
                        GTPP_ChunkManager.requestChunkLoad((TileEntity)this.getBaseMetaTileEntity(), Y);
                    }
                }
                this.setDoesWorkChunkNeedReload(false);
            }
        }
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        StaticChunkFunctions.saveNBTDataForTileEntity(this.getBaseMetaTileEntity(), aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        StaticChunkFunctions.loadNBTDataForTileEntity(this.getBaseMetaTileEntity(), aNBT);
    }

    public long maxAmperesIn() {
        return 2L;
    }

    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier] * 2L;
    }

    public long maxEUStore() {
        return GT_Values.V[this.mTier] * 256L;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    @Override
    public long getTicksRemaining() {
        return -1L;
    }

    @Override
    public void setTicksRemaining(long aTicks) {
        this.mTicksRemainingForChunkloading = aTicks;
    }

    @Override
    public ChunkCoordIntPair getResidingChunk() {
        return this.mCurrentChunk;
    }

    @Override
    public void setResidingChunk(ChunkCoordIntPair aCurrentChunk) {
        this.mCurrentChunk = aCurrentChunk;
    }

    @Override
    public boolean getChunkLoadingActive() {
        return this.getEUVar() >= this.maxEUInput() * this.maxAmperesIn();
    }

    @Override
    public void setChunkLoadingActive(boolean aActive) {
    }

    @Override
    public boolean getDoesWorkChunkNeedReload() {
        return this.mRefreshChunkTickets;
    }

    @Override
    public void setDoesWorkChunkNeedReload(boolean aActive) {
        this.mRefreshChunkTickets = aActive;
    }

    @Override
    public boolean addChunkToLoadedList(ChunkCoordIntPair aActiveChunk) {
        return this.mLoadedChunks.add(aActiveChunk);
    }

    @Override
    public boolean removeChunkFromLoadedList(ChunkCoordIntPair aActiveChunk) {
        return this.mLoadedChunks.remove(aActiveChunk);
    }

    @Override
    public Set<ChunkCoordIntPair> getManagedChunks() {
        return this.mLoadedChunks;
    }

    public void onRemoval() {
        StaticChunkFunctions.onRemoval(this.getBaseMetaTileEntity());
        super.onRemoval();
    }

    public static Set<ChunkCoordIntPair> spiralChunks(IGregTechTileEntity aBaseMetaTileEntity, int X2, int Z) {
        World w = aBaseMetaTileEntity.getWorld();
        HashSet<ChunkCoordIntPair> aSet = new HashSet<ChunkCoordIntPair>();
        if (w == null) {
            return aSet;
        }
        Chunk thisChunk = w.func_72938_d(aBaseMetaTileEntity.getXCoord(), aBaseMetaTileEntity.getZCoord());
        ChunkCoordIntPair aChunkCo = new ChunkCoordIntPair(thisChunk.field_76635_g, thisChunk.field_76647_h);
        int dx = 0;
        int z = 0;
        int x = 0;
        int dz = -1;
        int t = Math.max(X2, Z);
        int maxI = t * t;
        for (int i = 0; i < maxI; ++i) {
            Chunk C;
            if (-X2 / 2 <= x && x <= X2 / 2 && -Z / 2 <= z && z <= Z / 2 && (C = w.func_72964_e(aChunkCo.field_77276_a + x, aChunkCo.field_77275_b + z)) != null) {
                aSet.add(new ChunkCoordIntPair(C.field_76635_g, C.field_76647_h));
            }
            if (x == z || x < 0 && x == -z || x > 0 && x == 1 - z) {
                t = dx;
                dx = -dz;
                dz = t;
            }
            x += dx;
            z += dz;
        }
        return aSet;
    }

    @Override
    public int getChunkloaderTier() {
        return this.mTier;
    }

    public void createInitialWorkingChunk(IGregTechTileEntity aBaseMetaTileEntity, int aTileX, int aTileZ) {
        int centerX = aTileX >> 4;
        int centerZ = aTileZ >> 4;
        this.addChunkToLoadedList(new ChunkCoordIntPair(centerX, centerZ));
        GTPP_ChunkManager.requestChunkLoad((TileEntity)aBaseMetaTileEntity.getMetaTileEntity(), this.getResidingChunk());
        if (this.getManagedChunks().isEmpty()) {
            int aChunks = GregtechMetaTileEntityChunkLoader.getMaxChunksToLoadForTier(this.getChunkloaderTier());
            this.mLoadedChunks.addAll(GregtechMetaTileEntityChunkLoader.spiralChunks(aBaseMetaTileEntity, this.getChunkloaderTier(), this.getChunkloaderTier()));
        }
        if (!this.mLoadedChunks.isEmpty()) {
            for (ChunkCoordIntPair Y : this.mLoadedChunks) {
                GTPP_ChunkManager.requestChunkLoad((TileEntity)aBaseMetaTileEntity.getMetaTileEntity(), Y);
            }
        }
        this.setDoesWorkChunkNeedReload(false);
    }
}

