/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.api.gui.basic.GT_Container_CropHarvestor;
import gtPlusPlus.xmod.gregtech.api.gui.basic.GT_GUIContainer_CropHarvestor;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import ic2.core.item.DamageHandler;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class GT_MetaTileEntity_CropHarvestor
extends GT_MetaTileEntity_BasicTank {
    protected String mLocalName;
    private static final int SLOT_WEEDEX_1 = 1;
    private static final int SLOT_WEEDEX_2 = 2;
    private static final int SLOT_FERT_1 = 3;
    private static final int SLOT_FERT_4 = 6;
    private static final int SLOT_OUTPUT_START = 7;
    public boolean mModeAlternative = false;
    private HashSet<ICropTile> mCropCache = new HashSet();
    private boolean mInvalidCache = false;

    public GT_MetaTileEntity_CropHarvestor(int aID, int aTier, String aDescription) {
        super(aID, "basicmachine.cropharvester.0" + aTier, "Crop Manager (" + GT_Values.VN[aTier] + ")", aTier, 21, aDescription, new ITexture[0]);
        this.mLocalName = "Crop Manager (" + GT_Values.VN[aTier] + ")";
    }

    public GT_MetaTileEntity_CropHarvestor(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 21, aDescription, aTextures);
        this.mLocalName = "Crop Manager (" + GT_Values.VN[aTier] + ")";
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_CropHarvestor(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_CropHarvestor(aPlayerInventory, aBaseMetaTileEntity, this.mLocalName);
    }

    public boolean isTransformerUpgradable() {
        return true;
    }

    public boolean isOverclockerUpgradable() {
        return true;
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isInputFacing(byte aSide) {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isElectric() {
        return true;
    }

    public long maxAmperesIn() {
        return 8L;
    }

    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier];
    }

    public long maxEUStore() {
        return GT_Values.V[this.mTier] * ((long)this.mTier * GT_Values.V[this.mTier]);
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public int getCapacity() {
        return 32000 * this.mTier;
    }

    public int getTankPressure() {
        return -100;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_CropHarvestor(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public int func_70302_i_() {
        return 21;
    }

    private static final int getRange(int aTier) {
        switch (aTier) {
            case 1: {
                return 1;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 9;
            }
            case 4: {
                return 13;
            }
            case 5: {
                return 17;
            }
            case 6: {
                return 21;
            }
            case 7: {
                return 25;
            }
            case 8: {
                return 29;
            }
            case 9: {
                return 33;
            }
        }
        return 0;
    }

    public boolean doesInventoryHaveSpace() {
        for (int i = 7; i < this.func_70302_i_(); ++i) {
            if (this.mInventory[i] != null && this.mInventory[i].field_77994_a >= 64) continue;
            return true;
        }
        return false;
    }

    public long powerUsage() {
        return this.maxEUInput() / 8L;
    }

    public long powerUsageSecondary() {
        return this.maxEUInput() / 32L;
    }

    public static AutoMap<ItemStack> splitOutputStacks(ItemStack aOutput) {
        return GT_MetaTileEntity_CropHarvestor.splitOutputStacks(new ItemStack[]{aOutput});
    }

    public static AutoMap<ItemStack> splitOutputStacks(ItemStack[] aOutputs) {
        AutoMap<ItemStack> aOutputMap = new AutoMap<ItemStack>();
        for (ItemStack aStack : aOutputs) {
            int aOriginalSize;
            if (aStack == null) continue;
            if (aStack.field_77994_a <= 64) {
                aOutputMap.add(aStack);
                continue;
            }
            int aStacks = 0;
            int aExcess = 0;
            for (aOriginalSize = aStack.field_77994_a; aOriginalSize >= 64; aOriginalSize -= 64) {
                ++aStacks;
            }
            aExcess = aOriginalSize;
            for (int i = 0; i < aStacks; ++i) {
                aOutputMap.add(ItemUtils.getSimpleStack(aStack, 64));
            }
            aOutputMap.add(ItemUtils.getSimpleStack(aStack, aExcess));
        }
        return aOutputMap;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().isAllowedToWork() && (this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || aTick % 100L == 0L) && this.getBaseMetaTileEntity().getUniversalEnergyStored() >= this.getMinimumStoredEU()) {
            int aTileX = this.getBaseMetaTileEntity().getXCoord();
            int aTileY = this.getBaseMetaTileEntity().getXCoord();
            int aTileZ = this.getBaseMetaTileEntity().getXCoord();
            int aRadius = 10 + GT_MetaTileEntity_CropHarvestor.getRange(this.mTier);
            int aSide = (aRadius - 1) / 2;
            ArrayList<ItemStack> aAllDrops = new ArrayList<ItemStack>();
            if (this.mCropCache.isEmpty() || aTick % 1200L == 0L || this.mInvalidCache) {
                if (!this.mCropCache.isEmpty()) {
                    this.mCropCache.clear();
                }
                for (int y = 0; y <= 2; ++y) {
                    for (int x = -aSide; x <= aSide; ++x) {
                        for (int z = -aSide; z <= aSide; ++z) {
                            TileEntity tTileEntity = this.getBaseMetaTileEntity().getTileEntityOffset(x, y, z);
                            if (tTileEntity == null || !(tTileEntity instanceof ICropTile)) continue;
                            ICropTile tCrop = (ICropTile)tTileEntity;
                            this.mCropCache.add(tCrop);
                        }
                    }
                }
            }
            if (this.doesInventoryHaveSpace()) {
                for (ICropTile tCrop : this.mCropCache) {
                    ItemStack[] aHarvest;
                    if (tCrop == null) {
                        this.mInvalidCache = true;
                        break;
                    }
                    CropCard aCrop = tCrop.getCrop();
                    if (aCrop == null) continue;
                    if (!aCrop.canGrow(tCrop) && aCrop.canBeHarvested(tCrop) && this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.powerUsage(), true) && (aHarvest = tCrop.harvest_automated(true)) != null && aHarvest.length > 0) {
                        for (ItemStack aStack : aHarvest) {
                            if (aStack.field_77994_a <= 0) continue;
                            if (this.mTier * 5 > MathUtils.randInt(1, 100)) {
                                aStack.field_77994_a = (int)((double)aStack.field_77994_a + Math.floor(tCrop.getGain() / 10));
                                Logger.INFO("Bonus output given for " + aCrop.displayName());
                            }
                            Logger.INFO("Harvested " + aCrop.displayName());
                            aAllDrops.addAll(GT_MetaTileEntity_CropHarvestor.splitOutputStacks(aStack));
                        }
                    }
                    if (!this.mModeAlternative) continue;
                    this.processSecondaryFunctions(tCrop);
                }
                if (!aAllDrops.isEmpty()) {
                    Logger.INFO("Handling " + aAllDrops.size() + " Harvests");
                    block5: for (ItemStack aDrop : aAllDrops) {
                        if (!ItemUtils.checkForInvalidItems(aDrop)) continue;
                        for (int i = 7; i < this.func_70302_i_(); ++i) {
                            if (this.mInventory[i] != null) {
                                if (!GT_Utility.areStacksEqual((ItemStack)aDrop, (ItemStack)this.mInventory[i], (boolean)false)) continue;
                                if (this.mInventory[i].field_77994_a < 64 && this.mInventory[i].field_77994_a + aDrop.field_77994_a <= 64) {
                                    this.mInventory[i].field_77994_a += aDrop.field_77994_a;
                                    continue block5;
                                }
                                if (this.mInventory[i].field_77994_a >= 64 || this.mInventory[i].field_77994_a + aDrop.field_77994_a <= 64) continue;
                                int aRemainder = this.mInventory[i].field_77994_a + aDrop.field_77994_a - 64;
                                Logger.INFO("Remainder: " + aRemainder + ", Continuing.");
                                this.mInventory[i].field_77994_a = 64;
                                aDrop.field_77994_a = aRemainder;
                                continue;
                            }
                            this.mInventory[i] = aDrop;
                            continue block5;
                        }
                    }
                }
            }
        }
    }

    public boolean hasFertilizer() {
        for (int i = 3; i <= 6; ++i) {
            if (this.mInventory[i] == null) continue;
            return true;
        }
        return false;
    }

    public boolean consumeFertilizer(boolean aSimulate) {
        if (this.hasFertilizer()) {
            for (int i = 3; i <= 6; ++i) {
                if (this.mInventory[i] == null) continue;
                this.consume(i, 1, aSimulate);
                return true;
            }
        }
        return false;
    }

    public boolean hasWeedEX() {
        for (int i = 1; i <= 2; ++i) {
            if (this.mInventory[i] == null) continue;
            return true;
        }
        return false;
    }

    public boolean consumeWeedEX(boolean aSimulate) {
        if (this.hasWeedEX()) {
            for (int i = 1; i <= 2; ++i) {
                if (this.mInventory[i] == null) continue;
                this.damage(i, 1, aSimulate);
                return true;
            }
        }
        return false;
    }

    public void processSecondaryFunctions(ICropTile aCrop) {
        if (!this.mModeAlternative) {
            return;
        }
        if (!(this.hasFertilizer() && this.consumeFertilizer(true) && this.getBaseMetaTileEntity().getUniversalEnergyStored() >= this.getMinimumStoredEU() && this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.powerUsageSecondary(), true) && this.applyFertilizer(aCrop) && !this.consumeFertilizer(false))) {
            // empty if block
        }
        if (this.getFluidAmount() <= 0 || this.getBaseMetaTileEntity().getUniversalEnergyStored() < this.getMinimumStoredEU() || !this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.powerUsageSecondary(), true) || this.applyHydration(aCrop)) {
            // empty if block
        }
        if (!(this.hasWeedEX() && this.consumeWeedEX(true) && this.getBaseMetaTileEntity().getUniversalEnergyStored() >= this.getMinimumStoredEU() && this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.powerUsageSecondary(), true) && this.applyWeedEx(aCrop) && !this.consumeWeedEX(false))) {
            // empty if block
        }
    }

    public boolean applyWeedEx(ICropTile aCrop) {
        if (aCrop.getWeedExStorage() < 150) {
            boolean triggerDecline;
            aCrop.setWeedExStorage(aCrop.getWeedExStorage() + 50);
            boolean bl = triggerDecline = aCrop.getWorld().field_73012_v.nextInt(3) == 0;
            if (aCrop.getCrop() != null && aCrop.getCrop().isWeed(aCrop) && aCrop.getWeedExStorage() >= 75 && triggerDecline) {
                switch (aCrop.getWorld().field_73012_v.nextInt(5)) {
                    case 0: {
                        if (aCrop.getGrowth() > 0) {
                            aCrop.setGrowth((byte)(aCrop.getGrowth() - 1));
                        }
                    }
                    case 1: {
                        if (aCrop.getGain() <= 0) break;
                        aCrop.setGain((byte)(aCrop.getGain() - 1));
                    }
                }
                if (aCrop.getResistance() > 0) {
                    aCrop.setResistance((byte)(aCrop.getResistance() - 1));
                }
            }
            return true;
        }
        return false;
    }

    public boolean applyFertilizer(ICropTile aCrop) {
        if (aCrop.getNutrientStorage() >= 100) {
            return false;
        }
        aCrop.setNutrientStorage(100);
        return true;
    }

    public boolean applyHydration(ICropTile aCrop) {
        if (aCrop.getHydrationStorage() >= 200 || this.getFluidAmount() == 0) {
            return false;
        }
        int apply = 200 - aCrop.getHydrationStorage();
        if (this.getFluidAmount() >= 0) {
            int drain = 0;
            drain = this.getFluidAmount() >= apply ? apply : this.getFluidAmount();
            this.mFluid.amount -= drain;
            if (this.mFluid.amount <= 0) {
                this.mFluid = null;
            }
            aCrop.setHydrationStorage(aCrop.getHydrationStorage() + drain);
            return true;
        }
        return false;
    }

    public boolean consume(int aSlot, int amount, boolean simulate) {
        ItemStack stack = this.mInventory[aSlot];
        if (stack != null && stack.field_77994_a >= amount) {
            int currentAmount = Math.min(amount, stack.field_77994_a);
            amount -= currentAmount;
            if (!simulate) {
                if (stack.field_77994_a == currentAmount) {
                    this.mInventory[aSlot] = null;
                } else {
                    stack.field_77994_a -= currentAmount;
                }
            } else {
                return amount >= 0;
            }
            return true;
        }
        return false;
    }

    public ItemStack damage(int aSlot, int amount, boolean simulate) {
        ItemStack ret = null;
        int damageApplied = 0;
        ItemStack stack = this.mInventory[aSlot];
        Item item = stack.func_77973_b();
        if (stack != null && item.func_77645_m() && (ret == null || stack.func_77973_b() == ret.func_77973_b() && ItemStack.func_77970_a((ItemStack)stack, ret))) {
            if (simulate) {
                stack = stack.func_77946_l();
            }
            int maxDamage = DamageHandler.getMaxDamage((ItemStack)stack);
            while (amount > 0 && stack.field_77994_a > 0) {
                int currentAmount = Math.min(amount, maxDamage - DamageHandler.getDamage((ItemStack)stack));
                DamageHandler.damage((ItemStack)stack, (int)currentAmount, null);
                damageApplied += currentAmount;
                amount -= currentAmount;
                if (DamageHandler.getDamage((ItemStack)stack) >= maxDamage) {
                    --stack.field_77994_a;
                    DamageHandler.setDamage((ItemStack)stack, (int)0);
                }
                if (ret != null) continue;
                ret = stack.func_77946_l();
            }
            if (stack.field_77994_a == 0 && !simulate) {
                this.mInventory[aSlot] = null;
            }
        }
        if (ret != null) {
            int i = DamageHandler.getMaxDamage(ret);
            ret.field_77994_a = damageApplied / i;
            DamageHandler.setDamage(ret, (int)(damageApplied % i));
        }
        return ret;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aStack != null && aIndex >= 7 && aIndex < this.func_70302_i_();
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (aStack != null) {
            if (aStack.func_77973_b().func_77658_a().equals("ic2.itemFertilizer")) {
                return aIndex >= 3 && aIndex <= 6;
            }
            if (aStack.func_77973_b().func_77658_a().equals("ic2.itemWeedEx")) {
                return aIndex >= 1 && aIndex <= 2;
            }
        }
        return false;
    }

    public String[] getDescription() {
        int aRadius = 10 + GT_MetaTileEntity_CropHarvestor.getRange(this.mTier);
        int aSide = (aRadius - 1) / 2;
        return new String[]{this.mDescription, "Secondary mode can Hydrate/Fertilize/Weed-EX", "Consumes " + this.powerUsage() + "eu per harvest", "Consumes " + this.powerUsageSecondary() + "eu per secondary operation", "Can harvest 2 blocks above", "Radius: " + aSide + " each side (" + aRadius + "x3x" + aRadius + ")", "Has " + this.mTier * 5 + "% chance for extra drops", "Holds " + this.getCapacity() + "L of Water", CORE.GT_Tooltip};
    }

    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aStack) {
        return true;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFront(i);
            rTextures[6][i + 1] = this.getBack(i);
            rTextures[7][i + 1] = this.getBottom(i);
            rTextures[8][i + 1] = this.getTop(i);
            rTextures[9][i + 1] = this.getSides(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == 0 || aSide == 1) {
            return this.mTextures[3][aColorIndex + 1];
        }
        return this.mTextures[4][aColorIndex + 1];
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_CropHarvester_Cutter)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_CropHarvester_Cutter)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_CropHarvester_Boxes)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_CropHarvester_Boxes)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_CropHarvester_Cutter)};
    }

    public boolean doesFillContainers() {
        return false;
    }

    public boolean doesEmptyContainers() {
        return false;
    }

    public boolean canTankBeFilled() {
        return true;
    }

    public boolean canTankBeEmptied() {
        return false;
    }

    public boolean displaysItemStack() {
        return false;
    }

    public boolean displaysStackSize() {
        return false;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("mModeAlternative", this.mModeAlternative);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.mModeAlternative = aNBT.func_74767_n("mModeAlternative");
    }
}

