/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.generators.creative;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.core.util.sys.KeyboardUtils;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.tileentities.storage.GregtechMetaEnergyBuffer;
import java.lang.reflect.Field;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class GregtechMetaCreativeEnergyBuffer
extends GregtechMetaEnergyBuffer {
    private int mVoltageTier = 3;

    public GregtechMetaCreativeEnergyBuffer(String aName, int aTier, String aDescription, ITexture[][][] aTextures, int aSlotCount) {
        super(aName, aTier, aDescription, aTextures, aSlotCount);
    }

    public GregtechMetaCreativeEnergyBuffer(int aID, String aName, String aNameRegional, int aTier, String aDescription, int aSlotCount) {
        super(aID, aName, aNameRegional, aTier, aDescription, aSlotCount);
    }

    @Override
    public String[] getDescription() {
        return new String[]{this.mDescription, "Use Screwdriver to change voltage", "Hold Shift while using Screwdriver to change amperage", EnumChatFormatting.GREEN + "CREATIVE MACHINE", CORE.GT_Tooltip};
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        TexturesGtBlock.CustomIcon h = TexturesGtBlock.Casing_Material_RedSteel;
        TexturesGtBlock.CustomIcon g = TexturesGtBlock.Casing_Material_Grisium;
        boolean j = MathUtils.isNumberEven(this.mVoltageTier);
        ITexture[][][] rTextures = new ITexture[2][17][];
        TexturesGtBlock.CustomIcon k = j ? g : h;
        for (int i = -1; i < 16; i = (int)((byte)(i + 1))) {
            rTextures[0][i + 1] = new ITexture[]{new GT_RenderedTexture((IIconContainer)k)};
            rTextures[1][i + 1] = new ITexture[]{new GT_RenderedTexture((IIconContainer)k), this.mInventory.length > 4 ? Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.mVoltageTier] : Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mVoltageTier]};
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[aSide == aFacing ? 1 : 0][aColorIndex + 1];
    }

    @Override
    protected void showEnergy(World worldIn, EntityPlayer playerIn) {
        long tempStorage = this.getBaseMetaTileEntity().getStoredEU();
        double c = (double)tempStorage / (double)this.maxEUStore() * 100.0;
        double roundOff = (double)Math.round(c * 100.0) / 100.0;
        PlayerUtils.messagePlayer(playerIn, "Energy: " + GT_Utility.formatNumbers((long)tempStorage) + " EU at " + GT_Values.V[this.mVoltageTier] + "v (" + roundOff + "%)");
        PlayerUtils.messagePlayer(playerIn, "Amperage: " + GT_Utility.formatNumbers((long)this.maxAmperesOut()) + "A");
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaCreativeEnergyBuffer(this.mName, (int)this.mTier, this.mDescription, this.mTextures, this.mInventory.length);
    }

    @Override
    public long getMinimumStoredEU() {
        return 0L;
    }

    @Override
    public long maxEUStore() {
        return Long.MAX_VALUE;
    }

    @Override
    public long maxEUInput() {
        return GT_Values.V[this.mVoltageTier];
    }

    @Override
    public long maxEUOutput() {
        return GT_Values.V[this.mVoltageTier];
    }

    @Override
    public long maxAmperesIn() {
        return this.aCurrentOutputAmperage;
    }

    @Override
    public long maxAmperesOut() {
        return this.aCurrentOutputAmperage;
    }

    @Override
    public int getProgresstime() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int maxProgresstime() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    @Override
    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return null;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            aBaseMetaTileEntity.increaseStoredEnergyUnits(Integer.MAX_VALUE, true);
        }
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    @Override
    public String[] getInfoData() {
        String[] infoData = super.getInfoData();
        return new String[]{infoData[0], "THIS IS A CREATIVE ITEM - FOR TESTING | Tier: " + this.mVoltageTier, infoData[1], infoData[2]};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mVoltageTier", this.mVoltageTier);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mVoltageTier = aNBT.func_74762_e("mVoltageTier");
        super.loadNBTData(aNBT);
    }

    @Override
    public void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (KeyboardUtils.isShiftKeyDown()) {
            super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
        } else {
            this.mVoltageTier = this.mVoltageTier < (GT_Values.VN[9].equals("UHV") ? GT_Values.V.length - 1 : 9) ? ++this.mVoltageTier : 0;
            this.func_70296_d();
            try {
                Field field = ReflectionUtils.getField(((Object)((Object)this)).getClass(), "mTextures");
                field.setAccessible(true);
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
                ITexture[][][] V = this.getTextureSet(null);
                if (V != null) {
                    Logger.REFLECTION("Got Valid Textures.");
                    if (this.getBaseMetaTileEntity().isClientSide()) {
                        Logger.REFLECTION("Clientside Call.");
                        Logger.REFLECTION("Refreshing Textures on buffer.");
                        field.set((Object)this, V);
                        Logger.REFLECTION("Refreshed Textures on buffer.");
                    } else {
                        Logger.REFLECTION("Serverside Call.");
                    }
                } else {
                    Logger.REFLECTION("Bad mTextures setter.");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                Logger.REFLECTION("Bad mTextures setter.");
            }
            PlayerUtils.messagePlayer(aPlayer, "Now running at " + GT_Values.VOLTAGE_NAMES[this.mVoltageTier] + ".");
        }
    }
}

