/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.generators;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicGenerator;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.gregtech.PollutionUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fluids.FluidStack;

public class GregtechMetaTileEntity_RTG
extends GT_MetaTileEntity_BasicGenerator {
    public int mEfficiency;
    private int mDays;
    private long mTicksToBurnFor;
    private int mVoltage = 0;
    private GT_Recipe mCurrentRecipe;
    private int mDaysRemaining = 0;
    private int mDayTick = 0;
    private byte mNewTier = 0;

    public int removeDayOfTime() {
        if (this.mDaysRemaining > 0) {
            return this.mDaysRemaining--;
        }
        return this.mDaysRemaining;
    }

    public static int convertDaysToTicks(float days) {
        int value = 0;
        value = MathUtils.roundToClosestInt(1728000.0f * days);
        return value;
    }

    public static long getTotalEUGenerated(int ticks, int voltage) {
        return ticks * voltage;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74772_a("mTicksToBurnFor", this.mTicksToBurnFor);
        aNBT.func_74768_a("mVoltage", this.mVoltage);
        aNBT.func_74768_a("mDaysRemaining", this.mDaysRemaining);
        aNBT.func_74768_a("mDayTick", this.mDayTick);
        aNBT.func_74774_a("mNewTier", this.mNewTier);
        if (this.mCurrentRecipe != null) {
            NBTTagList list = new NBTTagList();
            ItemStack stack = this.mCurrentRecipe.mInputs[0];
            if (stack != null) {
                NBTTagCompound data = new NBTTagCompound();
                stack.func_77955_b(data);
                data.func_74768_a("mSlot", 0);
                list.func_74742_a((NBTBase)data);
            }
            aNBT.func_74782_a("mRecipeItem", (NBTBase)list);
        }
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        block3: {
            super.loadNBTData(aNBT);
            this.mTicksToBurnFor = aNBT.func_74763_f("mTicksToBurnFor");
            this.mVoltage = aNBT.func_74762_e("mVoltage");
            this.mDaysRemaining = aNBT.func_74762_e("mDaysRemaining");
            this.mDayTick = aNBT.func_74762_e("mDayTick");
            this.mNewTier = aNBT.func_74771_c("mNewTier");
            try {
                ReflectionUtils.setByte((Object)this, "mTier", this.mNewTier);
            }
            catch (Exception e) {
                IGregTechTileEntity thisTile;
                if (this.getBaseMetaTileEntity() == null || !(thisTile = this.getBaseMetaTileEntity()).isAllowedToWork() && !thisTile.isActive()) break block3;
                thisTile.setActive(false);
            }
        }
        NBTTagList list = aNBT.func_150295_c("mRecipeItem", 10);
        NBTTagCompound data = list.func_150305_b(0);
        ItemStack lastUsedFuel = ItemStack.func_77949_a((NBTTagCompound)data);
        if (lastUsedFuel != null) {
            this.mCurrentRecipe = this.getRecipes().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, null, new ItemStack[]{lastUsedFuel});
        }
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.mDayTick < 24000) {
                ++this.mDayTick;
            } else if (this.mDayTick >= 24000) {
                this.mDayTick = 0;
                this.mDaysRemaining = this.removeDayOfTime();
            }
        }
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && aTick % 10L == 0L) {
            int tFuelValue;
            long tProducedEU = 0L;
            if (this.mFluid == null) {
                if (aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() + this.getMinimumStoredEU()) {
                    this.mInventory[this.getStackDisplaySlot()] = null;
                } else {
                    if (this.mInventory[this.getStackDisplaySlot()] == null) {
                        this.mInventory[this.getStackDisplaySlot()] = new ItemStack((Block)Blocks.field_150480_ab, 1);
                    }
                    this.mInventory[this.getStackDisplaySlot()].func_151001_c("Generating: " + (aBaseMetaTileEntity.getUniversalEnergyStored() - this.getMinimumStoredEU()) + " EU");
                }
            } else {
                long tFluidAmountToUse;
                tFuelValue = this.getFuelValue(this.mFluid);
                int tConsumed = this.consumedFluidPerOperation(this.mFluid);
                if (tFuelValue > 0 && tConsumed > 0 && this.mFluid.amount > tConsumed && (tFluidAmountToUse = Math.min((long)(this.mFluid.amount / tConsumed), (this.maxEUStore() - aBaseMetaTileEntity.getUniversalEnergyStored()) / (long)tFuelValue)) > 0L && aBaseMetaTileEntity.increaseStoredEnergyUnits(tFluidAmountToUse * (long)tFuelValue, true)) {
                    tProducedEU = tFluidAmountToUse * (long)tFuelValue;
                    FluidStack tmp260_257 = this.mFluid;
                    tmp260_257.amount = (int)((long)tmp260_257.amount - tFluidAmountToUse * (long)tConsumed);
                }
            }
            if (this.mInventory[this.getInputSlot()] != null && aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() * 20L + this.getMinimumStoredEU() && GT_Utility.getFluidForFilledItem((ItemStack)this.mInventory[this.getInputSlot()], (boolean)true) == null && (tFuelValue = this.getFuelValue(this.mInventory[this.getInputSlot()])) > 0) {
                ItemStack tEmptyContainer = this.getEmptyContainer(this.mInventory[this.getInputSlot()]);
                if (aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), tEmptyContainer)) {
                    aBaseMetaTileEntity.increaseStoredEnergyUnits((long)tFuelValue, true);
                    aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                    tProducedEU = tFuelValue;
                }
            }
            if (tProducedEU > 0L && this.getPollution() > 0) {
                PollutionUtils.addPollution(aBaseMetaTileEntity, (int)(tProducedEU * (long)this.getPollution() / 500L * (long)this.mTier + 1L));
            }
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            aBaseMetaTileEntity.setActive(aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.getUniversalEnergyStored() >= this.maxEUOutput() + this.getMinimumStoredEU());
        }
    }

    public String[] getDescription() {
        return new String[]{this.mDescription, "Fuel is measured in minecraft days (Check with Scanner)", "RTG changes output voltage depending on fuel", "Generates power at " + this.getEfficiency() + "% Efficiency per tick", "Output Voltage: " + this.getOutputTier() + " EU/t", CORE.GT_Tooltip};
    }

    public GregtechMetaTileEntity_RTG(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, "Requires RTG Pellets", new ITexture[0]);
    }

    private byte getTier() {
        int voltage = this.mVoltage;
        if (voltage >= 512) {
            return 4;
        }
        if (voltage >= 128) {
            return 3;
        }
        if (voltage >= 32) {
            return 2;
        }
        if (voltage >= 8) {
            return 1;
        }
        return 0;
    }

    public GregtechMetaTileEntity_RTG(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    public boolean isOutputFacing(byte aSide) {
        return aSide > 1 && aSide != this.getBaseMetaTileEntity().getFrontFacing() && aSide != this.getBaseMetaTileEntity().getBackFacing();
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GregtechMetaTileEntity_RTG(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public GT_Recipe.GT_Recipe_Map getRecipes() {
        return GTPP_Recipe.GTPP_Recipe_Map.sRTGFuels;
    }

    public int getCapacity() {
        return 0;
    }

    public int getEfficiency() {
        this.mEfficiency = 100;
        return 100;
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{super.getFront(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MASSFAB)};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{super.getBack(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP)};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{super.getBottom(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{super.getTop(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_FLUID_SIDE)};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP_ACTIVE), Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.getTier()]};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return new ITexture[]{super.getFrontActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MASSFAB_ACTIVE)};
    }

    public ITexture[] getBackActive(byte aColor) {
        return new ITexture[]{super.getBackActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP_ACTIVE)};
    }

    public ITexture[] getBottomActive(byte aColor) {
        return new ITexture[]{super.getBottomActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP_ACTIVE)};
    }

    public ITexture[] getTopActive(byte aColor) {
        return new ITexture[]{super.getTopActive(aColor)[0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP_ACTIVE), new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_FLUID_SIDE_ACTIVE)};
    }

    public ITexture[] getSidesActive(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][0], new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.NAQUADAH_REACTOR_SOLID_TOP_ACTIVE), Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI[this.getTier()]};
    }

    public int getPollution() {
        return 0;
    }

    public int getFuelValue(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack) || this.getRecipes() == null) {
            return 0;
        }
        GT_Recipe tFuel = this.getRecipes().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, null, new ItemStack[]{aStack});
        if (tFuel != null) {
            int voltage;
            this.mCurrentRecipe = tFuel;
            this.mVoltage = voltage = tFuel.mEUt;
            byte sfsf = this.mTier;
            try {
                int mTier2 = ItemStack.func_77989_b((ItemStack)tFuel.mInputs[0], (ItemStack)GregtechItemList.Pellet_RTG_AM241.get(1L, new Object[0])) ? 1 : (ItemStack.func_77989_b((ItemStack)tFuel.mInputs[0], (ItemStack)GregtechItemList.Pellet_RTG_PO210.get(1L, new Object[0])) ? 3 : (ItemStack.func_77989_b((ItemStack)tFuel.mInputs[0], (ItemStack)GregtechItemList.Pellet_RTG_PU238.get(1L, new Object[0])) ? 2 : (ItemStack.func_77989_b((ItemStack)tFuel.mInputs[0], (ItemStack)GregtechItemList.Pellet_RTG_SR90.get(1L, new Object[0])) ? 1 : 0)));
                ReflectionUtils.setByte((Object)this, "mTier", (byte)mTier2);
                this.mNewTier = mTier2;
            }
            catch (Exception e) {
                Logger.WARNING("Failed setting mTier.");
                e.printStackTrace();
            }
            this.mTicksToBurnFor = GregtechMetaTileEntity_RTG.getTotalEUGenerated(GregtechMetaTileEntity_RTG.convertDaysToTicks(tFuel.mSpecialValue), voltage);
            if (this.mTicksToBurnFor >= Integer.MAX_VALUE) {
                this.mTicksToBurnFor = Integer.MAX_VALUE;
                Logger.WARNING("Fuel went over Int limit, setting to MAX_VALUE.");
            }
            this.mDaysRemaining = MathUtils.roundToClosestInt(this.mTicksToBurnFor / 20L / 60L / 3L);
            Logger.WARNING("step | " + (int)(this.mTicksToBurnFor * (long)this.getEfficiency() / 100L));
            return (int)(this.mTicksToBurnFor * (long)this.getEfficiency() / 100L);
        }
        Logger.WARNING("Not sure");
        return 0;
    }

    public long maxEUOutput() {
        return this.getBaseMetaTileEntity().isAllowedToWork() ? (long)this.mVoltage : 0L;
    }

    public long getOutputTier() {
        if (this.mCurrentRecipe != null) {
            this.mVoltage = this.mCurrentRecipe.mEUt;
            return this.mVoltage;
        }
        return 0L;
    }

    public boolean isGivingInformation() {
        return true;
    }

    public String[] getInfoData() {
        return new String[]{"RTG - Running at tier " + this.mTier, "Active: " + this.getBaseMetaTileEntity().isActive(), "Current Output: " + this.mVoltage + " EU/t", "Days of Fuel remaining: " + this.mTicksToBurnFor / 20L / 60L / 20L, "Hours of Fuel remaining: " + this.mTicksToBurnFor / 20L / 60L / 60L, "Ticks of " + this.mVoltage + "v remaining: " + this.mTicksToBurnFor, "Current Recipe input: " + this.mCurrentRecipe != null ? this.mCurrentRecipe.mInputs[0].func_82833_r() + " x1" : "NUll"};
    }
}

