/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.automation;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.gui.automation.GT_Container_ElectricInventoryManager;
import gtPlusPlus.xmod.gregtech.api.gui.automation.GT_GUIContainer_ElectricInventoryManager;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GT_MetaTileEntity_ElectricInventoryManager
extends GT_MetaTileEntity_TieredMachineBlock {
    public int[] mSlotRange = new int[4];
    public boolean mWorkedLastTick = false;
    protected String mLocalName;

    public GT_MetaTileEntity_ElectricInventoryManager(int aID, int aTier, String aDescription) {
        super(aID, "basicmachine.automation.inventorymanager.0" + aTier, "Electric Inventory Manager (" + GT_Values.VN[aTier] + ")", aTier, 16, aDescription, new ITexture[0]);
        this.mLocalName = "Auto Workbench (" + GT_Values.VN[aTier] + ")";
    }

    public GT_MetaTileEntity_ElectricInventoryManager(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 16, aDescription, aTextures);
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_Container_ElectricInventoryManager(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new GT_GUIContainer_ElectricInventoryManager(aPlayerInventory, aBaseMetaTileEntity);
    }

    public boolean isTransformerUpgradable() {
        return true;
    }

    public boolean isOverclockerUpgradable() {
        return false;
    }

    public boolean isSimpleMachine() {
        return false;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isEnetOutput() {
        return true;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public long maxEUOutput() {
        return GT_Values.V[this.mTier];
    }

    public long getMinimumStoredEU() {
        return GT_Values.V[this.mTier];
    }

    public long maxEUStore() {
        return GT_Values.V[this.mTier] * ((long)this.mTier * GT_Values.V[this.mTier]);
    }

    public long maxAmperesIn() {
        return 4L;
    }

    public long maxAmperesOut() {
        return 4L;
    }

    public boolean isValidSlot(int aIndex) {
        return aIndex < 3;
    }

    public boolean isInputFacing(byte aSide) {
        return !this.isOutputFacing(aSide);
    }

    public boolean isOutputFacing(byte aSide) {
        for (int i = 0; i < this.mSlotRange.length; ++i) {
            if (aSide != this.getRangeDirection(i) || !this.getRangeEnergy(i)) continue;
            return true;
        }
        return false;
    }

    public int func_70302_i_() {
        return 16;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_ElectricInventoryManager(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mSlotRange0", this.mSlotRange[0]);
        aNBT.func_74768_a("mSlotRange1", this.mSlotRange[1]);
        aNBT.func_74768_a("mSlotRange2", this.mSlotRange[2]);
        aNBT.func_74768_a("mSlotRange3", this.mSlotRange[3]);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.mSlotRange[0] = aNBT.func_74762_e("mSlotRange0");
        this.mSlotRange[1] = aNBT.func_74762_e("mSlotRange1");
        this.mSlotRange[2] = aNBT.func_74762_e("mSlotRange2");
        this.mSlotRange[3] = aNBT.func_74762_e("mSlotRange3");
    }

    public void iterateRangeDirection(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFFFF8 | ((this.mSlotRange[aIndex] & 7) + 1) % 6;
    }

    public void switchRangeEnergy(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFFFF7 | ((this.mSlotRange[aIndex] & 8) > 0 ? 0 : 8);
    }

    public void iterateSlot1Direction(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFFF8F | (((this.mSlotRange[aIndex] & 0x70) >> 4) + 1) % 6 << 4;
    }

    public void iterateSlot2Direction(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFFC7F | (((this.mSlotRange[aIndex] & 0x380) >> 7) + 1) % 6 << 7;
    }

    public void iterateSlot3Direction(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFE3FF | (((this.mSlotRange[aIndex] & 0x1C00) >> 10) + 1) % 6 << 10;
    }

    public void switchSlot1InOut(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFDFFF | ((this.mSlotRange[aIndex] & 0x2000) > 0 ? 0 : 8192);
    }

    public void switchSlot2InOut(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFFBFFF | ((this.mSlotRange[aIndex] & 0x4000) > 0 ? 0 : 16384);
    }

    public void switchSlot3InOut(int aIndex) {
        this.mSlotRange[aIndex] = this.mSlotRange[aIndex] & 0xFFFF7FFF | ((this.mSlotRange[aIndex] & 0x8000) > 0 ? 0 : 32768);
    }

    public byte getRangeDirection(int aIndex) {
        return (byte)(this.mSlotRange[aIndex] & 7);
    }

    public byte getSlot1Direction(int aIndex) {
        return (byte)((this.mSlotRange[aIndex] & 0x70) >> 4);
    }

    public byte getSlot2Direction(int aIndex) {
        return (byte)((this.mSlotRange[aIndex] & 0x380) >> 7);
    }

    public byte getSlot3Direction(int aIndex) {
        return (byte)((this.mSlotRange[aIndex] & 0x1C00) >> 10);
    }

    public boolean getRangeEnergy(int aIndex) {
        return (this.mSlotRange[aIndex] & 8) > 0;
    }

    public boolean getSlot1InOut(int aIndex) {
        return (this.mSlotRange[aIndex] & 0x2000) > 0;
    }

    public boolean getSlot2InOut(int aIndex) {
        return (this.mSlotRange[aIndex] & 0x4000) > 0;
    }

    public boolean getSlot3InOut(int aIndex) {
        return (this.mSlotRange[aIndex] & 0x8000) > 0;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isAllowedToWork() && this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().getUniversalEnergyStored() >= 5000L && (this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || this.getBaseMetaTileEntity().getTimer() % 100L == 0L || this.mWorkedLastTick || this.getBaseMetaTileEntity().hasInventoryBeenModified())) {
            this.mWorkedLastTick = false;
            IInventory[] tTileEntities = new IInventory[]{this.getBaseMetaTileEntity().getIInventoryAtSide((byte)0), this.getBaseMetaTileEntity().getIInventoryAtSide((byte)1), this.getBaseMetaTileEntity().getIInventoryAtSide((byte)2), this.getBaseMetaTileEntity().getIInventoryAtSide((byte)3), this.getBaseMetaTileEntity().getIInventoryAtSide((byte)4), this.getBaseMetaTileEntity().getIInventoryAtSide((byte)5), null, null};
            int tCost = 0;
            for (int i = 0; i < 4; ++i) {
                if (tTileEntities[this.getRangeDirection(i)] == null) continue;
                ArrayList<ItemStack> tList = new ArrayList<ItemStack>();
                tList.add(null);
                ItemStack tStack = this.mInventory[3 + i * 3 + 0];
                if (tStack == null) {
                    tCost = this.getSlot1InOut(i) ? (tCost += 5 * GT_Utility.moveOneItemStack((Object)this.getBaseMetaTileEntity(), (Object)tTileEntities[this.getRangeDirection(i)], (byte)this.getSlot1Direction(i), (byte)this.getSlot1Direction(i), null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1)) : (tCost += 5 * GT_Utility.moveOneItemStack((Object)tTileEntities[this.getRangeDirection(i)], (Object)this.getBaseMetaTileEntity(), (byte)this.getSlot1Direction(i), (byte)this.getSlot1Direction(i), null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1));
                } else {
                    tList.set(0, tStack);
                    tCost = this.getSlot1InOut(i) ? (tCost += 5 * GT_Utility.moveOneItemStack((Object)this.getBaseMetaTileEntity(), (Object)tTileEntities[this.getRangeDirection(i)], (byte)this.getSlot1Direction(i), (byte)this.getSlot1Direction(i), tList, (boolean)false, (byte)((byte)tStack.field_77994_a), (byte)1, (byte)64, (byte)1)) : (tCost += 5 * GT_Utility.moveOneItemStack((Object)tTileEntities[this.getRangeDirection(i)], (Object)this.getBaseMetaTileEntity(), (byte)this.getSlot1Direction(i), (byte)this.getSlot1Direction(i), tList, (boolean)false, (byte)((byte)tStack.field_77994_a), (byte)1, (byte)64, (byte)1));
                }
                tStack = this.mInventory[3 + i * 3 + 1];
                if (tStack == null) {
                    tCost = this.getSlot2InOut(i) ? (tCost += 5 * GT_Utility.moveOneItemStack((Object)this.getBaseMetaTileEntity(), (Object)tTileEntities[this.getRangeDirection(i)], (byte)this.getSlot2Direction(i), (byte)this.getSlot2Direction(i), null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1)) : (tCost += 5 * GT_Utility.moveOneItemStack((Object)tTileEntities[this.getRangeDirection(i)], (Object)this.getBaseMetaTileEntity(), (byte)this.getSlot2Direction(i), (byte)this.getSlot2Direction(i), null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1));
                } else {
                    tList.set(0, tStack);
                    tCost = this.getSlot2InOut(i) ? (tCost += 5 * GT_Utility.moveOneItemStack((Object)this.getBaseMetaTileEntity(), (Object)tTileEntities[this.getRangeDirection(i)], (byte)this.getSlot2Direction(i), (byte)this.getSlot2Direction(i), tList, (boolean)false, (byte)((byte)tStack.field_77994_a), (byte)1, (byte)64, (byte)1)) : (tCost += 5 * GT_Utility.moveOneItemStack((Object)tTileEntities[this.getRangeDirection(i)], (Object)this.getBaseMetaTileEntity(), (byte)this.getSlot2Direction(i), (byte)this.getSlot2Direction(i), tList, (boolean)false, (byte)((byte)tStack.field_77994_a), (byte)1, (byte)64, (byte)1));
                }
                tStack = this.mInventory[3 + i * 3 + 2];
                if (tStack == null) {
                    if (this.getSlot3InOut(i)) {
                        tCost += 5 * GT_Utility.moveOneItemStack((Object)this.getBaseMetaTileEntity(), (Object)tTileEntities[this.getRangeDirection(i)], (byte)this.getSlot3Direction(i), (byte)this.getSlot3Direction(i), null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1);
                        continue;
                    }
                    tCost += 5 * GT_Utility.moveOneItemStack((Object)tTileEntities[this.getRangeDirection(i)], (Object)this.getBaseMetaTileEntity(), (byte)this.getSlot3Direction(i), (byte)this.getSlot3Direction(i), null, (boolean)false, (byte)64, (byte)1, (byte)64, (byte)1);
                    continue;
                }
                tList.set(0, tStack);
                if (this.getSlot3InOut(i)) {
                    tCost += 5 * GT_Utility.moveOneItemStack((Object)this.getBaseMetaTileEntity(), (Object)tTileEntities[this.getRangeDirection(i)], (byte)this.getSlot3Direction(i), (byte)this.getSlot3Direction(i), tList, (boolean)false, (byte)((byte)tStack.field_77994_a), (byte)1, (byte)64, (byte)1);
                    continue;
                }
                tCost += 5 * GT_Utility.moveOneItemStack((Object)tTileEntities[this.getRangeDirection(i)], (Object)this.getBaseMetaTileEntity(), (byte)this.getSlot3Direction(i), (byte)this.getSlot3Direction(i), tList, (boolean)false, (byte)((byte)tStack.field_77994_a), (byte)1, (byte)64, (byte)1);
            }
            if (tCost > 0) {
                this.mWorkedLastTick = true;
                this.getBaseMetaTileEntity().decreaseStoredEnergyUnits((long)tCost, true);
            }
        }
    }

    public String[] getDescription() {
        return new String[]{"It's simpler than you think. I promise.", this.mDescription, CORE.GT_Tooltip};
    }

    public boolean allowCoverOnSide(byte aSide, GT_ItemStack aStack) {
        return false;
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return true;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return true;
    }

    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[16][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getBottom(i);
            rTextures[1][i + 1] = this.getTop(i);
            rTextures[2][i + 1] = this.getNegativeZ(i);
            rTextures[3][i + 1] = this.getPositiveZ(i);
            rTextures[4][i + 1] = this.getNegativeX(i);
            rTextures[5][i + 1] = this.getPositiveX(i);
            rTextures[6][i + 1] = this.getBottomRedstone(i);
            rTextures[7][i + 1] = this.getTopRedstone(i);
            rTextures[8][i + 1] = this.getNegativeZRedstone(i);
            rTextures[9][i + 1] = this.getPositiveZRedstone(i);
            rTextures[10][i + 1] = this.getNegativeXRedstone(i);
            rTextures[11][i + 1] = this.getPositiveXRedstone(i);
        }
        return rTextures;
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        return this.mTextures[!aRedstone ? aSide : aSide + 6][aColorIndex < 0 ? (byte)0 : aColorIndex];
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Red)};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Green)};
    }

    public ITexture[] getNegativeZ(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Blue)};
    }

    public ITexture[] getPositiveZ(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Cyan)};
    }

    public ITexture[] getNegativeX(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Purple)};
    }

    public ITexture[] getPositiveX(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Yellow)};
    }

    public ITexture[] getBottomRedstone(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Red_Redstone)};
    }

    public ITexture[] getTopRedstone(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Green_Redstone)};
    }

    public ITexture[] getNegativeZRedstone(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Blue_Redstone)};
    }

    public ITexture[] getPositiveZRedstone(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Cyan_Redstone)};
    }

    public ITexture[] getNegativeXRedstone(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Purple_Redstone)};
    }

    public ITexture[] getPositiveXRedstone(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1], new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Casing_InventoryManagaer_Yellow_Redstone)};
    }
}

