/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.helpers;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import gnu.trove.set.hash.THashSet;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.common.items.GT_MetaGenerated_Item_02;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.players.FakeFarmer;
import gtPlusPlus.core.slots.SlotBuzzSaw;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.particles.BlockBreakParticles;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.common.items.MetaGeneratedGregtechItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S23PacketBlockChange;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class TreeFarmHelper {
    public static final FluidStack fertT1 = FluidUtils.getFluidStack("fluid.fertiliser", 3);
    public static final FluidStack fertT2 = FluidUtils.getFluidStack("fluid.un18fertiliser", 2);
    public static final FluidStack fertT3 = FluidUtils.getFluidStack("fluid.un32fertiliser", 1);
    private static final int sawOreId = OreDictionary.getOreID((String)ToolDictNames.craftingToolSaw.name());
    public static boolean isHumusLoaded = false;
    public static boolean isForestryLogsLoaded = false;
    public static boolean isForestryFenceLoaded = false;
    public static boolean isForestrySaplingsLoaded = false;
    public static boolean isForestryLeavesLoaded = false;
    public static Block blockHumus;
    private static EntityPlayerMP farmerAI;

    public static ITexture[][][] getTextureSet() {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = TreeFarmHelper.getFront(i);
            rTextures[1][i + 1] = TreeFarmHelper.getBack(i);
            rTextures[2][i + 1] = TreeFarmHelper.getBottom(i);
            rTextures[3][i + 1] = TreeFarmHelper.getTop(i);
            rTextures[4][i + 1] = TreeFarmHelper.getSides(i);
            rTextures[5][i + 1] = TreeFarmHelper.getFrontActive(i);
            rTextures[6][i + 1] = TreeFarmHelper.getBackActive(i);
            rTextures[7][i + 1] = TreeFarmHelper.getBottomActive(i);
            rTextures[8][i + 1] = TreeFarmHelper.getTopActive(i);
            rTextures[9][i + 1] = TreeFarmHelper.getSidesActive(i);
        }
        return rTextures;
    }

    public static ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[2][aColor + 1]};
    }

    public static ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[2][aColor + 1]};
    }

    public static ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[2][aColor + 1]};
    }

    public static ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[2][aColor + 1]};
    }

    public static ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[2][aColor + 1]};
    }

    public static ITexture[] getFrontActive(byte aColor) {
        return TreeFarmHelper.getFront(aColor);
    }

    public static ITexture[] getBackActive(byte aColor) {
        return TreeFarmHelper.getBack(aColor);
    }

    public static ITexture[] getBottomActive(byte aColor) {
        return TreeFarmHelper.getBottom(aColor);
    }

    public static ITexture[] getTopActive(byte aColor) {
        return TreeFarmHelper.getTop(aColor);
    }

    public static ITexture[] getSidesActive(byte aColor) {
        return TreeFarmHelper.getSides(aColor);
    }

    public static boolean applyBonemeal(EntityPlayer player, World world, int intX, int intY, int intZ, short multiplier) {
        IGrowable igrowable;
        BonemealEvent event;
        int rollNeeded;
        int roll;
        Block block = world.func_147439_a(intX, intY, intZ);
        if (multiplier == 1) {
            roll = MathUtils.randInt(1, 15);
            rollNeeded = 15;
        } else if (multiplier == 2) {
            roll = MathUtils.randInt(1, 10);
            rollNeeded = 10;
        } else {
            roll = MathUtils.randInt(1, 5);
            rollNeeded = 5;
        }
        if (roll != rollNeeded) {
            return false;
        }
        if (!world.field_72995_K && CORE.ConfigSwitches.enableTreeFarmerParticles) {
            world.func_72926_e(2005, intX, intY, intZ, 0);
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new BonemealEvent(player, world, block, intX, intY, intZ)))) {
            Logger.MACHINE_INFO("Not sure why this returned false", new Object[0]);
            return false;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            if (!world.field_72995_K) {
                world.func_72926_e(2005, intX, intY, intZ, 0);
            }
            return true;
        }
        if (block instanceof IGrowable && (igrowable = (IGrowable)block).func_149851_a(world, intX, intY, intZ, world.field_72995_K)) {
            if (!world.field_72995_K && igrowable.func_149852_a(world, CORE.RANDOM, intX, intY, intZ)) {
                igrowable.func_149853_b(world, CORE.RANDOM, intX, intY, intZ);
            }
            return true;
        }
        return false;
    }

    public static boolean cleanUp(IGregTechTileEntity aBaseMetaTileEntity) {
        Logger.MACHINE_INFO("called cleanUp()", new Object[0]);
        int cleanedUp = 0;
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * 11;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * 11;
        for (int h = 1; h < 175; ++h) {
            for (int i = -11; i <= 11; ++i) {
                for (int j = -11; j <= 11; ++j) {
                    Block testBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j);
                    if ((i == -8 || i == 8 || i == -9 || i == 9 || i == -10 || i == 10 || i == -11 || i == 11) && (j == -8 || j == 8 || j == -9 || j == 9 || j == -10 || j == 10 || j == -11 || j == 11) && testBlock.func_149739_a().toLowerCase().contains("air") && testBlock.func_149739_a().toLowerCase().contains("pumpkin")) {
                        aBaseMetaTileEntity.getWorld().func_147449_b(aBaseMetaTileEntity.getXCoord() + xDir + i, aBaseMetaTileEntity.getYCoord() + h, aBaseMetaTileEntity.getZCoord() + zDir + j, Blocks.field_150342_X);
                    }
                    if (i == 7 || i == -7 || j == 7 || j == -7 || i == 6 || i == -6 || j == 6 || j == -6 || i == 5 || i == -5 || j == 5 || j == -5 || i == 4 || i == -4 || j == 4 || j == -4 || i == 3 || i == -3 || j == 3 || j == -3 || i == 2 || i == -2 || j == 2 || j == -2 || i == 1 || i == -1 || j == 1 || j == -1 || i == 0 || j == 0) continue;
                    if (testBlock.func_149739_a().toLowerCase().contains("air") && testBlock.func_149739_a().toLowerCase().contains("pumpkin")) {
                        aBaseMetaTileEntity.getWorld().func_147449_b(aBaseMetaTileEntity.getXCoord() + xDir + i, aBaseMetaTileEntity.getYCoord() + h, aBaseMetaTileEntity.getZCoord() + zDir + j, Blocks.field_150440_ba);
                    }
                    if (!TreeFarmHelper.isLeaves(testBlock) && !TreeFarmHelper.isWoodLog(testBlock)) continue;
                    int posiX = aBaseMetaTileEntity.getXCoord() + xDir + i;
                    int posiY = aBaseMetaTileEntity.getYCoord() + h;
                    int posiZ = aBaseMetaTileEntity.getZCoord() + zDir + j;
                    ++cleanedUp;
                    aBaseMetaTileEntity.getWorld().func_147468_f(posiX, posiY, posiZ);
                    new BlockBreakParticles(aBaseMetaTileEntity.getWorld(), posiX, posiY, posiZ, Blocks.field_150346_d);
                }
            }
        }
        Logger.MACHINE_INFO("cleaning up | " + cleanedUp, new Object[0]);
        return true;
    }

    public static boolean isValidForGUI(ItemStack aStack) {
        return TreeFarmHelper.isCorrectMachinePart(aStack) != SlotBuzzSaw.SAWTOOL.NONE;
    }

    public static SlotBuzzSaw.SAWTOOL isCorrectMachinePart(ItemStack aStack) {
        if (aStack != null && (aStack.func_77973_b() instanceof GT_MetaGenerated_Item_02 || aStack.func_77973_b() instanceof GT_MetaGenerated_Tool) && OrePrefixes.craftingTool.contains(aStack) && (aStack.func_82833_r().toLowerCase().contains("saw") || aStack.func_82833_r().toLowerCase().contains("gt.metatool.01"))) {
            if (aStack.func_77960_j() == 10) {
                return SlotBuzzSaw.SAWTOOL.SAW;
            }
            if (aStack.func_77960_j() == 140 || aStack.func_82833_r().toLowerCase().contains("gt.metatool.01.140")) {
                return SlotBuzzSaw.SAWTOOL.BUZZSAW;
            }
            if (aStack.func_77960_j() == 110 || aStack.func_82833_r().toLowerCase().contains("gt.metatool.01.110")) {
                return SlotBuzzSaw.SAWTOOL.CHAINSAW;
            }
            if (aStack.func_77960_j() == 112 || aStack.func_82833_r().toLowerCase().contains("gt.metatool.01.112")) {
                return SlotBuzzSaw.SAWTOOL.CHAINSAW;
            }
            if (aStack.func_77960_j() == 114 || aStack.func_82833_r().toLowerCase().contains("gt.metatool.01.114")) {
                return SlotBuzzSaw.SAWTOOL.CHAINSAW;
            }
            return SlotBuzzSaw.SAWTOOL.NONE;
        }
        return SlotBuzzSaw.SAWTOOL.NONE;
    }

    public static ToolType getPartType(ItemStack aStack) {
        if (aStack != null) {
            if (aStack.func_77973_b() == MetaGeneratedGregtechItems.INSTANCE) {
                int aDmg = aStack.func_77960_j();
                if (aDmg >= 32120 && aDmg <= 32128) {
                    return ToolType.Unbreakable;
                }
                Logger.INFO("bad Tool in Slot 2 | " + aStack.func_77977_a().toLowerCase() + " | " + aDmg);
                return null;
            }
            if (aStack.func_77973_b() instanceof GT_MetaGenerated_Tool && Arrays.stream(OreDictionary.getOreIDs((ItemStack)aStack)).anyMatch(i -> i == sawOreId)) {
                return ToolType.Breakable;
            }
        }
        Logger.INFO("bad Tool in Slot 4");
        return null;
    }

    public static boolean isForestryValid() {
        if (!LoadedMods.Forestry) {
            return false;
        }
        if (ReflectionUtils.doesClassExist("forestry.core.blocks.BlockSoil")) {
            isHumusLoaded = true;
        }
        if (ReflectionUtils.doesClassExist("forestry.arboriculture.blocks.BlockLog")) {
            isForestryLogsLoaded = true;
        }
        if (ReflectionUtils.doesClassExist("forestry.arboriculture.blocks.BlockArbFence")) {
            isForestryFenceLoaded = true;
        }
        if (ReflectionUtils.doesClassExist("forestry.arboriculture.blocks.BlockSapling")) {
            isForestrySaplingsLoaded = true;
        }
        if (ReflectionUtils.doesClassExist("forestry.arboriculture.blocks.BlockForestryLeaves")) {
            isForestryLeavesLoaded = true;
        }
        return true;
    }

    @Optional.Method(modid="Forestry")
    public static Block getHumus() {
        if (blockHumus != null) {
            return blockHumus;
        }
        if (isHumusLoaded) {
            Class<?> humusClass = ReflectionUtils.getClass("forestry.core.blocks.BlockSoil");
            ItemStack humusStack = ItemUtils.getCorrectStacktype("Forestry:soil", 1);
            if (humusClass != null) {
                blockHumus = Block.func_149634_a((Item)humusStack.func_77973_b());
                return Block.func_149634_a((Item)humusStack.func_77973_b());
            }
        }
        return null;
    }

    public static boolean isWoodLog(Block log) {
        String tTool = log.getHarvestTool(0);
        if (log == Blocks.field_150364_r || log == Blocks.field_150363_s) {
            return true;
        }
        if (log.getClass().getName().toLowerCase().contains("blocklog")) {
            return true;
        }
        if (log.getClass().getName().toLowerCase().contains("rubwood") || log.getClass().getName().toLowerCase().contains("rubleaves")) {
            return true;
        }
        return OrePrefixes.log.contains(new ItemStack(log, 1)) && tTool != null && tTool.equals("axe") || log.func_149688_o() != Material.field_151575_d ? false : !OrePrefixes.fence.contains(new ItemStack(log, 1));
    }

    public static boolean isLeaves(Block log) {
        if (log.func_149739_a().toLowerCase().contains("leaf")) {
            return true;
        }
        if (log.func_149739_a().toLowerCase().contains("leaves")) {
            return true;
        }
        if (log.func_149732_F().toLowerCase().contains("leaf")) {
            return true;
        }
        if (log.func_149732_F().toLowerCase().contains("leaves")) {
            return true;
        }
        return OrePrefixes.leaves.contains(new ItemStack(log, 1)) || log.func_149688_o() == Material.field_151584_j || OrePrefixes.treeLeaves.contains(new ItemStack(log, 1)) || log.func_149688_o() == Material.field_151582_l || OrePrefixes.mushroom.contains(new ItemStack(log, 1)) || log.func_149688_o() == Material.field_151570_A;
    }

    public static boolean isSapling(Block log) {
        if (log != null) {
            if (OrePrefixes.sapling.contains(new ItemStack(log, 1))) {
                // empty if block
            }
            if (log.func_149732_F().toLowerCase().contains("sapling")) {
                return true;
            }
        }
        return OrePrefixes.sapling.contains(new ItemStack(log, 1));
    }

    public static boolean isDirtBlock(Block dirt) {
        return dirt == Blocks.field_150346_d ? true : (dirt == Blocks.field_150349_c ? true : (TreeFarmHelper.getHumus() == null ? false : dirt == blockHumus));
    }

    public static boolean isFenceBlock(Block fence) {
        return fence == Blocks.field_150422_aJ ? true : (fence == Blocks.field_150396_be ? true : (fence == Blocks.field_150386_bk ? true : OrePrefixes.fence.contains(new ItemStack(fence, 1))));
    }

    public static boolean isAirBlock(Block air) {
        if (air.func_149732_F().toLowerCase().contains("air")) {
            return true;
        }
        if (air.getClass().getName().toLowerCase().contains("residual") || air.getClass().getName().toLowerCase().contains("heat")) {
            return true;
        }
        return air == Blocks.field_150350_a ? true : air instanceof BlockAir;
    }

    public static BlockPos checkForLogsInGrowArea(IGregTechTileEntity aBaseMetaTileEntity) {
        int xDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetX * 7;
        int zDir = ForgeDirection.getOrientation((int)aBaseMetaTileEntity.getBackFacing()).offsetZ * 7;
        for (int i = -7; i <= 7; ++i) {
            for (int j = -7; j <= 7; ++j) {
                for (int h = 0; h <= 1; ++h) {
                    if (i == -7 || i == 7 || j == -7 || j == 7 || h != 1 || !TreeFarmHelper.isWoodLog(aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j))) continue;
                    Logger.INFO("Found a Log");
                    return new BlockPos(aBaseMetaTileEntity.getXCoord() + xDir + i, aBaseMetaTileEntity.getYCoord() + h, aBaseMetaTileEntity.getZCoord() + zDir + j, aBaseMetaTileEntity.getWorld());
                }
            }
        }
        return null;
    }

    public static ItemStack[] findTreeFromBase(World world, BlockPos h) {
        int HARD_LIMIT = 10000;
        int mCount = 0;
        Logger.INFO("Finding Rest of Tree.");
        BlockPos mFirstSpot = h;
        HashSet<BlockPos> mSearchedSpaces = new HashSet<BlockPos>();
        Set<BlockPos> mTreeSet = TreeFarmHelper.getConnectedBlocks(world, mFirstSpot, mSearchedSpaces);
        HashSet<Set<BlockPos>> mTreeSet2 = new HashSet<Set<BlockPos>>();
        HashSet<BlockPos> mFinalTree = new HashSet<BlockPos>();
        Iterator<BlockPos> it = mTreeSet.iterator();
        Logger.INFO("Running first iteration.");
        while (it.hasNext()) {
            BlockPos G = it.next();
            mSearchedSpaces.add(G);
            mTreeSet2.add(TreeFarmHelper.getConnectedBlocks(world, G, mSearchedSpaces));
            Logger.INFO("First Search: " + G.getLocationString());
            if (++mCount <= HARD_LIMIT) continue;
            break;
        }
        mCount = 0;
        Iterator it2 = mTreeSet2.iterator();
        Logger.INFO("Running second iteration.");
        while (it2.hasNext()) {
            Set G = (Set)it2.next();
            for (BlockPos G2 : G) {
                mSearchedSpaces.add(G2);
                mFinalTree.add(G2);
                Logger.INFO("Second Search: " + G2.getLocationString());
                if (++mCount <= HARD_LIMIT) continue;
                break;
            }
            if (mCount <= HARD_LIMIT) continue;
            break;
        }
        if (mFinalTree.size() > 0) {
            ItemStack[] loot;
            Logger.INFO("Queuing " + mFinalTree.size() + " to Harvest Manager.");
            TreeCutter harvestManager = new TreeCutter(world);
            for (BlockPos G : mFinalTree) {
                harvestManager.queue(G);
                Logger.INFO("Queued: " + G.getLocationString());
                if (++mCount <= HARD_LIMIT) continue;
                break;
            }
            if (harvestManager.isValid && (loot = harvestManager.getDrops()).length > 0) {
                return loot;
            }
        }
        return new ItemStack[0];
    }

    public static Set<BlockPos> getConnectedBlocks(World W, BlockPos P, Set<BlockPos> checkedSpaces) {
        int HARD_LIMIT = 1000;
        int mCount = 0;
        Logger.INFO("Finding blocks connected to " + P.getLocationString() + ".");
        Set<BlockPos> mCheckedSpaces = checkedSpaces;
        Set<BlockPos> mStartSearch = TreeFarmHelper.searchSixFaces(W, P, mCheckedSpaces, false);
        HashSet<BlockPos> mSecondSearch = new HashSet<BlockPos>();
        HashSet<BlockPos> mThirdSearch = new HashSet<BlockPos>();
        Iterator<BlockPos> it = mStartSearch.iterator();
        while (it.hasNext()) {
            Logger.INFO("Running first iteration. [II]");
            BlockPos G = it.next();
            mCheckedSpaces.add(G);
            Set<BlockPos> mBranchSearch = TreeFarmHelper.searchSixFaces(W, G, mCheckedSpaces, true);
            Iterator<BlockPos> it2 = mBranchSearch.iterator();
            while (it2.hasNext()) {
                Logger.INFO("Running second iteration. [II]");
                BlockPos G2 = it2.next();
                mCheckedSpaces.add(G2);
                mSecondSearch.add(G2);
                if (++mCount <= HARD_LIMIT) continue;
                break;
            }
            if (mCount <= HARD_LIMIT) continue;
            break;
        }
        mCount = 0;
        for (BlockPos G : mSecondSearch) {
            mCheckedSpaces.add(G);
            Set<BlockPos> mBranchSearch = TreeFarmHelper.searchSixFaces(W, G, mCheckedSpaces, true);
            for (BlockPos G2 : mBranchSearch) {
                mCheckedSpaces.add(G2);
                mThirdSearch.add(G2);
                if (++mCount <= HARD_LIMIT) continue;
                break;
            }
            if (mCount <= HARD_LIMIT) continue;
            break;
        }
        return mThirdSearch;
    }

    public static Set<BlockPos> searchSixFaces(World W, BlockPos P, Set<BlockPos> checkedSpaces, boolean checkLeaves) {
        HashSet<BlockPos> mConnected = new HashSet<BlockPos>();
        int x = P.xPos;
        int y = P.yPos;
        int z = P.zPos;
        if (checkLeaves) {
            BlockPos L;
            if ((TreeFarmHelper.isWoodLog(W.func_147439_a(x - 1, y, z)) || TreeFarmHelper.isLeaves(W.func_147439_a(x - 1, y, z))) && !checkedSpaces.contains(L = new BlockPos(x - 1, y, z, W))) {
                mConnected.add(L);
                Logger.INFO("Found Connected. [III]");
            }
            if ((TreeFarmHelper.isWoodLog(W.func_147439_a(x + 1, y, z)) || TreeFarmHelper.isLeaves(W.func_147439_a(x + 1, y, z))) && !checkedSpaces.contains(L = new BlockPos(x + 1, y, z, W))) {
                mConnected.add(L);
                Logger.INFO("Found Connected. [III]");
            }
            if ((TreeFarmHelper.isWoodLog(W.func_147439_a(x, y - 1, z)) || TreeFarmHelper.isLeaves(W.func_147439_a(x, y - 1, z))) && !checkedSpaces.contains(L = new BlockPos(x, y - 1, z, W))) {
                mConnected.add(L);
                Logger.INFO("Found Connected. [III]");
            }
            if ((TreeFarmHelper.isWoodLog(W.func_147439_a(x, y + 1, z)) || TreeFarmHelper.isLeaves(W.func_147439_a(x, y + 1, z))) && !checkedSpaces.contains(L = new BlockPos(x, y + 1, z, W))) {
                mConnected.add(L);
                Logger.INFO("Found Connected. [III]");
            }
            if ((TreeFarmHelper.isWoodLog(W.func_147439_a(x, y, z - 1)) || TreeFarmHelper.isLeaves(W.func_147439_a(x, y, z - 1))) && !checkedSpaces.contains(L = new BlockPos(x, y, z - 1, W))) {
                mConnected.add(L);
                Logger.INFO("Found Connected. [III]");
            }
            if ((TreeFarmHelper.isWoodLog(W.func_147439_a(x, y, z + 1)) || TreeFarmHelper.isLeaves(W.func_147439_a(x, y, z + 1))) && !checkedSpaces.contains(L = new BlockPos(x, y, z + 1, W))) {
                mConnected.add(L);
                Logger.INFO("Found Connected. [III]");
            }
        } else {
            BlockPos L;
            if (TreeFarmHelper.isWoodLog(W.func_147439_a(x - 1, y, z))) {
                L = new BlockPos(x - 1, y, z, W);
                mConnected.add(L);
                Logger.INFO("Found Connected. [III]");
            }
            if (TreeFarmHelper.isWoodLog(W.func_147439_a(x + 1, y, z))) {
                L = new BlockPos(x + 1, y, z, W);
                mConnected.add(L);
                Logger.INFO("Found Connected. [III]");
            }
            if (TreeFarmHelper.isWoodLog(W.func_147439_a(x, y - 1, z))) {
                L = new BlockPos(x, y - 1, z, W);
                mConnected.add(L);
                Logger.INFO("Found Connected. [III]");
            }
            if (TreeFarmHelper.isWoodLog(W.func_147439_a(x, y + 1, z))) {
                L = new BlockPos(x, y + 1, z, W);
                mConnected.add(L);
                Logger.INFO("Found Connected. [III]");
            }
            if (TreeFarmHelper.isWoodLog(W.func_147439_a(x, y, z - 1))) {
                L = new BlockPos(x, y, z - 1, W);
                mConnected.add(L);
                Logger.INFO("Found Connected. [III]");
            }
            if (TreeFarmHelper.isWoodLog(W.func_147439_a(x, y, z + 1))) {
                L = new BlockPos(x, y, z + 1, W);
                mConnected.add(L);
                Logger.INFO("Found Connected. [III]");
            }
        }
        return mConnected;
    }

    public EntityPlayerMP getFakePlayer(World world) {
        farmerAI = TreeFarmHelper.checkFakePlayer(world);
        return farmerAI;
    }

    public static EntityPlayerMP checkFakePlayer(World world) {
        if (farmerAI == null) {
            return new FakeFarmer(MinecraftServer.func_71276_C().func_71218_a(world.field_73011_w.field_76574_g));
        }
        return farmerAI;
    }

    public static boolean onBlockStartBreak(int x, int y, int z, World world) {
        Block wood = world.func_147439_a(x, y, z);
        if (wood == null) {
            return false;
        }
        if ((wood.isWood((IBlockAccess)world, x, y, z) || wood.func_149688_o() == Material.field_151583_m) && TreeFarmHelper.detectTree(world, x, y, z)) {
            TreeChopTask chopper = new TreeChopTask(new ChunkPosition(x, y, z), (EntityPlayer)TreeFarmHelper.checkFakePlayer(world), 128);
            FMLCommonHandler.instance().bus().register((Object)chopper);
            return true;
        }
        return false;
    }

    public static boolean detectTree(World world, int pX, int pY, int pZ) {
        ChunkPosition pos = null;
        Stack<ChunkPosition> candidates = new Stack<ChunkPosition>();
        candidates.add(new ChunkPosition(pX, pY, pZ));
        while (!candidates.isEmpty()) {
            ChunkPosition candidate = (ChunkPosition)candidates.pop();
            int curX = candidate.field_151329_a;
            int curY = candidate.field_151327_b;
            int curZ = candidate.field_151328_c;
            Block block = world.func_147439_a(curX, curY, curZ);
            if (pos != null && candidate.field_151327_b <= pos.field_151327_b || !block.isWood((IBlockAccess)world, curX, curY, curZ)) continue;
            pos = new ChunkPosition(curX, candidate.field_151327_b + 1, curZ);
            while (world.func_147439_a(curX, pos.field_151327_b, curZ).isWood((IBlockAccess)world, curX, pos.field_151327_b, curZ)) {
                pos = new ChunkPosition(curX, pos.field_151327_b + 1, curZ);
            }
            candidates.add(new ChunkPosition(curX + 1, pos.field_151327_b + 1, curZ));
            candidates.add(new ChunkPosition(curX, pos.field_151327_b + 1, curZ + 1));
            candidates.add(new ChunkPosition(curX - 1, pos.field_151327_b + 1, curZ));
            candidates.add(new ChunkPosition(curX, pos.field_151327_b + 1, curZ - 1));
        }
        if (pos == null) {
            return false;
        }
        int d = 3;
        int leaves = 0;
        for (int offX = 0; offX < d; ++offX) {
            for (int offY = 0; offY < d; ++offY) {
                for (int offZ = 0; offZ < d; ++offZ) {
                    int xPos = pos.field_151329_a - 1 + offX;
                    int yPos = pos.field_151327_b - 1 + offY;
                    int zPos = pos.field_151328_c - 1 + offZ;
                    Block leaf = world.func_147439_a(xPos, yPos, zPos);
                    if (leaf == null || !leaf.isLeaves((IBlockAccess)world, xPos, yPos, zPos) || ++leaves < 5) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void breakExtraBlock(World world, int x, int y, int z, int sidehit, EntityPlayer playerEntity, int refX, int refY, int refZ) {
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (!TreeFarmHelper.isWoodLog(block)) {
            return;
        }
        Block refBlock = world.func_147439_a(refX, refY, refZ);
        float refStrength = ForgeHooks.blockStrength((Block)refBlock, (EntityPlayer)player, (World)world, (int)refX, (int)refY, (int)refZ);
        float strength = ForgeHooks.blockStrength((Block)block, (EntityPlayer)player, (World)world, (int)x, (int)y, (int)z);
        if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta) || refStrength / strength > 10.0f) {
            return;
        }
        BlockEvent.BreakEvent event = ForgeHooks.onBlockBreakEvent((World)world, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (int)x, (int)y, (int)z);
        if (event.isCanceled()) {
            return;
        }
        if (player.field_71075_bZ.field_75098_d) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, false)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if (!world.field_72995_K) {
                player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
            }
            return;
        }
        player.func_71045_bC().func_150999_a(world, block, x, y, z, (EntityPlayer)player);
        if (!world.field_72995_K) {
            block.func_149681_a(world, x, y, z, meta, (EntityPlayer)player);
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
                block.func_149636_a(world, (EntityPlayer)player, x, y, z, meta);
                block.func_149657_c(world, x, y, z, event.getExpToDrop());
            }
            player.field_71135_a.func_147359_a((Packet)new S23PacketBlockChange(x, y, z, world));
        } else {
            ItemStack itemstack;
            world.func_72926_e(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12));
            if (block.removedByPlayer(world, (EntityPlayer)player, x, y, z, true)) {
                block.func_149664_b(world, x, y, z, meta);
            }
            if ((itemstack = player.func_71045_bC()) != null) {
                itemstack.func_150999_a(world, block, x, y, z, (EntityPlayer)player);
                if (itemstack.field_77994_a == 0) {
                    player.func_71028_bD();
                }
            }
        }
    }

    public static class TreeChopTask {
        public final World world;
        public final EntityPlayer player;
        public final int blocksPerTick;
        public Queue<ChunkPosition> blocks = Lists.newLinkedList();
        public Set<ChunkPosition> visited = new THashSet();

        public TreeChopTask(ChunkPosition start, EntityPlayer player, int blocksPerTick) {
            this.world = player.func_130014_f_();
            this.player = player;
            this.blocksPerTick = blocksPerTick;
            this.blocks.add(start);
        }

        private void queueCoordinate(int x, int y, int z) {
            ChunkPosition pos = new ChunkPosition(x, y, z);
            if (!this.visited.contains(pos)) {
                this.blocks.add(pos);
            }
        }

        @SubscribeEvent
        public void onWorldTick(TickEvent.WorldTickEvent event) {
            if (event.side.isClient()) {
                this.finish();
                return;
            }
            if (event.world.field_73011_w.field_76574_g != this.world.field_73011_w.field_76574_g) {
                return;
            }
            int left = this.blocksPerTick;
            while (left > 0) {
                if (this.blocks.isEmpty()) {
                    this.finish();
                    return;
                }
                ChunkPosition pos = this.blocks.remove();
                if (!this.visited.add(pos)) continue;
                int x = pos.field_151329_a;
                int y = pos.field_151327_b;
                int z = pos.field_151328_c;
                Block block = this.world.func_147439_a(x, y, z);
                int meta = this.world.func_72805_g(x, y, z);
                if (!block.isWood((IBlockAccess)this.world, x, y, z) || !TreeFarmHelper.isWoodLog(block)) continue;
                this.queueCoordinate(x + 1, y, z);
                this.queueCoordinate(x, y, z + 1);
                this.queueCoordinate(x - 1, y, z);
                this.queueCoordinate(x, y, z - 1);
                for (int offX = 0; offX < 3; ++offX) {
                    for (int offZ = 0; offZ < 3; ++offZ) {
                        this.queueCoordinate(x - 1 + offX, y + 1, z - 1 + offZ);
                    }
                }
                TreeFarmHelper.breakExtraBlock(this.player.field_70170_p, x, y, z, 0, this.player, x, y, z);
                --left;
            }
        }

        private void finish() {
            FMLCommonHandler.instance().bus().unregister((Object)this);
        }
    }

    public static class TreeCutter {
        private final World mWorld;
        private Map<String, BlockPos> mQueue = new ConcurrentHashMap<String, BlockPos>();
        private AutoMap<ItemStack[]> mDrops = new AutoMap();
        private boolean isValid = true;

        public TreeCutter(World world) {
            this.mWorld = world;
        }

        public boolean queue(BlockPos pos) {
            String hash;
            if (this.isValid && pos != null && (hash = Utils.calculateChecksumMD5(pos)) != null && !this.mQueue.containsKey(hash)) {
                this.mQueue.put(hash, pos);
                return true;
            }
            return false;
        }

        private boolean emptyQueue() {
            if (this.isValid) {
                Logger.INFO("Emptying Queue.");
                if (this.mQueue.size() > 0) {
                    int totalRemoved = 0;
                    for (BlockPos h : this.mQueue.values()) {
                        Block block = this.mWorld.func_147439_a(h.xPos, h.yPos, h.zPos);
                        if (block == null) continue;
                        int dropMeta = this.mWorld.func_72805_g(h.xPos, h.yPos, h.zPos);
                        ArrayList blockDrops = block.getDrops(this.mWorld, h.xPos, h.yPos, h.zPos, dropMeta, 0);
                        ItemStack[] drops = ItemUtils.getBlockDrops(blockDrops);
                        this.mDrops.put(drops);
                        this.mWorld.func_147468_f(h.xPos, h.yPos, h.zPos);
                        ++totalRemoved;
                    }
                    if (totalRemoved > 0 && this.mDrops.size() > 0) {
                        return true;
                    }
                }
            }
            return false;
        }

        public ItemStack[] getDrops() {
            if (this.isValid && this.emptyQueue()) {
                AutoMap<ItemStack> mCollective = new AutoMap<ItemStack>();
                for (ItemStack[] i : this.mDrops) {
                    if (i == null) continue;
                    for (int d = 0; d < i.length; ++d) {
                        if (i[d] == null || i[d].field_77994_a <= 0) continue;
                        mCollective.put(i[d]);
                    }
                }
                ItemStack[] drops = new ItemStack[mCollective.size()];
                for (int m = 0; m < drops.length; ++m) {
                    drops[m] = (ItemStack)mCollective.get(m);
                }
                if (drops.length > 0) {
                    this.isValid = false;
                    return drops;
                }
            }
            this.isValid = false;
            return new ItemStack[0];
        }
    }

    public static enum ToolType {
        Unbreakable,
        Breakable;

    }
}

