/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.helpers;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.enums.GT_Values;
import gregtech.api.util.GT_ModHandler;
import gregtech.common.items.GT_MetaGenerated_Item_01;
import gregtech.common.items.GT_MetaGenerated_Item_02;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.basic.GregtechMetaWirelessCharger;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEvent;

public class ChargingHelper {
    private static Map<String, Pair<GregtechMetaWirelessCharger, Byte>> mValidPlayers = new HashMap<String, Pair<GregtechMetaWirelessCharger, Byte>>();
    protected static Map<BlockPos, GregtechMetaWirelessCharger> mChargerMap = new HashMap<BlockPos, GregtechMetaWirelessCharger>();
    private int mTickTimer = 0;
    private final int mTickMultiplier = 20;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerTick(LivingEvent.LivingUpdateEvent event) {
        block13: {
            try {
                EntityPlayer mPlayerMan;
                if (event.entity == null || event.entityLiving == null || !(event.entityLiving instanceof EntityPlayer) || (mPlayerMan = (EntityPlayer)event.entityLiving) == null || !Utils.isServer()) break block13;
                ++this.mTickTimer;
                if (this.mTickTimer % 20 != 0) break block13;
                long mVoltage = 0L;
                long mEuStored = 0L;
                if (mChargerMap.isEmpty() || !mValidPlayers.containsKey(mPlayerMan.getDisplayName())) break block13;
                InventoryPlayer mPlayerInventory = mPlayerMan.field_71071_by;
                ItemStack[] mArmourContents = (ItemStack[])mPlayerInventory.field_70460_b.clone();
                ItemStack[] mInventoryContents = (ItemStack[])mPlayerInventory.field_70462_a.clone();
                for (GregtechMetaWirelessCharger mEntityTemp : mChargerMap.values()) {
                    double mDistance;
                    long mMaxDistance;
                    long mVoltageCost;
                    if (mEntityTemp == null || mPlayerMan.func_130014_f_().field_73011_w.field_76574_g != mEntityTemp.getDimensionID()) continue;
                    mVoltage = mEntityTemp.maxEUInput();
                    mEuStored = mEntityTemp.getEUVar();
                    if (mVoltage <= 0L || mEuStored < mVoltage) continue;
                    Map<String, UUID> LR = mEntityTemp.getLongRangeMap();
                    Map<String, UUID> LO = mEntityTemp.getLocalMap();
                    long mStartingEu = mEntityTemp.getEUVar();
                    long mCurrentEu = mEntityTemp.getEUVar();
                    long mEuUsed = 0L;
                    if (mEntityTemp.getMode() == 0) {
                        if (!LR.isEmpty() && LR.containsKey(mPlayerMan.getDisplayName())) {
                            mCurrentEu = this.chargeItems(mEntityTemp, mArmourContents, mPlayerMan);
                            mCurrentEu = this.chargeItems(mEntityTemp, mInventoryContents, mPlayerMan);
                        }
                    } else if (mEntityTemp.getMode() == 1) {
                        if (!LO.isEmpty() && LO.containsKey(mPlayerMan.getDisplayName())) {
                            mCurrentEu = this.chargeItems(mEntityTemp, mArmourContents, mPlayerMan);
                            mCurrentEu = this.chargeItems(mEntityTemp, mInventoryContents, mPlayerMan);
                        }
                    } else {
                        if (!LR.isEmpty() && LR.containsKey(mPlayerMan.getDisplayName())) {
                            mCurrentEu = this.chargeItems(mEntityTemp, mArmourContents, mPlayerMan);
                            mCurrentEu = this.chargeItems(mEntityTemp, mInventoryContents, mPlayerMan);
                        }
                        if (!LO.isEmpty() && LO.containsKey(mPlayerMan.getDisplayName())) {
                            mCurrentEu = this.chargeItems(mEntityTemp, mArmourContents, mPlayerMan);
                            mCurrentEu = this.chargeItems(mEntityTemp, mInventoryContents, mPlayerMan);
                        }
                    }
                    if ((mEuUsed = mStartingEu - mCurrentEu) > 0L || mEntityTemp == null || (mVoltageCost = (long)MathUtils.findPercentageOfInt(mMaxDistance = mEntityTemp.getMode() == 0 ? 4L * GT_Values.V[mEntityTemp.getTier()] : (mEntityTemp.getMode() == 1 ? (long)(mEntityTemp.getTier() * 10) : 4L * GT_Values.V[mEntityTemp.getTier()] / 2L), (float)(mDistance = this.calculateDistance(mEntityTemp, mPlayerMan)))) <= 0L) continue;
                    if (mVoltageCost > mEntityTemp.maxEUInput()) {
                        mEntityTemp.setEUVar(mEntityTemp.getEUVar() - mEntityTemp.maxEUInput());
                        continue;
                    }
                    mEntityTemp.setEUVar(mEntityTemp.getEUVar() - mVoltageCost);
                }
            }
            catch (Throwable t) {
                if (mChargerMap.isEmpty()) break block13;
                for (BlockPos aPos : mChargerMap.keySet()) {
                    GregtechMetaWirelessCharger r = mChargerMap.get(aPos);
                    if (r != null && !r.getBaseMetaTileEntity().isInvalidTileEntity()) continue;
                    mChargerMap.remove(aPos);
                }
            }
        }
    }

    public static boolean addEntry(BlockPos mPos, GregtechMetaWirelessCharger mEntity) {
        if (mEntity == null) {
            return false;
        }
        if (!mChargerMap.containsKey(mPos)) {
            return mChargerMap.put(mPos, mEntity) == null;
        }
        return true;
    }

    public static boolean removeEntry(BlockPos mPos, GregtechMetaWirelessCharger mEntity) {
        if (mEntity == null) {
            return false;
        }
        if (mChargerMap.containsKey(mPos)) {
            return mChargerMap.remove(mPos, (Object)mEntity);
        }
        return false;
    }

    public static boolean addValidPlayer(EntityPlayer mPlayer, GregtechMetaWirelessCharger mEntity) {
        if (mEntity == null) {
            return false;
        }
        Logger.WARNING("trying to map new player");
        if (mValidPlayers.containsKey(mPlayer.getDisplayName())) {
            Logger.WARNING("Key contains player already?");
            return false;
        }
        Logger.WARNING("key not found, adding");
        Pair<GregtechMetaWirelessCharger, Byte> mEntry = new Pair<GregtechMetaWirelessCharger, Byte>(mEntity, (byte)mEntity.getMode());
        if (mValidPlayers.put(mPlayer.getDisplayName(), mEntry) == null) {
            Logger.WARNING("Added a Player to the Tick Map.");
            return true;
        }
        Logger.WARNING("Tried to add player but it was already there?");
        return false;
    }

    public static boolean removeValidPlayer(EntityPlayer mPlayer, GregtechMetaWirelessCharger mEntity) {
        if (mEntity == null) {
            return false;
        }
        Logger.WARNING("trying to remove player from map");
        if (mValidPlayers.containsKey(mPlayer.getDisplayName())) {
            Logger.WARNING("key found, removing");
            Pair<GregtechMetaWirelessCharger, Byte> mEntry = new Pair<GregtechMetaWirelessCharger, Byte>(mEntity, (byte)mEntity.getMode());
            if (mValidPlayers.remove(mPlayer, mEntry)) {
                Logger.WARNING("Removed a Player to the Tick Map.");
                return true;
            }
            Logger.WARNING("Tried to remove player but it was not there?");
            return false;
        }
        Logger.WARNING("Key does not contain player?");
        return false;
    }

    public double calculateDistance(GregtechMetaWirelessCharger mEntityTemp, EntityPlayer mPlayerMan) {
        if (mEntityTemp == null || mPlayerMan == null) {
            return 0.0;
        }
        return mEntityTemp.getDistanceBetweenTwoPositions(mEntityTemp.getTileEntityPosition(), mEntityTemp.getPositionOfEntity((Entity)mPlayerMan));
    }

    public long chargeItems(GregtechMetaWirelessCharger mEntity, ItemStack[] mItems, EntityPlayer mPlayer) {
        if (mEntity == null) {
            return -100L;
        }
        if (mItems == null || mItems.length == 0) {
            return mEntity.getEUVar();
        }
        long mInitialValue = mEntity.getEUVar();
        long mReturnValue = this.chargeItemsEx(mEntity, mItems, mPlayer);
        return mReturnValue < mInitialValue ? mReturnValue : mInitialValue;
    }

    public long chargeItemsEx(GregtechMetaWirelessCharger mEntity, ItemStack[] mItems, EntityPlayer mPlayer) {
        if (mEntity == null) {
            return -100L;
        }
        if (mItems == null || mItems.length == 0) {
            return mEntity.getEUVar();
        }
        int mChargedItems = 0;
        int mTier = mEntity.getTier();
        long mVoltage = mEntity.maxEUInput();
        long mEuStored = mEntity.getEUVar();
        long mEuStoredOriginal = mEntity.getEUVar();
        int mItemSlot = 0;
        for (ItemStack mTemp : mItems) {
            ++mItemSlot;
            if (mTemp != null) {
                Logger.WARNING("Slot " + mItemSlot + " contains " + mTemp.func_82833_r());
            }
            if (ChargingHelper.isItemValid(mTemp)) {
                Logger.WARNING("1");
                double mItemEuTLimit = ((IElectricItem)mTemp.func_77973_b()).getTransferLimit(mTemp);
                if (!((double)mEuStored >= mItemEuTLimit)) continue;
                Logger.WARNING("2");
                double mItemMaxCharge = ((IElectricItem)mTemp.func_77973_b()).getMaxCharge(mTemp);
                double mitemCurrentCharge = ElectricItem.manager.getCharge(mTemp);
                if (mitemCurrentCharge >= mItemMaxCharge) continue;
                Logger.WARNING("3");
                if (mTemp.func_77973_b() instanceof GT_MetaGenerated_Tool_01 || mTemp.func_77973_b() instanceof GT_MetaGenerated_Item_01 || mTemp.func_77973_b() instanceof GT_MetaGenerated_Item_02 || ReflectionUtils.getClass("gregtech.common.items.GT_MetaGenerated_Item_03").isInstance(mTemp.func_77973_b()) || mTemp.func_77973_b().getClass().getName().toLowerCase().equals("gregtech.common.items.GT_MetaGenerated_Tool_01".toLowerCase())) {
                    if (!NBTUtils.hasKey(mTemp, "GT.ItemCharge")) {
                        if (!mTemp.func_82833_r().toLowerCase().contains("battery")) {
                            if (!GT_ModHandler.isElectricItem((ItemStack)mTemp)) {
                                continue;
                            }
                        } else {
                            mitemCurrentCharge = 0.0;
                        }
                    } else {
                        mitemCurrentCharge = NBTUtils.getLong(mTemp, "GT.ItemCharge");
                    }
                } else if (mTemp.func_77973_b() instanceof IElectricItem) {
                    mitemCurrentCharge = NBTUtils.getLong(mTemp, "charge");
                }
                double mVoltageIncrease = mItemEuTLimit >= (double)mVoltage ? (double)mVoltage : (mItemEuTLimit < (double)mVoltage ? mItemEuTLimit : mItemEuTLimit);
                Logger.WARNING("4");
                int mMulti = mitemCurrentCharge + mVoltageIncrease * 20.0 <= mItemMaxCharge - mVoltageIncrease * 20.0 ? 20 : (mitemCurrentCharge + mVoltageIncrease * 10.0 <= mItemMaxCharge - mVoltageIncrease * 10.0 ? 10 : (mitemCurrentCharge + mVoltageIncrease * 5.0 <= mItemMaxCharge - mVoltageIncrease * 5.0 ? 5 : 1));
                Logger.WARNING("5");
                int mMultiVoltage = (int)((double)mMulti * mVoltageIncrease);
                if (mitemCurrentCharge + (double)mMultiVoltage <= mItemMaxCharge) {
                    Logger.WARNING("6");
                    int g = 0;
                    g = GT_ModHandler.chargeElectricItem((ItemStack)mTemp, (int)mMultiVoltage, (int)Integer.MAX_VALUE, (boolean)true, (boolean)false);
                    if (g > 0) {
                        Logger.WARNING("6.5 - " + g + " - " + mMulti);
                        for (int i = 0; i < mMulti; ++i) {
                            if (!(ElectricItem.manager.charge(mTemp, mVoltageIncrease, Integer.MAX_VALUE, false, false) > 0.0)) continue;
                        }
                    }
                    if (ElectricItem.manager.getCharge(mTemp) > mitemCurrentCharge) {
                        Logger.WARNING("7");
                        mEntity.setEUVar(mEuStored - mVoltage * (long)mMulti);
                        mEuStored = mEntity.getEUVar();
                        Logger.WARNING("Charged " + mTemp.func_82833_r() + " | Slot: " + mItemSlot + " | EU Multiplier: " + mMulti + " | EU/t input: " + mVoltageIncrease + " | EU/t consumed by Tile: " + mVoltage + " | Item Max Charge: " + mItemMaxCharge + " | Item Start Charge: " + mitemCurrentCharge + " | Item New Charge" + ElectricItem.manager.getCharge(mTemp));
                        ++mChargedItems;
                    }
                }
                if (!((mitemCurrentCharge = ElectricItem.manager.getCharge(mTemp)) < mItemMaxCharge) || !(mitemCurrentCharge >= mItemMaxCharge - (double)mVoltage)) continue;
                int xDif = (int)(mItemMaxCharge - mitemCurrentCharge);
                Logger.WARNING("8 - " + xDif);
                int g = 0;
                g = GT_ModHandler.chargeElectricItem((ItemStack)mTemp, (int)xDif, (int)Integer.MAX_VALUE, (boolean)true, (boolean)false);
                if (g < 0) continue;
                Logger.WARNING("8.5 - " + g);
                if (!(ElectricItem.manager.getCharge(mTemp) >= mItemMaxCharge)) continue;
                Logger.WARNING("9");
                mEntity.setEUVar(mEntity.getEUVar() - (long)xDif);
                mEuStored = mEntity.getEUVar();
                Logger.WARNING("Charged " + mTemp.func_82833_r() + " | Slot: " + mItemSlot + " | EU Multiplier: " + mMulti + " | EU/t input: " + mVoltageIncrease + " | EU/t consumed by Tile: " + mVoltage + " | Item Max Charge: " + mItemMaxCharge + " | Item Start Charge: " + mitemCurrentCharge + " | Item New Charge" + ElectricItem.manager.getCharge(mTemp));
                ++mChargedItems;
                continue;
            }
            if (mTemp == null) continue;
            Logger.WARNING("Found Non-Valid item. " + mTemp.func_82833_r());
        }
        if (mChargedItems < 1) {
            return mEuStoredOriginal;
        }
        return mEntity.getEUVar();
    }

    public static boolean isItemValid(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        if (GT_ModHandler.isElectricItem((ItemStack)itemstack)) {
            return true;
        }
        return ChargingHelper.accepts(itemstack) || itemstack.func_77973_b() instanceof IElectricItem;
    }

    public static boolean accepts(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return false;
    }
}

