/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.computer;

import Ic2ExpReactorPlanner.AutomationSimulator;
import Ic2ExpReactorPlanner.Reactor;
import Ic2ExpReactorPlanner.SimulationData;
import Ic2ExpReactorPlanner.components.ReactorItem;
import gregtech.api.objects.GT_ItemStack;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.common.tileentities.misc.GT_TileEntity_ComputerCube;
import java.util.ArrayList;
import java.util.HashMap;

public class GT_Computercube_Simulator {
    private static final HashMap<Integer, Pair<Integer, Integer>> sSlotPositions = new HashMap();
    private final Reactor reactor = new Reactor();
    public AutomationSimulator simulator = null;
    public Reactor simulatedReactor = null;
    private String currentReactorCode = null;
    private String currentReactorOldCode = null;
    private ArrayList<String> output = new ArrayList();
    private final GT_TileEntity_ComputerCube mTile;

    public GT_Computercube_Simulator(GT_TileEntity_ComputerCube aTile) {
        this.mTile = aTile;
    }

    public void slotClick(int aSlot, GT_ItemStack aStack) {
        if (aSlot >= 4 && aSlot < 58) {
            ReactorItem aItem;
            Pair<Integer, Integer> aSpot = sSlotPositions.get(aSlot);
            if (aStack == null) {
                aItem = null;
            } else {
                Logger.INFO("Using lookup key: " + ItemUtils.getModId(aStack.toStack()) + "." + aStack.mItem.func_77658_a() + "." + aStack.mMetaData);
                aItem = ReactorItem.sComponentMap.get(ItemUtils.getModId(aStack.toStack()) + "." + aStack.mItem.func_77658_a() + "." + aStack.mMetaData);
            }
            int aRow = aSpot.getKey();
            int aColumn = aSpot.getValue();
            Logger.INFO("Putting " + (aItem == null ? "null" : aItem.name) + " at x:" + aRow + ", y:" + aColumn);
            this.reactor.setComponentAt(aColumn, aRow, aItem);
            this.currentReactorCode = this.reactor.getCode();
            this.currentReactorOldCode = this.reactor.getOldCode();
            Logger.INFO("Code: " + this.currentReactorCode);
        }
    }

    public void simulate() {
        if (this.simulator != null && this.simulator.isRunning()) {
            Logger.INFO("Simulator Running, Stopping.");
            this.simulator.cancel();
        }
        Logger.INFO("Starting Simulator.");
        this.mTile.mHeat = 0;
        this.mTile.mEU = 0L;
        this.currentReactorCode = this.reactor.getCode();
        this.currentReactorOldCode = this.reactor.getOldCode();
        this.output.clear();
        this.simulatedReactor = new Reactor();
        this.simulatedReactor.setCode(this.reactor.getCode());
        Logger.INFO("Making new AutomationSimulator.");
        this.simulator = new AutomationSimulator(this.simulatedReactor, this.output, this.mTile);
        Logger.INFO("Starting AutomationSimulator.process().");
        this.simulator.process();
        Logger.INFO("Done.");
        SimulationData aData = this.simulator.getData();
        if (aData != null && aData.totalReactorTicks > 0) {
            this.mTile.mEU = aData.avgEUoutput * aData.totalReactorTicks;
            this.mTile.mEUOut = aData.avgEUoutput;
            this.mTile.mHeat = aData.avgHUoutput;
            this.mTile.mMaxHeat = aData.maxHUoutput;
            this.mTile.mExplosionStrength = aData.explosionPower;
            this.mTile.mHEM = (float)aData.hullHeating;
            this.mTile.mProgress = aData.totalReactorTicks;
        }
        for (String s : this.output) {
            Logger.INFO("\t" + s);
        }
    }

    public ArrayList<String> getOutputData() {
        return this.output;
    }

    private void clearGrid() {
        this.reactor.clearGrid();
        this.output.clear();
    }

    static {
        int aSlot = 4;
        for (int column = 0; column < 6; ++column) {
            for (int row = 0; row < 9; ++row) {
                sSlotPositions.put(aSlot++, new Pair<Integer, Integer>(row, column));
            }
        }
    }
}

