/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.nbthandlers;

import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_TieredMachineBlock;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.api.gui.hatches.CONTAINER_HatchNbtConsumable;
import gtPlusPlus.xmod.gregtech.api.gui.hatches.GUI_HatchNbtConsumable;
import gtPlusPlus.xmod.gregtech.common.StaticFields59;
import java.lang.reflect.Constructor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public abstract class GT_MetaTileEntity_Hatch_NbtConsumable
extends GT_MetaTileEntity_Hatch {
    public GT_Recipe.GT_Recipe_Map mRecipeMap = null;
    private final int mInputslotCount = this.getInputSlotCount();
    private final int mTotalSlotCount = this.getInputSlotCount() * 2;
    private final boolean mAllowDuplicateUsageTypes;

    public GT_MetaTileEntity_Hatch_NbtConsumable(int aID, String aName, String aNameRegional, int aTier, int aInputSlots, String aDescription, boolean aAllowDuplicateTypes) {
        super(aID, aName, aNameRegional, aTier, aInputSlots * 2, aDescription, new ITexture[0]);
        this.mAllowDuplicateUsageTypes = aAllowDuplicateTypes;
    }

    public GT_MetaTileEntity_Hatch_NbtConsumable(String aName, int aTier, int aInputSlots, String aDescription, boolean aAllowDuplicateTypes, ITexture[][][] aTextures) {
        super(aName, aTier, aInputSlots * 2, aDescription, aTextures);
        this.mAllowDuplicateUsageTypes = aAllowDuplicateTypes;
    }

    public GT_MetaTileEntity_Hatch_NbtConsumable(String aName, int aTier, int aInputSlots, String[] aDescription, boolean aAllowDuplicateTypes, ITexture[][][] aTextures) {
        super(aName, aTier, aInputSlots * 2, aDescription, aTextures);
        this.mAllowDuplicateUsageTypes = aAllowDuplicateTypes;
    }

    public abstract ITexture[] getTexturesActive(ITexture var1);

    public abstract ITexture[] getTexturesInactive(ITexture var1);

    public abstract int getInputSlotCount();

    public final boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public final boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public final boolean isValidSlot(int aIndex) {
        return aIndex < this.mInputslotCount;
    }

    public final MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        Constructor<?> aConstructor = ReflectionUtils.getConstructor(this.getHatchEntityClass(), String.class, String[].class, ITexture[][][].class);
        GT_MetaTileEntity_Hatch_NbtConsumable aInstance = (GT_MetaTileEntity_Hatch_NbtConsumable)((Object)ReflectionUtils.createNewInstanceFromConstructor(aConstructor, new Object[]{this.mName, StaticFields59.getDescriptionArray((GT_MetaTileEntity_TieredMachineBlock)this), this.mTextures}));
        if (aInstance instanceof GT_MetaTileEntity_Hatch_NbtConsumable) {
            GT_MetaTileEntity_Hatch_NbtConsumable aMetaTile = aInstance;
            return aMetaTile;
        }
        return null;
    }

    public abstract Class<? extends GT_MetaTileEntity_Hatch_NbtConsumable> getHatchEntityClass();

    public final boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public final Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        return new CONTAINER_HatchNbtConsumable(aPlayerInventory, aBaseMetaTileEntity, this.mInputslotCount);
    }

    public final Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        CONTAINER_HatchNbtConsumable aContainer = new CONTAINER_HatchNbtConsumable(aPlayerInventory, aBaseMetaTileEntity, this.mInputslotCount);
        return new GUI_HatchNbtConsumable(aContainer, this.getNameGUI());
    }

    public abstract String getNameGUI();

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.fillStacksIntoFirstSlots();
            this.tryFillUsageSlots();
        }
    }

    public final void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] != null && this.mInventory[i].field_77994_a <= 0) {
                this.mInventory[i] = null;
            }
            if (i > this.getSlotID_LastInput()) continue;
            this.fillStacksIntoFirstSlots();
        }
    }

    protected final void fillStacksIntoFirstSlots() {
        for (int i = 0; i <= this.getSlotID_LastInput(); ++i) {
            for (int j = i + 1; j <= this.getSlotID_LastInput(); ++j) {
                if (this.mInventory[j] == null || this.mInventory[i] != null && !GT_Utility.areStacksEqual((ItemStack)this.mInventory[i], (ItemStack)this.mInventory[j])) continue;
                GT_Utility.moveStackFromSlotAToSlotB((IInventory)this.getBaseMetaTileEntity(), (IInventory)this.getBaseMetaTileEntity(), (int)j, (int)i, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        }
    }

    public final void tryFillUsageSlots() {
        int aSlotSpace = this.mInputslotCount - this.getContentUsageSlots().size();
        if (aSlotSpace > 0) {
            Logger.INFO("We have empty usage slots. " + aSlotSpace);
            for (int i = this.getSlotID_FirstInput(); i <= this.getSlotID_LastInput(); ++i) {
                ItemStack aStackToTryMove = this.mInventory[i];
                if (aStackToTryMove == null || !this.isItemValidForUsageSlot(aStackToTryMove)) continue;
                Logger.INFO("Trying to move stack from input slot " + i);
                if (!this.moveItemFromStockToUsageSlots(aStackToTryMove)) continue;
                Logger.INFO("Updating Slots.");
                this.updateSlots();
            }
        }
    }

    private int getSlotID_FirstInput() {
        return 0;
    }

    private int getSlotID_LastInput() {
        return this.mInputslotCount - 1;
    }

    private int getSlotID_FirstUsage() {
        return this.mInputslotCount;
    }

    private int getSlotID_LastUsage() {
        return this.mTotalSlotCount - 1;
    }

    public final AutoMap<ItemStack> getContentUsageSlots() {
        AutoMap<ItemStack> aItems = new AutoMap<ItemStack>();
        for (int i = this.mInputslotCount; i < this.mTotalSlotCount; ++i) {
            if (this.mInventory[i] == null) continue;
            aItems.add(this.mInventory[i]);
        }
        return aItems;
    }

    public final boolean moveItemFromStockToUsageSlots(ItemStack aStack) {
        return this.moveItemFromStockToUsageSlots(aStack, this.mAllowDuplicateUsageTypes);
    }

    public final boolean moveItemFromStockToUsageSlots(ItemStack aStack, boolean aAllowMultiOfSameTypeInUsageSlots) {
        if (aStack != null && aStack.field_77994_a > 0) {
            int i;
            if (!this.isItemValidForUsageSlot(aStack)) {
                Logger.INFO("Stack not valid: " + ItemUtils.getItemName(aStack));
                return false;
            }
            ItemStack aStackToMove = aStack.func_77946_l();
            aStackToMove.field_77994_a = 1;
            boolean aDidSet = false;
            boolean aFoundMatching = false;
            for (i = this.getSlotID_FirstUsage(); i <= this.getSlotID_LastUsage(); ++i) {
                if (this.mInventory[i] == null || !GT_Utility.areStacksEqual((ItemStack)aStackToMove, (ItemStack)this.mInventory[i], (boolean)true)) continue;
                Logger.INFO("Found matching stack in slot " + i + ".");
                aFoundMatching = true;
                break;
            }
            for (i = this.getSlotID_FirstUsage(); i <= this.getSlotID_LastUsage(); ++i) {
                if (this.mInventory[i] != null || (!aFoundMatching || !aAllowMultiOfSameTypeInUsageSlots) && aFoundMatching) continue;
                this.mInventory[i] = aStackToMove;
                aDidSet = true;
                Logger.INFO("Moving new stack to usage slots.");
                break;
            }
            if (aDidSet) {
                Logger.INFO("Depleting input stack size by 1.");
                --aStack.field_77994_a;
            }
            return aDidSet;
        }
        return false;
    }

    public final boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return false;
    }

    public final boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing() && this.isItemValidForUsageSlot(aStack);
    }

    public abstract AutoMap<ItemStack> getItemsValidForUsageSlots();

    public boolean isItemValidForUsageSlot(ItemStack aStack) {
        if (aStack != null) {
            for (ItemStack aValid : this.getItemsValidForUsageSlots()) {
                if (!GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)aValid, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }
}

