/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.ConcurrentHashSet;
import gtPlusPlus.api.objects.data.FlexiblePair;
import gtPlusPlus.api.objects.data.Triplet;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Steam_BusInput;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Steam_BusOutput;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GT_MetaTileEntity_Hatch_CustomFluidBase;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GregtechMeta_MultiBlockBase;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class GregtechMeta_SteamMultiBase
extends GregtechMeta_MultiBlockBase {
    public ArrayList<GT_MetaTileEntity_Hatch_Steam_BusInput> mSteamInputs = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_Steam_BusOutput> mSteamOutputs = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_CustomFluidBase> mSteamInputFluids = new ArrayList();

    public GregtechMeta_SteamMultiBase(String aName) {
        super(aName);
    }

    public GregtechMeta_SteamMultiBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, byte aSide, byte aFacing, byte aColorIndex, boolean aActive, boolean aRedstone) {
        if (aSide == aFacing) {
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureIndex()), aActive ? this.getFrontOverlayActive() : this.getFrontOverlay()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId((int)this.getCasingTextureIndex())};
    }

    protected abstract GT_RenderedTexture getFrontOverlay();

    protected abstract GT_RenderedTexture getFrontOverlayActive();

    private int getCasingTextureIndex() {
        return 10;
    }

    @Override
    public boolean hasSlotInGUI() {
        return true;
    }

    @Override
    public String getCustomGUIResourceName() {
        return null;
    }

    @Override
    public int getEuDiscountForParallelism() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkRecipe(ItemStack arg0) {
        void var22_27;
        int parallelRecipes;
        this.log("Running checkRecipeGeneric(0)");
        ArrayList<ItemStack> tItems = this.getStoredInputs();
        ArrayList<FluidStack> tFluids = this.getStoredFluids();
        GT_Recipe.GT_Recipe_Map tMap = this.getRecipeMap();
        if (tMap == null) {
            return false;
        }
        ItemStack[] aItemInputs = tItems.toArray(new ItemStack[tItems.size()]);
        FluidStack[] aFluidInputs = tFluids.toArray(new FluidStack[tFluids.size()]);
        GT_Recipe tRecipe = tMap.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[1], null, null, aItemInputs);
        if (tRecipe == null) {
            this.log("BAD RETURN - 1");
            return false;
        }
        int aEUPercent = 100;
        int aSpeedBonusPercent = 0;
        int aOutputChanceRoll = 10000;
        this.mEUt = 0;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        this.log("Running checkRecipeGeneric(1)");
        this.mLastRecipe = tRecipe;
        int aMaxParallelRecipes = this.canBufferOutputs(tRecipe.mOutputs, tRecipe.mFluidOutputs, this.getMaxParallelRecipes());
        if (aMaxParallelRecipes == 0) {
            this.log("BAD RETURN - 2");
            return false;
        }
        float tRecipeEUt = (float)(tRecipe.mEUt * aEUPercent) / 100.0f;
        float tTotalEUt = 0.0f;
        this.log("parallelRecipes: " + parallelRecipes);
        this.log("aMaxParallelRecipes: " + aMaxParallelRecipes);
        this.log("tTotalEUt: " + tTotalEUt);
        this.log("tRecipeEUt: " + tRecipeEUt);
        for (parallelRecipes = 0; parallelRecipes < aMaxParallelRecipes && tTotalEUt < 32.0f - tRecipeEUt; tTotalEUt += tRecipeEUt, ++parallelRecipes) {
            if (!tRecipe.isRecipeInputEqual(true, aFluidInputs, aItemInputs)) {
                this.log("Broke at " + parallelRecipes + ".");
                break;
            }
            this.log("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ".");
        }
        if (parallelRecipes == 0) {
            this.log("BAD RETURN - 3");
            return false;
        }
        aSpeedBonusPercent = Math.max(-99, aSpeedBonusPercent);
        float tTimeFactor = 100.0f / (100.0f + (float)aSpeedBonusPercent);
        this.mMaxProgresstime = (int)((float)tRecipe.mDuration * tTimeFactor * 1.5f);
        this.mEUt = (int)Math.ceil(tTotalEUt * 1.33f);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        FluidStack[] tOutputFluids = this.getOutputFluids(tRecipe, parallelRecipes);
        Object[] tOutputItems = this.getOutputItems(tRecipe);
        for (int f = 0; f < tOutputItems.length; ++f) {
            if (tRecipe.mOutputs[f] == null || tOutputItems[f] == null) continue;
            for (int g = 0; g < parallelRecipes; ++g) {
                if (this.getBaseMetaTileEntity().getRandomNumber(aOutputChanceRoll) >= tRecipe.getOutputChance(f)) continue;
                tOutputItems[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
            }
        }
        tOutputItems = ArrayUtils.removeNulls((ItemStack[])tOutputItems);
        ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : tOutputItems) {
            while (itemStack.func_77976_d() < itemStack.field_77994_a) {
                ItemStack tmp = itemStack.func_77946_l();
                tmp.field_77994_a = tmp.func_77976_d();
                itemStack.field_77994_a -= itemStack.func_77976_d();
                splitStacks.add(tmp);
            }
        }
        if (splitStacks.size() > 0) {
            Object[] tmp = new ItemStack[splitStacks.size()];
            tmp = splitStacks.toArray(tmp);
            tOutputItems = (ItemStack[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])tOutputItems, (Object[])tmp);
        }
        ArrayList<Object> tSList = new ArrayList<Object>();
        Object[] objectArray = tOutputItems;
        int n = objectArray.length;
        boolean bl = false;
        while (var22_27 < n) {
            Object tS = objectArray[var22_27];
            if (((ItemStack)tS).field_77994_a > 0) {
                tSList.add(tS);
            }
            ++var22_27;
        }
        tOutputItems = tSList.toArray(new ItemStack[tSList.size()]);
        this.mOutputItems = tOutputItems;
        this.mOutputFluids = tOutputFluids;
        this.updateSlots();
        this.startProcess();
        this.log("GOOD RETURN - 1");
        return true;
    }

    public ArrayList<FluidStack> getAllSteamStacks() {
        ArrayList<FluidStack> aFluids = new ArrayList<FluidStack>();
        FluidStack aSteam = FluidUtils.getSteam(1);
        for (FluidStack aFluid : this.getStoredFluids()) {
            if (!aFluid.isFluidEqual(aSteam)) continue;
            aFluids.add(aFluid);
        }
        return aFluids;
    }

    public int getTotalSteamStored() {
        int aSteam = 0;
        for (FluidStack aFluid : this.getAllSteamStacks()) {
            aSteam += aFluid.amount;
        }
        return aSteam;
    }

    public boolean tryConsumeSteam(int aAmount) {
        if (this.getTotalSteamStored() <= 0) {
            return false;
        }
        return this.depleteInput(FluidUtils.getSteam(aAmount));
    }

    public int getMaxEfficiency(ItemStack arg0) {
        return 0;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.mSteamInputs.clear();
            this.mSteamOutputs.clear();
            this.mSteamInputFluids.clear();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public boolean onRunningTick(ItemStack aStack) {
        long aSteamVal;
        this.fixAllMaintenanceIssue();
        if (this.mEUt < 0 && !this.tryConsumeSteam((int)(aSteamVal = (long)(-this.mEUt) * 10000L / (long)Math.max(1000, this.mEfficiency)))) {
            this.stopMachine();
            return false;
        }
        return true;
    }

    @Override
    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            this.log("Invalid IGregTechTileEntity");
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            this.log("Invalid IMetaTileEntity");
            return false;
        }
        boolean aDidAdd = false;
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_CustomFluidBase) {
            this.log("Adding Steam Input Hatch");
            aDidAdd = this.addToMachineListInternal(this.mSteamInputFluids, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Steam_BusInput) {
            this.log("Trying to set recipe map. Type: " + (this.getRecipeMap() != null ? this.getRecipeMap().mNEIName : "Null"));
            this.resetRecipeMapForHatch(aTileEntity, this.getRecipeMap());
            this.log("Adding Steam Input Bus");
            aDidAdd = this.addToMachineListInternal(this.mSteamInputs, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Steam_BusOutput) {
            this.log("Adding Steam Output Bus");
            aDidAdd = this.addToMachineListInternal(this.mSteamOutputs, aMetaTileEntity, aBaseCasingIndex);
        }
        return aDidAdd;
    }

    public void stopMachine() {
        super.stopMachine();
    }

    public FluidStack[] getOutputFluids(GT_Recipe aRecipe, int parallelRecipes) {
        FluidStack[] tOutputFluids = new FluidStack[aRecipe.mFluidOutputs.length];
        for (int h = 0; h < aRecipe.mFluidOutputs.length; ++h) {
            if (aRecipe.getFluidOutput(h) == null) continue;
            tOutputFluids[h] = aRecipe.getFluidOutput(h).copy();
            tOutputFluids[h].amount *= parallelRecipes;
        }
        return tOutputFluids;
    }

    public ItemStack[] getOutputItems(GT_Recipe aRecipe) {
        ItemStack[] tOutputItems = new ItemStack[aRecipe.mOutputs.length];
        for (int h = 0; h < aRecipe.mOutputs.length; ++h) {
            if (aRecipe.getOutput(h) == null) continue;
            tOutputItems[h] = aRecipe.getOutput(h).func_77946_l();
            tOutputItems[h].field_77994_a = 0;
        }
        return tOutputItems;
    }

    public int getOutputCount(ItemStack[] aOutputs) {
        return aOutputs.length;
    }

    public int getOutputFluidCount(FluidStack[] aOutputs) {
        return aOutputs.length;
    }

    /*
     * WARNING - void declaration
     */
    public int canBufferOutputs(ItemStack[] aOutputs, FluidStack[] aFluidOutputs, int aParallelRecipes) {
        boolean aDoesOutputFluids;
        boolean aDoesOutputItems;
        this.log("Determining if we have space to buffer outputs. Parallel: " + aParallelRecipes);
        if (aOutputs == null && aFluidOutputs == null) {
            return 0;
        }
        boolean bl = aOutputs != null ? aOutputs.length > 0 : (aDoesOutputItems = false);
        boolean bl2 = aFluidOutputs != null ? aFluidOutputs.length > 0 : (aDoesOutputFluids = false);
        if (!aDoesOutputItems && !aDoesOutputFluids) {
            return 0;
        }
        if (aDoesOutputItems) {
            this.log("We have items to output.");
            int aInputBusSlotsFree = 0;
            AutoMap<FlexiblePair<ItemStack, Integer>> aItemMap = new AutoMap<FlexiblePair<ItemStack, Integer>>();
            AutoMap<ItemStack> aItemOutputs = new AutoMap<ItemStack>(aOutputs);
            for (GT_MetaTileEntity_Hatch_Steam_BusOutput tBus : this.mSteamOutputs) {
                if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)tBus)) continue;
                IGregTechTileEntity tBusInv = tBus.getBaseMetaTileEntity();
                for (int i = 0; i < tBusInv.func_70302_i_(); ++i) {
                    if (tBus.func_70301_a(i) == null) {
                        ++aInputBusSlotsFree;
                        continue;
                    }
                    ItemStack aT = tBus.func_70301_a(i);
                    int aSize = aT.field_77994_a;
                    aT = aT.func_77946_l();
                    aT.field_77994_a = 0;
                    aItemMap.put(new FlexiblePair<ItemStack, Integer>(aT, aSize));
                }
            }
            int aRecipeSlotsRequired = 0;
            ConcurrentHashSet aInputMap = new ConcurrentHashSet();
            for (int i = 0; i < this.getOutputCount(aOutputs); ++i) {
                ItemStack itemStack = aItemOutputs.get(i);
                if (itemStack == null) continue;
                int aStackSize = itemStack.field_77994_a * aParallelRecipes;
                if (aStackSize > 64) {
                    int aSlotsNeedsForThisStack = (int)Math.ceil((float)aStackSize / 64.0f);
                    aRecipeSlotsRequired += aSlotsNeedsForThisStack;
                    for (int o = 0; o < aRecipeSlotsRequired; ++o) {
                        void var12_24;
                        int aStackToRemove = (aStackSize -= 64) > 64 ? 64 : aStackSize;
                        ItemStack itemStack2 = var12_24.func_77946_l();
                        itemStack2.field_77994_a = 0;
                        aInputMap.add(new FlexiblePair<ItemStack, Integer>(itemStack2, aStackToRemove));
                    }
                    continue;
                }
                ++aRecipeSlotsRequired;
                ItemStack itemStack3 = itemStack.func_77946_l();
                itemStack3.field_77994_a = 0;
                aInputMap.add(new FlexiblePair<ItemStack, Integer>(itemStack3, aStackSize));
            }
            if (aInputMap.size() > 0) {
                block4: for (FlexiblePair flexiblePair : aItemMap) {
                    Iterator aStackSize = aInputMap.iterator();
                    while (aStackSize.hasNext()) {
                        ItemStack aOutputStack;
                        FlexiblePair u = (FlexiblePair)aStackSize.next();
                        ItemStack aOutputBusStack = (ItemStack)flexiblePair.getKey();
                        if (!GT_Utility.areStacksEqual((ItemStack)aOutputBusStack, (ItemStack)(aOutputStack = (ItemStack)u.getKey()), (boolean)false)) continue;
                        if (aOutputBusStack.field_77994_a >= 64) continue block4;
                        if (aOutputBusStack.field_77994_a + aOutputStack.field_77994_a <= 64) {
                            flexiblePair.setValue(aOutputBusStack.field_77994_a + aOutputStack.field_77994_a);
                            aInputMap.remove(u);
                            continue;
                        }
                        int aRemainder = aOutputBusStack.field_77994_a + aOutputStack.field_77994_a - 64;
                        flexiblePair.setValue(64);
                        FlexiblePair t = new FlexiblePair(u.getKey(), aRemainder);
                        aInputMap.remove(u);
                        aInputMap.add(t);
                    }
                }
            }
            if (aInputMap.size() > 0 && aInputMap.size() > aInputBusSlotsFree) {
                aParallelRecipes = (int)Math.floor((double)aInputBusSlotsFree / (double)aInputMap.size() * (double)aParallelRecipes);
                this.log(" Free: " + aInputBusSlotsFree + ", Required: " + aInputMap.size());
                if (aParallelRecipes == 0) {
                    this.log("Failed to find enough space for all item outputs.");
                    return 0;
                }
            }
        }
        if (aDoesOutputFluids) {
            this.log("We have Fluids to output.");
            int aFluidHatches = 0;
            int aEmptyFluidHatches = 0;
            int aFullFluidHatches = 0;
            ArrayList<Triplet<GT_MetaTileEntity_Hatch_Output, Object, Integer>> aOutputHatches = new ArrayList<Triplet<GT_MetaTileEntity_Hatch_Output, Object, Integer>>();
            for (GT_MetaTileEntity_Hatch_Output tBus : this.mOutputHatches) {
                if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)tBus)) continue;
                ++aFluidHatches;
                if (tBus.getFluid() == null) {
                    aOutputHatches.add(new Triplet<GT_MetaTileEntity_Hatch_Output, Object, Integer>(tBus, null, tBus.getCapacity()));
                    continue;
                }
                int n = tBus.getCapacity() - tBus.getFluidAmount();
                aOutputHatches.add(new Triplet<GT_MetaTileEntity_Hatch_Output, FluidStack, Integer>(tBus, tBus.getFluid(), n));
            }
            ArrayList<FluidStack> aOutputFluids = new ArrayList<FluidStack>();
            aOutputFluids.addAll(new AutoMap<FluidStack>(aFluidOutputs));
            block7: for (int i = 0; i < aOutputHatches.size(); ++i) {
                GT_MetaTileEntity_Hatch_Output gT_MetaTileEntity_Hatch_Output = (GT_MetaTileEntity_Hatch_Output)((Triplet)aOutputHatches.get(i)).getValue_1();
                FluidStack aHatchStack = (FluidStack)((Triplet)aOutputHatches.get(i)).getValue_2();
                int aSpaceLeftInHatch = gT_MetaTileEntity_Hatch_Output.getCapacity() - gT_MetaTileEntity_Hatch_Output.getFluidAmount();
                if (aSpaceLeftInHatch <= 0) {
                    ++aFullFluidHatches;
                    aOutputHatches.remove(aOutputHatches.get(i));
                    --i;
                    continue;
                }
                for (int j = 0; j < this.getOutputFluidCount(aFluidOutputs); ++j) {
                    Triplet<GT_MetaTileEntity_Hatch_Output, FluidStack, Integer> aNewHatchData;
                    FluidStack aNewHatchStack;
                    if (!GT_Utility.areFluidsEqual((FluidStack)aHatchStack, (FluidStack)((FluidStack)aOutputFluids.get(j)))) continue;
                    int aFluidToPutIntoHatch = ((FluidStack)aOutputFluids.get((int)j)).amount * aParallelRecipes;
                    if (aSpaceLeftInHatch < aFluidToPutIntoHatch) {
                        aNewHatchStack = aHatchStack.copy();
                        aNewHatchStack.amount = 0;
                        FluidStack aNewOutputStack = aHatchStack.copy();
                        aNewOutputStack.amount = 0;
                        int aFluidLeftAfterInsert = aFluidToPutIntoHatch - aSpaceLeftInHatch;
                        aNewHatchStack.amount = gT_MetaTileEntity_Hatch_Output.getCapacity();
                        aNewOutputStack.amount = aFluidLeftAfterInsert;
                        aOutputFluids.remove(aOutputFluids.get(j));
                        --j;
                        aOutputHatches.remove(aOutputHatches.get(i));
                        --i;
                        aOutputFluids.add(aNewOutputStack);
                        continue block7;
                    }
                    if (aSpaceLeftInHatch == aFluidToPutIntoHatch) {
                        aNewHatchStack = aHatchStack.copy();
                        aNewHatchStack.amount += aFluidToPutIntoHatch;
                        aOutputFluids.remove(aOutputFluids.get(j));
                        --j;
                        aOutputHatches.remove(aOutputHatches.get(i));
                        --i;
                        aNewHatchData = new Triplet<GT_MetaTileEntity_Hatch_Output, FluidStack, Integer>(gT_MetaTileEntity_Hatch_Output, aNewHatchStack, aNewHatchStack.amount);
                        aOutputHatches.add(aNewHatchData);
                        continue block7;
                    }
                    aNewHatchStack = aHatchStack.copy();
                    aNewHatchStack.amount += aFluidToPutIntoHatch;
                    aOutputFluids.remove(aOutputFluids.get(j));
                    --j;
                    aOutputHatches.remove(aOutputHatches.get(i));
                    --i;
                    aNewHatchData = new Triplet<GT_MetaTileEntity_Hatch_Output, FluidStack, Integer>(gT_MetaTileEntity_Hatch_Output, aNewHatchStack, aNewHatchStack.amount);
                    aOutputHatches.add(aNewHatchData);
                }
            }
            for (Triplet triplet : aOutputHatches) {
                if (triplet.getValue_2() != null && (Integer)triplet.getValue_3() != 0 && ((GT_MetaTileEntity_Hatch_Output)triplet.getValue_1()).getFluid() != null) continue;
                ++aEmptyFluidHatches;
            }
            this.log("fluids to output " + aOutputFluids.size() + " empty hatches " + aEmptyFluidHatches);
            if (aOutputFluids.size() > 0 && aOutputFluids.size() > aEmptyFluidHatches) {
                aParallelRecipes = (int)Math.floor((double)aEmptyFluidHatches / (double)aOutputFluids.size() * (double)aParallelRecipes);
                this.log("Failed to find enough space for all fluid outputs. Free: " + aEmptyFluidHatches + ", Required: " + aOutputFluids.size());
                return 0;
            }
        }
        return aParallelRecipes;
    }

    @Override
    public boolean depleteInput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        for (GT_MetaTileEntity_Hatch_Input gT_MetaTileEntity_Hatch_Input : this.mSteamInputFluids) {
            FluidStack tLiquid;
            gT_MetaTileEntity_Hatch_Input.mRecipeMap = this.getRecipeMap();
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)gT_MetaTileEntity_Hatch_Input) || (tLiquid = gT_MetaTileEntity_Hatch_Input.getFluid()) == null || !tLiquid.isFluidEqual(aLiquid) || (tLiquid = gT_MetaTileEntity_Hatch_Input.drain(aLiquid.amount, false)) == null || tLiquid.amount < aLiquid.amount) continue;
            tLiquid = gT_MetaTileEntity_Hatch_Input.drain(aLiquid.amount, true);
            return tLiquid != null && tLiquid.amount >= aLiquid.amount;
        }
        return false;
    }

    public boolean depleteInput(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack)) {
            return false;
        }
        FluidStack aLiquid = GT_Utility.getFluidForFilledItem((ItemStack)aStack, (boolean)true);
        if (aLiquid != null) {
            return this.depleteInput(aLiquid);
        }
        for (GT_MetaTileEntity_Hatch_Input gT_MetaTileEntity_Hatch_Input : this.mSteamInputFluids) {
            gT_MetaTileEntity_Hatch_Input.mRecipeMap = this.getRecipeMap();
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)gT_MetaTileEntity_Hatch_Input) || !GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70301_a(0)) || gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
            gT_MetaTileEntity_Hatch_Input.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
            return true;
        }
        for (GT_MetaTileEntity_Hatch_Steam_BusInput gT_MetaTileEntity_Hatch_Steam_BusInput : this.mSteamInputs) {
            gT_MetaTileEntity_Hatch_Steam_BusInput.mRecipeMap = this.getRecipeMap();
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)gT_MetaTileEntity_Hatch_Steam_BusInput)) continue;
            for (int i = gT_MetaTileEntity_Hatch_Steam_BusInput.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (!GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)gT_MetaTileEntity_Hatch_Steam_BusInput.getBaseMetaTileEntity().func_70301_a(i)) || gT_MetaTileEntity_Hatch_Steam_BusInput.getBaseMetaTileEntity().func_70301_a((int)0).field_77994_a < aStack.field_77994_a) continue;
                gT_MetaTileEntity_Hatch_Steam_BusInput.getBaseMetaTileEntity().func_70298_a(0, aStack.field_77994_a);
                return true;
            }
        }
        return false;
    }

    public ArrayList<FluidStack> getStoredFluids() {
        ArrayList<FluidStack> rList = new ArrayList<FluidStack>();
        for (GT_MetaTileEntity_Hatch_Input gT_MetaTileEntity_Hatch_Input : this.mSteamInputFluids) {
            gT_MetaTileEntity_Hatch_Input.mRecipeMap = this.getRecipeMap();
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)gT_MetaTileEntity_Hatch_Input) || gT_MetaTileEntity_Hatch_Input.getFillableStack() == null) continue;
            rList.add(gT_MetaTileEntity_Hatch_Input.getFillableStack());
        }
        return rList;
    }

    public ArrayList<ItemStack> getStoredInputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_Steam_BusInput tHatch : this.mSteamInputs) {
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                if (tHatch.getBaseMetaTileEntity().func_70301_a(i) == null) continue;
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    public boolean addOutput(ItemStack aStack) {
        if (GT_Utility.isStackInvalid((Object)aStack)) {
            return false;
        }
        aStack = GT_Utility.copy((Object[])new Object[]{aStack});
        boolean outputSuccess = true;
        while (outputSuccess && aStack.field_77994_a > 0) {
            outputSuccess = false;
            ItemStack single = aStack.func_77979_a(1);
            for (GT_MetaTileEntity_Hatch_Steam_BusOutput tHatch : this.mSteamOutputs) {
                if (outputSuccess || !GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
                for (int i = tHatch.func_70302_i_() - 1; i >= 0 && !outputSuccess; --i) {
                    if (!tHatch.getBaseMetaTileEntity().addStackToSlot(i, single)) continue;
                    outputSuccess = true;
                }
            }
            for (GT_MetaTileEntity_Hatch_Steam_BusOutput tHatch : this.mOutputHatches) {
                if (outputSuccess || !GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)tHatch) || !tHatch.outputsItems() || !tHatch.getBaseMetaTileEntity().addStackToSlot(1, single)) continue;
                outputSuccess = true;
            }
        }
        return outputSuccess;
    }

    public ArrayList<ItemStack> getStoredOutputs() {
        ArrayList<ItemStack> rList = new ArrayList<ItemStack>();
        for (GT_MetaTileEntity_Hatch_Steam_BusOutput tHatch : this.mSteamOutputs) {
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            for (int i = tHatch.getBaseMetaTileEntity().func_70302_i_() - 1; i >= 0; --i) {
                rList.add(tHatch.getBaseMetaTileEntity().func_70301_a(i));
            }
        }
        return rList;
    }

    @Override
    public void updateSlots() {
        for (GT_MetaTileEntity_Hatch_Input gT_MetaTileEntity_Hatch_Input : this.mSteamInputFluids) {
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)gT_MetaTileEntity_Hatch_Input)) continue;
            gT_MetaTileEntity_Hatch_Input.updateSlots();
        }
        for (GT_MetaTileEntity_Hatch_Steam_BusInput gT_MetaTileEntity_Hatch_Steam_BusInput : this.mSteamInputs) {
            if (!GregtechMeta_SteamMultiBase.isValidMetaTileEntity((MetaTileEntity)gT_MetaTileEntity_Hatch_Steam_BusInput)) continue;
            gT_MetaTileEntity_Hatch_Steam_BusInput.updateSlots();
        }
    }
}

