/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.gui.GT_Container_MultiMachine;
import gregtech.api.gui.GT_GUIContainer_MultiMachine;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Dynamo;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Maintenance;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Muffler;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBus;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.GTplusplus;
import gtPlusPlus.api.helpers.GregtechPlusPlus_API;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.api.objects.data.ConcurrentHashSet;
import gtPlusPlus.api.objects.data.FlexiblePair;
import gtPlusPlus.api.objects.data.Triplet;
import gtPlusPlus.api.objects.minecraft.BlockPos;
import gtPlusPlus.api.objects.minecraft.multi.SpecialMultiBehaviour;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.data.ArrayUtils;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.preloader.CORE_Preloader;
import gtPlusPlus.preloader.asm.AsmConfig;
import gtPlusPlus.xmod.gregtech.api.gui.CONTAINER_MultiMachine;
import gtPlusPlus.xmod.gregtech.api.gui.CONTAINER_MultiMachine_NoPlayerInventory;
import gtPlusPlus.xmod.gregtech.api.gui.GUI_MultiMachine;
import gtPlusPlus.xmod.gregtech.api.gui.GUI_MultiMachine_Default;
import gtPlusPlus.xmod.gregtech.api.gui.GUI_Multi_Basic_Slotted;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_AirIntake;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_ControlCore;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBattery;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_OutputBattery;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Steam_BusInput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class GregtechMeta_MultiBlockBase<T extends GT_MetaTileEntity_EnhancedMultiBlockBase<T>>
extends GT_MetaTileEntity_EnhancedMultiBlockBase<T> {
    public static final boolean DEBUG_DISABLE_CORES_TEMPORARILY = true;
    private static final Method findRecipe08;
    private static final Method findRecipe09;
    public GT_Recipe mLastRecipe;
    private boolean mInternalCircuit = false;
    protected long mTotalRunTime = 0L;
    protected boolean mVoidExcess = false;
    public ArrayList<GT_MetaTileEntity_Hatch_ControlCore> mControlCoreBus = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_AirIntake> mAirIntakes = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_InputBattery> mChargeHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch_OutputBattery> mDischargeHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch> mAllEnergyHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch> mAllDynamoHatches = new ArrayList();
    private static final HashMap<String, SpecialMultiBehaviour> mCustomBehviours;
    private String[] aCachedToolTip;
    public static final String TAG_HIDE_HATCHES = "TAG_HIDE_HATCHES";
    public static final String TAG_HIDE_MAINT = "TAG_HIDE_MAINT";
    public static final String TAG_HIDE_POLLUTION = "TAG_HIDE_POLLUTION";
    public static final String TAG_HIDE_MACHINE_TYPE = "TAG_HIDE_MACHINE_TYPE";
    public static Method aLogger;
    private boolean mHasBoostedCurrentRecipe = false;
    private GT_Recipe mBoostedRecipe = null;
    private ItemStack[] mInputVerificationForBoosting = null;
    public ArrayList<GT_MetaTileEntity_Hatch> mTecTechDynamoHatches = new ArrayList();
    public ArrayList<GT_MetaTileEntity_Hatch> mTecTechEnergyHatches = new ArrayList();
    private static Method calculatePollutionReduction;

    public GregtechMeta_MultiBlockBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GregtechMeta_MultiBlockBase(String aName) {
        super(aName);
    }

    public static boolean isValidMetaTileEntity(MetaTileEntity aMetaTileEntity) {
        return aMetaTileEntity.getBaseMetaTileEntity() != null && aMetaTileEntity.getBaseMetaTileEntity().getMetaTileEntity() == aMetaTileEntity && !aMetaTileEntity.getBaseMetaTileEntity().isDead();
    }

    public abstract boolean hasSlotInGUI();

    public long getTotalRuntimeInTicks() {
        return this.mTotalRunTime;
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        if (this.hasSlotInGUI()) {
            return new GT_Container_MultiMachine(aPlayerInventory, aBaseMetaTileEntity);
        }
        String aCustomGUI = this.getCustomGUIResourceName();
        if (aCustomGUI == null) {
            return new CONTAINER_MultiMachine_NoPlayerInventory(aPlayerInventory, aBaseMetaTileEntity);
        }
        return new CONTAINER_MultiMachine(aPlayerInventory, aBaseMetaTileEntity);
    }

    public abstract String getCustomGUIResourceName();

    public boolean requiresVanillaGtGUI() {
        return false;
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        String aCustomGUI = this.getCustomGUIResourceName();
        aCustomGUI = aCustomGUI != null ? aCustomGUI : (this.hasSlotInGUI() ? "MultiblockDisplay" : "MultiblockDisplay_Generic");
        aCustomGUI = aCustomGUI + ".png";
        if (this.hasSlotInGUI()) {
            if (!this.requiresVanillaGtGUI()) {
                return new GUI_Multi_Basic_Slotted(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), aCustomGUI);
            }
            return new GT_GUIContainer_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), aCustomGUI);
        }
        if (this.getCustomGUIResourceName() == null && !this.hasSlotInGUI()) {
            return new GUI_MultiMachine(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), aCustomGUI);
        }
        return new GUI_MultiMachine_Default(aPlayerInventory, aBaseMetaTileEntity, this.getLocalName(), aCustomGUI);
    }

    public abstract String getMachineType();

    public String getMachineTooltip() {
        return "Machine Type: " + EnumChatFormatting.YELLOW + this.getMachineType() + EnumChatFormatting.RESET;
    }

    public String[] getExtraInfoData() {
        return new String[0];
    }

    public final String[] getInfoData() {
        ArrayList<String> mInfo = new ArrayList<String>();
        try {
            long maxEnergy;
            long storedEnergy;
            String[] extra;
            if (!this.getMetaName().equals("")) {
                mInfo.add(this.getMetaName());
            }
            if ((extra = this.getExtraInfoData()) == null) {
                extra = new String[]{};
            }
            if (extra.length > 0) {
                for (String s : extra) {
                    mInfo.add(s);
                }
            }
            long seconds = this.mTotalRunTime / 20L;
            int weeks = (int)(TimeUnit.SECONDS.toDays(seconds) / 7L);
            int days = (int)(TimeUnit.SECONDS.toDays(seconds) - (long)(7 * weeks));
            long hours = TimeUnit.SECONDS.toHours(seconds) - TimeUnit.DAYS.toHours(days) - TimeUnit.DAYS.toHours(7 * weeks);
            long minutes = TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.SECONDS.toHours(seconds) * 60L;
            long second = TimeUnit.SECONDS.toSeconds(seconds) - TimeUnit.SECONDS.toMinutes(seconds) * 60L;
            mInfo.add(this.getMachineTooltip());
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.progress") + ": " + EnumChatFormatting.GREEN + Integer.toString(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + Integer.toString(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s");
            if (!this.mAllEnergyHatches.isEmpty()) {
                storedEnergy = this.getStoredEnergyInAllEnergyHatches();
                maxEnergy = this.getMaxEnergyStorageOfAllEnergyHatches();
                mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.energy") + ":");
                mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.GREEN + Long.toString(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + Long.toString(maxEnergy) + EnumChatFormatting.RESET + " EU")));
                mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.mei") + ":");
                mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.YELLOW + Long.toString(this.getMaxInputVoltage()) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier((long)this.getMaxInputVoltage())] + EnumChatFormatting.RESET)));
            }
            if (!this.mAllDynamoHatches.isEmpty()) {
                storedEnergy = this.getStoredEnergyInAllDynamoHatches();
                maxEnergy = this.getMaxEnergyStorageOfAllDynamoHatches();
                mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.energy") + " In Dynamos:");
                mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.GREEN + Long.toString(storedEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + Long.toString(maxEnergy) + EnumChatFormatting.RESET + " EU")));
            }
            if (-this.mEUt > 0) {
                mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.usage") + ":");
                mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.RED + Integer.toString(-this.mEUt) + EnumChatFormatting.RESET + " EU/t")));
            } else {
                mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.generation") + ":");
                mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.GREEN + Integer.toString(this.mEUt) + EnumChatFormatting.RESET + " EU/t")));
            }
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GTPP.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + Float.toString((float)this.mEfficiency / 100.0f) + EnumChatFormatting.RESET + " %");
            if (this.getPollutionPerSecond(null) > 0) {
                int mPollutionReduction = this.getPollutionReductionForAllMufflers();
                mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.pollution") + ": " + EnumChatFormatting.RED + this.getPollutionPerSecond(null) + EnumChatFormatting.RESET + "/sec");
                mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.pollutionreduced") + ": " + EnumChatFormatting.GREEN + mPollutionReduction + EnumChatFormatting.RESET + " %");
            }
            if (this.mControlCoreBus.size() > 0) {
                int tTier = this.getControlCoreTier();
                mInfo.add(StatCollector.func_74838_a((String)"GTPP.CC.machinetier") + ": " + EnumChatFormatting.GREEN + tTier + EnumChatFormatting.RESET);
            }
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.CC.discount") + ": " + EnumChatFormatting.GREEN + this.getEuDiscountForParallelism() + EnumChatFormatting.RESET + "%");
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.CC.parallel") + ": " + EnumChatFormatting.GREEN + this.getMaxParallelRecipes() + EnumChatFormatting.RESET);
            mInfo.add("Total Time Since Built: " + EnumChatFormatting.DARK_GREEN + Integer.toString(weeks) + EnumChatFormatting.RESET + " Weeks, " + EnumChatFormatting.DARK_GREEN + Integer.toString(days) + EnumChatFormatting.RESET + " Days, ");
            mInfo.add(EnumChatFormatting.DARK_GREEN + Long.toString(hours) + EnumChatFormatting.RESET + " Hours, " + EnumChatFormatting.DARK_GREEN + Long.toString(minutes) + EnumChatFormatting.RESET + " Minutes, " + EnumChatFormatting.DARK_GREEN + Long.toString(second) + EnumChatFormatting.RESET + " Seconds.");
            mInfo.add("Total Time in ticks: " + EnumChatFormatting.DARK_GREEN + Long.toString(this.mTotalRunTime));
            String[] mInfo2 = mInfo.toArray(new String[mInfo.size()]);
            return mInfo2;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new String[0];
        }
    }

    public int getPollutionReductionForAllMufflers() {
        int mPollutionReduction = 0;
        for (GT_MetaTileEntity_Hatch_Muffler tHatch : this.mMufflerHatches) {
            if (!GregtechMeta_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            mPollutionReduction = Math.max(this.calculatePollutionReductionForHatch(tHatch, 100), mPollutionReduction);
        }
        return mPollutionReduction;
    }

    public long getStoredEnergyInAllEnergyHatches() {
        long storedEnergy = 0L;
        for (GT_MetaTileEntity_Hatch tHatch : this.mAllEnergyHatches) {
            if (!GregtechMeta_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
        }
        return storedEnergy;
    }

    public long getMaxEnergyStorageOfAllEnergyHatches() {
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch tHatch : this.mAllEnergyHatches) {
            if (!GregtechMeta_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return maxEnergy;
    }

    public long getStoredEnergyInAllDynamoHatches() {
        long storedEnergy = 0L;
        for (GT_MetaTileEntity_Hatch tHatch : this.mAllDynamoHatches) {
            if (!GregtechMeta_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            storedEnergy += tHatch.getBaseMetaTileEntity().getStoredEU();
        }
        return storedEnergy;
    }

    public long getMaxEnergyStorageOfAllDynamoHatches() {
        long maxEnergy = 0L;
        for (GT_MetaTileEntity_Hatch tHatch : this.mAllDynamoHatches) {
            if (!GregtechMeta_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            maxEnergy += tHatch.getBaseMetaTileEntity().getEUCapacity();
        }
        return maxEnergy;
    }

    public boolean isGivingInformation() {
        return true;
    }

    public int getAmountOfOutputs() {
        return 1;
    }

    public abstract int getMaxParallelRecipes();

    public abstract int getEuDiscountForParallelism();

    public boolean isCorrectMachinePart(ItemStack paramItemStack) {
        return true;
    }

    public int getDamageToComponent(ItemStack paramItemStack) {
        return 0;
    }

    public boolean explodesOnComponentBreak(ItemStack p0) {
        return false;
    }

    public void startSoundLoop(byte aIndex, double aX, double aY, double aZ) {
        super.startSoundLoop(aIndex, aX, aY, aZ);
        if (aIndex == 1) {
            GT_Utility.doSoundAtClient((String)this.getSound(), (int)10, (float)1.0f, (double)aX, (double)aY, (double)aZ);
        }
    }

    public void startProcess() {
        if (GT_Utility.isStringValid((Object)this.getSound())) {
            this.sendLoopStart((byte)1);
        }
    }

    public String getSound() {
        return "";
    }

    public int canBufferOutputs(GT_Recipe aRecipe, int aParallelRecipes) {
        return this.canBufferOutputs(aRecipe, aParallelRecipes, true);
    }

    /*
     * WARNING - void declaration
     */
    public int canBufferOutputs(GT_Recipe aRecipe, int aParallelRecipes, boolean aAllow16SlotWithoutCheck) {
        boolean aDoesOutputFluids;
        if (this.mVoidExcess) {
            return aParallelRecipes;
        }
        this.log("Determining if we have space to buffer outputs. Parallel: " + aParallelRecipes);
        if (aRecipe == null || aRecipe.mOutputs.length > 16) {
            if (aRecipe == null) {
                return 0;
            }
            if (aRecipe.mOutputs.length > 16 && aAllow16SlotWithoutCheck) {
                return aParallelRecipes;
            }
        }
        boolean aDoesOutputItems = aRecipe.mOutputs.length > 0;
        boolean bl = aDoesOutputFluids = aRecipe.mFluidOutputs.length > 0;
        if (aDoesOutputItems) {
            this.log("We have items to output.");
            int aInputBusSlotsFree = 0;
            AutoMap<FlexiblePair<ItemStack, Integer>> aItemMap = new AutoMap<FlexiblePair<ItemStack, Integer>>();
            AutoMap<ItemStack> aOutputs = new AutoMap<ItemStack>(aRecipe.mOutputs);
            for (GT_MetaTileEntity_Hatch_OutputBus tBus : this.mOutputBusses) {
                if (!GregtechMeta_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tBus)) continue;
                IGregTechTileEntity tBusInv = tBus.getBaseMetaTileEntity();
                for (int i = 0; i < tBusInv.func_70302_i_(); ++i) {
                    if (tBus.func_70301_a(i) == null) {
                        ++aInputBusSlotsFree;
                        continue;
                    }
                    ItemStack aT = tBus.func_70301_a(i);
                    int aSize = aT.field_77994_a;
                    aT = aT.func_77946_l();
                    aT.field_77994_a = 0;
                    aItemMap.put(new FlexiblePair<ItemStack, Integer>(aT, aSize));
                }
            }
            int aRecipeSlotsRequired = 0;
            ConcurrentHashSet aInputMap = new ConcurrentHashSet();
            for (int i = 0; i < aOutputs.size(); ++i) {
                ItemStack itemStack = aOutputs.get(i);
                if (itemStack == null) continue;
                int aStackSize = itemStack.field_77994_a * aParallelRecipes;
                if (aStackSize > 64) {
                    int aSlotsNeedsForThisStack = (int)Math.ceil((float)aStackSize / 64.0f);
                    aRecipeSlotsRequired += aSlotsNeedsForThisStack;
                    for (int o = 0; o < aRecipeSlotsRequired; ++o) {
                        void var12_24;
                        int aStackToRemove = (aStackSize -= 64) > 64 ? 64 : aStackSize;
                        ItemStack itemStack2 = var12_24.func_77946_l();
                        itemStack2.field_77994_a = 0;
                        aInputMap.add(new FlexiblePair<ItemStack, Integer>(itemStack2, aStackToRemove));
                    }
                    continue;
                }
                ++aRecipeSlotsRequired;
                ItemStack itemStack3 = itemStack.func_77946_l();
                itemStack3.field_77994_a = 0;
                aInputMap.add(new FlexiblePair<ItemStack, Integer>(itemStack3, aStackSize));
            }
            if (aInputMap.size() > 0) {
                block4: for (FlexiblePair flexiblePair : aItemMap) {
                    Iterator aStackSize = aInputMap.iterator();
                    while (aStackSize.hasNext()) {
                        ItemStack aOutputStack;
                        FlexiblePair u = (FlexiblePair)aStackSize.next();
                        ItemStack aOutputBusStack = (ItemStack)flexiblePair.getKey();
                        if (!GT_Utility.areStacksEqual((ItemStack)aOutputBusStack, (ItemStack)(aOutputStack = (ItemStack)u.getKey()), (boolean)false)) continue;
                        if (aOutputBusStack.field_77994_a >= 64) continue block4;
                        if (aOutputBusStack.field_77994_a + aOutputStack.field_77994_a <= 64) {
                            flexiblePair.setValue(aOutputBusStack.field_77994_a + aOutputStack.field_77994_a);
                            aInputMap.remove(u);
                            continue;
                        }
                        int aRemainder = aOutputBusStack.field_77994_a + aOutputStack.field_77994_a - 64;
                        flexiblePair.setValue(64);
                        FlexiblePair t = new FlexiblePair(u.getKey(), aRemainder);
                        aInputMap.remove(u);
                        aInputMap.add(t);
                    }
                }
            }
            if (aInputMap.size() > 0 && aInputMap.size() > aInputBusSlotsFree) {
                aParallelRecipes = (int)Math.floor((double)aInputBusSlotsFree / (double)aInputMap.size() * (double)aParallelRecipes);
                this.log(" Free: " + aInputBusSlotsFree + ", Required: " + aInputMap.size());
                if (aParallelRecipes == 0) {
                    this.log("Failed to find enough space for all item outputs.");
                    return 0;
                }
            }
        }
        if (aDoesOutputFluids) {
            this.log("We have Fluids to output.");
            int aFluidHatches = 0;
            int aEmptyFluidHatches = 0;
            int aFullFluidHatches = 0;
            ArrayList<Triplet<GT_MetaTileEntity_Hatch_Output, Object, Integer>> aOutputHatches = new ArrayList<Triplet<GT_MetaTileEntity_Hatch_Output, Object, Integer>>();
            for (GT_MetaTileEntity_Hatch_Output tBus : this.mOutputHatches) {
                if (!GregtechMeta_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tBus)) continue;
                ++aFluidHatches;
                if (tBus.getFluid() == null) {
                    aOutputHatches.add(new Triplet<GT_MetaTileEntity_Hatch_Output, Object, Integer>(tBus, null, tBus.getCapacity()));
                    continue;
                }
                int n = tBus.getCapacity() - tBus.getFluidAmount();
                aOutputHatches.add(new Triplet<GT_MetaTileEntity_Hatch_Output, FluidStack, Integer>(tBus, tBus.getFluid(), n));
            }
            ArrayList<FluidStack> aOutputFluids = new ArrayList<FluidStack>();
            aOutputFluids.addAll(new AutoMap<FluidStack>(aRecipe.mFluidOutputs));
            block7: for (int i = 0; i < aOutputHatches.size(); ++i) {
                GT_MetaTileEntity_Hatch_Output gT_MetaTileEntity_Hatch_Output = (GT_MetaTileEntity_Hatch_Output)((Triplet)aOutputHatches.get(i)).getValue_1();
                FluidStack aHatchStack = (FluidStack)((Triplet)aOutputHatches.get(i)).getValue_2();
                int aSpaceLeftInHatch = gT_MetaTileEntity_Hatch_Output.getCapacity() - gT_MetaTileEntity_Hatch_Output.getFluidAmount();
                if (aSpaceLeftInHatch <= 0) {
                    ++aFullFluidHatches;
                    aOutputHatches.remove(aOutputHatches.get(i));
                    --i;
                    continue;
                }
                for (int j = 0; j < aOutputFluids.size(); ++j) {
                    Triplet<GT_MetaTileEntity_Hatch_Output, FluidStack, Integer> aNewHatchData;
                    FluidStack aNewHatchStack;
                    if (!GT_Utility.areFluidsEqual((FluidStack)aHatchStack, (FluidStack)((FluidStack)aOutputFluids.get(j)))) continue;
                    int aFluidToPutIntoHatch = ((FluidStack)aOutputFluids.get((int)j)).amount * aParallelRecipes;
                    if (aSpaceLeftInHatch < aFluidToPutIntoHatch) {
                        aNewHatchStack = aHatchStack.copy();
                        aNewHatchStack.amount = 0;
                        FluidStack aNewOutputStack = aHatchStack.copy();
                        aNewOutputStack.amount = 0;
                        int aFluidLeftAfterInsert = aFluidToPutIntoHatch - aSpaceLeftInHatch;
                        aNewHatchStack.amount = gT_MetaTileEntity_Hatch_Output.getCapacity();
                        aNewOutputStack.amount = aFluidLeftAfterInsert;
                        aOutputFluids.remove(aOutputFluids.get(j));
                        --j;
                        aOutputHatches.remove(aOutputHatches.get(i));
                        --i;
                        aOutputFluids.add(aNewOutputStack);
                        continue block7;
                    }
                    if (aSpaceLeftInHatch == aFluidToPutIntoHatch) {
                        aNewHatchStack = aHatchStack.copy();
                        aNewHatchStack.amount += aFluidToPutIntoHatch;
                        aOutputFluids.remove(aOutputFluids.get(j));
                        --j;
                        aOutputHatches.remove(aOutputHatches.get(i));
                        --i;
                        aNewHatchData = new Triplet<GT_MetaTileEntity_Hatch_Output, FluidStack, Integer>(gT_MetaTileEntity_Hatch_Output, aNewHatchStack, aNewHatchStack.amount);
                        aOutputHatches.add(aNewHatchData);
                        continue block7;
                    }
                    aNewHatchStack = aHatchStack.copy();
                    aNewHatchStack.amount += aFluidToPutIntoHatch;
                    aOutputFluids.remove(aOutputFluids.get(j));
                    --j;
                    aOutputHatches.remove(aOutputHatches.get(i));
                    --i;
                    aNewHatchData = new Triplet<GT_MetaTileEntity_Hatch_Output, FluidStack, Integer>(gT_MetaTileEntity_Hatch_Output, aNewHatchStack, aNewHatchStack.amount);
                    aOutputHatches.add(aNewHatchData);
                }
            }
            for (Triplet triplet : aOutputHatches) {
                if (triplet.getValue_2() != null && (Integer)triplet.getValue_3() != 0 && ((GT_MetaTileEntity_Hatch_Output)triplet.getValue_1()).getFluid() != null) continue;
                ++aEmptyFluidHatches;
            }
            this.log("fluids to output " + aOutputFluids.size() + " empty hatches " + aEmptyFluidHatches);
            if (aOutputFluids.size() > 0 && aOutputFluids.size() > aEmptyFluidHatches) {
                aParallelRecipes = (int)Math.floor((double)aEmptyFluidHatches / (double)aOutputFluids.size() * (double)aParallelRecipes);
                this.log("Failed to find enough space for all fluid outputs. Free: " + aEmptyFluidHatches + ", Required: " + aOutputFluids.size());
                return 0;
            }
        }
        return aParallelRecipes;
    }

    public void log(String s) {
        if (!AsmConfig.disableAllLogging) {
            if (CORE_Preloader.DEBUG_MODE) {
                Logger.INFO(s);
            } else {
                Logger.MACHINE_INFO(s, new Object[0]);
            }
        }
    }

    public boolean checkRecipeGeneric() {
        return this.checkRecipeGeneric(1, 100, 0);
    }

    public boolean checkRecipeGeneric(int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent) {
        return this.checkRecipeGeneric(aMaxParallelRecipes, aEUPercent, aSpeedBonusPercent, 10000);
    }

    public boolean checkRecipeGeneric(int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        ArrayList tItems = this.getStoredInputs();
        ArrayList tFluids = this.getStoredFluids();
        ItemStack[] tItemInputs = tItems.toArray(new ItemStack[tItems.size()]);
        FluidStack[] tFluidInputs = tFluids.toArray(new FluidStack[tFluids.size()]);
        return this.checkRecipeGeneric(tItemInputs, tFluidInputs, aMaxParallelRecipes, aEUPercent, aSpeedBonusPercent, aOutputChanceRoll);
    }

    public boolean checkRecipeGeneric(GT_Recipe aRecipe, int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        if (aRecipe == null) {
            return false;
        }
        ArrayList tItems = this.getStoredInputs();
        ArrayList tFluids = this.getStoredFluids();
        ItemStack[] tItemInputs = tItems.toArray(new ItemStack[tItems.size()]);
        FluidStack[] tFluidInputs = tFluids.toArray(new FluidStack[tFluids.size()]);
        return this.checkRecipeGeneric(tItemInputs, tFluidInputs, aMaxParallelRecipes, aEUPercent, aSpeedBonusPercent, aOutputChanceRoll, aRecipe);
    }

    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll) {
        return this.checkRecipeGeneric(aItemInputs, aFluidInputs, aMaxParallelRecipes, aEUPercent, aSpeedBonusPercent, aOutputChanceRoll, null);
    }

    public long getMaxInputEnergy() {
        long rEnergy = 0L;
        if (this.mEnergyHatches.size() < 2) {
            return ((GT_MetaTileEntity_Hatch_Energy)this.mEnergyHatches.get(0)).getBaseMetaTileEntity().getInputVoltage();
        }
        for (GT_MetaTileEntity_Hatch_Energy tHatch : this.mEnergyHatches) {
            if (!GregtechMeta_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch)) continue;
            rEnergy += tHatch.getBaseMetaTileEntity().getInputVoltage() * tHatch.getBaseMetaTileEntity().getInputAmperage();
        }
        return rEnergy;
    }

    public boolean hasPerfectOverclock() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkRecipeGeneric(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll, GT_Recipe aRecipe) {
        void var24_35;
        int parallelRecipes;
        this.mEUt = 0;
        this.mMaxProgresstime = 0;
        this.mOutputItems = new ItemStack[0];
        this.mOutputFluids = new FluidStack[0];
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = this.getMaxInputEnergy();
        this.log("Running checkRecipeGeneric(0)");
        GT_Recipe tRecipe = this.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, false, GT_Values.V[tTier], aFluidInputs, aItemInputs);
        this.log("Running checkRecipeGeneric(1)");
        this.mLastRecipe = tRecipe;
        if (tRecipe == null) {
            this.log("BAD RETURN - 1");
            return false;
        }
        if (mCustomBehviours.isEmpty()) {
            mCustomBehviours.putAll(GregtechPlusPlus_API.Multiblock_API.getSpecialBehaviourItemMap());
        }
        if (tRecipe.mSpecialItems != null && tRecipe.mSpecialItems instanceof ItemStack) {
            ItemStack aSpecialStack = (ItemStack)tRecipe.mSpecialItems;
            boolean aDidFindMatch = false;
            for (ItemStack aInputItemsToCheck : aItemInputs) {
                if (!GT_Utility.areStacksEqual((ItemStack)aSpecialStack, (ItemStack)aInputItemsToCheck, (boolean)false)) continue;
                aDidFindMatch = true;
                break;
            }
            if (aDidFindMatch) {
                for (SpecialMultiBehaviour aBehaviours : mCustomBehviours.values()) {
                    if (!aBehaviours.isTriggerItem(aSpecialStack)) continue;
                    aMaxParallelRecipes = aBehaviours.getMaxParallelRecipes();
                    aEUPercent = aBehaviours.getEUPercent();
                    aSpeedBonusPercent = aBehaviours.getSpeedBonusPercent();
                    aOutputChanceRoll = aBehaviours.getOutputChanceRoll();
                    break;
                }
            }
        }
        if ((aMaxParallelRecipes = this.canBufferOutputs(tRecipe, aMaxParallelRecipes)) == 0) {
            this.log("BAD RETURN - 2");
            return false;
        }
        float tRecipeEUt = (float)(tRecipe.mEUt * aEUPercent) / 100.0f;
        float tTotalEUt = 0.0f;
        this.log("parallelRecipes: " + parallelRecipes);
        this.log("aMaxParallelRecipes: " + aMaxParallelRecipes);
        this.log("tTotalEUt: " + tTotalEUt);
        this.log("tVoltage: " + tVoltage);
        this.log("tRecipeEUt: " + tRecipeEUt);
        for (parallelRecipes = 0; parallelRecipes < aMaxParallelRecipes && tTotalEUt < (float)tEnergy - tRecipeEUt; tTotalEUt += tRecipeEUt, ++parallelRecipes) {
            if (!tRecipe.isRecipeInputEqual(true, aFluidInputs, aItemInputs)) {
                this.log("Broke at " + parallelRecipes + ".");
                break;
            }
            this.log("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ".");
        }
        if (parallelRecipes == 0) {
            this.log("BAD RETURN - 3");
            return false;
        }
        aSpeedBonusPercent = Math.max(-99, aSpeedBonusPercent);
        float tTimeFactor = 100.0f / (100.0f + (float)aSpeedBonusPercent);
        this.mMaxProgresstime = (int)((float)tRecipe.mDuration * tTimeFactor);
        this.mEUt = (int)Math.ceil(tTotalEUt);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mEUt <= 16) {
            this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
            this.mMaxProgresstime /= 1 << tTier - 1;
        } else {
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                if (this.hasPerfectOverclock()) {
                    this.mMaxProgresstime /= 4;
                    continue;
                }
                this.mMaxProgresstime /= 2;
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        FluidStack[] tOutputFluids = new FluidStack[tRecipe.mFluidOutputs.length];
        for (int h = 0; h < tRecipe.mFluidOutputs.length; ++h) {
            if (tRecipe.getFluidOutput(h) == null) continue;
            tOutputFluids[h] = tRecipe.getFluidOutput(h).copy();
            tOutputFluids[h].amount *= parallelRecipes;
        }
        Object[] tOutputItems = new ItemStack[tRecipe.mOutputs.length];
        for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
            if (tRecipe.getOutput(h) == null) continue;
            tOutputItems[h] = tRecipe.getOutput(h).func_77946_l();
            tOutputItems[h].field_77994_a = 0;
        }
        for (int f = 0; f < tOutputItems.length; ++f) {
            if (tRecipe.mOutputs[f] == null || tOutputItems[f] == null) continue;
            for (int g = 0; g < parallelRecipes; ++g) {
                if (this.getBaseMetaTileEntity().getRandomNumber(aOutputChanceRoll) >= tRecipe.getOutputChance(f)) continue;
                tOutputItems[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
            }
        }
        tOutputItems = ArrayUtils.removeNulls((ItemStack[])tOutputItems);
        ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : tOutputItems) {
            while (itemStack.func_77976_d() < itemStack.field_77994_a) {
                ItemStack tmp = itemStack.func_77946_l();
                tmp.field_77994_a = tmp.func_77976_d();
                itemStack.field_77994_a -= itemStack.func_77976_d();
                splitStacks.add(tmp);
            }
        }
        if (splitStacks.size() > 0) {
            Object[] tmp = new ItemStack[splitStacks.size()];
            tmp = splitStacks.toArray(tmp);
            tOutputItems = (ItemStack[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])tOutputItems, (Object[])tmp);
        }
        ArrayList<Object> tSList = new ArrayList<Object>();
        Object[] objectArray = tOutputItems;
        int n = objectArray.length;
        boolean bl = false;
        while (var24_35 < n) {
            Object tS = objectArray[var24_35];
            if (((ItemStack)tS).field_77994_a > 0) {
                tSList.add(tS);
            }
            ++var24_35;
        }
        tOutputItems = tSList.toArray(new ItemStack[tSList.size()]);
        this.mOutputItems = tOutputItems;
        this.mOutputFluids = tOutputFluids;
        this.updateSlots();
        this.startProcess();
        this.log("GOOD RETURN - 1");
        return true;
    }

    protected boolean doesMachineBoostOutput() {
        return false;
    }

    private int boostOutput(int aAmount) {
        if (aAmount <= 0) {
            return 10000;
        }
        if (aAmount <= 250) {
            aAmount += MathUtils.randInt(Math.max(aAmount / 2, 1), aAmount * 2);
        } else if (aAmount <= 500) {
            aAmount += MathUtils.randInt(Math.max(aAmount / 2, 1), aAmount * 2);
        } else if (aAmount <= 750) {
            aAmount += MathUtils.randInt(Math.max(aAmount / 2, 1), aAmount * 2);
        } else if (aAmount <= 1000) {
            aAmount *= 2;
        } else if (aAmount <= 1500) {
            aAmount *= 2;
        } else if (aAmount <= 2000) {
            aAmount = (int)((double)aAmount * 1.5);
        } else if (aAmount <= 3000) {
            aAmount = (int)((double)aAmount * 1.5);
        } else if (aAmount <= 4000) {
            aAmount = (int)((double)aAmount * 1.2);
        } else if (aAmount <= 5000) {
            aAmount = (int)((double)aAmount * 1.2);
        } else if (aAmount <= 7000) {
            aAmount = (int)((double)aAmount * 1.2);
        } else if (aAmount <= 9000) {
            aAmount = (int)((double)aAmount * 1.1);
        }
        return Math.min(10000, aAmount);
    }

    public GT_Recipe generateAdditionalOutputForRecipe(GT_Recipe aRecipe) {
        AutoMap<Integer> aNewChances = new AutoMap<Integer>();
        for (int chance : aRecipe.mChances) {
            aNewChances.put(this.boostOutput(chance));
        }
        GT_Recipe aClone = aRecipe.copy();
        int[] aTemp = new int[aNewChances.size()];
        int slot = 0;
        Iterator iterator = aNewChances.iterator();
        while (iterator.hasNext()) {
            int g;
            aTemp[slot] = g = ((Integer)iterator.next()).intValue();
            ++slot;
        }
        aClone.mChances = aTemp;
        return aClone;
    }

    /*
     * WARNING - void declaration
     */
    public boolean checkRecipeBoostedOutputs(ItemStack[] aItemInputs, FluidStack[] aFluidInputs, int aMaxParallelRecipes, int aEUPercent, int aSpeedBonusPercent, int aOutputChanceRoll, GT_Recipe aRecipe) {
        void var25_30;
        int parallelRecipes;
        GT_Recipe aBoostedRecipe;
        long tVoltage = this.getMaxInputVoltage();
        byte tTier = (byte)Math.max(1, GT_Utility.getTier((long)tVoltage));
        long tEnergy = this.getMaxInputEnergy();
        this.log("Running checkRecipeGeneric(0)");
        GT_Recipe tRecipe = aRecipe != null ? aRecipe : this.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, GT_Values.V[tTier], aFluidInputs, aItemInputs);
        this.log("Running checkRecipeGeneric(1)");
        boolean isRecipeInputTheSame = false;
        if (this.mInputVerificationForBoosting == null) {
            this.mInputVerificationForBoosting = tRecipe.mInputs;
            isRecipeInputTheSame = true;
        } else {
            isRecipeInputTheSame = tRecipe.mInputs == this.mInputVerificationForBoosting;
        }
        if (isRecipeInputTheSame) {
            if (this.mHasBoostedCurrentRecipe && this.mBoostedRecipe != null) {
                tRecipe = this.mBoostedRecipe;
            } else {
                aBoostedRecipe = this.generateAdditionalOutputForRecipe(tRecipe);
                if (aBoostedRecipe != null) {
                    this.mBoostedRecipe = aBoostedRecipe;
                    this.mHasBoostedCurrentRecipe = true;
                    tRecipe = this.mBoostedRecipe;
                } else {
                    this.mBoostedRecipe = null;
                    this.mHasBoostedCurrentRecipe = false;
                }
            }
        } else {
            aBoostedRecipe = this.generateAdditionalOutputForRecipe(tRecipe);
            if (aBoostedRecipe != null) {
                this.mBoostedRecipe = aBoostedRecipe;
                this.mHasBoostedCurrentRecipe = true;
                tRecipe = this.mBoostedRecipe;
            } else {
                this.mBoostedRecipe = null;
                this.mHasBoostedCurrentRecipe = false;
            }
        }
        if (!this.mHasBoostedCurrentRecipe || this.mBoostedRecipe == null) {
            tRecipe = aRecipe != null ? aRecipe : this.findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), this.mLastRecipe, false, false, GT_Values.V[tTier], aFluidInputs, aItemInputs);
        }
        this.mLastRecipe = tRecipe;
        if (tRecipe == null) {
            this.log("BAD RETURN - 1");
            return false;
        }
        if ((aMaxParallelRecipes = this.canBufferOutputs(tRecipe, aMaxParallelRecipes)) == 0) {
            this.log("BAD RETURN - 2");
            return false;
        }
        float tRecipeEUt = (float)(tRecipe.mEUt * aEUPercent) / 100.0f;
        float tTotalEUt = 0.0f;
        this.log("parallelRecipes: " + parallelRecipes);
        this.log("aMaxParallelRecipes: " + aMaxParallelRecipes);
        this.log("tTotalEUt: " + tTotalEUt);
        this.log("tVoltage: " + tVoltage);
        this.log("tRecipeEUt: " + tRecipeEUt);
        for (parallelRecipes = 0; parallelRecipes < aMaxParallelRecipes && tTotalEUt < (float)tEnergy - tRecipeEUt; tTotalEUt += tRecipeEUt, ++parallelRecipes) {
            if (!tRecipe.isRecipeInputEqual(true, aFluidInputs, aItemInputs)) {
                this.log("Broke at " + parallelRecipes + ".");
                break;
            }
            this.log("Bumped EU from " + tTotalEUt + " to " + (tTotalEUt + tRecipeEUt) + ".");
        }
        if (parallelRecipes == 0) {
            this.log("BAD RETURN - 3");
            return false;
        }
        aSpeedBonusPercent = Math.max(-99, aSpeedBonusPercent);
        float tTimeFactor = 100.0f / (100.0f + (float)aSpeedBonusPercent);
        this.mMaxProgresstime = (int)((float)tRecipe.mDuration * tTimeFactor);
        this.mEUt = (int)Math.ceil(tTotalEUt);
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        if (this.mEUt <= 16) {
            this.mEUt = this.mEUt * (1 << tTier - 1) * (1 << tTier - 1);
            this.mMaxProgresstime /= 1 << tTier - 1;
        } else {
            while ((long)this.mEUt <= GT_Values.V[tTier - 1]) {
                this.mEUt *= 4;
                this.mMaxProgresstime /= 2;
            }
        }
        if (this.mEUt > 0) {
            this.mEUt = -this.mEUt;
        }
        this.mMaxProgresstime = Math.max(1, this.mMaxProgresstime);
        FluidStack[] tOutputFluids = new FluidStack[tRecipe.mFluidOutputs.length];
        for (int h = 0; h < tRecipe.mFluidOutputs.length; ++h) {
            if (tRecipe.getFluidOutput(h) == null) continue;
            tOutputFluids[h] = tRecipe.getFluidOutput(h).copy();
            tOutputFluids[h].amount *= parallelRecipes;
        }
        Object[] tOutputItems = new ItemStack[tRecipe.mOutputs.length];
        for (int h = 0; h < tRecipe.mOutputs.length; ++h) {
            if (tRecipe.getOutput(h) == null) continue;
            tOutputItems[h] = tRecipe.getOutput(h).func_77946_l();
            tOutputItems[h].field_77994_a = 0;
        }
        for (int f = 0; f < tOutputItems.length; ++f) {
            if (tRecipe.mOutputs[f] == null || tOutputItems[f] == null) continue;
            for (int g = 0; g < parallelRecipes; ++g) {
                if (this.getBaseMetaTileEntity().getRandomNumber(aOutputChanceRoll) >= tRecipe.getOutputChance(f)) continue;
                tOutputItems[f].field_77994_a += tRecipe.mOutputs[f].field_77994_a;
            }
        }
        tOutputItems = ArrayUtils.removeNulls((ItemStack[])tOutputItems);
        ArrayList<ItemStack> splitStacks = new ArrayList<ItemStack>();
        for (ItemStack itemStack : tOutputItems) {
            while (itemStack.func_77976_d() < itemStack.field_77994_a) {
                ItemStack tmp = itemStack.func_77946_l();
                tmp.field_77994_a = tmp.func_77976_d();
                itemStack.field_77994_a -= itemStack.func_77976_d();
                splitStacks.add(tmp);
            }
        }
        if (splitStacks.size() > 0) {
            Object[] tmp = new ItemStack[splitStacks.size()];
            tmp = splitStacks.toArray(tmp);
            tOutputItems = (ItemStack[])org.apache.commons.lang3.ArrayUtils.addAll((Object[])tOutputItems, (Object[])tmp);
        }
        ArrayList<Object> tSList = new ArrayList<Object>();
        Object[] objectArray = tOutputItems;
        int n = objectArray.length;
        boolean bl = false;
        while (var25_30 < n) {
            Object tS = objectArray[var25_30];
            if (((ItemStack)tS).field_77994_a > 0) {
                tSList.add(tS);
            }
            ++var25_30;
        }
        tOutputItems = tSList.toArray(new ItemStack[tSList.size()]);
        this.mOutputItems = tOutputItems;
        this.mOutputFluids = tOutputFluids;
        this.updateSlots();
        this.startProcess();
        this.log("GOOD RETURN - 1");
        return true;
    }

    public boolean isMachineRunning() {
        boolean aRunning = this.getBaseMetaTileEntity().isActive();
        return aRunning;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            ++this.mTotalRunTime;
        }
        if (aBaseMetaTileEntity.isServerSide() && (this.mUpdate == 1 || this.mStartUpCheck == 1)) {
            this.mChargeHatches.clear();
            this.mDischargeHatches.clear();
            this.mControlCoreBus.clear();
            this.mAirIntakes.clear();
            this.mTecTechEnergyHatches.clear();
            this.mTecTechDynamoHatches.clear();
            this.mAllEnergyHatches.clear();
            this.mAllDynamoHatches.clear();
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    public void explodeMultiblock() {
        for (MetaTileEntity metaTileEntity : this.mChargeHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        Object var1_3 = null;
        for (MetaTileEntity metaTileEntity : this.mDischargeHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        Object var1_6 = null;
        for (MetaTileEntity metaTileEntity : this.mTecTechDynamoHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        Object var1_9 = null;
        for (MetaTileEntity metaTileEntity : this.mTecTechEnergyHatches) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GT_Values.V[8]);
        }
        super.explodeMultiblock();
    }

    protected int getGUICircuit(ItemStack[] t) {
        Item g = CI.getNumberedCircuit(0).func_77973_b();
        ItemStack guiSlot = this.mInventory[1];
        int mMode = -1;
        if (guiSlot != null && guiSlot.func_77973_b() == g) {
            this.mInternalCircuit = true;
            return guiSlot.func_77960_j();
        }
        this.mInternalCircuit = false;
        if (!this.mInternalCircuit) {
            for (ItemStack j : t) {
                if (j.func_77973_b() != g) continue;
                mMode = j.func_77960_j();
                break;
            }
        }
        return mMode;
    }

    protected ItemStack getGUIItemStack() {
        ItemStack guiSlot = this.mInventory[1];
        return guiSlot;
    }

    protected boolean setGUIItemStack(ItemStack aNewGuiSlotContents) {
        boolean result = false;
        if (this.mInventory[1] == null) {
            this.mInventory[1] = aNewGuiSlotContents != null ? aNewGuiSlotContents.func_77946_l() : null;
            this.depleteInput(aNewGuiSlotContents);
            this.updateSlots();
            result = true;
        }
        return result;
    }

    protected boolean clearGUIItemSlot() {
        return this.setGUIItemStack(null);
    }

    public ItemStack findItemInInventory(Item aSearchStack) {
        return this.findItemInInventory(aSearchStack, 0);
    }

    public ItemStack findItemInInventory(Item aSearchStack, int aMeta) {
        return this.findItemInInventory(ItemUtils.simpleMetaStack(aSearchStack, aMeta, 1));
    }

    public ItemStack findItemInInventory(ItemStack aSearchStack) {
        if (aSearchStack != null && this.mInputBusses.size() > 0) {
            for (GT_MetaTileEntity_Hatch_InputBus bus : this.mInputBusses) {
                if (bus == null) continue;
                for (ItemStack uStack : bus.mInventory) {
                    if (uStack == null || !aSearchStack.getClass().isInstance(uStack.func_77973_b())) continue;
                    return uStack;
                }
            }
        }
        return null;
    }

    public void updateSlots() {
        for (GT_MetaTileEntity_Hatch_InputBattery gT_MetaTileEntity_Hatch_InputBattery : this.mChargeHatches) {
            if (!GregtechMeta_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)gT_MetaTileEntity_Hatch_InputBattery)) continue;
            gT_MetaTileEntity_Hatch_InputBattery.updateSlots();
        }
        for (GT_MetaTileEntity_Hatch_OutputBattery gT_MetaTileEntity_Hatch_OutputBattery : this.mDischargeHatches) {
            if (!GregtechMeta_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)gT_MetaTileEntity_Hatch_OutputBattery)) continue;
            gT_MetaTileEntity_Hatch_OutputBattery.updateSlots();
        }
        super.updateSlots();
    }

    public boolean isToolCreative(ItemStack mStack) {
        Materials t1 = GT_MetaGenerated_Tool.getPrimaryMaterial((ItemStack)mStack);
        Materials t2 = GT_MetaGenerated_Tool.getSecondaryMaterial((ItemStack)mStack);
        return t1 == Materials._NULL && t2 == Materials._NULL;
    }

    public boolean causeMaintenanceIssue() {
        boolean b = false;
        switch (this.getBaseMetaTileEntity().getRandomNumber(6)) {
            case 0: {
                this.mWrench = false;
                b = true;
                break;
            }
            case 1: {
                this.mScrewdriver = false;
                b = true;
                break;
            }
            case 2: {
                this.mSoftHammer = false;
                b = true;
                break;
            }
            case 3: {
                this.mHardHammer = false;
                b = true;
                break;
            }
            case 4: {
                this.mSolderingTool = false;
                b = true;
                break;
            }
            case 5: {
                this.mCrowbar = false;
                b = true;
            }
        }
        return b;
    }

    public void fixAllMaintenanceIssue() {
        this.mCrowbar = true;
        this.mWrench = true;
        this.mHardHammer = true;
        this.mSoftHammer = true;
        this.mSolderingTool = true;
        this.mScrewdriver = true;
    }

    public boolean checkHatch() {
        return this.mMaintenanceHatches.size() <= 1 && (this.getPollutionPerSecond(null) <= 0 || !this.mMufflerHatches.isEmpty());
    }

    public <E> boolean addToMachineListInternal(ArrayList<E> aList, IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addToMachineListInternal(aList, this.getMetaTileEntity(aTileEntity), aBaseCasingIndex);
    }

    public <E> boolean addToMachineListInternal(ArrayList<E> aList, IMetaTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        try {
            if (aTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
                this.resetRecipeMapForHatch((GT_MetaTileEntity_Hatch)aTileEntity, this.getRecipeMap());
            }
            if (aTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
                this.resetRecipeMapForHatch((GT_MetaTileEntity_Hatch)aTileEntity, this.getRecipeMap());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        if (aList.isEmpty()) {
            if (aTileEntity instanceof GT_MetaTileEntity_Hatch) {
                if (GTplusplus.CURRENT_LOAD_PHASE == GTplusplus.INIT_PHASE.STARTED) {
                    this.log("Adding " + aTileEntity.func_145825_b() + " at " + new BlockPos(aTileEntity.getBaseMetaTileEntity()).getLocationString());
                }
                this.updateTexture(aTileEntity, aBaseCasingIndex);
                return aList.add(aTileEntity);
            }
        } else {
            IGregTechTileEntity aCur = aTileEntity.getBaseMetaTileEntity();
            if (aList.contains(aTileEntity)) {
                this.log("Found Duplicate " + aTileEntity.func_145825_b() + " @ " + new BlockPos(aCur).getLocationString());
                return false;
            }
            BlockPos aCurPos = new BlockPos(aCur);
            boolean aExists = false;
            for (IMetaTileEntity iMetaTileEntity : aList) {
                BlockPos aPos;
                IGregTechTileEntity b = iMetaTileEntity.getBaseMetaTileEntity();
                if (b == null || (aPos = new BlockPos(b)) == null || !aCurPos.equals(aPos)) continue;
                if (GTplusplus.CURRENT_LOAD_PHASE == GTplusplus.INIT_PHASE.STARTED) {
                    this.log("Found Duplicate " + b.func_145825_b() + " at " + aPos.getLocationString());
                }
                return false;
            }
            if (aTileEntity instanceof GT_MetaTileEntity_Hatch) {
                if (GTplusplus.CURRENT_LOAD_PHASE == GTplusplus.INIT_PHASE.STARTED) {
                    this.log("Adding " + aCur.func_145825_b() + " at " + aCurPos.getLocationString());
                }
                this.updateTexture(aTileEntity, aBaseCasingIndex);
                return aList.add(aTileEntity);
            }
        }
        return false;
    }

    public int getControlCoreTier() {
        ItemStack x;
        if (this.mControlCoreBus.isEmpty()) {
            this.log("No Control Core Modules Found.");
            return 0;
        }
        GT_MetaTileEntity_Hatch_ControlCore i = this.getControlCoreBus();
        if (i != null && (x = i.mInventory[0]) != null) {
            return x.func_77960_j();
        }
        this.log("Control Core Module was null.");
        return 0;
    }

    public GT_MetaTileEntity_Hatch_ControlCore getControlCoreBus() {
        if (this.mControlCoreBus == null || this.mControlCoreBus.isEmpty()) {
            return null;
        }
        GT_MetaTileEntity_Hatch_ControlCore x = this.mControlCoreBus.get(0);
        if (x != null) {
            this.log("getControlCore(ok)");
            return x;
        }
        this.log("getControlCore(bad)");
        return null;
    }

    public boolean addControlCoreToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (!this.mControlCoreBus.isEmpty()) {
            this.log("Tried to add a secondary control core module.");
            return false;
        }
        GT_MetaTileEntity_Hatch_ControlCore Module2 = (GT_MetaTileEntity_Hatch_ControlCore)this.getMetaTileEntity(aTileEntity);
        if (Module2 != null && Module2.setOwner(aTileEntity)) {
            this.log("Adding control core module.");
            return this.addToMachineListInternal(this.mControlCoreBus, (IMetaTileEntity)Module2, aBaseCasingIndex);
        }
        return false;
    }

    private IMetaTileEntity getMetaTileEntity(IGregTechTileEntity aTileEntity) {
        if (aTileEntity == null) {
            return null;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        return aMetaTileEntity;
    }

    public boolean addToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addToMachineList(this.getMetaTileEntity(aTileEntity), aBaseCasingIndex);
    }

    public boolean addToMachineList(IMetaTileEntity aMetaTileEntity, int aBaseCasingIndex) {
        if (aMetaTileEntity == null) {
            return false;
        }
        boolean aDidAdd = false;
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_ControlCore) {
            this.log("Found GT_MetaTileEntity_Hatch_ControlCore");
            if (!this.mControlCoreBus.isEmpty()) {
                this.log("Tried to add a secondary control core module.");
                return false;
            }
            aDidAdd = this.addToMachineListInternal(this.mControlCoreBus, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBattery) {
            this.log("Found GT_MetaTileEntity_Hatch_InputBattery");
            aDidAdd = this.addToMachineListInternal(this.mChargeHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBattery) {
            this.log("Found GT_MetaTileEntity_Hatch_OutputBattery");
            aDidAdd = this.addToMachineListInternal(this.mDischargeHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_AirIntake) {
            aDidAdd = this.addToMachineListInternal(this.mAirIntakes, aMetaTileEntity, aBaseCasingIndex);
        } else if (LoadedMods.TecTech && this.isThisHatchMultiEnergy(aMetaTileEntity)) {
            this.log("Found isThisHatchMultiEnergy");
            aDidAdd = this.addToMachineListInternal(this.mTecTechEnergyHatches, aMetaTileEntity, aBaseCasingIndex);
            this.updateMasterEnergyHatchList(aMetaTileEntity);
        } else if (LoadedMods.TecTech && this.isThisHatchMultiDynamo(aMetaTileEntity)) {
            this.log("Found isThisHatchMultiDynamo");
            aDidAdd = this.addToMachineListInternal(this.mTecTechDynamoHatches, aMetaTileEntity, aBaseCasingIndex);
            this.updateMasterDynamoHatchList(aMetaTileEntity);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            aDidAdd = this.addToMachineListInternal(this.mInputHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output) {
            aDidAdd = this.addToMachineListInternal(this.mOutputHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            aDidAdd = this.addToMachineListInternal(this.mInputBusses, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            aDidAdd = this.addToMachineListInternal(this.mOutputBusses, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy) {
            aDidAdd = this.addToMachineListInternal(this.mEnergyHatches, aMetaTileEntity, aBaseCasingIndex);
            this.updateMasterEnergyHatchList(aMetaTileEntity);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo) {
            aDidAdd = this.addToMachineListInternal(this.mDynamoHatches, aMetaTileEntity, aBaseCasingIndex);
            this.updateMasterDynamoHatchList(aMetaTileEntity);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            aDidAdd = this.addToMachineListInternal(this.mMaintenanceHatches, aMetaTileEntity, aBaseCasingIndex);
        } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            aDidAdd = this.addToMachineListInternal(this.mMufflerHatches, aMetaTileEntity, aBaseCasingIndex);
        }
        return aDidAdd;
    }

    public boolean addMaintenanceToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Maintenance) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean addMufflerToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Muffler) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean addInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input || aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean addOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Output || aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_OutputBus) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean addAirIntakeToMachineList(IGregTechTileEntity aMetaTileEntity, int aBaseCasingIndex) {
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_AirIntake) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean addFluidInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        return this.addFluidInputToMachineList(this.getMetaTileEntity(aTileEntity), aBaseCasingIndex);
    }

    public boolean addFluidInputToMachineList(IMetaTileEntity aMetaTileEntity, int aBaseCasingIndex) {
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean clearRecipeMapForAllInputHatches() {
        return this.resetRecipeMapForAllInputHatches(null);
    }

    public boolean resetRecipeMapForAllInputHatches() {
        return this.resetRecipeMapForAllInputHatches(this.getRecipeMap());
    }

    public boolean resetRecipeMapForAllInputHatches(GT_Recipe.GT_Recipe_Map aMap) {
        int cleared = 0;
        for (GT_MetaTileEntity_Hatch_Input g : this.mInputHatches) {
            if (!this.resetRecipeMapForHatch((GT_MetaTileEntity_Hatch)g, aMap)) continue;
            ++cleared;
        }
        for (GT_MetaTileEntity_Hatch_Input g : this.mInputBusses) {
            if (!this.resetRecipeMapForHatch((GT_MetaTileEntity_Hatch)g, aMap)) continue;
            ++cleared;
        }
        return cleared > 0;
    }

    public boolean resetRecipeMapForHatch(IGregTechTileEntity aTileEntity, GT_Recipe.GT_Recipe_Map aMap) {
        try {
            IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
            if (aMetaTileEntity == null) {
                return false;
            }
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input || aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus || aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Steam_BusInput) {
                return this.resetRecipeMapForHatch((GT_MetaTileEntity_Hatch)aMetaTileEntity, aMap);
            }
            return false;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }

    public boolean resetRecipeMapForHatch(GT_MetaTileEntity_Hatch aTileEntity, GT_Recipe.GT_Recipe_Map aMap) {
        if (aTileEntity == null) {
            return false;
        }
        GT_MetaTileEntity_Hatch aMetaTileEntity = aTileEntity;
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input || aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus || aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Steam_BusInput) {
            if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Input) {
                ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = null;
                ((GT_MetaTileEntity_Hatch_Input)aMetaTileEntity).mRecipeMap = aMap;
                if (aMap != null && aMap.mNEIName != null) {
                    this.log("Remapped Input Hatch to " + aMap.mNEIName + ".");
                } else {
                    this.log("Cleared Input Hatch.");
                }
            } else if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_InputBus) {
                ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mRecipeMap = null;
                ((GT_MetaTileEntity_Hatch_InputBus)aMetaTileEntity).mRecipeMap = aMap;
                if (aMap != null && aMap.mNEIName != null) {
                    this.log("Remapped Input Bus to " + aMap.mNEIName + ".");
                } else {
                    this.log("Cleared Input Bus.");
                }
            } else {
                ((GT_MetaTileEntity_Hatch_Steam_BusInput)aMetaTileEntity).mRecipeMap = null;
                ((GT_MetaTileEntity_Hatch_Steam_BusInput)aMetaTileEntity).mRecipeMap = aMap;
                if (aMap != null && aMap.mNEIName != null) {
                    this.log("Remapped Input Bus to " + aMap.mNEIName + ".");
                } else {
                    this.log("Cleared Input Bus.");
                }
            }
            return true;
        }
        return false;
    }

    public final void onScrewdriverRightClick(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(aSide, aPlayer, aX, aY, aZ);
        this.clearRecipeMapForAllInputHatches();
        this.onModeChangeByScrewdriver(aSide, aPlayer, aX, aY, aZ);
        this.resetRecipeMapForAllInputHatches();
    }

    public void onModeChangeByScrewdriver(byte aSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
    }

    public boolean updateTexture(IGregTechTileEntity aTileEntity, int aCasingID) {
        return this.updateTexture(this.getMetaTileEntity(aTileEntity), aCasingID);
    }

    public boolean updateTexture(IMetaTileEntity aTileEntity, int aCasingID) {
        try {
            IMetaTileEntity aMetaTileEntity = aTileEntity;
            if (aMetaTileEntity == null) {
                return false;
            }
            Method mProper = ReflectionUtils.getMethod(GT_MetaTileEntity_Hatch.class, "updateTexture", Integer.TYPE);
            if (mProper != null) {
                if (GT_MetaTileEntity_Hatch.class.isInstance(aMetaTileEntity)) {
                    mProper.setAccessible(true);
                    mProper.invoke((Object)aMetaTileEntity, aCasingID);
                    return true;
                }
            } else {
                this.log("Bad Method Call for updateTexture.");
                if (GT_MetaTileEntity_Hatch.class.isInstance(aMetaTileEntity)) {
                    if (aCasingID <= 127) {
                        ((GT_MetaTileEntity_Hatch)aTileEntity).mMachineBlock = (byte)aCasingID;
                        this.log("Good Method Call for updateTexture. Used fallback method of setting mMachineBlock as casing id was <= 128.");
                        return true;
                    }
                    this.log("updateTexture returning false. 1.2");
                } else {
                    this.log("updateTexture returning false. 1.3");
                }
            }
            this.log("updateTexture returning false. 1");
            return false;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            this.log("updateTexture returning false.");
            this.log("updateTexture returning false. 2");
            e.printStackTrace();
            return false;
        }
    }

    public boolean addMultiAmpDynamoToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity == null) {
            return false;
        }
        if (this.isThisHatchMultiDynamo(aTileEntity)) {
            return this.addToMachineListInternal(this.mTecTechDynamoHatches, aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean isThisHatchMultiDynamo(IGregTechTileEntity aTileEntity) {
        return this.isThisHatchMultiDynamo(this.getMetaTileEntity(aTileEntity));
    }

    public boolean isThisHatchMultiDynamo(IMetaTileEntity aMetaTileEntity) {
        Class<?> mDynamoClass = ReflectionUtils.getClass("com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_DynamoMulti");
        return mDynamoClass != null && mDynamoClass.isInstance(aMetaTileEntity);
    }

    public boolean addDynamoToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Dynamo || this.isThisHatchMultiDynamo(aMetaTileEntity)) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    private boolean updateMasterDynamoHatchList(IMetaTileEntity aMetaTileEntity) {
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch) {
            GT_MetaTileEntity_Hatch aHatch = (GT_MetaTileEntity_Hatch)aMetaTileEntity;
            return this.mAllDynamoHatches.add(aHatch);
        }
        return false;
    }

    public boolean addMultiAmpEnergyToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity == null) {
            return false;
        }
        if (this.isThisHatchMultiEnergy(aMetaTileEntity)) {
            return this.addToMachineListInternal(this.mTecTechEnergyHatches, aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    public boolean isThisHatchMultiEnergy(IGregTechTileEntity aTileEntity) {
        return this.isThisHatchMultiEnergy(this.getMetaTileEntity(aTileEntity));
    }

    public boolean isThisHatchMultiEnergy(IMetaTileEntity aMetaTileEntity) {
        Class<?> mDynamoClass = ReflectionUtils.getClass("com.github.technus.tectech.thing.metaTileEntity.hatch.GT_MetaTileEntity_Hatch_EnergyMulti");
        return mDynamoClass != null && mDynamoClass.isInstance(aMetaTileEntity);
    }

    public boolean addEnergyInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        IMetaTileEntity aMetaTileEntity = this.getMetaTileEntity(aTileEntity);
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch_Energy || this.isThisHatchMultiEnergy(aMetaTileEntity)) {
            return this.addToMachineList(aMetaTileEntity, aBaseCasingIndex);
        }
        return false;
    }

    private boolean updateMasterEnergyHatchList(IMetaTileEntity aMetaTileEntity) {
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof GT_MetaTileEntity_Hatch) {
            GT_MetaTileEntity_Hatch aHatch = (GT_MetaTileEntity_Hatch)aMetaTileEntity;
            return this.mAllEnergyHatches.add(aHatch);
        }
        return false;
    }

    public int calculatePollutionReductionForHatch(GT_MetaTileEntity_Hatch_Muffler i, int g) {
        if (calculatePollutionReduction != null) {
            try {
                return (Integer)calculatePollutionReduction.invoke((Object)i, g);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74772_a("mTotalRunTime", this.mTotalRunTime);
        aNBT.func_74757_a("mVoidExcess", this.mVoidExcess);
        super.saveNBTData(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        this.mTotalRunTime = aNBT.func_74763_f("mTotalRunTime");
        this.mVoidExcess = aNBT.func_74767_n("mVoidExcess");
        super.loadNBTData(aNBT);
    }

    public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack ... aInputs) {
        return this.findRecipe(aTileEntity, (GT_Recipe)null, aNotUnificated, aDontCheckStackSizes, aVoltage, aFluids, (ItemStack)null, aInputs);
    }

    public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack ... aInputs) {
        return this.findRecipe(aTileEntity, (GT_Recipe)null, aNotUnificated, aVoltage, aFluids, (ItemStack)null, aInputs);
    }

    public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack ... aInputs) {
        return this.findRecipe(aTileEntity, aRecipe, aNotUnificated, aDontCheckStackSizes, aVoltage, aFluids, (ItemStack)null, aInputs);
    }

    public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack ... aInputs) {
        return this.findRecipe(aTileEntity, aRecipe, aNotUnificated, aVoltage, aFluids, (ItemStack)null, aInputs);
    }

    public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
        return this.findRecipe(aTileEntity, aRecipe, aNotUnificated, true, aVoltage, aFluids, aSpecialSlot, aInputs);
    }

    public GT_Recipe findRecipe(IHasWorldObjectAndCoords aTileEntity, GT_Recipe aRecipe, boolean aNotUnificated, boolean aDontCheckStackSizes, long aVoltage, FluidStack[] aFluids, ItemStack aSpecialSlot, ItemStack ... aInputs) {
        if (this.getRecipeMap().mRecipeList.isEmpty()) {
            this.log("No Recipes in Map to search through.");
            return null;
        }
        GT_Recipe mRecipeResult = null;
        try {
            Collection tRecipes;
            int n;
            if (GregTech_API.sPostloadFinished) {
                int n2;
                FluidStack[] fluidStackArray;
                int tAmount;
                if (this.getRecipeMap().mMinimalInputFluids > 0) {
                    if (aFluids == null) {
                        this.log("aFluids == null && minFluids > 0");
                        return null;
                    }
                    tAmount = 0;
                    fluidStackArray = aFluids;
                    n = fluidStackArray.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        FluidStack aFluid = fluidStackArray[n2];
                        if (aFluid == null) continue;
                        ++tAmount;
                    }
                    if (tAmount < this.getRecipeMap().mMinimalInputFluids) {
                        this.log("Not enough fluids?");
                        return null;
                    }
                }
                if (this.getRecipeMap().mMinimalInputItems > 0) {
                    if (aInputs == null) {
                        this.log("No inputs and minItems > 0");
                        return null;
                    }
                    tAmount = 0;
                    fluidStackArray = aInputs;
                    n = fluidStackArray.length;
                    for (n2 = 0; n2 < n; ++n2) {
                        FluidStack aInput = fluidStackArray[n2];
                        if (aInput == null) continue;
                        ++tAmount;
                    }
                    if (tAmount < this.getRecipeMap().mMinimalInputItems) {
                        this.log("Not enough items?");
                        return null;
                    }
                }
            } else {
                this.log("Game Not Loaded properly for recipe lookup.");
            }
            if (aNotUnificated) {
                aInputs = GT_OreDictUnificator.getStackArray((boolean)true, (Object[])aInputs);
            }
            if (aRecipe != null && !aRecipe.mFakeRecipe && aRecipe.mCanBeBuffered && aRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs)) {
                mRecipeResult = aRecipe.mEnabled ? aRecipe : null;
                this.log("x) Found Recipe? " + (mRecipeResult != null ? "true" : "false"));
                if (mRecipeResult != null) {
                    return mRecipeResult;
                }
            }
            if (mRecipeResult == null && this.getRecipeMap().mUsualInputCount >= 0 && aInputs != null && aInputs.length > 0) {
                ItemStack[] tAmount = aInputs;
                int n3 = tAmount.length;
                for (n = 0; n < n3; ++n) {
                    ItemStack tStack = tAmount[n];
                    if (tStack == null) continue;
                    tRecipes = (Collection)this.getRecipeMap().mRecipeItemMap.get(new GT_ItemStack(tStack));
                    if (tRecipes != null) {
                        for (GT_Recipe tRecipe : tRecipes) {
                            if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs)) continue;
                            mRecipeResult = tRecipe.mEnabled ? tRecipe : null;
                            this.log("1) Found Recipe? " + (mRecipeResult != null ? "true" : "false"));
                        }
                    }
                    if ((tRecipes = (Collection)this.getRecipeMap().mRecipeItemMap.get(new GT_ItemStack(GT_Utility.copyMetaData((long)32767L, (Object[])new Object[]{tStack})))) == null) continue;
                    for (GT_Recipe tRecipe : tRecipes) {
                        if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs)) continue;
                        mRecipeResult = tRecipe.mEnabled ? tRecipe : null;
                        this.log("2) Found Recipe? " + (mRecipeResult != null ? "true" : "false"));
                    }
                }
            }
            if (mRecipeResult == null && this.getRecipeMap().mMinimalInputItems == 0 && aFluids != null && aFluids.length > 0) {
                for (FluidStack aFluid2 : aFluids) {
                    if (aFluid2 == null || (tRecipes = (Collection)this.getRecipeMap().mRecipeFluidMap.get(aFluid2.getFluid())) == null) continue;
                    for (GT_Recipe tRecipe : tRecipes) {
                        if (tRecipe.mFakeRecipe || !tRecipe.isRecipeInputEqual(false, aDontCheckStackSizes, aFluids, aInputs)) continue;
                        mRecipeResult = tRecipe.mEnabled ? tRecipe : null;
                        this.log("3) Found Recipe? " + (mRecipeResult != null ? "true" : "false"));
                    }
                }
            }
        }
        catch (Throwable t) {
            this.log("Invalid recipe lookup.");
        }
        if (mRecipeResult == null) {
            this.log("Invalid recipe, Fallback lookup. " + this.getRecipeMap().mRecipeList.size() + " | " + this.getRecipeMap().mNEIName);
            if (!CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK) {
                try {
                    return (GT_Recipe)findRecipe08.invoke((Object)this.getRecipeMap(), aTileEntity, aRecipe, aNotUnificated, aVoltage, aFluids, aSpecialSlot, aInputs);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            try {
                return (GT_Recipe)findRecipe09.invoke((Object)this.getRecipeMap(), aTileEntity, aRecipe, aNotUnificated, aDontCheckStackSizes, aVoltage, aFluids, aSpecialSlot, aInputs);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        return mRecipeResult;
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        ItemStack tCurrentItem;
        if (this.getBaseMetaTileEntity().isServerSide() && (tCurrentItem = aPlayer.field_71071_by.func_70448_g()) != null && tCurrentItem.func_77973_b() instanceof GT_MetaGenerated_Tool) {
            int[] aOreID;
            for (int id : aOreID = OreDictionary.getOreIDs((ItemStack)tCurrentItem)) {
                if (!OreDictionary.getOreName((int)id).equals("craftingToolPlunger")) continue;
                return this.onPlungerRightClick(aPlayer, aSide, aX, aY, aZ);
            }
        }
        boolean aSuper = super.onRightclick(aBaseMetaTileEntity, aPlayer, aSide, aX, aY, aZ);
        return aSuper;
    }

    public boolean onPlungerRightClick(EntityPlayer aPlayer, byte aSide, float aX, float aY, float aZ) {
        int aHatchIndex = 0;
        PlayerUtils.messagePlayer(aPlayer, "Trying to clear " + this.mOutputHatches.size() + " output hatches.");
        for (GT_MetaTileEntity_Hatch_Output hatch : this.mOutputHatches) {
            if (hatch.mFluid != null) {
                PlayerUtils.messagePlayer(aPlayer, "Clearing " + hatch.mFluid.amount + "L of " + hatch.mFluid.getLocalizedName() + " from hatch " + aHatchIndex + ".");
                hatch.mFluid = null;
            }
            ++aHatchIndex;
        }
        return aHatchIndex > 0;
    }

    public boolean onSolderingToolRightClick(byte aSide, byte aWrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        boolean tSuper = super.onSolderingToolRightClick(aSide, aWrenchingSide, aPlayer, aX, aY, aZ);
        if (aPlayer.func_70093_af()) {
            return tSuper;
        }
        this.mVoidExcess = !this.mVoidExcess;
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation(this.mVoidExcess ? "interaction.voidexcess.enabled" : "interaction.voidexcess.disabled", new Object[0]));
        return true;
    }

    public boolean isValidBlockForStructure(IGregTechTileEntity aBaseMetaTileEntity, int aCasingID, boolean canBeHatch, Block aFoundBlock, int aFoundMeta, Block aExpectedBlock, int aExpectedMeta) {
        boolean isHatch = false;
        if (aBaseMetaTileEntity != null) {
            isHatch = this.addToMachineList(aBaseMetaTileEntity, aCasingID);
            if (isHatch) {
                return true;
            }
            int aMetaTileID = aBaseMetaTileEntity.getMetaTileID();
            if (aMetaTileID >= 750 && aMetaTileID < 1000 && aFoundBlock == GregTech_API.sBlockMachines) {
                return true;
            }
            if (aMetaTileID >= 10 && aMetaTileID <= 99 && aFoundBlock == GregTech_API.sBlockMachines) {
                return true;
            }
            if (aMetaTileID >= 30001 && aMetaTileID <= 30009 && aFoundBlock == GregTech_API.sBlockMachines) {
                return true;
            }
            if (aMetaTileID >= 30020 && aMetaTileID <= 30040 && aFoundBlock == GregTech_API.sBlockMachines) {
                return true;
            }
            if (aMetaTileID == 111 && aFoundBlock == GregTech_API.sBlockMachines) {
                return true;
            }
            if ((aMetaTileID == 131 || aMetaTileID == 132) && aFoundBlock == GregTech_API.sBlockMachines) {
                return true;
            }
            this.log("Found meta Tile: " + aMetaTileID);
        }
        if (!isHatch) {
            if (aFoundBlock == aExpectedBlock && aFoundMeta == aExpectedMeta) {
                return true;
            }
            if (aFoundBlock != aExpectedBlock) {
                if (GTplusplus.CURRENT_LOAD_PHASE == GTplusplus.INIT_PHASE.STARTED) {
                    this.log("A1 - Found: " + aFoundBlock.func_149732_F() + ":" + aFoundMeta + ", Expected: " + aExpectedBlock.func_149732_F() + ":" + aExpectedMeta);
                }
                return false;
            }
            if (aFoundMeta != aExpectedMeta) {
                this.log("A2");
                return false;
            }
        }
        this.log("A3");
        return false;
    }

    public boolean depleteInput(FluidStack aLiquid) {
        if (aLiquid == null) {
            return false;
        }
        for (GT_MetaTileEntity_Hatch_Input tHatch : this.mInputHatches) {
            FluidStack tLiquid;
            tHatch.mRecipeMap = this.getRecipeMap();
            if (!GregtechMeta_MultiBlockBase.isValidMetaTileEntity((MetaTileEntity)tHatch) || (tLiquid = tHatch.getFluid()) == null || !tLiquid.isFluidEqual(aLiquid) || tLiquid.amount < aLiquid.amount || (tLiquid = tHatch.drain(aLiquid.amount, false)) == null || tLiquid.amount < aLiquid.amount) continue;
            tLiquid = tHatch.drain(aLiquid.amount, true);
            return tLiquid != null && tLiquid.amount >= aLiquid.amount;
        }
        return false;
    }

    public void onServerStart() {
        super.onServerStart();
        this.tryTickWaitTimerDown();
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.tryTickWaitTimerDown();
    }

    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        this.tryTickWaitTimerDown();
    }

    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        super.onCreated(aStack, aWorld, aPlayer);
        this.tryTickWaitTimerDown();
    }

    private final void tryTickWaitTimerDown() {
    }

    public static <T> IStructureElement<T> addTieredBlock(Block aBlock, BiConsumer<T, Integer> aSetTheFuckingMeta, Function<T, Integer> aGetTheFuckingMeta, int maxMeta) {
        return GregtechMeta_MultiBlockBase.addTieredBlock(aBlock, (T t, Integer i) -> {
            aSetTheFuckingMeta.accept((Object)t, (Integer)i);
            return true;
        }, aGetTheFuckingMeta, 0, maxMeta);
    }

    public static <T> IStructureElement<T> addTieredBlock(Block aBlock, BiConsumer<T, Integer> aSetTheFuckingMeta, Function<T, Integer> aGetTheFuckingMeta, int minMeta, int maxMeta) {
        return GregtechMeta_MultiBlockBase.addTieredBlock(aBlock, (T t, Integer i) -> {
            aSetTheFuckingMeta.accept((Object)t, (Integer)i);
            return true;
        }, aGetTheFuckingMeta, minMeta, maxMeta);
    }

    public static <T> IStructureElement<T> addTieredBlock(final Block aBlock, final BiPredicate<T, Integer> aSetTheFuckingMeta, final Function<T, Integer> aGetTheFuckingMeta, final int minMeta, final int maxMeta) {
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                Block tBlock = world.func_147439_a(x, y, z);
                if (aBlock == tBlock) {
                    Integer currentMeta = (Integer)aGetTheFuckingMeta.apply(t);
                    int newMeta = tBlock.func_149643_k(world, x, y, z) + 1;
                    if (newMeta > maxMeta || newMeta < minMeta + 1) {
                        return false;
                    }
                    if (currentMeta == 0) {
                        return aSetTheFuckingMeta.test(t, newMeta);
                    }
                    return currentMeta == newMeta;
                }
                return false;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)aBlock, (int)this.getMeta(trigger));
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return world.func_147465_d(x, y, z, aBlock, this.getMeta(trigger), 3);
            }

            private int getMeta(ItemStack trigger) {
                int meta = trigger.field_77994_a;
                if (meta <= 0) {
                    meta = minMeta;
                }
                if (meta + minMeta >= maxMeta) {
                    meta = maxMeta - 1 - minMeta;
                }
                return meta + minMeta;
            }
        };
    }

    static {
        Method a08 = findRecipe08 = ReflectionUtils.getMethod(GT_Recipe.GT_Recipe_Map.class, "findRecipe", IHasWorldObjectAndCoords.class, GT_Recipe.class, Boolean.TYPE, Long.TYPE, FluidStack[].class, ItemStack.class, ItemStack[].class);
        Method a09 = findRecipe09 = ReflectionUtils.getMethod(GT_Recipe.GT_Recipe_Map.class, "findRecipe", IHasWorldObjectAndCoords.class, GT_Recipe.class, Boolean.TYPE, Boolean.TYPE, Long.TYPE, FluidStack[].class, ItemStack.class, ItemStack[].class);
        Logger.MACHINE_INFO("Found .08 findRecipe method? " + (a08 != null), new Object[0]);
        Logger.MACHINE_INFO("Found .09 findRecipe method? " + (a09 != null), new Object[0]);
        try {
            calculatePollutionReduction = GT_MetaTileEntity_Hatch_Muffler.class.getDeclaredMethod("calculatePollutionReduction", Integer.TYPE);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        mCustomBehviours = new HashMap();
        aLogger = null;
        calculatePollutionReduction = null;
    }
}

