/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.ITexture;
import gregtech.api.metatileentity.MetaTileEntity;

public abstract class GregtechMetaTileEntity
extends MetaTileEntity {
    protected byte mTier;
    protected final String mDescription;
    public final ITexture[][][] mTextures;

    public GregtechMetaTileEntity(int aID, String aName, String aNameRegional, int aTier, int aInvSlotCount, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aInvSlotCount);
        this.mTier = (byte)Math.max(0, Math.min(aTier, 9));
        this.mDescription = aDescription;
        this.mTextures = GT_Values.GT.isClientSide() ? this.getTextureSet(aTextures) : (ITexture[][][])null;
    }

    public GregtechMetaTileEntity(String aName, int aTier, int aInvSlotCount, String aDescription, ITexture[][][] aTextures) {
        super(aName, aInvSlotCount);
        this.mTier = (byte)aTier;
        this.mDescription = aDescription;
        this.mTextures = aTextures;
    }

    public byte getTileEntityBaseType() {
        return (byte)Math.min(3, this.mTier <= 0 ? 0 : 1 + (this.mTier - 1) / 4);
    }

    public long getInputTier() {
        return this.mTier;
    }

    public long getOutputTier() {
        return this.mTier;
    }

    public String[] getDescription() {
        return new String[]{this.mDescription};
    }

    public abstract ITexture[][][] getTextureSet(ITexture[] var1);
}

