/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Input;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Hatch_CustomFluidBase
extends GT_MetaTileEntity_Hatch_Input {
    public final Fluid mLockedFluid;
    public final int mFluidCapacity;
    protected FluidStack mLockedStack = null;
    protected Integer mLockedTemp = null;
    protected String mTempMod = null;

    public GT_MetaTileEntity_Hatch_CustomFluidBase(Fluid aFluid, int aAmount, int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 6);
        this.mRecipeMap = null;
        this.mLockedFluid = aFluid;
        this.mFluidCapacity = aAmount;
    }

    public GT_MetaTileEntity_Hatch_CustomFluidBase(Fluid aFluid, int aAmount, String aName, String aDescription, ITexture[][][] aTextures) {
        super(aName, 6, aDescription, aTextures);
        this.mRecipeMap = null;
        this.mLockedFluid = aFluid;
        this.mFluidCapacity = aAmount;
    }

    public GT_MetaTileEntity_Hatch_CustomFluidBase(Fluid aFluid, int aAmount, String aName, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, 6, aDescription[0], aTextures);
        this.mRecipeMap = null;
        this.mLockedFluid = aFluid;
        this.mFluidCapacity = aAmount;
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        if (aSide == aBaseMetaTileEntity.getFrontFacing() && aIndex == 0) {
            if (this.mRecipeMap == null) {
                return true;
            }
            FluidStack fs = GT_Utility.getFluidForFilledItem((ItemStack)aStack, (boolean)true);
            if (fs != null && fs.getFluid() == this.mLockedFluid) {
                return true;
            }
        }
        return false;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PUMP)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)Textures.BlockIcons.OVERLAY_PUMP)};
    }

    public int getCapacity() {
        return this.mFluidCapacity;
    }

    public String[] getDescription() {
        if (this.mLockedStack == null) {
            this.mLockedStack = FluidUtils.getFluidStack(this.mLockedFluid, 1);
        }
        int aFluidTemp = 0;
        boolean isSteam = false;
        if (this.mLockedFluid != null) {
            aFluidTemp = this.mLockedFluid.getTemperature();
            this.mTempMod = this.mLockedFluid.getName();
        }
        if (this.mTempMod.toLowerCase().equals("steam")) {
            isSteam = true;
        }
        EnumChatFormatting aColour = EnumChatFormatting.BLUE;
        if (aFluidTemp <= -3000) {
            aColour = EnumChatFormatting.DARK_PURPLE;
        } else if (aFluidTemp >= -2999 && aFluidTemp <= -500) {
            aColour = EnumChatFormatting.DARK_BLUE;
        } else if (aFluidTemp >= -499 && aFluidTemp <= -50) {
            aColour = EnumChatFormatting.BLUE;
        } else if (aFluidTemp >= 30 && aFluidTemp <= 300) {
            aColour = EnumChatFormatting.AQUA;
        } else if (aFluidTemp >= 301 && aFluidTemp <= 800) {
            aColour = EnumChatFormatting.YELLOW;
        } else if (aFluidTemp >= 801 && aFluidTemp <= 1500) {
            aColour = EnumChatFormatting.GOLD;
        } else if (aFluidTemp >= 1501) {
            aColour = EnumChatFormatting.RED;
        }
        String aFluidName = "Accepted Fluid: " + aColour + (this.mLockedStack != null ? this.mLockedStack.getLocalizedName() : "Empty") + EnumChatFormatting.RESET;
        String[] s2 = new String[]{"Fluid Input for " + (isSteam ? "Steam " : "") + "Multiblocks", "Capacity: " + this.getCapacity() + "L", aFluidName, CORE.GT_Tooltip};
        return s2;
    }

    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.getFluid() == this.mLockedFluid;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_CustomFluidBase(this.mLockedFluid, this.mFluidCapacity, this.mName, this.mDescription, this.mTextures);
    }
}

