/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.objects.GT_RenderedTexture;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_FluidGenerator;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_MetaTileEntity_Hatch_Reservoir
extends GT_MetaTileEntity_Hatch_FluidGenerator {
    private static Block sBlock_EIO;
    private static Block sBlock_RIO;

    public GT_MetaTileEntity_Hatch_Reservoir(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier);
    }

    public GT_MetaTileEntity_Hatch_Reservoir(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Reservoir(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    @Override
    public String[] getCustomTooltip() {
        String[] aTooltip = new String[]{"Requires a Block of water facing the intake", "Infinite water supply hatch", "Creates 8000L of Water every 4 ticks"};
        return aTooltip;
    }

    @Override
    public Fluid getFluidToGenerate() {
        return FluidRegistry.WATER;
    }

    @Override
    public int getAmountOfFluidToGenerate() {
        return 8000;
    }

    @Override
    public int getMaxTickTime() {
        return 4;
    }

    @Override
    public int getCapacity() {
        return 256000;
    }

    private static void setCrossModData() {
        if (LoadedMods.EnderIO && sBlock_EIO == null) {
            sBlock_EIO = GameRegistry.findBlock((String)"EnderIO", (String)"blockReservoir");
        }
        if (LoadedMods.RemoteIO && sBlock_RIO == null) {
            sBlock_RIO = GameRegistry.findBlock((String)"RIO", (String)"machine");
        }
    }

    public static boolean isTileValid(TileEntity aTile) {
        if (aTile != null && aTile instanceof IFluidHandler) {
            IFluidHandler aFluidHandler = (IFluidHandler)aTile;
            return aFluidHandler.canDrain(ForgeDirection.UNKNOWN, FluidRegistry.WATER);
        }
        return false;
    }

    @Override
    public boolean doesHatchMeetConditionsToGenerate() {
        Block aWater = this.getBaseMetaTileEntity().getBlockAtSide(this.getBaseMetaTileEntity().getFrontFacing());
        if (aWater != null && aWater != Blocks.field_150350_a) {
            if (!this.canTankBeFilled()) {
                return false;
            }
            GT_MetaTileEntity_Hatch_Reservoir.setCrossModData();
            if (LoadedMods.EnderIO && aWater == sBlock_EIO) {
                return GT_MetaTileEntity_Hatch_Reservoir.isTileValid(this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getFrontFacing()));
            }
            if (LoadedMods.RemoteIO && aWater == sBlock_RIO && this.getBaseMetaTileEntity().getMetaIDAtSide(this.getBaseMetaTileEntity().getFrontFacing()) == 0) {
                return GT_MetaTileEntity_Hatch_Reservoir.isTileValid(this.getBaseMetaTileEntity().getTileEntityAtSide(this.getBaseMetaTileEntity().getFrontFacing()));
            }
            return aWater == Blocks.field_150355_j || aWater == Blocks.field_150358_i;
        }
        return false;
    }

    @Override
    public void generateParticles(World aWorld, String name) {
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Water)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Water)};
    }
}

