/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.implementations;

import gregtech.api.enums.GT_Values;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch;
import gregtech.api.objects.GT_RenderedTexture;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.xmod.gregtech.api.gui.hatches.charge.CONTAINER_Electric_2by2;
import gtPlusPlus.xmod.gregtech.api.gui.hatches.charge.CONTAINER_Electric_4by4;
import gtPlusPlus.xmod.gregtech.api.gui.hatches.charge.GUI_Electric_2by2;
import gtPlusPlus.xmod.gregtech.api.gui.hatches.charge.GUI_Electric_4by4;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class GT_MetaTileEntity_Hatch_InputBattery
extends GT_MetaTileEntity_Hatch {
    public final GT_Recipe.GT_Recipe_Map mRecipeMap = null;

    public GT_MetaTileEntity_Hatch_InputBattery(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, GT_MetaTileEntity_Hatch_InputBattery.getSlots((int)aTier), "Chargeable Item Bus for Multiblocks", new ITexture[0]);
    }

    public GT_MetaTileEntity_Hatch_InputBattery(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aTier < 1 ? 1 : (aTier == 1 ? 4 : (aTier == 2 ? 4 : 16)), aDescription, aTextures);
    }

    public String[] getDescription() {
        int mSlots = 0;
        mSlots = this.mTier == 2 ? 4 : (this.mTier == 4 ? 16 : 16);
        return new String[]{this.mDescription, "Capacity: " + mSlots + " slots", CORE.GT_Tooltip};
    }

    public boolean isEnetInput() {
        return true;
    }

    public boolean isInputFacing(byte aSide) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing();
    }

    public long getMinimumStoredEU() {
        return 0L;
    }

    public long maxEUInput() {
        return GT_Values.V[this.mTier];
    }

    public long maxEUStore() {
        return 512L + GT_Values.V[this.mTier + 1] * 16L;
    }

    public long maxAmperesIn() {
        return 4L;
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Hatch_Charger)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, new GT_RenderedTexture((IIconContainer)TexturesGtBlock.Overlay_Hatch_Charger)};
    }

    public boolean isSimpleMachine() {
        return true;
    }

    public boolean isFacingValid(byte aFacing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public boolean isValidSlot(int aIndex) {
        return true;
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_InputBattery(this.mName, this.mTier, this.mDescription, this.mTextures);
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (aBaseMetaTileEntity.isClientSide()) {
            return true;
        }
        aBaseMetaTileEntity.openGUI(aPlayer);
        return true;
    }

    public Object getServerGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        switch (this.mTier) {
            case 2: {
                return new CONTAINER_Electric_2by2(aPlayerInventory, aBaseMetaTileEntity);
            }
            case 4: {
                return new CONTAINER_Electric_4by4(aPlayerInventory, aBaseMetaTileEntity);
            }
        }
        return new CONTAINER_Electric_4by4(aPlayerInventory, aBaseMetaTileEntity);
    }

    public Object getClientGUI(int aID, InventoryPlayer aPlayerInventory, IGregTechTileEntity aBaseMetaTileEntity) {
        switch (this.mTier) {
            case 2: {
                return new GUI_Electric_2by2(aPlayerInventory, aBaseMetaTileEntity, "Charging Bus");
            }
            case 4: {
                return new GUI_Electric_4by4(aPlayerInventory, aBaseMetaTileEntity, "Charging Bus");
            }
        }
        return new GUI_Electric_4by4(aPlayerInventory, aBaseMetaTileEntity, "Charging Bus");
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        MetaTileEntity mMetaTileEntity;
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.hasInventoryBeenModified()) {
            this.fillStacksIntoFirstSlots();
        }
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.getMetaTileEntity() instanceof MetaTileEntity && (mMetaTileEntity = (MetaTileEntity)aBaseMetaTileEntity.getMetaTileEntity()).rechargerSlotCount() > 0 && aBaseMetaTileEntity.getStoredEU() > 0L) {
            int i;
            int k = mMetaTileEntity.rechargerSlotCount() + i;
            for (i = mMetaTileEntity.rechargerSlotStartIndex(); i < k; ++i) {
                if (aBaseMetaTileEntity.getStoredEU() <= 0L || mMetaTileEntity.mInventory[i] == null) continue;
                for (int u = 0; u < 10; ++u) {
                    aBaseMetaTileEntity.decreaseStoredEnergyUnits((long)GT_ModHandler.chargeElectricItem((ItemStack)mMetaTileEntity.mInventory[i], (int)((int)Math.min(GT_Values.V[this.mTier] * 15L, aBaseMetaTileEntity.getStoredEU())), (int)((int)Math.min(Integer.MAX_VALUE, GT_Values.V[u])), (boolean)false, (boolean)false), true);
                    if (mMetaTileEntity.mInventory[i].field_77994_a > 0) continue;
                    mMetaTileEntity.mInventory[i] = null;
                }
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTimer);
    }

    public void updateSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            if (this.mInventory[i] == null || this.mInventory[i].field_77994_a > 0) continue;
            this.mInventory[i] = null;
        }
        this.fillStacksIntoFirstSlots();
    }

    protected void fillStacksIntoFirstSlots() {
        for (int i = 0; i < this.mInventory.length; ++i) {
            for (int j = i + 1; j < this.mInventory.length; ++j) {
                if (this.mInventory[j] == null || this.mInventory[i] != null && !GT_Utility.areStacksEqual((ItemStack)this.mInventory[i], (ItemStack)this.mInventory[j])) continue;
                GT_Utility.moveStackFromSlotAToSlotB((IInventory)this.getBaseMetaTileEntity(), (IInventory)this.getBaseMetaTileEntity(), (int)j, (int)i, (byte)64, (byte)1, (byte)64, (byte)1);
            }
        }
    }

    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing() && (this.mRecipeMap == null || this.mRecipeMap.containsInput(aStack));
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, byte aSide, ItemStack aStack) {
        return aSide == this.getBaseMetaTileEntity().getFrontFacing() && (this.mRecipeMap == null || this.mRecipeMap.containsInput(aStack));
    }

    public int rechargerSlotStartIndex() {
        return 0;
    }

    public int rechargerSlotCount() {
        switch (this.mTier) {
            case 2: {
                return 4;
            }
            case 4: {
                return 16;
            }
        }
        return 16;
    }

    public int dechargerSlotStartIndex() {
        return 0;
    }

    public int dechargerSlotCount() {
        return 0;
    }
}

