/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.metatileentity.custom.power;

import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.xmod.gregtech.api.metatileentity.BaseCustomTileEntity;
import ic2.api.Direction;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class BaseCustomPower_MTE
extends BaseCustomTileEntity {
    public BaseCustomPower_MTE() {
        Logger.INFO("Created new BaseCustomPower_MTE");
    }

    @Override
    public boolean doesExplode() {
        return false;
    }

    public long injectEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        if (this.mMetaTileEntity == null) {
            Logger.INFO("Bad Tile");
        }
        if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.inputEnergyFrom(aSide) && aAmperage > 0L && aVoltage > 0L && this.getStoredEU() < this.getEUCapacity() && this.mMetaTileEntity.maxAmperesIn() >= this.getInputAmperage()) {
            Logger.INFO("Injecting Energy Units");
            return super.injectEnergyUnits(aSide, aVoltage, aAmperage);
        }
        Logger.INFO("canAccessData(): " + this.canAccessData());
        Logger.INFO("isElectric(): " + this.mMetaTileEntity.isElectric());
        Logger.INFO("InputEnergyFromSide(" + aSide + "): " + this.inputEnergyFrom(aSide));
        Logger.INFO("aAmperage: " + aAmperage);
        Logger.INFO("aVoltage: " + aVoltage);
        Logger.INFO("this.getStoredEU() < this.getEUCapacity(): " + (this.getStoredEU() < this.getEUCapacity()));
        Logger.INFO("this.mMetaTileEntity.maxAmperesIn() >= this.mAcceptedAmperes: " + (this.mMetaTileEntity.maxAmperesIn() >= this.getInputAmperage()));
        Logger.INFO("this.mMetaTileEntity.maxAmperesIn(): " + this.mMetaTileEntity.maxAmperesIn());
        Logger.INFO("this.mAcceptedAmperes: " + this.getInputAmperage());
        return 0L;
    }

    public boolean drainEnergyUnits(byte aSide, long aVoltage, long aAmperage) {
        Logger.INFO("Draining Energy Units 4");
        if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.outputsEnergyTo(aSide) && this.getStoredEU() - aVoltage * aAmperage >= this.mMetaTileEntity.getMinimumStoredEU()) {
            if (this.decreaseStoredEU(aVoltage * aAmperage, false)) {
                this.mAverageEUOutput[this.mAverageEUOutputIndex] = (int)(this.mAverageEUOutput[this.mAverageEUOutputIndex] + aVoltage * aAmperage);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLessEnergy) {
        Logger.INFO("Draining Energy Units 3");
        return super.decreaseStoredEnergyUnits(aEnergy, aIgnoreTooLessEnergy);
    }

    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        return super.increaseStoredEnergyUnits(aEnergy, aIgnoreTooMuchEnergy);
    }

    public boolean inputEnergyFrom(byte aSide) {
        return super.inputEnergyFrom(aSide);
    }

    public boolean outputsEnergyTo(byte aSide) {
        Logger.INFO("Draining Energy Units 2");
        return super.outputsEnergyTo(aSide);
    }

    public long getOutputAmperage() {
        return super.getOutputAmperage();
    }

    public long getOutputVoltage() {
        return super.getOutputVoltage();
    }

    public long getInputAmperage() {
        return super.getInputAmperage();
    }

    public long getInputVoltage() {
        return super.getInputVoltage();
    }

    public long getUniversalEnergyStored() {
        return super.getUniversalEnergyStored();
    }

    public long getUniversalEnergyCapacity() {
        return super.getUniversalEnergyCapacity();
    }

    public long getStoredEU() {
        return super.getStoredEU();
    }

    public long getEUCapacity() {
        return super.getEUCapacity();
    }

    public boolean setStoredEU(long aEnergy) {
        return super.setStoredEU(aEnergy);
    }

    public boolean decreaseStoredEU(long aEnergy, boolean aIgnoreTooLessEnergy) {
        Logger.INFO("Draining Energy Units 1");
        return super.decreaseStoredEU(aEnergy, aIgnoreTooLessEnergy);
    }

    public boolean decreaseStoredSteam(long aEnergy, boolean aIgnoreTooLessEnergy) {
        return super.decreaseStoredSteam(aEnergy, aIgnoreTooLessEnergy);
    }

    @Override
    public void doEnergyExplosion() {
        super.doEnergyExplosion();
    }

    @Override
    public void doExplosion(long aAmount) {
        super.doExplosion(aAmount);
    }

    public byte getLightValue() {
        return super.getLightValue();
    }

    public long getAverageElectricInput() {
        return super.getAverageElectricInput();
    }

    public long getAverageElectricOutput() {
        return super.getAverageElectricOutput();
    }

    public double getOutputEnergyUnitsPerTick() {
        return super.getOutputEnergyUnitsPerTick();
    }

    public double demandedEnergyUnits() {
        return super.demandedEnergyUnits();
    }

    public double injectEnergyUnits(ForgeDirection aDirection, double aAmount) {
        return super.injectEnergyUnits(aDirection, aAmount);
    }

    public boolean acceptsEnergyFrom(TileEntity aEmitter, ForgeDirection aDirection) {
        return super.acceptsEnergyFrom(aEmitter, aDirection);
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, ForgeDirection aDirection) {
        return super.emitsEnergyTo(aReceiver, aDirection);
    }

    public double getOfferedEnergy() {
        return super.getOfferedEnergy();
    }

    public void drawEnergy(double amount) {
        super.drawEnergy(amount);
    }

    public int injectEnergy(ForgeDirection aForgeDirection, int aAmount) {
        return super.injectEnergy(aForgeDirection, aAmount);
    }

    public int addEnergy(int aEnergy) {
        return super.addEnergy(aEnergy);
    }

    public boolean isAddedToEnergyNet() {
        return super.isAddedToEnergyNet();
    }

    public int demandsEnergy() {
        return super.demandsEnergy();
    }

    public int getMaxSafeInput() {
        return super.getMaxSafeInput();
    }

    public int getMaxEnergyOutput() {
        return super.getMaxEnergyOutput();
    }

    public int injectEnergy(Direction aDirection, int aAmount) {
        return super.injectEnergy(aDirection, aAmount);
    }

    public boolean acceptsEnergyFrom(TileEntity aReceiver, Direction aDirection) {
        return super.acceptsEnergyFrom(aReceiver, aDirection);
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, Direction aDirection) {
        return super.emitsEnergyTo(aReceiver, aDirection);
    }

    public boolean isUniversalEnergyStored(long aEnergyAmount) {
        return super.isUniversalEnergyStored(aEnergyAmount);
    }
}

