/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.api.gui;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.gui.GT_ContainerMetaTile_Machine;
import gregtech.api.gui.GT_GUIContainerMetaTile_Machine;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.api.gui.CONTAINER_MultiMachine;
import gtPlusPlus.xmod.gregtech.api.gui.CONTAINER_MultiMachine_NoPlayerInventory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;

public class GUI_MultiMachine
extends GT_GUIContainerMetaTile_Machine {
    private static final Materials GOOD;
    private static final Materials BAD;
    private final String mName;
    private static final ConcurrentHashMap<String, ItemStack> mToolStacks;
    private static final Method mDrawItemStack;

    public GUI_MultiMachine(InventoryPlayer aInventoryPlayer, IGregTechTileEntity aTileEntity, String aName, String aTextureFile) {
        super((GT_ContainerMetaTile_Machine)new CONTAINER_MultiMachine_NoPlayerInventory(aInventoryPlayer, aTileEntity), "miscutils:textures/gui/" + (aTextureFile == null ? "MultiblockDisplay" : aTextureFile));
        this.mName = aName != null ? aName : "";
    }

    protected void func_146979_b(int par1, int par2) {
        if (this.mContainer != null) {
            this.drawGuiInfoTextLayer(par1, par2);
            this.drawGuiRepairStatusLayer(par1, par2);
        }
    }

    protected void drawGuiInfoTextLayer(float par1, int par2) {
        if ((((CONTAINER_MultiMachine)this.mContainer).mDisplayErrorCode & 0x40) != 0) {
            this.field_146289_q.func_78276_b(this.mName, 6, 7, 0xFAFAFF);
            this.field_146289_q.func_78276_b("Incomplete Structure.", 6, 15, 0xFAFAFF);
        } else {
            int aTotalTickTime = ((CONTAINER_MultiMachine)this.mContainer).aTotalTickTime;
            int aMaxParallel = ((CONTAINER_MultiMachine)this.mContainer).aMaxParallel;
            int aPollutionTick = ((CONTAINER_MultiMachine)this.mContainer).aPollutionTick;
            int aMaxInputVoltage = ((CONTAINER_MultiMachine)this.mContainer).aMaxInputVoltage;
            int aInputTier = ((CONTAINER_MultiMachine)this.mContainer).aInputTier;
            int aOutputTier = ((CONTAINER_MultiMachine)this.mContainer).aOutputTier;
            int aRecipeDuration = ((CONTAINER_MultiMachine)this.mContainer).aRecipeDuration;
            int aRecipeEU = ((CONTAINER_MultiMachine)this.mContainer).aRecipeEU;
            int aRecipeSpecial = ((CONTAINER_MultiMachine)this.mContainer).aRecipeSpecial;
            int aEfficiency = ((CONTAINER_MultiMachine)this.mContainer).aEfficiency;
            int aPollutionReduction = ((CONTAINER_MultiMachine)this.mContainer).aPollutionReduction;
            long aStoredEnergy = ((CONTAINER_MultiMachine)this.mContainer).aStoredEnergy;
            long aMaxEnergy = ((CONTAINER_MultiMachine)this.mContainer).aMaxEnergy;
            long seconds = aTotalTickTime / 20;
            int weeks = (int)(TimeUnit.SECONDS.toDays(seconds) / 7L);
            int days = (int)(TimeUnit.SECONDS.toDays(seconds) - (long)(7 * weeks));
            long hours = TimeUnit.SECONDS.toHours(seconds) - TimeUnit.DAYS.toHours(days) - TimeUnit.DAYS.toHours(7 * weeks);
            long minutes = TimeUnit.SECONDS.toMinutes(seconds) - TimeUnit.SECONDS.toHours(seconds) * 60L;
            long second = TimeUnit.SECONDS.toSeconds(seconds) - TimeUnit.SECONDS.toMinutes(seconds) * 60L;
            ArrayList<String> mInfo = new ArrayList<String>();
            String EU2 = StatCollector.func_74838_a((String)"GTPP.info.eu");
            mInfo.add(this.mName);
            if (aInputTier > 0) {
                mInfo.add(StatCollector.func_74838_a((String)"GTPP.machines.input") + " " + StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.GREEN + GT_Values.VOLTAGE_NAMES[aInputTier]);
            }
            if (aOutputTier > 0) {
                mInfo.add(StatCollector.func_74838_a((String)"GTPP.machines.output") + " " + StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.GREEN + GT_Values.VOLTAGE_NAMES[aOutputTier]);
            }
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.progress") + ": " + EnumChatFormatting.GREEN + Integer.toString(((CONTAINER_MultiMachine)this.mContainer).mProgressTime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + Integer.toString(((CONTAINER_MultiMachine)this.mContainer).mMaxProgressTime / 20) + EnumChatFormatting.RESET + " s");
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.energy") + ":");
            mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.GREEN + Long.toString(aStoredEnergy) + EnumChatFormatting.RESET + " EU / " + EnumChatFormatting.YELLOW + Long.toString(aMaxEnergy) + EnumChatFormatting.RESET + " EU")));
            if (aRecipeEU != 0 && aRecipeDuration > 0) {
                if (aRecipeEU > 0) {
                    mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.usage") + ":");
                    mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.RED + Integer.toString(-aRecipeEU) + EnumChatFormatting.RESET + " EU/t/parallel")));
                } else {
                    mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.generation") + ":");
                    mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.GREEN + Integer.toString(aRecipeEU) + EnumChatFormatting.RESET + " EU/t/parallel")));
                }
                mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.duration") + ": " + EnumChatFormatting.RED + Integer.toString(aRecipeDuration) + EnumChatFormatting.RESET + " ticks");
                if (aRecipeSpecial > 0) {
                    mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.specialvalue") + ": " + EnumChatFormatting.RED + Integer.toString(aRecipeEU) + EnumChatFormatting.RESET + "");
                }
            }
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.mei") + ":");
            mInfo.add(StatCollector.func_74838_a((String)("" + EnumChatFormatting.YELLOW + Long.toString(aMaxInputVoltage) + EnumChatFormatting.RESET + " EU/t(*2A) " + StatCollector.func_74838_a((String)"GTPP.machines.tier") + ": " + EnumChatFormatting.YELLOW + GT_Values.VN[GT_Utility.getTier((long)aMaxInputVoltage)] + EnumChatFormatting.RESET)));
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + Float.toString((float)aEfficiency / 100.0f) + EnumChatFormatting.RESET + " %");
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.pollution") + ": " + EnumChatFormatting.RED + aPollutionTick * 20 + EnumChatFormatting.RESET + "/sec");
            mInfo.add(StatCollector.func_74838_a((String)"GTPP.multiblock.pollutionreduced") + ": " + EnumChatFormatting.GREEN + aPollutionReduction + EnumChatFormatting.RESET + " %");
            mInfo.add("Total Time Since Built: ");
            mInfo.add("" + EnumChatFormatting.DARK_GREEN + Integer.toString(weeks) + EnumChatFormatting.RESET + " Weeks,");
            mInfo.add("" + EnumChatFormatting.DARK_GREEN + Integer.toString(days) + EnumChatFormatting.RESET + " Days,");
            mInfo.add("" + EnumChatFormatting.DARK_GREEN + Long.toString(hours) + EnumChatFormatting.RESET + " Hours,");
            mInfo.add("" + EnumChatFormatting.DARK_GREEN + Long.toString(minutes) + EnumChatFormatting.RESET + " Minutes,");
            mInfo.add("" + EnumChatFormatting.DARK_GREEN + Long.toString(second) + EnumChatFormatting.RESET + " Seconds");
            for (int i = 0; i < mInfo.size(); ++i) {
                this.field_146289_q.func_78276_b((String)mInfo.get(i), 6, 7 + i * 8, 0xFAFAFF);
            }
        }
    }

    protected void drawGuiRepairStatusLayer(float par1, int par2) {
        boolean aCrowbar;
        boolean aWrench = (((CONTAINER_MultiMachine)this.mContainer).mDisplayErrorCode & 1) != 0;
        boolean aScrewdriver = (((CONTAINER_MultiMachine)this.mContainer).mDisplayErrorCode & 2) != 0;
        boolean aMallet = (((CONTAINER_MultiMachine)this.mContainer).mDisplayErrorCode & 4) != 0;
        boolean aHammer = (((CONTAINER_MultiMachine)this.mContainer).mDisplayErrorCode & 8) != 0;
        boolean aSoldering = (((CONTAINER_MultiMachine)this.mContainer).mDisplayErrorCode & 0x10) != 0;
        boolean bl = aCrowbar = (((CONTAINER_MultiMachine)this.mContainer).mDisplayErrorCode & 0x20) != 0;
        if (mToolStacks.isEmpty()) {
            aWrench = false;
            aScrewdriver = false;
            aMallet = false;
            aHammer = false;
            aSoldering = false;
            aCrowbar = false;
            mToolStacks.put(aWrench + "WRENCH", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(16, 1, aWrench ? BAD : GOOD, Materials.Tungsten, null));
            mToolStacks.put(aCrowbar + "CROWBAR", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(20, 1, aCrowbar ? BAD : GOOD, Materials.Tungsten, null));
            mToolStacks.put(aHammer + "HARDHAMMER", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(12, 1, aHammer ? BAD : GOOD, Materials.Tungsten, null));
            mToolStacks.put(aMallet + "SOFTHAMMER", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(14, 1, aMallet ? BAD : GOOD, Materials.Tungsten, null));
            mToolStacks.put(aScrewdriver + "SCREWDRIVER", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(22, 1, aScrewdriver ? BAD : GOOD, Materials.Tungsten, null));
            mToolStacks.put(aSoldering + "SOLDERING_IRON_LV", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(160, 1, aSoldering ? BAD : GOOD, Materials.Tungsten, null));
            aWrench = true;
            aScrewdriver = true;
            aMallet = true;
            aHammer = true;
            aSoldering = true;
            aCrowbar = true;
            mToolStacks.put(aWrench + "WRENCH", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(16, 1, aWrench ? BAD : GOOD, Materials.Tungsten, null));
            mToolStacks.put(aCrowbar + "CROWBAR", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(20, 1, aCrowbar ? BAD : GOOD, Materials.Tungsten, null));
            mToolStacks.put(aHammer + "HARDHAMMER", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(12, 1, aHammer ? BAD : GOOD, Materials.Tungsten, null));
            mToolStacks.put(aMallet + "SOFTHAMMER", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(14, 1, aMallet ? BAD : GOOD, Materials.Tungsten, null));
            mToolStacks.put(aScrewdriver + "SCREWDRIVER", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(22, 1, aScrewdriver ? BAD : GOOD, Materials.Tungsten, null));
            mToolStacks.put(aSoldering + "SOLDERING_IRON_LV", GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(160, 1, aSoldering ? BAD : GOOD, Materials.Tungsten, null));
            ItemStack aGlassPane1 = ItemUtils.getItemStackOfAmountFromOreDict("paneGlassRed", 1);
            ItemStack aGlassPane2 = ItemUtils.getItemStackOfAmountFromOreDict("paneGlassLime", 1);
            mToolStacks.put("falseGLASS", aGlassPane1);
            mToolStacks.put("trueGLASS", aGlassPane2);
            aWrench = (((CONTAINER_MultiMachine)this.mContainer).mDisplayErrorCode & 1) != 0;
            aScrewdriver = (((CONTAINER_MultiMachine)this.mContainer).mDisplayErrorCode & 2) != 0;
            aMallet = (((CONTAINER_MultiMachine)this.mContainer).mDisplayErrorCode & 4) != 0;
            aHammer = (((CONTAINER_MultiMachine)this.mContainer).mDisplayErrorCode & 8) != 0;
            aSoldering = (((CONTAINER_MultiMachine)this.mContainer).mDisplayErrorCode & 0x10) != 0;
            boolean bl2 = aCrowbar = (((CONTAINER_MultiMachine)this.mContainer).mDisplayErrorCode & 0x20) != 0;
        }
        if (!mToolStacks.isEmpty() && mDrawItemStack != null) {
            ItemStack aWrenchStack = mToolStacks.get(aWrench + "WRENCH");
            ItemStack aCrowbarStack = mToolStacks.get(aCrowbar + "CROWBAR");
            ItemStack aHammerStack = mToolStacks.get(aHammer + "HARDHAMMER");
            ItemStack aMalletStack = mToolStacks.get(aMallet + "SOFTHAMMER");
            ItemStack aScrewdriverStack = mToolStacks.get(aScrewdriver + "SCREWDRIVER");
            ItemStack aSolderingStack = mToolStacks.get(aSoldering + "SOLDERING_IRON_LV");
            try {
                ItemStack[] aToolStacks2 = new ItemStack[]{aWrenchStack, aCrowbarStack, aHammerStack, aMalletStack, aScrewdriverStack, aSolderingStack};
                int aIndex = 0;
                for (aIndex = 0; aIndex < 6; ++aIndex) {
                    int x = 156;
                    int y = 58 + aIndex * 18;
                    mDrawItemStack.invoke((Object)this, aToolStacks2[aIndex] != null ? aToolStacks2[aIndex] : ItemUtils.getErrorStack(1, "Bad Times"), x, y, "" + (aIndex == 2 ? "H" : (aIndex == 3 ? "M" : "")));
                }
                boolean running = ((CONTAINER_MultiMachine)this.mContainer).mActive != 0;
                ItemStack aGlassPane = mToolStacks.get(running + "GLASS");
                if (aGlassPane == null) {
                    aGlassPane = ItemUtils.getItemStackOfAmountFromOreDict("paneGlass" + (running ? "Lime" : "Red"), 1);
                    mToolStacks.put(running + "GLASS", aGlassPane);
                }
                mDrawItemStack.invoke((Object)this, aGlassPane != null ? aGlassPane : ItemUtils.getErrorStack(1, "Bad Times"), 156, 22, running ? "On" : "Off");
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    protected void func_146976_a(float par1, int par2, int par3) {
        super.func_146976_a(par1, par2, par3);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    static {
        mToolStacks = new ConcurrentHashMap();
        GOOD = Materials.Uranium;
        BAD = Materials.Plutonium;
        mDrawItemStack = ReflectionUtils.getMethod(GuiContainer.class, "drawItemStack", ItemStack.class, Integer.TYPE, Integer.TYPE, String.class);
    }
}

