/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.forestry.bees.custom;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesCustom;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeMutationCustom;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.apiculture.genetics.BeeVariation;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.core.genetics.alleles.AlleleHelper;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.forestry.bees.custom.CustomCombs;
import gtPlusPlus.xmod.forestry.bees.custom.GTPP_Bees;
import gtPlusPlus.xmod.forestry.bees.custom.GTPP_Branch_Definition;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.commons.lang3.text.WordUtils;

public enum GTPP_Bee_Definition implements IBeeDefinition
{
    SILICON(GTPP_Branch_Definition.ORGANIC, "Silicon", true, Utils.rgbtoHexValue(75, 75, 75), Utils.rgbtoHexValue(125, 125, 125)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPP_Bee_Definition.getSlagComb(), Float.valueOf(0.1f));
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.SILICON), Float.valueOf(0.2f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(1.getGregtechBeeType("SLIMEBALL"), 1.getGregtechBeeType("STICKYRESIN"), 10);
        }
    }
    ,
    RUBBER(GTPP_Branch_Definition.ORGANIC, "Rubber", true, Utils.rgbtoHexValue(55, 55, 55), Utils.rgbtoHexValue(75, 75, 75)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPP_Bee_Definition.getSlagComb(), Float.valueOf(0.1f));
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.RUBBER), Float.valueOf(0.3f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(2.getGregtechBeeType("SLIMEBALL"), 2.getGregtechBeeType("STICKYRESIN"), 10);
        }
    }
    ,
    PLASTIC(GTPP_Branch_Definition.ORGANIC, "Plastic", true, Utils.rgbtoHexValue(245, 245, 245), Utils.rgbtoHexValue(175, 175, 175)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPP_Bee_Definition.getStoneComb(), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.PLASTIC), Float.valueOf(0.15f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)RUBBER.species, 3.getGregtechBeeType("OIL"), 10);
        }
    }
    ,
    PTFE(GTPP_Branch_Definition.ORGANIC, "Ptfe", true, Utils.rgbtoHexValue(150, 150, 150), Utils.rgbtoHexValue(75, 75, 75)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPP_Bee_Definition.getStoneComb(), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.PTFE), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)RUBBER.species, (IAlleleBeeSpecies)PLASTIC.species, 10);
        }
    }
    ,
    PBS(GTPP_Branch_Definition.ORGANIC, "Pbs", true, Utils.rgbtoHexValue(33, 26, 24), Utils.rgbtoHexValue(23, 16, 14)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPP_Bee_Definition.getStoneComb(), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.PBS), Float.valueOf(0.1f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)PTFE.species, (IAlleleBeeSpecies)PLASTIC.species, 10);
        }
    }
    ,
    BIOMASS(GTPP_Branch_Definition.ORGANIC, "Biomass", true, Utils.rgbtoHexValue(33, 225, 24), Utils.rgbtoHexValue(23, 175, 14)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.SAND), Float.valueOf(0.4f));
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.BIOMASS), Float.valueOf(0.2f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(GTPP_Bee_Definition.getSpecies("Industrious"), GTPP_Bee_Definition.getSpecies("Rural"), 10);
            tMutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        }
    }
    ,
    ETHANOL(GTPP_Branch_Definition.ORGANIC, "Ethanol", true, Utils.rgbtoHexValue(255, 128, 0), Utils.rgbtoHexValue(220, 156, 32)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.SAND), Float.valueOf(0.4f));
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.ETHANOL), Float.valueOf(0.2f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.NORMAL);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation((IAlleleBeeSpecies)BIOMASS.species, GTPP_Bee_Definition.getSpecies("Farmerly"), 5);
            tMutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.FOREST});
        }
    }
    ,
    FLUORINE(GTPP_Branch_Definition.ORGANIC, "Fluorine", true, Utils.rgbtoHexValue(30, 230, 230), Utils.rgbtoHexValue(10, 150, 150)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPP_Bee_Definition.getStoneComb(), Float.valueOf(0.4f));
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.FLUORINE), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.COLD);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(8.getGregtechBeeType("LAPIS"), 8.getGregtechBeeType("SAPPHIRE"), 5);
            tMutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD});
        }
    }
    ,
    FORCE(GTPP_Branch_Definition.METAL, "Force", true, Utils.rgbtoHexValue(250, 250, 20), Utils.rgbtoHexValue(200, 200, 5)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPP_Bee_Definition.getStoneComb(), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.SAND), Float.valueOf(0.25f));
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.FORCE), Float.valueOf(0.25f));
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.SALT), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(9.getGregtechBeeType("STEEL"), 9.getGregtechBeeType("GOLD"), 10);
            tMutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT});
        }
    }
    ,
    NIKOLITE(GTPP_Branch_Definition.METAL, "Nikolite", true, Utils.rgbtoHexValue(60, 180, 200), Utils.rgbtoHexValue(40, 150, 170)){

        @Override
        protected void setSpeciesProperties(IAlleleBeeSpeciesCustom beeSpecies) {
            beeSpecies.addProduct(GTPP_Bee_Definition.getStoneComb(), Float.valueOf(0.3f));
            beeSpecies.addProduct(GTPP_Bees.combs.getStackForType(CustomCombs.NIKOLITE), Float.valueOf(0.05f));
            beeSpecies.setHumidity(EnumHumidity.NORMAL);
            beeSpecies.setTemperature(EnumTemperature.HOT);
        }

        @Override
        protected void setAlleles(IAllele[] template) {
            template = BeeDefinition.COMMON.getTemplate();
        }

        @Override
        protected void registerMutations() {
            IBeeMutationCustom tMutation = this.registerMutation(10.getGregtechBeeType("ALUMINIUM"), 10.getGregtechBeeType("SILVER"), 8);
            tMutation.restrictBiomeType(new BiomeDictionary.Type[]{BiomeDictionary.Type.HOT});
        }
    };

    private final GTPP_Branch_Definition branch;
    private final IAlleleBeeSpeciesCustom species;
    private IAllele[] template;
    private IBeeGenome genome;

    private GTPP_Bee_Definition(GTPP_Branch_Definition branch, String binomial, boolean dominant, int primary, int secondary) {
        String lowercaseName = this.toString().toLowerCase(Locale.ENGLISH);
        String species = "species" + WordUtils.capitalize((String)lowercaseName);
        String uid = "forestry." + species;
        String description = "for.description." + species;
        String name = "for.bees.species." + lowercaseName;
        this.branch = branch;
        this.species = BeeManager.beeFactory.createSpecies(uid, dominant, "Sengir", name, description, branch.getBranch(), binomial, primary, secondary);
    }

    public static void initBees() {
        for (GTPP_Bee_Definition bee : GTPP_Bee_Definition.values()) {
            bee.init();
        }
        for (GTPP_Bee_Definition bee : GTPP_Bee_Definition.values()) {
            bee.registerMutations();
        }
    }

    private static IAlleleBeeSpecies getSpecies(String name) {
        return (IAlleleBeeSpecies)AlleleManager.alleleRegistry.getAllele("forestry.species" + name);
    }

    protected abstract void setSpeciesProperties(IAlleleBeeSpeciesCustom var1);

    protected abstract void setAlleles(IAllele[] var1);

    protected abstract void registerMutations();

    private void init() {
        this.setSpeciesProperties(this.species);
        this.template = this.branch.getTemplate();
        AlleleHelper.instance.set(this.template, (Enum)EnumBeeChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
        BeeManager.beeRoot.registerTemplate(this.template);
    }

    protected final IBeeMutationCustom registerMutation(IAlleleBeeSpecies parent1, IAlleleBeeSpecies parent2, int chance) {
        IAllele[] template = this.getTemplate();
        Logger.DEBUG_BEES("parent1: " + (parent1 != null));
        Logger.DEBUG_BEES("parent2: " + (parent2 != null));
        Logger.DEBUG_BEES("chance: " + chance);
        Logger.DEBUG_BEES("template: " + (template != null));
        return BeeManager.beeMutationFactory.createMutation(parent1, parent2, template, chance);
    }

    public final IAllele[] getTemplate() {
        return Arrays.copyOf(this.template, this.template.length);
    }

    public final IBeeGenome getGenome() {
        return this.genome;
    }

    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    public final ItemStack getMemberStack(EnumBeeType beeType) {
        IBee bee = this.getIndividual();
        return BeeManager.beeRoot.getMemberStack((IIndividual)bee, beeType.ordinal());
    }

    public final IBeeDefinition getRainResist() {
        return new BeeVariation.RainResist((IBeeDefinition)this);
    }

    private static ItemStack getSlagComb() {
        return GTPP_Bee_Definition.issStackValid(ItemUtils.getSimpleStack(GTPP_Bees.Comb_Slag, 1));
    }

    private static ItemStack getStoneComb() {
        return GTPP_Bee_Definition.issStackValid(ItemUtils.getSimpleStack(GTPP_Bees.Comb_Stone, 1));
    }

    private static ItemStack issStackValid(ItemStack result) {
        if (result == null) {
            return ItemUtils.getErrorStack(1);
        }
        return result;
    }

    public static IAlleleBeeSpecies getGregtechBeeType(String name) {
        try {
            Class<?> gtBeeTypes = Class.forName("gregtech.loaders.misc.GT_BeeDefinition");
            Object gtBeeEnumObject = Enum.valueOf(gtBeeTypes, name);
            Field gtBeesField = FieldUtils.getDeclaredField(gtBeeTypes, (String)"species", (boolean)true);
            gtBeesField.setAccessible(true);
            ReflectionUtils.makeFieldAccessible(gtBeesField);
            Object beeType = gtBeesField.get(gtBeeEnumObject);
            return (IAlleleBeeSpecies)beeType;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            return null;
        }
    }
}

