/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.asm.transformers;

import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.ReflectionHelper;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.preloader.CORE_Preloader;
import gtPlusPlus.preloader.DevHelper;
import gtPlusPlus.preloader.Preloader_Logger;
import gtPlusPlus.preloader.asm.AsmConfig;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_COFH_OreDictionaryArbiter;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_Forge_ChunkLoading;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_GC_EntityAutoRocket;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_GC_FluidUtil;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_GC_FuelLoader;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_GT_Achievements_CrashFix;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_GT_BaseMetaTileEntity;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_GT_BlockMachines_MetaPipeEntity;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_GT_BlockMachines_NBT;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_GT_CharcoalPit;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_GT_Client;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_GT_EnergyHatchPatch;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_GT_MetaGenerated_Tool;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_GT_Packet_TileEntity;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_IC2_GetHarvestTool;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_LWJGL_Keyboard;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_Railcraft_FluidCartHandling;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_Railcraft_FluidHelper;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_Railcraft_InvTools;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_TC_ItemWispEssence;
import gtPlusPlus.preloader.asm.transformers.ClassTransformer_TiConFluids;
import gtPlusPlus.preloader.asm.transformers.Preloader_ClassTransformer;
import java.io.File;
import java.io.IOException;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class Preloader_Transformer_Handler
implements IClassTransformer {
    public static final AsmConfig mConfig;
    public static final AutoMap<String> IC2_WRENCH_PATCH_CLASS_NAMES;
    private static Boolean mObf;

    public boolean checkObfuscated() {
        if (mObf != null) {
            return mObf;
        }
        boolean obfuscated = false;
        try {
            obfuscated = (Boolean)ReflectionHelper.findField(CoreModManager.class, (String[])new String[]{"deobfuscatedEnvironment"}).get(null) == false;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
            try {
                byte[] bs = Launch.classLoader.getClassBytes("net.minecraft.world.World");
                obfuscated = bs == null;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                obfuscated = false;
            }
        }
        mObf = obfuscated;
        return obfuscated;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        boolean obfuscated = this.checkObfuscated();
        if ((transformedName.equals("org.lwjgl.input.Keyboard") || transformedName.equals("bbj") || transformedName.equals("net.minecraft.client.settings.GameSettings")) && AsmConfig.enabledLwjglKeybindingFix) {
            boolean isClientSettingsClass = false;
            if (!transformedName.equals("org.lwjgl.input.Keyboard")) {
                isClientSettingsClass = true;
            }
            Preloader_Logger.INFO("LWJGL Keybinding index out of bounds fix", "Transforming " + transformedName);
            return new ClassTransformer_LWJGL_Keyboard(basicClass, isClientSettingsClass).getWriter().toByteArray();
        }
        if (transformedName.equals("net.minecraftforge.common.ForgeChunkManager") && AsmConfig.enableChunkDebugging) {
            Preloader_Logger.INFO("Chunkloading Patch", "Transforming " + transformedName);
            return new ClassTransformer_Forge_ChunkLoading(basicClass, false).getWriter().toByteArray();
        }
        if (transformedName.equals("net.minecraftforge.oredict.OreDictionary") && AsmConfig.enableOreDictPatch) {
            Preloader_Logger.INFO("OreDictTransformer", "Transforming " + transformedName);
            ClassWriter classWriter = new ClassWriter(2);
            new ClassReader(basicClass).accept((ClassVisitor)new Preloader_ClassTransformer.OreDictionaryVisitor((ClassVisitor)classWriter), 0);
            return classWriter.toByteArray();
        }
        if (transformedName.equals("codechicken.nei.guihook.GuiContainerManager")) {
            // empty if block
        }
        if (transformedName.equals("cofh.core.util.oredict.OreDictionaryArbiter") && (AsmConfig.enableCofhPatch || !obfuscated)) {
            Preloader_Logger.INFO("COFH", "Transforming " + transformedName);
            return new ClassTransformer_COFH_OreDictionaryArbiter(basicClass).getWriter().toByteArray();
        }
        if (transformedName.equals("tconstruct.smeltery.blocks.TConstructFluid") && AsmConfig.enableTiConFluidLighting) {
            Preloader_Logger.INFO("Bright Fluids", "Transforming " + transformedName);
            return new ClassTransformer_TiConFluids("getLightValue", obfuscated, basicClass).getWriter().toByteArray();
        }
        if (transformedName.equals("mods.railcraft.common.fluids.FluidHelper") && AsmConfig.enableRcFlowFix && AsmConfig.maxRailcraftTankProcessVolume != 4000) {
            Preloader_Logger.INFO("Railcraft PROCESS_VOLUME Patch", "Transforming " + transformedName);
            return new ClassTransformer_Railcraft_FluidHelper(basicClass, obfuscated).getWriter().toByteArray();
        }
        if (transformedName.equals("mods.railcraft.common.blocks.machine.gamma.TileFluidLoader") && AsmConfig.maxRailcraftFluidLoaderFlow != 20 || transformedName.equals("mods.railcraft.common.blocks.machine.gamma.TileFluidUnloader") && AsmConfig.maxRailcraftFluidUnloaderFlow != 80) {
            Preloader_Logger.INFO("Railcraft TRANSFER_RATE Patch", "Transforming " + transformedName);
            return new ClassTransformer_Railcraft_FluidCartHandling(basicClass, obfuscated, transformedName).getWriter().toByteArray();
        }
        if (transformedName.equals("mods.railcraft.common.util.inventory.InvTools") && AsmConfig.enableRcItemDupeFix) {
            Preloader_Logger.INFO("Railcraft negative ItemStack Fix", "Transforming " + transformedName);
            return new ClassTransformer_Railcraft_InvTools(basicClass, obfuscated).getWriter().toByteArray();
        }
        if (AsmConfig.enableGcFuelChanges) {
            if (transformedName.equals("micdoodle8.mods.galacticraft.core.util.FluidUtil")) {
                Preloader_Logger.INFO("Galacticraft FluidUtils Patch", "Transforming " + transformedName);
                return new ClassTransformer_GC_FluidUtil(basicClass, false).getWriter().toByteArray();
            }
            if (transformedName.equals("micdoodle8.mods.galacticraft.core.tile.TileEntityFuelLoader")) {
                Preloader_Logger.INFO("Galacticraft Fuel_Loader Patch", "Transforming " + transformedName);
                return new ClassTransformer_GC_FuelLoader(basicClass, false).getWriter().toByteArray();
            }
            if (transformedName.equals("micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket")) {
                Preloader_Logger.INFO("Galacticraft EntityAutoRocket Patch", "Transforming " + transformedName);
                return new ClassTransformer_GC_EntityAutoRocket(basicClass, false).getWriter().toByteArray();
            }
        }
        if (transformedName.equals("gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy") || transformedName.equals("gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Energy_RTG")) {
            Preloader_Logger.INFO("Gregtech RTG Patch", "Transforming " + transformedName);
            return new ClassTransformer_GT_EnergyHatchPatch(basicClass, transformedName).getWriter().toByteArray();
        }
        if (transformedName.equals("gregtech.loaders.misc.GT_Achievements")) {
            Preloader_Logger.INFO("Gregtech Achievements Patch", "Transforming " + transformedName);
            return new ClassTransformer_GT_Achievements_CrashFix(basicClass, obfuscated).getWriter().toByteArray();
        }
        if (transformedName.equals("gregtech.common.GT_Client")) {
            Preloader_Logger.INFO("Gregtech Client Proxy Patch", "Transforming " + transformedName);
            return new ClassTransformer_GT_Client(basicClass, obfuscated).getByteArray();
        }
        if (transformedName.equals("gregtech.api.net.GT_Packet_TileEntity")) {
            Preloader_Logger.INFO("Gregtech GT_Packet_TileEntity Patch", "Transforming " + transformedName);
            return new ClassTransformer_GT_Packet_TileEntity(basicClass, obfuscated).getWriter().toByteArray();
        }
        if (transformedName.equals("gregtech.api.metatileentity.BaseMetaTileEntity")) {
            Preloader_Logger.INFO("Gregtech setMetaTileEntity Patch", "Transforming " + transformedName);
            return new ClassTransformer_GT_BaseMetaTileEntity(basicClass).getWriter().toByteArray();
        }
        if (transformedName.equals("gregtech.api.items.GT_MetaGenerated_Tool") && CORE_Preloader.DEV_ENVIRONMENT) {
            Preloader_Logger.INFO("Gregtech Additional Tools Patch", "Transforming " + transformedName);
            return new ClassTransformer_GT_MetaGenerated_Tool(basicClass).getWriter().toByteArray();
        }
        if (transformedName.equals("gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_Charcoal_Pit") && AsmConfig.enableGtCharcoalPitFix) {
            Preloader_Logger.INFO("GT Charcoal Pit Fix", "Transforming " + transformedName);
            return new ClassTransformer_GT_CharcoalPit(basicClass, obfuscated).getWriter().toByteArray();
        }
        if (!transformedName.equals("gregtech.common.blocks.GT_Item_Machines") || AsmConfig.enableGtTooltipFix) {
            // empty if block
        }
        if (transformedName.equals("gregtech.common.blocks.GT_Block_Machines")) {
            Preloader_Logger.INFO("Gregtech NBT Persistency Patch", "Transforming " + transformedName);
            byte[] g = new ClassTransformer_GT_BlockMachines_NBT(basicClass, false).getWriter().toByteArray();
            Preloader_Logger.INFO("Gregtech getTileEntityBaseType Patch", "Transforming " + transformedName);
            return new ClassTransformer_GT_BlockMachines_MetaPipeEntity(g, 0).getWriter().toByteArray();
        }
        if (transformedName.equals("gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Item") || transformedName.equals("gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Frame") || transformedName.equals("gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Fluid")) {
            Preloader_Logger.INFO("Gregtech getTileEntityBaseType Patch", "Transforming " + transformedName);
            int mode = 0;
            mode = transformedName.equals("gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Item") ? 1 : (transformedName.equals("gregtech.api.metatileentity.implementations.GT_MetaPipeEntity_Frame") ? 2 : 3);
            return new ClassTransformer_GT_BlockMachines_MetaPipeEntity(basicClass, mode).getWriter().toByteArray();
        }
        for (String y : IC2_WRENCH_PATCH_CLASS_NAMES) {
            if (!transformedName.equals(y)) continue;
            Preloader_Logger.INFO("IC2 getHarvestTool Patch", "Transforming " + transformedName);
            return new ClassTransformer_IC2_GetHarvestTool(basicClass, obfuscated, transformedName).getWriter().toByteArray();
        }
        if (transformedName.equals("thaumcraft.common.items.ItemWispEssence") && AsmConfig.enableTcAspectSafety) {
            Preloader_Logger.INFO("Thaumcraft WispEssence_Patch", "Transforming " + transformedName);
            return new ClassTransformer_TC_ItemWispEssence(basicClass, obfuscated).getWriter().toByteArray();
        }
        if (!transformedName.equals("thaumic.tinkerer.common.block.tile.TileRepairer") || AsmConfig.enableThaumicTinkererRepairFix) {
            // empty if block
        }
        return basicClass;
    }

    static {
        IC2_WRENCH_PATCH_CLASS_NAMES = new AutoMap();
        mConfig = new AsmConfig(new File("config/GTplusplus/asm.cfg"));
        Preloader_Logger.INFO("Config Location: " + AsmConfig.config.getConfigFile().getAbsolutePath());
        Preloader_Logger.INFO("Is DevHelper Valid? " + DevHelper.mIsValidHelper);
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.BlockTileEntity");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.machine.BlockMachine");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.machine.BlockMachine2");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.machine.BlockMachine3");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.kineticgenerator.block.BlockKineticGenerator");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.heatgenerator.block.BlockHeatGenerator");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.generator.block.BlockGenerator");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.reactor.block.BlockReactorAccessHatch");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.reactor.block.BlockReactorChamber");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.reactor.block.BlockReactorFluidPort");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.reactor.block.BlockReactorRedstonePort");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.reactor.block.BlockReactorVessel");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.personal.BlockPersonal.class");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.wiring.BlockChargepad.class");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.wiring.BlockElectric.class");
        IC2_WRENCH_PATCH_CLASS_NAMES.add("ic2.core.block.wiring.BlockLuminator.class");
        mObf = null;
    }
}

