/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.asm.transformers;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import gtPlusPlus.preloader.DevHelper;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class ClassTransformer_TiConFluids {
    private static final String className = "tconstruct.smeltery.blocks.TConstructFluid";
    private final boolean isValid;
    private final boolean isObfuscated;
    private final String methodName;
    private final ClassReader reader;
    private final ClassWriter writer;

    public ClassTransformer_TiConFluids(String aMethodName, boolean obfuscated, byte[] basicClass) {
        this.isObfuscated = obfuscated;
        this.methodName = obfuscated ? DevHelper.getSRG(aMethodName) : aMethodName;
        ClassReader aTempReader = null;
        ClassWriter aTempWriter = null;
        aTempReader = new ClassReader(basicClass);
        aTempWriter = new ClassWriter(aTempReader, 2);
        aTempReader.accept((ClassVisitor)new localClassVisitir((ClassVisitor)aTempWriter, this.isObfuscated), 0);
        this.isValid = aTempReader != null && aTempWriter != null;
        this.reader = aTempReader;
        this.writer = aTempWriter;
        if (this.reader != null && this.writer != null) {
            this.injectMethod();
        }
    }

    public boolean isValidTransformer() {
        return this.isValid;
    }

    public ClassReader getReader() {
        return this.reader;
    }

    public ClassWriter getWriter() {
        return this.writer;
    }

    public void injectMethod() {
        if (this.isValidTransformer()) {
            FMLRelaunchLog.log((String)"[GT++ ASM] Bright Fluids", (Level)Level.INFO, (String)("Injecting " + this.methodName + " into " + className + ". [" + (this.isObfuscated ? "Obfuscated" : "Unobfuscated") + "]"), (Object[])new Object[0]);
            String IBlockAccessName = this.isObfuscated ? "ahl" : "net/minecraft/world/IBlockAccess";
            String aConstructorTypes = "(L" + IBlockAccessName + ";III)I";
            MethodVisitor mv = this.getWriter().visitMethod(1, this.methodName, aConstructorTypes, null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(17, l0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "tconstruct/smeltery/blocks/TConstructFluid", "maxScaledLight", "I");
            mv.visitVarInsn(54, 5);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLineNumber(18, l1);
            mv.visitVarInsn(21, 5);
            Label l2 = new Label();
            mv.visitJumpInsn(158, l2);
            Label l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLineNumber(19, l3);
            mv.visitVarInsn(21, 5);
            mv.visitInsn(172);
            mv.visitLabel(l2);
            mv.visitLineNumber(21, l2);
            mv.visitFrame(1, 1, new Object[]{Opcodes.INTEGER}, 0, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitVarInsn(21, 3);
            mv.visitVarInsn(21, 4);
            mv.visitMethodInsn(183, "net/minecraftforge/fluids/BlockFluidClassic", this.methodName, aConstructorTypes, false);
            mv.visitInsn(172);
            Label l4 = new Label();
            mv.visitLabel(l4);
            mv.visitLocalVariable("this", "Ltconstruct/smeltery/blocks/TConstructFluid;", null, l0, l4, 0);
            mv.visitLocalVariable("world", "L" + IBlockAccessName + ";", null, l0, l4, 1);
            mv.visitLocalVariable("x", "I", null, l0, l4, 2);
            mv.visitLocalVariable("y", "I", null, l0, l4, 3);
            mv.visitLocalVariable("z", "I", null, l0, l4, 4);
            mv.visitLocalVariable("maxLight", "I", null, l1, l4, 5);
            mv.visitMaxs(5, 6);
            mv.visitEnd();
            FMLRelaunchLog.log((String)"[GT++ ASM] Bright Fluids", (Level)Level.INFO, (String)"Method injection complete.", (Object[])new Object[0]);
        }
    }

    private final class localMethodVisitor
    extends MethodVisitor {
        private final boolean mObfuscated;

        public localMethodVisitor(MethodVisitor mv, boolean obfuscated) {
            super(327680, mv);
            this.mObfuscated = obfuscated;
        }

        public void visitCode() {
        }
    }

    public final class localClassVisitir
    extends ClassVisitor {
        private final boolean mIsObfuscated;

        public localClassVisitir(ClassVisitor cv, boolean obfuscated) {
            super(327680, cv);
            this.mIsObfuscated = obfuscated;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            String IBlockAccessName = ClassTransformer_TiConFluids.this.isObfuscated ? "ahl" : "net/minecraft/world/IBlockAccess";
            String aConstructorTypes = "(L" + IBlockAccessName + ";III)I";
            MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            if (name.equals(ClassTransformer_TiConFluids.this.methodName) && desc.equals(aConstructorTypes)) {
                FMLRelaunchLog.log((String)"[GT++ ASM] OreDictTransformer", (Level)Level.INFO, (String)("Found target method. [" + this.mIsObfuscated + "]"), (Object[])new Object[0]);
                return new localMethodVisitor(methodVisitor, this.mIsObfuscated);
            }
            return methodVisitor;
        }
    }
}

