/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.asm.transformers;

import cpw.mods.fml.common.Loader;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.preloader.Preloader_Logger;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class ClassTransformer_TT_ThaumicRestorer {
    private final boolean isValid;
    private final ClassReader reader;
    private final ClassWriter writer;
    private static boolean mInit = false;
    private static Class mTileRepairerClass;
    private static Class mTTConfigHandler;
    private static Class mTinkersConstructCompat;
    private static Class mThaumicTinkerer;
    private static Class mTCProxy;
    private static Method mIsTcTool;
    private static Method mGetTcDamage;
    private static Method mFixTcDamage;
    private static Method mSparkle;
    private static Method mDrawEssentia;
    private static Field mRepairTiconTools;
    private static Field mTicksExisted;
    private static Field mInventory;
    private static Field mTookLastTick;
    private static Field mDamageLastTick;
    private static Field mProxyTC;
    private static boolean repairTConTools;

    private static final boolean isTConstructTool(ItemStack aStack) {
        return ReflectionUtils.invoke(null, mIsTcTool, new Object[]{aStack});
    }

    private static final int getDamage(ItemStack aStack) {
        return (Integer)ReflectionUtils.invokeNonBool(null, mGetTcDamage, new Object[]{aStack});
    }

    private static final boolean fixDamage(ItemStack aStack, int aAmount) {
        return ReflectionUtils.invoke(null, mFixTcDamage, new Object[]{aStack, aAmount});
    }

    private static final int drawEssentia(TileEntity aTile) {
        return (Integer)ReflectionUtils.invokeNonBool(aTile, mDrawEssentia, new Object[0]);
    }

    private static final void sparkle(float a, float b, float c, int d) {
        ReflectionUtils.invokeVoid(ReflectionUtils.getFieldValue(mProxyTC), mSparkle, new Object[]{Float.valueOf(a), Float.valueOf(b), Float.valueOf(c), d});
    }

    public static void updateEntity(TileEntity aTile) {
        if (!mInit) {
            mTileRepairerClass = ReflectionUtils.getClass("thaumic.tinkerer.common.block.tile.TileRepairer");
            mTTConfigHandler = ReflectionUtils.getClass("thaumic.tinkerer.common.core.handler.ConfigHandler");
            mTinkersConstructCompat = ReflectionUtils.getClass("thaumic.tinkerer.common.compat.TinkersConstructCompat");
            mThaumicTinkerer = ReflectionUtils.getClass("thaumic.tinkerer.common.ThaumicTinkerer");
            mTCProxy = ReflectionUtils.getClass("thaumcraft.common.CommonProxy");
            mIsTcTool = ReflectionUtils.getMethod(mTinkersConstructCompat, "isTConstructTool", ItemStack.class);
            mGetTcDamage = ReflectionUtils.getMethod(mTinkersConstructCompat, "getDamage", ItemStack.class);
            mFixTcDamage = ReflectionUtils.getMethod(mTinkersConstructCompat, "fixDamage", ItemStack.class, Integer.TYPE);
            mSparkle = ReflectionUtils.getMethod(mTCProxy, "sparkle", Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE);
            mDrawEssentia = ReflectionUtils.getMethod(mTileRepairerClass, "drawEssentia", new Class[0]);
            mRepairTiconTools = ReflectionUtils.getField(mTTConfigHandler, "repairTConTools");
            mTicksExisted = ReflectionUtils.getField(mTileRepairerClass, "ticksExisted");
            mInventory = ReflectionUtils.getField(mTileRepairerClass, "inventorySlots");
            mTookLastTick = ReflectionUtils.getField(mTileRepairerClass, "tookLastTick");
            mDamageLastTick = ReflectionUtils.getField(mTileRepairerClass, "dmgLastTick");
            mProxyTC = ReflectionUtils.getField(mThaumicTinkerer, "tcProxy");
            repairTConTools = (Boolean)ReflectionUtils.getFieldValue(mRepairTiconTools);
            mInit = true;
        }
        if (mInit && mTileRepairerClass.isInstance(aTile)) {
            int ticksExisted = (Integer)ReflectionUtils.getFieldValue(mTicksExisted, aTile);
            ItemStack[] inventorySlots = (ItemStack[])ReflectionUtils.getFieldValue(mInventory, aTile);
            boolean tookLastTick = (Boolean)ReflectionUtils.getFieldValue(mTookLastTick, aTile);
            int dmgLastTick = (Integer)ReflectionUtils.getFieldValue(mDamageLastTick, aTile);
            ReflectionUtils.setField((Object)aTile, mTicksExisted, (Object)(++ticksExisted));
            boolean aDidRun = false;
            if (ticksExisted % 10 == 0) {
                if (Loader.isModLoaded((String)"TConstruct") && repairTConTools && inventorySlots[0] != null && ClassTransformer_TT_ThaumicRestorer.isTConstructTool(inventorySlots[0])) {
                    int dmg = ClassTransformer_TT_ThaumicRestorer.getDamage(inventorySlots[0]);
                    if (dmg > 0) {
                        int essentia = ClassTransformer_TT_ThaumicRestorer.drawEssentia(aTile);
                        ClassTransformer_TT_ThaumicRestorer.fixDamage(inventorySlots[0], essentia);
                        aTile.func_70296_d();
                        if (dmgLastTick != 0 && dmgLastTick != dmg) {
                            ClassTransformer_TT_ThaumicRestorer.sparkle((float)((double)aTile.field_145851_c + 0.25 + Math.random() / 2.0), (float)((double)(aTile.field_145848_d + 1) + Math.random() / 2.0), (float)((double)aTile.field_145849_e + 0.25 + Math.random() / 2.0), 0);
                            tookLastTick = true;
                        } else {
                            tookLastTick = false;
                        }
                    } else {
                        tookLastTick = false;
                    }
                    dmgLastTick = inventorySlots[0] == null ? 0 : ClassTransformer_TT_ThaumicRestorer.getDamage(inventorySlots[0]);
                    aDidRun = true;
                }
                if (inventorySlots[0] != null && inventorySlots[0].func_77960_j() > 0 && inventorySlots[0].func_77973_b().isRepairable()) {
                    int essentia2 = ClassTransformer_TT_ThaumicRestorer.drawEssentia(aTile);
                    int dmg2 = inventorySlots[0].func_77960_j();
                    inventorySlots[0].func_77964_b(Math.max(0, dmg2 - essentia2));
                    aTile.func_70296_d();
                    if (dmgLastTick != 0 && dmgLastTick != dmg2) {
                        ClassTransformer_TT_ThaumicRestorer.sparkle((float)((double)aTile.field_145851_c + 0.25 + Math.random() / 2.0), (float)((double)(aTile.field_145848_d + 1) + Math.random() / 2.0), (float)((double)aTile.field_145849_e + 0.25 + Math.random() / 2.0), 0);
                        tookLastTick = true;
                    } else {
                        tookLastTick = false;
                    }
                } else {
                    tookLastTick = false;
                }
                dmgLastTick = inventorySlots[0] == null ? 0 : inventorySlots[0].func_77960_j();
                aDidRun = true;
            }
            if (aDidRun) {
                ReflectionUtils.setField((Object)aTile, mInventory, (Object)inventorySlots);
                ReflectionUtils.setField((Object)aTile, mTookLastTick, (Object)tookLastTick);
                ReflectionUtils.setField((Object)aTile, mDamageLastTick, (Object)dmgLastTick);
            }
        }
    }

    public ClassTransformer_TT_ThaumicRestorer(byte[] basicClass) {
        ClassReader aTempReader = null;
        ClassWriter aTempWriter = null;
        boolean obfuscated = false;
        aTempReader = new ClassReader(basicClass);
        aTempWriter = new ClassWriter(aTempReader, 2);
        AddAdapter aMethodStripper = new AddAdapter((ClassVisitor)aTempWriter);
        aTempReader.accept((ClassVisitor)aMethodStripper, 0);
        obfuscated = aMethodStripper.isObfuscated;
        String aUpdateEntity = obfuscated ? "func_145845_h" : "updateEntity";
        Preloader_Logger.LOG("Thaumic Tinkerer RepairItem Patch", Level.INFO, "Patching: " + aUpdateEntity + ", Are we patching obfuscated methods? " + obfuscated);
        this.injectMethodNew(aTempWriter, obfuscated);
        this.isValid = aTempReader != null && aTempWriter != null;
        Preloader_Logger.LOG("Thaumic Tinkerer RepairItem Patch", Level.INFO, "Valid? " + this.isValid + ".");
        this.reader = aTempReader;
        this.writer = aTempWriter;
    }

    public boolean isValidTransformer() {
        return this.isValid;
    }

    public ClassReader getReader() {
        return this.reader;
    }

    public ClassWriter getWriter() {
        return this.writer;
    }

    public boolean injectMethodNew(ClassWriter cw, boolean obfuscated) {
        boolean didInject = false;
        String aUpdateEntity = obfuscated ? "func_145845_h" : "updateEntity";
        String aTileEntity = obfuscated ? "aor" : "net/minecraft/tileentity/TileEntity";
        Preloader_Logger.LOG("Thaumic Tinkerer RepairItem Patch", Level.INFO, "Injecting " + aUpdateEntity + ".");
        MethodVisitor mv = cw.visitMethod(1, aUpdateEntity, "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(60, l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "gtPlusPlus/preloader/asm/transformers/ClassTransformer_TT_ThaumicRestorer", "updateEntity", "(L" + aTileEntity + ";)V", false);
        Label l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(61, l1);
        mv.visitInsn(177);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable("this", "Lthaumic/tinkerer/common/block/tile/TileRepairer;", null, l0, l2, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        didInject = true;
        Preloader_Logger.LOG("Thaumic Tinkerer RepairItem Patch", Level.INFO, "Method injection complete. " + (obfuscated ? "Obfuscated" : "Non-Obfuscated"));
        return didInject;
    }

    public boolean injectMethod(String aMethodName, ClassWriter cw, boolean obfuscated) {
        boolean didInject = false;
        Preloader_Logger.LOG("Thaumic Tinkerer RepairItem Patch", Level.INFO, "Injecting " + aMethodName + ".");
        String aItemStack = obfuscated ? "add" : "net/minecraft/item/ItemStack";
        String aItem = obfuscated ? "adb" : "net/minecraft/item/Item";
        String aGetItemDamage = obfuscated ? "func_150976_a" : "getItemDamage";
        String aGetItem = obfuscated ? "func_77973_b" : "getItem";
        String aSetItemDamage = obfuscated ? "func_77964_b" : "setItemDamage";
        String aIsRepairable = obfuscated ? "func_82789_a" : "isRepairable";
        MethodVisitor mv = cw.visitMethod(1, aMethodName, "()V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(59, l0);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(89);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "ticksExisted", "I");
        mv.visitInsn(4);
        mv.visitInsn(96);
        mv.visitInsn(90);
        mv.visitFieldInsn(181, "thaumic/tinkerer/common/block/tile/TileRepairer", "ticksExisted", "I");
        mv.visitIntInsn(16, 10);
        mv.visitInsn(112);
        Label l1 = new Label();
        mv.visitJumpInsn(154, l1);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(60, l2);
        mv.visitLdcInsn((Object)"TConstruct");
        mv.visitMethodInsn(184, "cpw/mods/fml/common/Loader", "isModLoaded", "(Ljava/lang/String;)Z", false);
        Label l3 = new Label();
        mv.visitJumpInsn(153, l3);
        mv.visitFieldInsn(178, "thaumic/tinkerer/common/core/handler/ConfigHandler", "repairTConTools", "Z");
        mv.visitJumpInsn(153, l3);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLineNumber(61, l4);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "inventorySlots", "[L" + aItemStack + ";");
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitJumpInsn(198, l3);
        Label l5 = new Label();
        mv.visitLabel(l5);
        mv.visitLineNumber(62, l5);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "inventorySlots", "[L" + aItemStack + ";");
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitMethodInsn(184, "thaumic/tinkerer/common/compat/TinkersConstructCompat", "isTConstructTool", "(L" + aItemStack + ";)Z", false);
        mv.visitJumpInsn(153, l3);
        Label l6 = new Label();
        mv.visitLabel(l6);
        mv.visitLineNumber(63, l6);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "inventorySlots", "[L" + aItemStack + ";");
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitMethodInsn(184, "thaumic/tinkerer/common/compat/TinkersConstructCompat", "getDamage", "(L" + aItemStack + ";)I", false);
        mv.visitVarInsn(54, 1);
        Label l7 = new Label();
        mv.visitLabel(l7);
        mv.visitLineNumber(64, l7);
        mv.visitVarInsn(21, 1);
        Label l8 = new Label();
        mv.visitJumpInsn(158, l8);
        Label l9 = new Label();
        mv.visitLabel(l9);
        mv.visitLineNumber(65, l9);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "thaumic/tinkerer/common/block/tile/TileRepairer", "drawEssentia", "()I", false);
        mv.visitVarInsn(54, 2);
        Label l10 = new Label();
        mv.visitLabel(l10);
        mv.visitLineNumber(66, l10);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "inventorySlots", "[L" + aItemStack + ";");
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitVarInsn(21, 2);
        mv.visitMethodInsn(184, "thaumic/tinkerer/common/compat/TinkersConstructCompat", "fixDamage", "(L" + aItemStack + ";I)Z", false);
        mv.visitInsn(87);
        Label l11 = new Label();
        mv.visitLabel(l11);
        mv.visitLineNumber(67, l11);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "thaumic/tinkerer/common/block/tile/TileRepairer", "markDirty", "()V", false);
        Label l12 = new Label();
        mv.visitLabel(l12);
        mv.visitLineNumber(68, l12);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "dmgLastTick", "I");
        Label l13 = new Label();
        mv.visitJumpInsn(153, l13);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "dmgLastTick", "I");
        mv.visitVarInsn(21, 1);
        mv.visitJumpInsn(159, l13);
        Label l14 = new Label();
        mv.visitLabel(l14);
        mv.visitLineNumber(69, l14);
        mv.visitFieldInsn(178, "thaumic/tinkerer/common/ThaumicTinkerer", "tcProxy", "Lthaumcraft/common/CommonProxy;");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "xCoord", "I");
        mv.visitInsn(135);
        mv.visitLdcInsn((Object)new Double("0.25"));
        mv.visitInsn(99);
        mv.visitMethodInsn(184, "java/lang/Math", "random", "()D", false);
        mv.visitLdcInsn((Object)new Double("2.0"));
        mv.visitInsn(111);
        mv.visitInsn(99);
        mv.visitInsn(144);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "yCoord", "I");
        mv.visitInsn(4);
        mv.visitInsn(96);
        mv.visitInsn(135);
        mv.visitMethodInsn(184, "java/lang/Math", "random", "()D", false);
        mv.visitLdcInsn((Object)new Double("2.0"));
        mv.visitInsn(111);
        mv.visitInsn(99);
        mv.visitInsn(144);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "zCoord", "I");
        mv.visitInsn(135);
        mv.visitLdcInsn((Object)new Double("0.25"));
        mv.visitInsn(99);
        mv.visitMethodInsn(184, "java/lang/Math", "random", "()D", false);
        mv.visitLdcInsn((Object)new Double("2.0"));
        mv.visitInsn(111);
        mv.visitInsn(99);
        mv.visitInsn(144);
        mv.visitInsn(3);
        mv.visitMethodInsn(182, "thaumcraft/common/CommonProxy", "sparkle", "(FFFI)V", false);
        Label l15 = new Label();
        mv.visitLabel(l15);
        mv.visitLineNumber(70, l15);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(4);
        mv.visitFieldInsn(181, "thaumic/tinkerer/common/block/tile/TileRepairer", "tookLastTick", "Z");
        Label l16 = new Label();
        mv.visitLabel(l16);
        mv.visitLineNumber(71, l16);
        Label l17 = new Label();
        mv.visitJumpInsn(167, l17);
        mv.visitLabel(l13);
        mv.visitFrame(1, 2, new Object[]{Opcodes.INTEGER, Opcodes.INTEGER}, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, "thaumic/tinkerer/common/block/tile/TileRepairer", "tookLastTick", "Z");
        Label l18 = new Label();
        mv.visitLabel(l18);
        mv.visitLineNumber(72, l18);
        mv.visitJumpInsn(167, l17);
        mv.visitLabel(l8);
        mv.visitFrame(2, 1, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, "thaumic/tinkerer/common/block/tile/TileRepairer", "tookLastTick", "Z");
        mv.visitLabel(l17);
        mv.visitLineNumber(73, l17);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "inventorySlots", "[L" + aItemStack + ";");
        mv.visitInsn(3);
        mv.visitInsn(50);
        Label l19 = new Label();
        mv.visitJumpInsn(199, l19);
        mv.visitInsn(3);
        Label l20 = new Label();
        mv.visitJumpInsn(167, l20);
        mv.visitLabel(l19);
        mv.visitFrame(4, 0, null, 1, new Object[]{"thaumic/tinkerer/common/block/tile/TileRepairer"});
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "inventorySlots", "[L" + aItemStack + ";");
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitMethodInsn(184, "thaumic/tinkerer/common/compat/TinkersConstructCompat", "getDamage", "(L" + aItemStack + ";)I", false);
        mv.visitLabel(l20);
        mv.visitFrame(0, 2, new Object[]{"thaumic/tinkerer/common/block/tile/TileRepairer", Opcodes.INTEGER}, 2, new Object[]{"thaumic/tinkerer/common/block/tile/TileRepairer", Opcodes.INTEGER});
        mv.visitFieldInsn(181, "thaumic/tinkerer/common/block/tile/TileRepairer", "dmgLastTick", "I");
        Label l21 = new Label();
        mv.visitLabel(l21);
        mv.visitLineNumber(74, l21);
        mv.visitInsn(177);
        mv.visitLabel(l3);
        mv.visitLineNumber(78, l3);
        mv.visitFrame(2, 1, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "inventorySlots", "[L" + aItemStack + ";");
        mv.visitInsn(3);
        mv.visitInsn(50);
        Label l22 = new Label();
        mv.visitJumpInsn(198, l22);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "inventorySlots", "[L" + aItemStack + ";");
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitMethodInsn(182, "" + aItemStack + "", "" + aGetItemDamage + "", "()I", false);
        mv.visitJumpInsn(158, l22);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "inventorySlots", "[L" + aItemStack + ";");
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitMethodInsn(182, "" + aItemStack + "", "" + aGetItem + "", "()L" + aItem + ";", false);
        mv.visitMethodInsn(182, "" + aItem + "", "" + aIsRepairable + "", "()Z", false);
        mv.visitJumpInsn(153, l22);
        Label l23 = new Label();
        mv.visitLabel(l23);
        mv.visitLineNumber(79, l23);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "thaumic/tinkerer/common/block/tile/TileRepairer", "drawEssentia", "()I", false);
        mv.visitVarInsn(54, 1);
        Label l24 = new Label();
        mv.visitLabel(l24);
        mv.visitLineNumber(80, l24);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "inventorySlots", "[L" + aItemStack + ";");
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitMethodInsn(182, "" + aItemStack + "", "" + aGetItemDamage + "", "()I", false);
        mv.visitVarInsn(54, 2);
        Label l25 = new Label();
        mv.visitLabel(l25);
        mv.visitLineNumber(81, l25);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "inventorySlots", "[L" + aItemStack + ";");
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitInsn(3);
        mv.visitVarInsn(21, 2);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(100);
        mv.visitMethodInsn(184, "java/lang/Math", "max", "(II)I", false);
        mv.visitMethodInsn(182, "" + aItemStack + "", "" + aSetItemDamage + "", "(I)V", false);
        Label l26 = new Label();
        mv.visitLabel(l26);
        mv.visitLineNumber(82, l26);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "thaumic/tinkerer/common/block/tile/TileRepairer", "markDirty", "()V", false);
        Label l27 = new Label();
        mv.visitLabel(l27);
        mv.visitLineNumber(84, l27);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "dmgLastTick", "I");
        Label l28 = new Label();
        mv.visitJumpInsn(153, l28);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "dmgLastTick", "I");
        mv.visitVarInsn(21, 2);
        mv.visitJumpInsn(159, l28);
        Label l29 = new Label();
        mv.visitLabel(l29);
        mv.visitLineNumber(85, l29);
        mv.visitFieldInsn(178, "thaumic/tinkerer/common/ThaumicTinkerer", "tcProxy", "Lthaumcraft/common/CommonProxy;");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "xCoord", "I");
        mv.visitInsn(135);
        mv.visitLdcInsn((Object)new Double("0.25"));
        mv.visitInsn(99);
        mv.visitMethodInsn(184, "java/lang/Math", "random", "()D", false);
        mv.visitLdcInsn((Object)new Double("2.0"));
        mv.visitInsn(111);
        mv.visitInsn(99);
        mv.visitInsn(144);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "yCoord", "I");
        mv.visitInsn(4);
        mv.visitInsn(96);
        mv.visitInsn(135);
        mv.visitMethodInsn(184, "java/lang/Math", "random", "()D", false);
        mv.visitLdcInsn((Object)new Double("2.0"));
        mv.visitInsn(111);
        mv.visitInsn(99);
        mv.visitInsn(144);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "zCoord", "I");
        mv.visitInsn(135);
        mv.visitLdcInsn((Object)new Double("0.25"));
        mv.visitInsn(99);
        mv.visitMethodInsn(184, "java/lang/Math", "random", "()D", false);
        mv.visitLdcInsn((Object)new Double("2.0"));
        mv.visitInsn(111);
        mv.visitInsn(99);
        mv.visitInsn(144);
        mv.visitInsn(3);
        mv.visitMethodInsn(182, "thaumcraft/common/CommonProxy", "sparkle", "(FFFI)V", false);
        Label l30 = new Label();
        mv.visitLabel(l30);
        mv.visitLineNumber(86, l30);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(4);
        mv.visitFieldInsn(181, "thaumic/tinkerer/common/block/tile/TileRepairer", "tookLastTick", "Z");
        Label l31 = new Label();
        mv.visitLabel(l31);
        mv.visitLineNumber(87, l31);
        Label l32 = new Label();
        mv.visitJumpInsn(167, l32);
        mv.visitLabel(l28);
        mv.visitFrame(1, 2, new Object[]{Opcodes.INTEGER, Opcodes.INTEGER}, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, "thaumic/tinkerer/common/block/tile/TileRepairer", "tookLastTick", "Z");
        Label l33 = new Label();
        mv.visitLabel(l33);
        mv.visitLineNumber(88, l33);
        mv.visitJumpInsn(167, l32);
        mv.visitLabel(l22);
        mv.visitFrame(2, 2, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, "thaumic/tinkerer/common/block/tile/TileRepairer", "tookLastTick", "Z");
        mv.visitLabel(l32);
        mv.visitLineNumber(90, l32);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "inventorySlots", "[L" + aItemStack + ";");
        mv.visitInsn(3);
        mv.visitInsn(50);
        Label l34 = new Label();
        mv.visitJumpInsn(199, l34);
        mv.visitInsn(3);
        Label l35 = new Label();
        mv.visitJumpInsn(167, l35);
        mv.visitLabel(l34);
        mv.visitFrame(4, 0, null, 1, new Object[]{"thaumic/tinkerer/common/block/tile/TileRepairer"});
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "thaumic/tinkerer/common/block/tile/TileRepairer", "inventorySlots", "[L" + aItemStack + ";");
        mv.visitInsn(3);
        mv.visitInsn(50);
        mv.visitMethodInsn(182, "" + aItemStack + "", "" + aGetItemDamage + "", "()I", false);
        mv.visitLabel(l35);
        mv.visitFrame(0, 1, new Object[]{"thaumic/tinkerer/common/block/tile/TileRepairer"}, 2, new Object[]{"thaumic/tinkerer/common/block/tile/TileRepairer", Opcodes.INTEGER});
        mv.visitFieldInsn(181, "thaumic/tinkerer/common/block/tile/TileRepairer", "dmgLastTick", "I");
        mv.visitLabel(l1);
        mv.visitLineNumber(92, l1);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitInsn(177);
        Label l36 = new Label();
        mv.visitLabel(l36);
        mv.visitLocalVariable("this", "Lthaumic/tinkerer/common/block/tile/TileRepairer;", null, l0, l36, 0);
        mv.visitLocalVariable("dmg", "I", null, l7, l3, 1);
        mv.visitLocalVariable("essentia", "I", null, l10, l18, 2);
        mv.visitLocalVariable("essentia", "I", null, l24, l33, 1);
        mv.visitLocalVariable("dmg", "I", null, l25, l33, 2);
        mv.visitMaxs(9, 3);
        mv.visitEnd();
        didInject = true;
        Preloader_Logger.LOG("Thaumic Tinkerer RepairItem Patch", Level.INFO, "Method injection complete. " + (obfuscated ? "Obfuscated" : "Non-Obfuscated"));
        return didInject;
    }

    static {
        repairTConTools = false;
    }

    public class AddAdapter
    extends ClassVisitor {
        private final String[] aMethodsToStrip;
        public boolean isObfuscated;

        public AddAdapter(ClassVisitor cv) {
            super(327680, cv);
            this.aMethodsToStrip = new String[]{"updateEntity", "func_145845_h"};
            this.isObfuscated = false;
            this.cv = cv;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            boolean found = false;
            for (String s : this.aMethodsToStrip) {
                if (!name.equals(s)) continue;
                found = true;
                if (!s.equals(this.aMethodsToStrip[1])) break;
                this.isObfuscated = true;
                break;
            }
            MethodVisitor methodVisitor = !found ? super.visitMethod(access, name, desc, signature, exceptions) : null;
            if (found) {
                Preloader_Logger.LOG("Thaumic Tinkerer RepairItem Patch", Level.INFO, "Found method " + name + ", removing.");
            }
            return methodVisitor;
        }
    }
}

