/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.asm.transformers;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import gregtech.api.enums.GT_Values;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.lang.reflect.Method;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassTransformer_Railcraft_InvTools {
    private final boolean isValid;
    private final ClassReader reader;
    private final ClassWriter writer;
    private boolean obfuscated = true;

    public static ItemStack depleteItem(ItemStack stack) {
        if (stack == null) {
            return GT_Values.NI;
        }
        if (stack.field_77994_a == 0) {
            return GT_Values.NI;
        }
        if (stack.field_77994_a == 1) {
            ItemStack container = stack.func_77973_b().getContainerItem(stack);
            if (container != null) {
                return container;
            }
            return GT_Values.NI;
        }
        return ItemUtils.depleteStack(stack);
    }

    public ClassTransformer_Railcraft_InvTools(byte[] basicClass, boolean obfuscated2) {
        ClassReader aTempReader = null;
        ClassWriter aTempWriter = null;
        boolean devEnv = false;
        boolean a1 = false;
        boolean a2 = false;
        try {
            Method aGetStackInSlot = IInventory.class.getDeclaredMethod("getStackInSlot", Integer.TYPE);
            if (aGetStackInSlot != null) {
                a1 = true;
            }
        }
        catch (NoSuchMethodException | SecurityException aGetStackInSlot) {
            // empty catch block
        }
        try {
            Method aGetStackInSlotObf = IInventory.class.getDeclaredMethod("func_70301_a", Integer.TYPE);
            if (aGetStackInSlotObf != null) {
                a2 = true;
            }
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        devEnv = a1 ? false : a2;
        if (!this.obfuscated || devEnv) {
            // empty if block
        }
        FMLRelaunchLog.log((String)"[GT++ ASM] Railcraft negative ItemStack Fix", (Level)Level.INFO, (String)("Are we patching obfuscated method? " + this.obfuscated), (Object[])new Object[0]);
        aTempReader = new ClassReader(basicClass);
        aTempWriter = new ClassWriter(aTempReader, 2);
        aTempReader.accept((ClassVisitor)new AddFieldAdapter((ClassVisitor)aTempWriter), 0);
        this.injectMethod("depleteItem", aTempWriter, this.obfuscated);
        this.isValid = aTempReader != null && aTempWriter != null;
        FMLRelaunchLog.log((String)"[GT++ ASM] Railcraft negative ItemStack Fix", (Level)Level.INFO, (String)("Valid? " + this.isValid + "."), (Object[])new Object[0]);
        this.reader = aTempReader;
        this.writer = aTempWriter;
    }

    public boolean isValidTransformer() {
        return this.isValid;
    }

    public ClassReader getReader() {
        return this.reader;
    }

    public ClassWriter getWriter() {
        return this.writer;
    }

    public boolean injectMethod(String aMethodName, ClassWriter cw, boolean obfuscated) {
        boolean didInject = false;
        FMLRelaunchLog.log((String)"[GT++ ASM] Railcraft negative ItemStack Fix", (Level)Level.INFO, (String)("Injecting " + aMethodName + "."), (Object[])new Object[0]);
        if (aMethodName.equals("depleteItem") && !obfuscated) {
            MethodVisitor mv = cw.visitMethod(9, "depleteItem", "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(36, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "gtPlusPlus/preloader/asm/transformers/ClassTransformer_Railcraft_InvTools", "depleteItem", "(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;", false);
            mv.visitInsn(176);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("stack", "Lnet/minecraft/item/ItemStack;", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            didInject = true;
        } else if (aMethodName.equals("depleteItem") && obfuscated) {
            MethodVisitor mv = cw.visitMethod(9, "depleteItem", "(Ladd;)Ladd;", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(36, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "gtPlusPlus/preloader/asm/transformers/ClassTransformer_Railcraft_InvTools", "depleteItem", "(Ladd;)Ladd;", false);
            mv.visitInsn(176);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("stack", "Ladd;", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            didInject = true;
        }
        FMLRelaunchLog.log((String)"[GT++ ASM] Railcraft negative ItemStack Fix", (Level)Level.INFO, (String)("Method injection complete. " + (obfuscated ? "Obfuscated" : "Non-Obfuscated")), (Object[])new Object[0]);
        return didInject;
    }

    public class AddFieldAdapter
    extends ClassVisitor {
        private final String[] aMethodsToStrip;

        public AddFieldAdapter(ClassVisitor cv) {
            super(327680, cv);
            this.aMethodsToStrip = new String[]{"depleteItem"};
            this.cv = cv;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor methodVisitor;
            boolean found = false;
            for (String s : this.aMethodsToStrip) {
                if (!name.equals(s)) continue;
                found = true;
                break;
            }
            if (!found) {
                methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            } else {
                if (desc.equals("(Lnet/minecraft/item/ItemStack;)Lnet/minecraft/item/ItemStack;")) {
                    ClassTransformer_Railcraft_InvTools.this.obfuscated = false;
                } else if (desc.equals("(Ladd;)Ladd;")) {
                    ClassTransformer_Railcraft_InvTools.this.obfuscated = true;
                } else {
                    ClassTransformer_Railcraft_InvTools.this.obfuscated = false;
                }
                FMLRelaunchLog.log((String)"[GT++ ASM] Railcraft negative ItemStack Fix", (Level)Level.INFO, (String)("Method desc " + desc + ", using " + (ClassTransformer_Railcraft_InvTools.this.obfuscated ? "obfuscated method handler" : "deobfuscated method handler")), (Object[])new Object[0]);
                methodVisitor = null;
            }
            if (found) {
                FMLRelaunchLog.log((String)"[GT++ ASM] Railcraft negative ItemStack Fix", (Level)Level.INFO, (String)("Found method " + name + ", removing."), (Object[])new Object[0]);
            }
            return methodVisitor;
        }
    }
}

