/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.asm.transformers;

import gtPlusPlus.core.util.Utils;
import gtPlusPlus.preloader.Preloader_Logger;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassTransformer_GT_Utility {
    private final boolean isValid;
    private final ClassReader reader;
    private final ClassWriter writer;
    private final String className;

    public ClassTransformer_GT_Utility(byte[] basicClass, String aClassName) {
        this.className = aClassName;
        ClassReader aTempReader = null;
        ClassWriter aTempWriter = null;
        aTempReader = new ClassReader(basicClass);
        aTempWriter = new ClassWriter(aTempReader, 2);
        aTempReader.accept((ClassVisitor)new localClassVisitor((ClassVisitor)aTempWriter, this.className), 0);
        this.isValid = aTempReader != null && aTempWriter != null;
        Preloader_Logger.LOG("Gregtech Utilities Patch", Level.INFO, "Valid patch? " + this.isValid + ".");
        this.reader = aTempReader;
        this.writer = aTempWriter;
        if (this.reader != null && this.writer != null) {
            Preloader_Logger.LOG("Gregtech Utilities Patch", Level.INFO, "Attempting Method Injection.");
            this.injectMethod("getTier");
            this.injectMethod("applyRadioactivity");
            this.injectMethod("isWearingFullFrostHazmat");
            this.injectMethod("isWearingFullHeatHazmat");
            this.injectMethod("isWearingFullBioHazmat");
            this.injectMethod("isWearingFullRadioHazmat");
            this.injectMethod("isWearingFullElectroHazmat");
            this.injectMethod("isWearingFullGasHazmat");
        }
    }

    public boolean isValidTransformer() {
        return this.isValid;
    }

    public ClassReader getReader() {
        return this.reader;
    }

    public ClassWriter getWriter() {
        return this.writer;
    }

    public boolean injectMethod(String aMethodName) {
        Label l1;
        Label l0;
        MethodVisitor mv;
        boolean didInject = false;
        ClassWriter cw = this.getWriter();
        String aClassNameFormatted = Utils.class.getName().replace(".", "/");
        if (aMethodName.equals("isWearingFullFrostHazmat")) {
            Preloader_Logger.LOG("Gregtech Utilities Patch", Level.INFO, "Injecting " + aMethodName + ".");
            mv = cw.visitMethod(9, "isWearingFullFrostHazmat", "(Lnet/minecraft/entity/EntityLivingBase;)Z", null, null);
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(1273, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "gtPlusPlus/core/util/minecraft/EntityUtils", "isWearingFullFrostHazmat", "(Lnet/minecraft/entity/EntityLivingBase;)Z", false);
            mv.visitInsn(172);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("aEntity", "Lnet/minecraft/entity/EntityLivingBase;", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            didInject = true;
        }
        if (aMethodName.equals("isWearingFullHeatHazmat")) {
            Preloader_Logger.LOG("Gregtech Utilities Patch", Level.INFO, "Injecting " + aMethodName + ".");
            mv = cw.visitMethod(9, "isWearingFullHeatHazmat", "(Lnet/minecraft/entity/EntityLivingBase;)Z", null, null);
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(1277, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "gtPlusPlus/core/util/minecraft/EntityUtils", "isWearingFullHeatHazmat", "(Lnet/minecraft/entity/EntityLivingBase;)Z", false);
            mv.visitInsn(172);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("aEntity", "Lnet/minecraft/entity/EntityLivingBase;", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            didInject = true;
        }
        if (aMethodName.equals("isWearingFullBioHazmat")) {
            Preloader_Logger.LOG("Gregtech Utilities Patch", Level.INFO, "Injecting " + aMethodName + ".");
            mv = cw.visitMethod(9, "isWearingFullBioHazmat", "(Lnet/minecraft/entity/EntityLivingBase;)Z", null, null);
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(1281, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "gtPlusPlus/core/util/minecraft/EntityUtils", "isWearingFullBioHazmat", "(Lnet/minecraft/entity/EntityLivingBase;)Z", false);
            mv.visitInsn(172);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("aEntity", "Lnet/minecraft/entity/EntityLivingBase;", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            didInject = true;
        }
        if (aMethodName.equals("isWearingFullRadioHazmat")) {
            Preloader_Logger.LOG("Gregtech Utilities Patch", Level.INFO, "Injecting " + aMethodName + ".");
            mv = cw.visitMethod(9, "isWearingFullRadioHazmat", "(Lnet/minecraft/entity/EntityLivingBase;)Z", null, null);
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(1285, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "gtPlusPlus/core/util/minecraft/EntityUtils", "isWearingFullRadioHazmat", "(Lnet/minecraft/entity/EntityLivingBase;)Z", false);
            mv.visitInsn(172);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("aEntity", "Lnet/minecraft/entity/EntityLivingBase;", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            didInject = true;
        }
        if (aMethodName.equals("isWearingFullElectroHazmat")) {
            Preloader_Logger.LOG("Gregtech Utilities Patch", Level.INFO, "Injecting " + aMethodName + ".");
            mv = cw.visitMethod(9, "isWearingFullElectroHazmat", "(Lnet/minecraft/entity/EntityLivingBase;)Z", null, null);
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(1289, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "gtPlusPlus/core/util/minecraft/EntityUtils", "isWearingFullElectroHazmat", "(Lnet/minecraft/entity/EntityLivingBase;)Z", false);
            mv.visitInsn(172);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("aEntity", "Lnet/minecraft/entity/EntityLivingBase;", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            didInject = true;
        }
        if (aMethodName.equals("isWearingFullGasHazmat")) {
            Preloader_Logger.LOG("Gregtech Utilities Patch", Level.INFO, "Injecting " + aMethodName + ".");
            mv = cw.visitMethod(9, "isWearingFullGasHazmat", "(Lnet/minecraft/entity/EntityLivingBase;)Z", null, null);
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(1293, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(184, "gtPlusPlus/core/util/minecraft/EntityUtils", "isWearingFullGasHazmat", "(Lnet/minecraft/entity/EntityLivingBase;)Z", false);
            mv.visitInsn(172);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("aEntity", "Lnet/minecraft/entity/EntityLivingBase;", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            didInject = true;
        }
        if (aMethodName.equals("getTier")) {
            Preloader_Logger.LOG("Gregtech Utilities Patch", Level.INFO, "Injecting " + aMethodName + ", static replacement call to " + aClassNameFormatted + ".");
            mv = cw.visitMethod(9, "getTier", "(J)B", null, null);
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(23, l0);
            mv.visitVarInsn(22, 0);
            mv.visitMethodInsn(184, aClassNameFormatted, "getTier", "(J)B", false);
            mv.visitInsn(172);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("l", "J", null, l0, l1, 0);
            mv.visitMaxs(2, 2);
            mv.visitEnd();
            didInject = true;
        }
        if (aMethodName.equals("applyRadioactivity")) {
            Preloader_Logger.LOG("Gregtech Utilities Patch", Level.INFO, "Injecting " + aMethodName + ".");
            mv = cw.visitMethod(9, "applyRadioactivity", "(Lnet/minecraft/entity/EntityLivingBase;II)Z", null, null);
            mv.visitCode();
            l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(1342, l0);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(21, 1);
            mv.visitVarInsn(21, 2);
            mv.visitMethodInsn(184, "gtPlusPlus/core/util/minecraft/EntityUtils", "applyRadioactivity", "(Lnet/minecraft/entity/EntityLivingBase;II)Z", false);
            mv.visitInsn(172);
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("aEntity", "Lnet/minecraft/entity/EntityLivingBase;", null, l0, l1, 0);
            mv.visitLocalVariable("aLevel", "I", null, l0, l1, 1);
            mv.visitLocalVariable("aAmountOfItems", "I", null, l0, l1, 2);
            mv.visitMaxs(3, 3);
            mv.visitEnd();
            didInject = true;
        }
        Preloader_Logger.LOG("Gregtech Utilities Patch", Level.INFO, "Method injection complete.");
        return didInject;
    }

    public final class localClassVisitor
    extends ClassVisitor {
        String aClassName;

        public localClassVisitor(ClassVisitor cv, String aName) {
            super(327680, cv);
            this.aClassName = aName;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor methodVisitor = name.equals("getTier") ? null : (name.equals("applyRadioactivity") ? null : (name.equals("isWearingFullFrostHazmat") ? null : (name.equals("isWearingFullHeatHazmat") ? null : (name.equals("isWearingFullBioHazmat") ? null : (name.equals("isWearingFullRadioHazmat") ? null : (name.equals("isWearingFullElectroHazmat") ? null : (name.equals("isWearingFullGasHazmat") ? null : super.visitMethod(access, name, desc, signature, exceptions))))))));
            if (methodVisitor == null) {
                Preloader_Logger.LOG("Gregtech Utilities Patch", Level.INFO, "Found method " + name + ", removing.");
                Preloader_Logger.LOG("Gregtech Utilities Patch", Level.INFO, "Descriptor: " + desc);
            }
            return methodVisitor;
        }
    }
}

