/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.asm.transformers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.reflect.ClassPath;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import gregtech.api.GregTech_API;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_PlayedSound;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.xmod.gregtech.common.StaticFields59;
import gtPlusPlus.xmod.gregtech.loaders.misc.AssLineAchievements;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatFileWriter;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassTransformer_GT_Client {
    private final boolean valid;
    private final ClassReader read;
    private final ClassWriter write;
    private boolean mModern = true;
    private boolean mObfuscated = true;
    private byte[] mTooledClass;
    private static final Map<UUID, Long> aTimeMap = new HashMap<UUID, Long>();

    public ClassTransformer_GT_Client(byte[] basicClass, boolean obfuscated) {
        ClassReader aTempReader = null;
        ClassWriter aTempWriter = null;
        this.mObfuscated = obfuscated;
        aTempReader = new ClassReader(basicClass);
        aTempWriter = new ClassWriter(aTempReader, 2);
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Client Proxy Patch", (Level)Level.INFO, (String)"Fixing Issues in vanilla GT.", (Object[])new Object[0]);
        if (this.mModern) {
            aTempReader.accept((ClassVisitor)new MethodAdaptor2((ClassVisitor)aTempWriter), 0);
            this.injectMethod(aTempWriter, "onPostLoad");
            if (aTempReader != null && aTempWriter != null) {
                this.valid = true;
                this.mTooledClass = aTempWriter.toByteArray();
            } else {
                this.valid = false;
            }
        } else {
            this.mTooledClass = basicClass;
            this.valid = true;
        }
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Client Proxy Patch", (Level)Level.INFO, (String)("Valid? " + this.valid + "."), (Object[])new Object[0]);
        this.read = aTempReader;
        this.write = aTempWriter;
    }

    public boolean isValidTransformer() {
        return this.valid;
    }

    public ClassReader getReader() {
        return this.read;
    }

    public ClassWriter getWriter() {
        return this.write;
    }

    public boolean findAssemblyLineClass() {
        ClassLoader cl = this.getClass().getClassLoader();
        try {
            ImmutableSet classesInPackage = ClassPath.from((ClassLoader)cl).getTopLevelClassesRecursive("gregtech");
            if (classesInPackage != null && classesInPackage.size() > 0) {
                for (ClassPath.ClassInfo x : classesInPackage) {
                    if (!x.getResourceName().contains("GT_MetaTileEntity_AssemblyLine")) continue;
                    FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Client Proxy Patch", (Level)Level.INFO, (String)("Patchable class | " + x.getResourceName()), (Object[])new Object[0]);
                    return true;
                }
            }
        }
        catch (IOException classesInPackage) {
            // empty catch block
        }
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Client Proxy Patch", (Level)Level.INFO, (String)"Failed to find Gregtech classes using prefered method, using backup.", (Object[])new Object[0]);
        cl = ClassLoader.getSystemClassLoader();
        ImmutableMap<File, ClassLoader> g = ClassTransformer_GT_Client.getClassPathEntries(cl);
        File aGregtech = null;
        if (g.size() > 0) {
            for (int i = 0; i < g.size(); ++i) {
                try {
                    File aF = (File)g.keySet().asList().get(i);
                    String aName = aF.getName();
                    if (aName == null || aName.length() <= 0 || !aName.toLowerCase().contains("gregtech")) continue;
                    FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Client Proxy Patch", (Level)Level.INFO, (String)("Patchable class | " + aName), (Object[])new Object[0]);
                    aGregtech = aF;
                    continue;
                }
                catch (Throwable aF) {
                    // empty catch block
                }
            }
        }
        if (aGregtech != null) {
            File file = aGregtech;
            try {
                JarEntry je;
                FileInputStream fis = new FileInputStream(file);
                JarInputStream jis = new JarInputStream(fis);
                System.out.println(jis.markSupported());
                while ((je = jis.getNextJarEntry()) != null) {
                    if (!je.getName().contains("GT_MetaTileEntity_AssemblyLine")) continue;
                    FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Client Proxy Patch", (Level)Level.INFO, (String)("Patchable class | " + je.getName()), (Object[])new Object[0]);
                    jis.close();
                    return true;
                }
                if (jis != null) {
                    jis.close();
                }
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Client Proxy Patch", (Level)Level.INFO, (String)"Failed to find Gregtech classes using backup method, probably using GT 5.08", (Object[])new Object[0]);
        return false;
    }

    static ImmutableMap<File, ClassLoader> getClassPathEntries(ClassLoader classloader) {
        LinkedHashMap entries = Maps.newLinkedHashMap();
        ClassLoader parent = classloader.getParent();
        if (parent != null) {
            entries.putAll(ClassTransformer_GT_Client.getClassPathEntries(parent));
        }
        if (classloader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classloader;
            for (URL entry : urlClassLoader.getURLs()) {
                File file;
                if (!entry.getProtocol().equals("file") || entries.containsKey(file = new File(entry.getFile()))) continue;
                entries.put(file, classloader);
            }
        }
        return ImmutableMap.copyOf((Map)entries);
    }

    public boolean injectMethod(ClassWriter cw, String string) {
        boolean didInject = false;
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Client Proxy Patch", (Level)Level.INFO, (String)("Injecting " + string + ". Obfuscated? " + this.mObfuscated), (Object[])new Object[0]);
        if (string.equals("onPlayerTickEventClient")) {
            MethodVisitor mv = cw.visitMethod(1, "onPlayerTickEventClient", "(Lcpw/mods/fml/common/gameevent/TickEvent$PlayerTickEvent;)V", null, null);
            AnnotationVisitor av0 = mv.visitAnnotation("Lcpw/mods/fml/common/eventhandler/SubscribeEvent;", true);
            av0.visitEnd();
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(371, l0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "gtPlusPlus/preloader/asm/transformers/ClassTransformer_GT_Client", "onPlayerTickEventClient", "(Lcpw/mods/fml/common/gameevent/TickEvent$PlayerTickEvent;)V", false);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLineNumber(372, l1);
            mv.visitInsn(177);
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitLocalVariable("this", "Lgregtech/common/GT_Client;", null, l0, l2, 0);
            mv.visitLocalVariable("aEvent", "Lcpw/mods/fml/common/gameevent/TickEvent$PlayerTickEvent;", null, l0, l2, 1);
            mv.visitMaxs(1, 2);
            mv.visitEnd();
            didInject = true;
        } else if (string.equals("onPostLoad")) {
            MethodVisitor mv = cw.visitMethod(1, "onPostLoad", "()V", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(315, l0);
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, "gregtech/common/GT_Proxy", "onPostLoad", "()V", false);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLineNumber(316, l1);
            mv.visitMethodInsn(184, "gtPlusPlus/preloader/asm/transformers/ClassTransformer_GT_Client", "onPostLoad", "()V", false);
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitLineNumber(317, l2);
            mv.visitInsn(177);
            Label l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLocalVariable("this", "Lgregtech/common/GT_Client;", null, l0, l3, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            didInject = true;
        }
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Client Proxy Patch", (Level)Level.INFO, (String)"Method injection complete.", (Object[])new Object[0]);
        return didInject;
    }

    public byte[] getByteArray() {
        if (this.mTooledClass != null) {
            return this.mTooledClass;
        }
        return this.getWriter().toByteArray();
    }

    public static void onPlayerTickEventClient(TickEvent.PlayerTickEvent aEvent) {
        if (aEvent.side.isClient() && aEvent.phase == TickEvent.Phase.END && !aEvent.player.field_70128_L) {
            long aTime = 0L;
            if (aTimeMap.get(aEvent.player.func_110124_au()) == null) {
                aTimeMap.put(aEvent.player.func_110124_au(), 0L);
            } else {
                aTime = aTimeMap.get(aEvent.player.func_110124_au()) + 1L;
                aTimeMap.put(aEvent.player.func_110124_au(), aTime);
            }
            if (aTime >= 100L) {
                aTimeMap.put(aEvent.player.func_110124_au(), 0L);
                if (StaticFields59.mAssLineVisualMapNEI != null) {
                    StatFileWriter tList = Minecraft.func_71410_x().field_71439_g.func_146107_m();
                    try {
                        GT_Recipe.GT_Recipe_Map aAssLineNei = (GT_Recipe.GT_Recipe_Map)StaticFields59.mAssLineVisualMapNEI.get(null);
                        for (GT_Recipe aFakeAssLineRecipe : aAssLineNei.mRecipeList) {
                            String aSafeUnlocalName;
                            if (aFakeAssLineRecipe.getOutput(0) == null) {
                                Logger.INFO("Someone tried to register an achievement for a recipe with null output. Please report this to Alkalus.");
                                continue;
                            }
                            ItemStack aStack = aFakeAssLineRecipe.getOutput(0);
                            try {
                                aSafeUnlocalName = aStack.func_77977_a();
                            }
                            catch (Throwable t) {
                                aSafeUnlocalName = ItemUtils.getUnlocalizedItemName(aStack);
                            }
                            boolean aHidden = true;
                            try {
                                aHidden = tList.func_77443_a(AssLineAchievements.getAchievement(aSafeUnlocalName));
                                Logger.INFO("Found achievement for " + aSafeUnlocalName);
                            }
                            catch (NullPointerException rrr) {
                                aHidden = true;
                            }
                            aFakeAssLineRecipe.mHidden = !aHidden;
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException exception) {
                        // empty catch block
                    }
                }
            }
            ArrayList arg5 = new ArrayList();
            for (Map.Entry entry : GT_Utility.sPlayedSoundMap.entrySet()) {
                if ((Integer)entry.getValue() < 0) {
                    arg5.add(entry.getKey());
                    continue;
                }
                entry.setValue((Integer)entry.getValue() - 1);
            }
            for (GT_PlayedSound arg6 : arg5) {
                GT_Utility.sPlayedSoundMap.remove(arg6);
            }
            if (!GregTech_API.mServerStarted) {
                GregTech_API.mServerStarted = true;
            }
        }
    }

    public static void onPostLoad() {
        try {
            for (int i = 0; i < GregTech_API.METATILEENTITIES.length; ++i) {
                try {
                    if (GregTech_API.METATILEENTITIES[i] == null) continue;
                    GregTech_API.METATILEENTITIES[i].getStackForm(1L).func_82840_a((EntityPlayer)null, true);
                    continue;
                }
                catch (Throwable t) {
                    GT_Log.err.println("Error in MetaTileEntity with ID of " + i);
                    t.printStackTrace(GT_Log.err);
                }
            }
        }
        catch (Throwable var2) {
            var2.printStackTrace();
        }
    }

    public class MethodAdaptor2
    extends ClassVisitor {
        public MethodAdaptor2(ClassVisitor cv) {
            super(327680, cv);
            this.cv = cv;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor methodVisitor;
            if (name.equals("onPostLoad")) {
                FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Client Proxy Patch", (Level)Level.INFO, (String)("Found method " + name + ", removing."), (Object[])new Object[0]);
                methodVisitor = null;
            } else {
                methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            }
            return methodVisitor;
        }
    }
}

