/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.asm.transformers;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassTransformer_GT_CharcoalPit {
    private final boolean isValid;
    private final ClassReader reader;
    private final ClassWriter writer;

    public static boolean isWoodLog(Block log) {
        return ClassTransformer_GT_CharcoalPit.isWoodLog(log, Short.MAX_VALUE);
    }

    public static boolean isWoodLog(Block log, int meta) {
        ItemStack aLogStack = ItemUtils.getSimpleStack(log, meta, 1);
        ArrayList aData = OrePrefixes.log.mPrefixedItems;
        for (ItemStack aStack : aData) {
            if (!GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)aLogStack)) continue;
            return true;
        }
        aData.clear();
        aData = OreDictionary.getOres((String)"logWood");
        for (ItemStack aStack : aData) {
            if (!GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)aLogStack)) continue;
            return true;
        }
        return false;
    }

    public ClassTransformer_GT_CharcoalPit(byte[] basicClass, boolean obfuscated) {
        ClassReader aTempReader = null;
        ClassWriter aTempWriter = null;
        boolean aBadTime = false;
        if (ReflectionUtils.doesClassExist("aji")) {
            obfuscated = true;
        } else if (ReflectionUtils.doesClassExist("net.minecraft.block.Block")) {
            obfuscated = false;
        } else {
            FMLRelaunchLog.log((String)"[GT++ ASM] GT Charcoal Pit Fix", (Level)Level.INFO, (String)"Unable to find Block.class/aji.class, this is BAD. Not Patching.", (Object[])new Object[0]);
        }
        aTempReader = new ClassReader(basicClass);
        aTempWriter = new ClassWriter(aTempReader, 2);
        if (!aBadTime) {
            aTempReader.accept((ClassVisitor)new CustomClassVisitor((ClassVisitor)aTempWriter), 0);
            this.injectMethod("isWoodLog", obfuscated, aTempWriter);
            this.isValid = aTempReader != null && aTempWriter != null;
        } else {
            this.isValid = false;
        }
        FMLRelaunchLog.log((String)"[GT++ ASM] GT Charcoal Pit Fix", (Level)Level.INFO, (String)("Valid? " + this.isValid + "."), (Object[])new Object[0]);
        this.reader = aTempReader;
        this.writer = aTempWriter;
    }

    public boolean isValidTransformer() {
        return this.isValid;
    }

    public ClassReader getReader() {
        return this.reader;
    }

    public ClassWriter getWriter() {
        return this.writer;
    }

    public boolean injectMethod(String aMethodName, boolean obfuscated, ClassWriter cw) {
        boolean didInject = false;
        FMLRelaunchLog.log((String)"[GT++ ASM] GT Charcoal Pit Fix", (Level)Level.INFO, (String)("Injecting " + aMethodName + "."), (Object[])new Object[0]);
        String aBlockClassName = "net/minecraft/block/Block";
        if (obfuscated) {
            aBlockClassName = "aji";
        }
        if (aMethodName.equals("isWoodLog")) {
            MethodVisitor mv = cw.visitMethod(1, "isWoodLog", "(L" + aBlockClassName + ";)Z", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(197, l0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(184, "gtPlusPlus/preloader/asm/transformers/ClassTransformer_GT_CharcoalPit", "isWoodLog", "(L" + aBlockClassName + ";)Z", false);
            mv.visitInsn(172);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "Lgregtech/common/tileentities/machines/multi/GT_MetaTileEntity_Charcoal_Pit;", null, l0, l1, 0);
            mv.visitLocalVariable("log", "L" + aBlockClassName + ";", null, l0, l1, 1);
            mv.visitMaxs(1, 2);
            mv.visitEnd();
            mv = cw.visitMethod(1, "isWoodLog", "(L" + aBlockClassName + ";I)Z", null, null);
            mv.visitCode();
            Label label0 = new Label();
            mv.visitLabel(label0);
            mv.visitLineNumber(201, label0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitMethodInsn(184, "gtPlusPlus/preloader/asm/transformers/ClassTransformer_GT_CharcoalPit", "isWoodLog", "(L" + aBlockClassName + ";I)Z", false);
            mv.visitInsn(172);
            Label label1 = new Label();
            mv.visitLabel(label1);
            mv.visitLocalVariable("this", "Lgregtech/common/tileentities/machines/multi/GT_MetaTileEntity_Charcoal_Pit;", null, label0, label1, 0);
            mv.visitLocalVariable("log", "L" + aBlockClassName + ";", null, label0, label1, 1);
            mv.visitLocalVariable("meta", "I", null, label0, label1, 2);
            mv.visitMaxs(2, 3);
            mv.visitEnd();
            didInject = true;
        }
        FMLRelaunchLog.log((String)"[GT++ ASM] GT Charcoal Pit Fix", (Level)Level.INFO, (String)"Method injection complete.", (Object[])new Object[0]);
        return didInject;
    }

    public class CustomClassVisitor
    extends ClassVisitor {
        private final String[] aMethodsToStrip;

        public CustomClassVisitor(ClassVisitor cv) {
            super(327680, cv);
            this.aMethodsToStrip = new String[]{"isWoodLog"};
            this.cv = cv;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            boolean found = false;
            for (String s : this.aMethodsToStrip) {
                if (!name.equals(s)) continue;
                found = true;
                break;
            }
            MethodVisitor methodVisitor = !found ? super.visitMethod(access, name, desc, signature, exceptions) : null;
            if (found) {
                FMLRelaunchLog.log((String)"[GT++ ASM] GT Charcoal Pit Fix", (Level)Level.INFO, (String)("Found method " + name + ", removing."), (Object[])new Object[0]);
            }
            return methodVisitor;
        }
    }
}

