/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.asm.transformers;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.preloader.DevHelper;
import gtPlusPlus.preloader.asm.AsmConfig;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassTransformer_GT_BlockMachines_NBT {
    private static final String className = "gregtech.common.blocks.GT_Block_Machines";
    private final boolean isValid;
    private final ClassReader reader;
    private final ClassWriter writer;
    String aEntityPlayer;
    String aEntityPlayerMP;
    String aWorld;
    public static boolean isNbtPersistencyPatchAlreadyApplied = false;

    public ClassTransformer_GT_BlockMachines_NBT(byte[] basicClass, boolean obfuscated) {
        ClassReader aTempReader = null;
        ClassWriter aTempWriter = null;
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech NBT Persistency Patch", (Level)Level.INFO, (String)"Attempting to patch gregtech.common.blocks.GT_Block_Machines.", (Object[])new Object[0]);
        aTempReader = new ClassReader(basicClass);
        aTempWriter = new ClassWriter(aTempReader, 2);
        aTempReader.accept((ClassVisitor)new localClassVisitor((ClassVisitor)aTempWriter), 0);
        this.isValid = aTempReader != null && aTempWriter != null;
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech NBT Persistency Patch", (Level)Level.INFO, (String)("Valid patch? " + this.isValid + "."), (Object[])new Object[0]);
        this.reader = aTempReader;
        this.writer = aTempWriter;
        CORE.NBT_PERSISTENCY_PATCH_APPLIED = isNbtPersistencyPatchAlreadyApplied;
        if (this.reader != null && this.writer != null && !isNbtPersistencyPatchAlreadyApplied && AsmConfig.enableGtNbtFix) {
            this.aEntityPlayer = obfuscated ? DevHelper.getObfuscated("net/minecraft/entity/player/EntityPlayer") : "net/minecraft/entity/player/EntityPlayer";
            this.aEntityPlayerMP = obfuscated ? DevHelper.getObfuscated("net/minecraft/entity/player/EntityPlayerMP") : "net/minecraft/entity/player/EntityPlayerMP";
            this.aWorld = obfuscated ? DevHelper.getObfuscated("net/minecraft/world/World") : "net/minecraft/world/World";
            FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech NBT Persistency Patch", (Level)Level.INFO, (String)"Attempting Method Injection.", (Object[])new Object[0]);
            if (this.injectMethod("removedByPlayer") && this.injectMethod("harvestBlock")) {
                CORE.NBT_PERSISTENCY_PATCH_APPLIED = true;
            }
        }
    }

    public boolean isValidTransformer() {
        return this.isValid;
    }

    public ClassReader getReader() {
        return this.reader;
    }

    public ClassWriter getWriter() {
        return this.writer;
    }

    public boolean injectMethod(String aMethodName) {
        boolean didInject = false;
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech NBT Persistency Patch", (Level)Level.INFO, (String)("Injecting " + aMethodName + " into " + className + "."), (Object[])new Object[0]);
        if (aMethodName.equals("removedByPlayer")) {
            MethodVisitor mv = this.getWriter().visitMethod(1, "removedByPlayer", "(L" + this.aWorld + ";L" + this.aEntityPlayer + ";IIIZ)Z", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(535, l0);
            mv.visitVarInsn(21, 6);
            Label l1 = new Label();
            mv.visitJumpInsn(153, l1);
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitLineNumber(536, l2);
            mv.visitInsn(4);
            mv.visitInsn(172);
            mv.visitLabel(l1);
            mv.visitLineNumber(538, l1);
            mv.visitFrame(3, 0, null, 0, null);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(21, 3);
            mv.visitVarInsn(21, 4);
            mv.visitVarInsn(21, 5);
            mv.visitInsn(3);
            mv.visitMethodInsn(183, "gregtech/api/items/GT_Generic_Block", "removedByPlayer", "(L" + this.aWorld + ";L" + this.aEntityPlayer + ";IIIZ)Z", false);
            mv.visitInsn(172);
            Label l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLocalVariable("this", "Lgregtech/common/blocks/GT_Block_Machines;", null, l0, l3, 0);
            mv.visitLocalVariable("aWorld", "L" + this.aWorld + ";", null, l0, l3, 1);
            mv.visitLocalVariable("aPlayer", "L" + this.aEntityPlayer + ";", null, l0, l3, 2);
            mv.visitLocalVariable("aX", "I", null, l0, l3, 3);
            mv.visitLocalVariable("aY", "I", null, l0, l3, 4);
            mv.visitLocalVariable("aZ", "I", null, l0, l3, 5);
            mv.visitLocalVariable("aWillHarvest", "Z", null, l0, l3, 6);
            mv.visitMaxs(7, 7);
            mv.visitEnd();
            didInject = true;
        } else if (aMethodName.equals("harvestBlock")) {
            MethodVisitor mv = this.getWriter().visitMethod(1, "harvestBlock", "(L" + this.aWorld + ";L" + this.aEntityPlayer + ";IIII)V", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(544, l0);
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 2);
            mv.visitVarInsn(21, 3);
            mv.visitVarInsn(21, 4);
            mv.visitVarInsn(21, 5);
            mv.visitVarInsn(21, 6);
            mv.visitMethodInsn(183, "gregtech/api/items/GT_Generic_Block", "harvestBlock", "(L" + this.aWorld + ";L" + this.aEntityPlayer + ";IIII)V", false);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLineNumber(545, l1);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 3);
            mv.visitVarInsn(21, 4);
            mv.visitVarInsn(21, 5);
            mv.visitMethodInsn(182, "" + this.aWorld + "", "setBlockToAir", "(III)Z", false);
            mv.visitInsn(87);
            Label l2 = new Label();
            mv.visitLabel(l2);
            mv.visitLineNumber(546, l2);
            mv.visitInsn(177);
            Label l3 = new Label();
            mv.visitLabel(l3);
            mv.visitLocalVariable("this", "Lgregtech/common/blocks/GT_Block_Machines;", null, l0, l3, 0);
            mv.visitLocalVariable("aWorld", "L" + this.aWorld + ";", null, l0, l3, 1);
            mv.visitLocalVariable("aPlayer", "L" + this.aEntityPlayer + ";", null, l0, l3, 2);
            mv.visitLocalVariable("aX", "I", null, l0, l3, 3);
            mv.visitLocalVariable("aY", "I", null, l0, l3, 4);
            mv.visitLocalVariable("aZ", "I", null, l0, l3, 5);
            mv.visitLocalVariable("aMeta", "I", null, l0, l3, 6);
            mv.visitMaxs(7, 7);
            mv.visitEnd();
            didInject = true;
        }
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech NBT Persistency Patch", (Level)Level.INFO, (String)"Method injection complete.", (Object[])new Object[0]);
        return didInject;
    }

    public static final class localClassVisitor
    extends ClassVisitor {
        public localClassVisitor(ClassVisitor cv) {
            super(327680, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (name.equals("removedByPlayer")) {
                FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech NBT Persistency Patch", (Level)Level.INFO, (String)("Found method " + name + ", skipping patch."), (Object[])new Object[0]);
                isNbtPersistencyPatchAlreadyApplied = true;
            }
            if (name.equals("harvestBlock")) {
                FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech NBT Persistency Patch", (Level)Level.INFO, (String)("Found method " + name + ", skipping patch."), (Object[])new Object[0]);
                isNbtPersistencyPatchAlreadyApplied = true;
            }
            MethodVisitor methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            return methodVisitor;
        }
    }
}

