/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.asm.transformers;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import gregtech.api.GregTech_API;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SubTag;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gtPlusPlus.xmod.gregtech.common.Meta_GT_Proxy;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassTransformer_GT_BlockMachines_MetaPipeEntity {
    private final boolean isValid;
    private final ClassReader reader;
    private final ClassWriter writer;
    int mMode;

    public static String getHarvestTool(int aMeta) {
        if (aMeta >= 8 && aMeta <= 11) {
            return "cutter";
        }
        return "wrench";
    }

    public static byte getTileEntityBaseType(Materials mMaterial) {
        byte mMetaID = mMaterial == null ? (byte)4 : (byte)((mMaterial.contains(SubTag.WOOD) ? 4 : 4) + Math.max(0, Math.min(3, mMaterial.mToolQuality)));
        return mMetaID;
    }

    public static TileEntity createTileEntity(World aWorld, int aMeta) {
        if (aMeta < 4) {
            return GregTech_API.constructBaseMetaTileEntity();
        }
        if (aMeta < 12) {
            return new BaseMetaPipeEntity();
        }
        try {
            return Meta_GT_Proxy.constructCustomGregtechMetaTileEntityByMeta(aMeta);
        }
        catch (Throwable c) {
            return new BaseMetaPipeEntity();
        }
    }

    public static TileEntity createTileEntity_Original(World aWorld, int aMeta) {
        if (aMeta < 4) {
            return GregTech_API.constructBaseMetaTileEntity();
        }
        return new BaseMetaPipeEntity();
    }

    public ClassTransformer_GT_BlockMachines_MetaPipeEntity(byte[] basicClass, int aMode) {
        this.mMode = aMode;
        ClassReader aTempReader = null;
        ClassWriter aTempWriter = null;
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech getTileEntityBaseType Patch", (Level)Level.INFO, (String)("Attempting to patch in mode " + aMode + "."), (Object[])new Object[0]);
        aTempReader = new ClassReader(basicClass);
        aTempWriter = new ClassWriter(aTempReader, 2);
        aTempReader.accept((ClassVisitor)new localClassVisitor((ClassVisitor)aTempWriter, this.mMode), 0);
        this.isValid = aTempReader != null && aTempWriter != null;
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech getTileEntityBaseType Patch", (Level)Level.INFO, (String)("Valid patch? " + this.isValid + "."), (Object[])new Object[0]);
        this.reader = aTempReader;
        this.writer = aTempWriter;
        if (this.reader != null && this.writer != null) {
            FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech getTileEntityBaseType Patch", (Level)Level.INFO, (String)"Attempting Method Injection.", (Object[])new Object[0]);
            if (aMode == 0) {
                this.injectMethod("getHarvestTool");
                this.injectMethod("createTileEntity");
            } else {
                this.injectMethod("getTileEntityBaseType");
            }
        }
    }

    public boolean isValidTransformer() {
        return this.isValid;
    }

    public ClassReader getReader() {
        return this.reader;
    }

    public ClassWriter getWriter() {
        return this.writer;
    }

    public boolean injectMethod(String aMethodName) {
        boolean didInject = false;
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech getTileEntityBaseType Patch", (Level)Level.INFO, (String)("Injecting " + aMethodName + "."), (Object[])new Object[0]);
        if (aMethodName.equals("getHarvestTool")) {
            MethodVisitor mv = this.getWriter().visitMethod(1, "getHarvestTool", "(I)Ljava/lang/String;", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(63, l0);
            mv.visitVarInsn(21, 1);
            mv.visitMethodInsn(184, "gtPlusPlus/preloader/asm/transformers/ClassTransformer_GT_BlockMachines_MetaPipeEntity", "getHarvestTool", "(I)Ljava/lang/String;", false);
            mv.visitInsn(176);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "Lgregtech/common/blocks/GT_Block_Machines;", null, l0, l1, 0);
            mv.visitLocalVariable("aMeta", "I", null, l0, l1, 1);
            mv.visitMaxs(1, 2);
            mv.visitEnd();
            didInject = true;
        } else if (aMethodName.equals("createTileEntity")) {
            MethodVisitor mv = this.getWriter().visitMethod(1, "createTileEntity", "(Lnet/minecraft/world/World;I)Lnet/minecraft/tileentity/TileEntity;", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(442, l0);
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(21, 2);
            mv.visitMethodInsn(184, "gtPlusPlus/preloader/asm/transformers/ClassTransformer_GT_BlockMachines_MetaPipeEntity", "createTileEntity", "(Lnet/minecraft/world/World;I)Lnet/minecraft/tileentity/TileEntity;", false);
            mv.visitInsn(176);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "Lgregtech/common/blocks/GT_Block_Machines;", null, l0, l1, 0);
            mv.visitLocalVariable("aWorld", "Lnet/minecraft/world/World;", null, l0, l1, 1);
            mv.visitLocalVariable("aMeta", "I", null, l0, l1, 2);
            mv.visitMaxs(2, 3);
            mv.visitEnd();
            didInject = true;
        } else if (aMethodName.equals("getTileEntityBaseType")) {
            String aClassName = this.mMode == 1 ? "gregtech/api/metatileentity/implementations/GT_MetaPipeEntity_Item" : (this.mMode == 2 ? "gregtech/api/metatileentity/implementations/GT_MetaPipeEntity_Frame" : "gregtech/api/metatileentity/implementations/GT_MetaPipeEntity_Fluid");
            MethodVisitor mv = this.getWriter().visitMethod(1, "getTileEntityBaseType", "()B", null, null);
            mv.visitCode();
            Label l0 = new Label();
            mv.visitLabel(l0);
            mv.visitLineNumber(37, l0);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, "" + aClassName + "", "mMaterial", "Lgregtech/api/enums/Materials;");
            mv.visitMethodInsn(184, "gtPlusPlus/preloader/asm/transformers/ClassTransformer_GT_BlockMachines_MetaPipeEntity", "getTileEntityBaseType", "(Lgregtech/api/enums/Materials;)B", false);
            mv.visitInsn(172);
            Label l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", "L" + aClassName + ";", null, l0, l1, 0);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            didInject = true;
        }
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech getTileEntityBaseType Patch", (Level)Level.INFO, (String)"Method injection complete.", (Object[])new Object[0]);
        return didInject;
    }

    public final class localClassVisitor
    extends ClassVisitor {
        private final int mMode;

        public localClassVisitor(ClassVisitor cv, int aMode) {
            super(327680, cv);
            this.mMode = aMode;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor methodVisitor;
            if (this.mMode == 0 && (name.equals("createTileEntity") || name.equals("getHarvestTool")) || this.mMode > 0 && name.equals("getTileEntityBaseType")) {
                FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech getTileEntityBaseType Patch", (Level)Level.INFO, (String)("Found method " + name + ", removing."), (Object[])new Object[0]);
                methodVisitor = null;
            } else {
                methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            }
            return methodVisitor;
        }
    }
}

