/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader.asm.transformers;

import cpw.mods.fml.relauncher.FMLRelaunchLog;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ClassTransformer_GT_Achievements_CrashFix {
    private final boolean isValid;
    private final ClassReader reader;
    private final ClassWriter writer;
    private final boolean mObfuscated;
    private static boolean mDidRemoveAssLineRecipeAdder = false;

    public ClassTransformer_GT_Achievements_CrashFix(byte[] basicClass, boolean obfuscated) {
        ClassReader aTempReader = null;
        ClassWriter aTempWriter = null;
        this.mObfuscated = obfuscated;
        aTempReader = new ClassReader(basicClass);
        aTempWriter = new ClassWriter(aTempReader, 2);
        aTempReader.accept((ClassVisitor)new MethodAdaptor((ClassVisitor)aTempWriter), 0);
        if (mDidRemoveAssLineRecipeAdder) {
            FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Achievements Patch", (Level)Level.INFO, (String)"Patching GT .09", (Object[])new Object[0]);
            this.injectMethod(aTempWriter);
        } else {
            FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Achievements Patch", (Level)Level.INFO, (String)"Patch not required, skipping.", (Object[])new Object[0]);
        }
        this.isValid = aTempReader != null && aTempWriter != null;
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Achievements Patch", (Level)Level.INFO, (String)("Valid? " + this.isValid + "."), (Object[])new Object[0]);
        this.reader = aTempReader;
        this.writer = aTempWriter;
    }

    public boolean isValidTransformer() {
        return this.isValid;
    }

    public ClassReader getReader() {
        return this.reader;
    }

    public ClassWriter getWriter() {
        return this.writer;
    }

    public boolean injectMethod(ClassWriter cw) {
        boolean didInject = false;
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Achievements Patch", (Level)Level.INFO, (String)("Injecting registerAssAchievement. Obfuscated? " + this.mObfuscated), (Object[])new Object[0]);
        MethodVisitor mv = cw.visitMethod(1, "registerAssAchievement", "(Lgregtech/api/util/GT_Recipe;)Lnet/minecraft/stats/Achievement;", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(293, l0);
        mv.visitVarInsn(25, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(199, l1);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(294, l2);
        mv.visitFieldInsn(178, "gregtech/api/util/GT_Log", "err", "Ljava/io/PrintStream;");
        mv.visitLdcInsn((Object)"GTPP_MOD: Someone tried to register an achievement for an invalid recipe. Please report this to Alkalus.");
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLineNumber(295, l3);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitLabel(l1);
        mv.visitLineNumber(297, l1);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(3);
        mv.visitMethodInsn(182, "gregtech/api/util/GT_Recipe", "getOutput", "(I)Lnet/minecraft/item/ItemStack;", false);
        Label l4 = new Label();
        mv.visitJumpInsn(199, l4);
        Label l5 = new Label();
        mv.visitLabel(l5);
        mv.visitLineNumber(298, l5);
        mv.visitFieldInsn(178, "gregtech/api/util/GT_Log", "err", "Ljava/io/PrintStream;");
        mv.visitLdcInsn((Object)"GTPP_MOD: Someone tried to register an achievement for a recipe with null output. Please report this to Alkalus.");
        mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/String;)V", false);
        Label l6 = new Label();
        mv.visitLabel(l6);
        mv.visitLineNumber(299, l6);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitLabel(l4);
        mv.visitLineNumber(301, l4);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(3);
        mv.visitMethodInsn(182, "gregtech/api/util/GT_Recipe", "getOutput", "(I)Lnet/minecraft/item/ItemStack;", false);
        mv.visitVarInsn(58, 3);
        Label l7 = new Label();
        mv.visitLabel(l7);
        mv.visitLineNumber(302, l7);
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(184, "gtPlusPlus/core/util/minecraft/ItemUtils", "getUnlocalizedItemName", "(Lnet/minecraft/item/ItemStack;)Ljava/lang/String;", false);
        mv.visitVarInsn(58, 2);
        Label l8 = new Label();
        mv.visitLabel(l8);
        mv.visitLineNumber(304, l8);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "gregtech/loaders/misc/GT_Achievements", "achievementList", "Ljava/util/concurrent/ConcurrentHashMap;");
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(182, "java/util/concurrent/ConcurrentHashMap", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
        Label l9 = new Label();
        mv.visitJumpInsn(199, l9);
        Label l10 = new Label();
        mv.visitLabel(l10);
        mv.visitLineNumber(305, l10);
        mv.visitFieldInsn(178, "gregtech/loaders/misc/GT_Achievements", "assReg", "I");
        mv.visitInsn(4);
        mv.visitInsn(96);
        mv.visitFieldInsn(179, "gregtech/loaders/misc/GT_Achievements", "assReg", "I");
        Label l11 = new Label();
        mv.visitLabel(l11);
        mv.visitLineNumber(306, l11);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 2);
        mv.visitIntInsn(16, 11);
        mv.visitFieldInsn(178, "gregtech/loaders/misc/GT_Achievements", "assReg", "I");
        mv.visitInsn(8);
        mv.visitInsn(112);
        mv.visitInsn(96);
        mv.visitInsn(116);
        mv.visitFieldInsn(178, "gregtech/loaders/misc/GT_Achievements", "assReg", "I");
        mv.visitInsn(8);
        mv.visitInsn(108);
        mv.visitIntInsn(16, 8);
        mv.visitInsn(100);
        mv.visitVarInsn(25, 1);
        mv.visitInsn(3);
        mv.visitMethodInsn(182, "gregtech/api/util/GT_Recipe", "getOutput", "(I)Lnet/minecraft/item/ItemStack;", false);
        mv.visitLdcInsn((Object)"NO_REQUIREMENT");
        mv.visitInsn(3);
        mv.visitMethodInsn(182, "gregtech/loaders/misc/GT_Achievements", "registerAchievement", "(Ljava/lang/String;IILnet/minecraft/item/ItemStack;Ljava/lang/String;Z)Lnet/minecraft/stats/Achievement;", false);
        mv.visitVarInsn(58, 4);
        Label l12 = new Label();
        mv.visitLabel(l12);
        mv.visitLineNumber(307, l12);
        Label l13 = new Label();
        mv.visitJumpInsn(167, l13);
        mv.visitLabel(l9);
        mv.visitLineNumber(309, l9);
        mv.visitFrame(1, 2, new Object[]{"java/lang/String", "net/minecraft/item/ItemStack"}, 0, null);
        mv.visitInsn(1);
        mv.visitVarInsn(58, 4);
        mv.visitLabel(l13);
        mv.visitLineNumber(311, l13);
        mv.visitFrame(1, 1, new Object[]{"net/minecraft/stats/Achievement"}, 0, null);
        mv.visitVarInsn(25, 4);
        mv.visitInsn(176);
        Label l14 = new Label();
        mv.visitLabel(l14);
        mv.visitLocalVariable("this", "Lgregtech/loaders/misc/GT_Achievements;", null, l0, l14, 0);
        mv.visitLocalVariable("recipe", "Lgregtech/api/util/GT_Recipe;", null, l0, l14, 1);
        mv.visitLocalVariable("aSafeUnlocalName", "Ljava/lang/String;", null, l8, l14, 2);
        mv.visitLocalVariable("aStack", "Lnet/minecraft/item/ItemStack;", null, l7, l14, 3);
        mv.visitLocalVariable("aYouDidSomethingInGT", "Lnet/minecraft/stats/Achievement;", null, l12, l9, 4);
        mv.visitLocalVariable("aYouDidSomethingInGT", "Lnet/minecraft/stats/Achievement;", null, l13, l14, 4);
        mv.visitMaxs(7, 5);
        mv.visitEnd();
        didInject = true;
        FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Achievements Patch", (Level)Level.INFO, (String)"Method injection complete.", (Object[])new Object[0]);
        return didInject;
    }

    public class MethodAdaptor
    extends ClassVisitor {
        public MethodAdaptor(ClassVisitor cv) {
            super(327680, cv);
            this.cv = cv;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor methodVisitor;
            if (name.equals("registerAssAchievement")) {
                FMLRelaunchLog.log((String)"[GT++ ASM] Gregtech Achievements Patch", (Level)Level.INFO, (String)("Found method " + name + ", removing."), (Object[])new Object[0]);
                methodVisitor = null;
                mDidRemoveAssLineRecipeAdder = true;
            } else {
                methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
            }
            return methodVisitor;
        }
    }
}

