/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.preloader;

import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.HashMap;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class CustomClassLoader
extends ClassLoader {
    private HashMap<String, ClassNode> classes = new HashMap();

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.findClass(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        ClassNode node = this.classes.get(name.replace('.', '/'));
        if (node != null) {
            return this.nodeToClass(node);
        }
        return super.findClass(name);
    }

    public final void addNode(ClassNode node) {
        this.classes.put(node.name, node);
    }

    private final Class<?> nodeToClass(ClassNode node) {
        if (super.findLoadedClass(node.name) != null) {
            return this.findLoadedClass(node.name);
        }
        ClassWriter cw = new ClassWriter(1);
        node.accept((ClassVisitor)cw);
        byte[] b = cw.toByteArray();
        return this.defineClass(node.name.replace('/', '.'), b, 0, b.length, this.getDomain());
    }

    private final ProtectionDomain getDomain() {
        CodeSource code = new CodeSource(null, (Certificate[])null);
        return new ProtectionDomain(code, this.getPermissions());
    }

    private final Permissions getPermissions() {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return permissions;
    }
}

