/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.sulfurchem;

import gregtech.api.enums.Materials;
import gregtech.api.util.GT_Recipe;
import gtPlusPlus.api.interfaces.IPlugin;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.plugin.manager.Core_Manager;
import gtPlusPlus.preloader.CORE_Preloader;
import gtPlusPlus.xmod.gregtech.common.StaticFields59;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class Core_SulfuricChemistry
implements IPlugin {
    static final Core_SulfuricChemistry mInstance;
    private static boolean shouldLoad;
    private static AutoMap<GT_Recipe> mRemovedRecipes1;
    private static AutoMap<GT_Recipe> mRemovedRecipes2;

    @Override
    public boolean preInit() {
        return shouldLoad;
    }

    @Override
    public boolean init() {
        return shouldLoad;
    }

    @Override
    public boolean postInit() {
        if (shouldLoad) {
            try {
                int disabled = this.disableSulfurTrioxide();
                this.log("Disabled " + disabled + " Sulfur Trioxide Chemistry recipes.");
                int disabled2 = this.disableSulfuricAcid();
                this.log("Disabled " + disabled2 + " Sulfuric Acid Chemistry recipes.");
                int addedNew = this.addRevisedGT6Recipes();
                this.log("Added " + addedNew + " new Sulfuric Chemistry recipes.");
                if (CORE.DEVENV || CORE_Preloader.DEBUG_MODE) {
                    for (int i = 0; i < 2; ++i) {
                        int r;
                        String[] mInfo;
                        for (GT_Recipe m : mRemovedRecipes1) {
                            mInfo = RecipeUtils.getRecipeInfo(m);
                            this.log("Removed Recipe");
                            for (r = 0; r < mInfo.length; ++r) {
                                this.log(mInfo[r]);
                            }
                        }
                        for (GT_Recipe m : mRemovedRecipes2) {
                            mInfo = RecipeUtils.getRecipeInfo(m);
                            this.log("Removed Recipe");
                            for (r = 0; r < mInfo.length; ++r) {
                                this.log(mInfo[r]);
                            }
                        }
                    }
                }
                return disabled > 0 && addedNew > 0;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public boolean serverStart() {
        return false;
    }

    @Override
    public boolean serverStop() {
        return false;
    }

    @Override
    public String getPluginName() {
        return "GT++ Revised Sulfuric Chemistry Module";
    }

    public int addRevisedGT6Recipes() {
        String catalyst = "dustPlatinum";
        int mCountAdded = 0;
        if (CORE.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict(catalyst, 0), ItemUtils.getItemStackOfAmountFromOreDict("cellAir", 1), FluidUtils.getFluidStack("sulfurdioxide", 3000), FluidUtils.getFluidStack("sulfurtrioxide", 4000), CI.emptyCells(1), null, 16, 16)) {
            ++mCountAdded;
        }
        if (CORE.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict(catalyst, 0), ItemUtils.getItemStackOfAmountFromOreDict("cellSulfurDioxide", 3), FluidUtils.getFluidStack("air", 1000), FluidUtils.getFluidStack("sulfurtrioxide", 4000), CI.emptyCells(3), null, 16, 16)) {
            ++mCountAdded;
        }
        if (CORE.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict(catalyst, 0), ItemUtils.getItemStackOfAmountFromOreDict("cellOxygen", 1), FluidUtils.getFluidStack("sulfurdioxide", 3000), FluidUtils.getFluidStack("sulfurtrioxide", 4000), CI.emptyCells(1), null, 16, 16)) {
            ++mCountAdded;
        }
        if (CORE.RA.addChemicalRecipe(ItemUtils.getItemStackOfAmountFromOreDict(catalyst, 0), ItemUtils.getItemStackOfAmountFromOreDict("cellSulfurDioxide", 3), FluidUtils.getFluidStack("oxygen", 1000), FluidUtils.getFluidStack("sulfurtrioxide", 4000), CI.emptyCells(3), null, 16, 16)) {
            ++mCountAdded;
        }
        if (CORE.RA.addChemicalRecipe(CI.getNumberedCircuit(22), ItemUtils.getItemStackOfAmountFromOreDict("cellSulfurTrioxide", 1), FluidUtils.getFluidStack("water", 750), Materials.SulfuricAcid.getFluid(1750L), CI.emptyCells(1), null, 20, 20)) {
            ++mCountAdded;
        }
        if (CORE.RA.addChemicalRecipe(CI.getNumberedCircuit(22), ItemUtils.getItemStackOfAmountFromOreDict("cellWater", 3), FluidUtils.getFluidStack("sulfurtrioxide", 4000), Materials.SulfuricAcid.getFluid(7000L), CI.emptyCells(3), null, 20, 20)) {
            ++mCountAdded;
        }
        return mCountAdded;
    }

    public int disableSulfurTrioxide() {
        int mDisabled = 0;
        FluidStack mStack = FluidUtils.getFluidStack("sulfurtrioxide", 1);
        block0: for (GT_Recipe r : GT_Recipe.GT_Recipe_Map.sChemicalRecipes.mRecipeList) {
            for (ItemStack itemStack : r.mOutputs) {
                itemStack.field_77994_a = 1;
                if (!ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("cellSulfurTrioxide", 1))) continue;
                mRemovedRecipes1.put(r);
                r.mEnabled = false;
                r.mHidden = true;
                ++mDisabled;
                continue block0;
            }
            for (ItemStack itemStack : r.mFluidOutputs) {
                itemStack.amount = 1;
                if (!FluidStack.areFluidStackTagsEqual((FluidStack)itemStack, (FluidStack)mStack)) continue;
                mRemovedRecipes1.put(r);
                r.mEnabled = false;
                r.mHidden = true;
                ++mDisabled;
                continue block0;
            }
        }
        if (CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK) {
            block3: for (GT_Recipe r : StaticFields59.getLargeChemicalReactorRecipeMap().mRecipeList) {
                for (ItemStack itemStack : r.mOutputs) {
                    itemStack.field_77994_a = 1;
                    if (!ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("cellSulfurTrioxide", 1))) continue;
                    mRemovedRecipes1.put(r);
                    r.mEnabled = false;
                    r.mHidden = true;
                    ++mDisabled;
                    continue block3;
                }
                for (ItemStack itemStack : r.mFluidOutputs) {
                    itemStack.amount = 1;
                    if (!FluidStack.areFluidStackTagsEqual((FluidStack)itemStack, (FluidStack)mStack)) continue;
                    mRemovedRecipes1.put(r);
                    r.mEnabled = false;
                    r.mHidden = true;
                    ++mDisabled;
                    continue block3;
                }
            }
        }
        return mDisabled;
    }

    public int disableSulfuricAcid() {
        int mDisabled = 0;
        FluidStack mStack = FluidUtils.getFluidStack("sulfuricacid", 1);
        block0: for (GT_Recipe r : GT_Recipe.GT_Recipe_Map.sChemicalRecipes.mRecipeList) {
            for (ItemStack itemStack : r.mOutputs) {
                itemStack.field_77994_a = 1;
                if (!ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("cellSulfuricAcid", 1))) continue;
                mRemovedRecipes2.put(r);
                r.mEnabled = false;
                r.mHidden = true;
                ++mDisabled;
                continue block0;
            }
            for (ItemStack itemStack : r.mFluidOutputs) {
                itemStack.amount = 1;
                if (!FluidStack.areFluidStackTagsEqual((FluidStack)itemStack, (FluidStack)mStack)) continue;
                mRemovedRecipes2.put(r);
                r.mEnabled = false;
                r.mHidden = true;
                ++mDisabled;
                continue block0;
            }
        }
        if (CORE.MAIN_GREGTECH_5U_EXPERIMENTAL_FORK) {
            block3: for (GT_Recipe r : StaticFields59.getLargeChemicalReactorRecipeMap().mRecipeList) {
                for (ItemStack itemStack : r.mOutputs) {
                    itemStack.field_77994_a = 1;
                    if (!ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)ItemUtils.getItemStackOfAmountFromOreDict("cellSulfuricAcid", 1))) continue;
                    mRemovedRecipes2.put(r);
                    r.mEnabled = false;
                    r.mHidden = true;
                    ++mDisabled;
                    continue block3;
                }
                for (ItemStack itemStack : r.mFluidOutputs) {
                    itemStack.amount = 1;
                    if (!FluidStack.areFluidStackTagsEqual((FluidStack)itemStack, (FluidStack)mStack)) continue;
                    mRemovedRecipes2.put(r);
                    r.mEnabled = false;
                    r.mHidden = true;
                    ++mDisabled;
                    continue block3;
                }
            }
        }
        return mDisabled;
    }

    @Override
    public String getPluginAbbreviation() {
        return "RSCM";
    }

    static {
        shouldLoad = false;
        mRemovedRecipes1 = new AutoMap();
        mRemovedRecipes2 = new AutoMap();
        mInstance = new Core_SulfuricChemistry();
        Core_Manager.registerPlugin(mInstance);
        mInstance.log("Preparing " + mInstance.getPluginName() + " for use.");
    }
}

