/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.plugin.agrichem;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_ModHandler;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.item.base.BaseItemComponent;
import gtPlusPlus.core.item.chemistry.AgriculturalChem;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.lib.LoadedMods;
import gtPlusPlus.core.material.ALLOY;
import gtPlusPlus.core.material.MISC_MATERIALS;
import gtPlusPlus.core.recipe.common.CI;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;
import gtPlusPlus.core.util.minecraft.OreDictUtils;
import gtPlusPlus.core.util.minecraft.RecipeUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.plugin.agrichem.block.AgrichemFluids;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.railcraft.utils.RailcraftUtils;
import ic2.core.Ic2Items;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class BioRecipes {
    private static Item mFert;
    private static Item mDustDirt;
    private static Fluid mSalineWater;
    private static Fluid mDistilledWater;
    private static Fluid mThermalWater;
    private static Fluid mAir;
    private static Fluid mSulfuricWasteWater;
    private static Fluid mAmmonia;
    private static Fluid mMethanol;
    private static Fluid mAceticAcid;
    private static Fluid mPropionicAcid;
    private static Fluid mLiquidPlastic;
    private static Fluid mFermentationBase;
    private static Fluid mCarbonDioxide;
    private static Fluid mCarbonMonoxide;
    private static Fluid mEthylene;
    public static Fluid mEthanol;
    private static Fluid mChlorine;
    private static Fluid mHydrogen;
    private static Fluid mDilutedSulfuricAcid;
    private static Fluid mSulfuricAcid;
    private static Fluid mUrea;
    public static Fluid mFormaldehyde;
    private static Fluid mLiquidResin;
    private static Fluid mMethane;
    private static Fluid mBenzene;
    private static Fluid mEthylbenzene;
    private static Fluid mStyrene;
    private static Fluid mButanol;
    private static Fluid mAcetone;
    public static final HashSet<GT_ItemStack> mFruits;
    public static final HashSet<GT_ItemStack> mVege;
    public static final HashSet<GT_ItemStack> mNuts;
    public static final HashSet<GT_ItemStack> mSeeds;
    public static final AutoMap<ItemStack> mList_Master_FruitVege;
    public static final AutoMap<ItemStack> mList_Master_Seeds;

    private static final ItemStack getGreenAlgaeRecipeChip() {
        return BioRecipes.getBioChip(4);
    }

    private static final ItemStack getBrownAlgaeRecipeChip() {
        return BioRecipes.getBioChip(8);
    }

    private static final ItemStack getGoldenBrownAlgaeRecipeChip() {
        return BioRecipes.getBioChip(12);
    }

    private static final ItemStack getRedAlgaeRecipeChip() {
        return BioRecipes.getBioChip(16);
    }

    private static final ItemStack getBioChip(int aID) {
        return ItemUtils.simpleMetaStack(AgriculturalChem.mBioCircuit, aID, 0);
    }

    public static void init() {
        Logger.INFO("[Bio] Setting Variables");
        BioRecipes.initRecipeVars();
        Logger.INFO("[Bio] Generating Biochip Recipes");
        BioRecipes.recipeBioChip();
        Logger.INFO("[Bio] Generating Recipes");
        BioRecipes.recipeAlgaeBiomass();
        Logger.INFO("[Bio] Finished with recipes");
    }

    private static final void initRecipeVars() {
        mFert = AgriculturalChem.dustOrganicFertilizer;
        mDustDirt = AgriculturalChem.dustDirt;
        if (!FluidUtils.doesFluidExist("saltwater")) {
            mSalineWater = FluidUtils.generateFluidNoPrefix("saltwater", "Salt Water", 200, new short[]{10, 30, 220, 100});
        } else {
            FluidStack aWaterStack;
            Materials aSaltWater = MaterialUtils.getMaterial("saltwater");
            if (aSaltWater != null && (aWaterStack = aSaltWater.getFluid(1L)) != null) {
                mSalineWater = aSaltWater.getFluid(1L).getFluid();
            }
            if (mSalineWater == null) {
                mSalineWater = FluidUtils.getWildcardFluidStack("saltwater", 1).getFluid();
            }
            if (ItemUtils.getItemStackOfAmountFromOreDictNoBroken("cellSaltWater", 1) == null) {
                new BaseItemComponent("saltwater", "Salt Water", new short[]{10, 30, 220});
            }
        }
        mDistilledWater = FluidUtils.getDistilledWater(1).getFluid();
        mThermalWater = FluidUtils.getFluidStack("ic2hotwater", 1).getFluid();
        mAir = FluidUtils.getFluidStack("air", 1).getFluid();
        mSulfuricWasteWater = FluidUtils.getFluidStack("sulfuricapatite", 1).getFluid();
        mAmmonia = MISC_MATERIALS.AMMONIA.getFluidStack(1).getFluid();
        mEthylene = FluidUtils.getFluidStack("ethylene", 1).getFluid();
        mEthanol = FluidUtils.getFluidStack("bioethanol", 1).getFluid();
        mDilutedSulfuricAcid = FluidUtils.getFluidStack("dilutedsulfuricacid", 1).getFluid();
        mSulfuricAcid = FluidUtils.getFluidStack("sulfuricacid", 1).getFluid();
        mFormaldehyde = FluidUtils.getFluidStack("fluid.formaldehyde", 1).getFluid();
        mMethane = FluidUtils.getFluidStack("methane", 1).getFluid();
        mBenzene = FluidUtils.getFluidStack("benzene", 1).getFluid();
        mEthylbenzene = FluidUtils.getFluidStack("fluid.ethylbenzene", 1).getFluid();
        mStyrene = FluidUtils.getFluidStack("styrene", 1).getFluid();
        mMethanol = FluidUtils.getFluidStack("methanol", 1).getFluid();
        mLiquidPlastic = FluidUtils.getWildcardFluidStack("plastic", 1).getFluid();
        mCarbonDioxide = MISC_MATERIALS.CARBON_DIOXIDE.getFluidStack(1).getFluid();
        mCarbonMonoxide = MISC_MATERIALS.CARBON_MONOXIDE.getFluidStack(1).getFluid();
        mChlorine = FluidUtils.getFluidStack("chlorine", 1).getFluid();
        mHydrogen = FluidUtils.getFluidStack("hydrogen", 1).getFluid();
        mAceticAcid = AgrichemFluids.mAceticAcid;
        mPropionicAcid = AgrichemFluids.mPropionicAcid;
        mUrea = AgrichemFluids.mUrea;
        mLiquidResin = AgrichemFluids.mLiquidResin;
        mFermentationBase = AgrichemFluids.mFermentationBase;
        mButanol = AgrichemFluids.mButanol;
        mAcetone = AgrichemFluids.mAcetone;
    }

    private static void recipeAlgaeBiomass() {
        BioRecipes.recipeGreenAlgae();
        BioRecipes.recipeBrownAlgae();
        BioRecipes.recipeGoldenBrownAlgae();
        BioRecipes.recipeRedAlgae();
        BioRecipes.recipeWoodPellets();
        BioRecipes.recipeWoodBricks();
        BioRecipes.recipeCellulosePulp();
        BioRecipes.recipeCatalystCarrier();
        BioRecipes.recipeAluminiumSilverCatalyst();
        BioRecipes.recipeAceticAcid();
        BioRecipes.recipePropionicAcid();
        BioRecipes.recipeFermentationBase();
        BioRecipes.recipeEthanol();
        BioRecipes.recipeCelluloseFibre();
        BioRecipes.recipeGoldenBrownCelluloseFiber();
        BioRecipes.recipeRedCelluloseFiber();
        BioRecipes.recipeSodiumHydroxide();
        BioRecipes.recipeSodiumCarbonate();
        BioRecipes.recipePelletMold();
        BioRecipes.recipeAluminiumPellet();
        BioRecipes.recipeAlumina();
        BioRecipes.recipeAluminium();
        BioRecipes.recipeCalciumCarbonate();
        BioRecipes.recipeLithiumChloride();
        BioRecipes.recipeAlginicAcid();
        BioRecipes.recipeSulfuricAcid();
        BioRecipes.recipeUrea();
        BioRecipes.recipeRawBioResin();
        BioRecipes.recipeLiquidResin();
        BioRecipes.recipeCompost();
        BioRecipes.recipeMethane();
        BioRecipes.recipeBenzene();
        BioRecipes.recipeStyrene();
        BioRecipes.registerFuels();
    }

    private static void registerFuels() {
        ItemUtils.registerFuel(ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), 800);
        ItemUtils.registerFuel(ItemUtils.getSimpleStack(AgriculturalChem.mWoodBrick, 1), 4800);
        GT_Values.RA.addFuel(ItemUtils.getItemStackOfAmountFromOreDict("cellButanol", 1), null, 1125, 0);
    }

    private static void recipeGreenAlgae() {
        GT_ModHandler.addPulverisationRecipe((ItemStack)ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 10), (ItemStack)ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 1));
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{BioRecipes.getGreenAlgaeRecipeChip(), ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 30)}, GT_Values.NF, ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 5), 900, 16);
    }

    private static void recipeBrownAlgae() {
        GT_ModHandler.addPulverisationRecipe((ItemStack)ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 10), (ItemStack)ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 1));
        CORE.RA.addExtractorRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 10), ItemUtils.getSimpleStack(AgriculturalChem.mAlginicAcid, 1), 300, 30);
        GT_Values.RA.addBlastRecipe(BioRecipes.getBrownAlgaeRecipeChip(), ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 20), GT_Values.NF, GT_Values.NF, ItemUtils.getSimpleStack(AgriculturalChem.mLithiumChloride, 1), GT_Values.NI, 120, 120, 1200);
        CORE.RA.addChemicalRecipe(BioRecipes.getBrownAlgaeRecipeChip(), ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 20), FluidUtils.getDistilledWater(2000), GT_Values.NF, ItemUtils.getSimpleStack(AgriculturalChem.mSodiumCarbonate, 1), 600, 30);
    }

    private static void recipeGoldenBrownAlgae() {
        GT_ModHandler.addPulverisationRecipe((ItemStack)ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownAlgaeBiosmass, 10), (ItemStack)ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 1));
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{BioRecipes.getGoldenBrownAlgaeRecipeChip(), ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownAlgaeBiosmass, 30)}, GT_Values.NF, ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownCelluloseFiber, 5), 900, 120);
    }

    private static void recipeRedAlgae() {
        GT_ModHandler.addPulverisationRecipe((ItemStack)ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, 10), (ItemStack)ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 1));
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{BioRecipes.getRedAlgaeRecipeChip(), ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, 30)}, GT_Values.NF, ItemUtils.getSimpleStack(AgriculturalChem.mRedCelluloseFiber, 5), 900, 240);
    }

    private static void recipeCelluloseFibre() {
        CORE.RA.addChemicalRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 20), ItemUtils.getSimpleStack(AgriculturalChem.mAlginicAcid, 2), GT_Values.NF, GT_Values.NF, ItemUtils.getSimpleStack(AgriculturalChem.mCellulosePulp, 10), 900, 16);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{BioRecipes.getBioChip(2), ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 12)}, GT_Values.NF, ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 2), 80, 8);
        GT_Values.RA.addFluidExtractionRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 12), GT_Values.NI, FluidUtils.getFluidStack(mMethanol, 50), 10000, 600, 30);
        GT_ModHandler.addPulverisationRecipe((ItemStack)ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 5), (ItemStack)ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 1));
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(16), ItemUtils.getSimpleStack(AgriculturalChem.mCellulosePulp, 64)}, new FluidStack[]{FluidUtils.getFluidStack(mAceticAcid, 500), FluidUtils.getFluidStack(mPropionicAcid, 500)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mLiquidPlastic, 144)}, 2400, 240L, 2);
    }

    private static void recipeWoodPellets() {
        RecipeUtils.addShapelessGregtechRecipe(new ItemStack[]{ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1)}, ItemUtils.getSimpleStack(AgriculturalChem.mWoodBrick, 2));
        GT_Values.RA.addExtruderRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 12), ItemUtils.getSimpleStack(AgriculturalChem.mPelletMold, 0), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 3), 200, 16);
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{BioRecipes.getBioChip(2), ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 8)}, GT_Values.NF, ItemUtils.getSimpleStack(AgriculturalChem.mWoodBrick, 2), 100, 8);
        CORE.RA.addFluidExtractionRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 1), FluidUtils.getFluidStack(mCarbonDioxide, 70), 200, 30);
        if (LoadedMods.Railcraft) {
            RailcraftUtils.addCokeOvenRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 2), true, true, ItemUtils.getItemStackOfAmountFromOreDict("gemCharcoal", 3), GT_Values.NF, 1200);
        }
        CORE.RA.addCokeOvenRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mWoodPellet, 2), BioRecipes.getBioChip(3), null, GT_Values.NF, ItemUtils.getItemStackOfAmountFromOreDict("gemCharcoal", 3), 120, 16);
    }

    private static void recipeWoodBricks() {
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{BioRecipes.getBioChip(3), ItemUtils.getOrePrefixStack(OrePrefixes.dust, Materials.Wood, 50)}, GT_Values.NF, ItemUtils.getSimpleStack(AgriculturalChem.mWoodBrick, 1), 2000, 16);
    }

    private static void recipeCellulosePulp() {
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{BioRecipes.getBioChip(2), ItemUtils.getSimpleStack(AgriculturalChem.mCellulosePulp, 4)}, GT_Values.NF, ItemUtils.getSimpleStack(Items.field_151121_aF, 1), 1200, 16);
    }

    private static void recipeCatalystCarrier() {
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{BioRecipes.getBioChip(20), ItemUtils.getItemStackOfAmountFromOreDict("plateSteel", CORE.GTNH ? 8 : 4), ItemUtils.getItemStackOfAmountFromOreDict("wireFineCopper", CORE.GTNH ? 4 : 2), ItemUtils.getItemStackOfAmountFromOreDict("screwTin", CORE.GTNH ? 6 : 3)}, GT_Values.NF, CI.getEmptyCatalyst(1), 6000, 16);
    }

    private static void recipeAluminiumSilverCatalyst() {
        CORE.RA.addSixSlotAssemblingRecipe(new ItemStack[]{BioRecipes.getBioChip(4), CI.getEmptyCatalyst(10), ItemUtils.getItemStackOfAmountFromOreDict("dustAluminium", 4), ItemUtils.getItemStackOfAmountFromOreDict("dustSilver", 4)}, GT_Values.NF, CI.getGreenCatalyst(10), 400, 30);
    }

    private static void recipeAceticAcid() {
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getGreenCatalyst(0)}, new FluidStack[]{FluidUtils.getFluidStack(mMethanol, 700), FluidUtils.getFluidStack(mCarbonMonoxide, 300), FluidUtils.getFluidStack(mDistilledWater, 2000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mAceticAcid, 250)}, 2400, 60L, 1);
        CORE.RA.addDehydratorRecipe(new ItemStack[]{CI.getNumberedBioCircuit(14), CI.emptyCells(1)}, FluidUtils.getFluidStack(mFermentationBase, 4000), null, new ItemStack[]{ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 1), ItemUtils.getItemStackOfAmountFromOreDict("cellAceticAcid", 1)}, new int[]{10000, 10000}, 1200, 16);
    }

    private static void processFermentationOreDict() {
        BioRecipes.processOreDictEntry("listAllfruit", mFruits);
        BioRecipes.processOreDictEntry("listAllFruit", mFruits);
        BioRecipes.processOreDictEntry("listAllveggie", mVege);
        BioRecipes.processOreDictEntry("listAllVeggie", mVege);
        BioRecipes.processOreDictEntry("listAllnut", mNuts);
        BioRecipes.processOreDictEntry("listAllNut", mNuts);
        BioRecipes.processOreDictEntry("listAllseed", mSeeds);
        BioRecipes.processOreDictEntry("listAllSeed", mSeeds);
        if (!mFruits.isEmpty()) {
            for (GT_ItemStack g : mFruits) {
                mList_Master_FruitVege.put(g.toStack());
            }
        }
        if (!mVege.isEmpty()) {
            for (GT_ItemStack g : mVege) {
                mList_Master_FruitVege.put(g.toStack());
            }
        }
        if (!mNuts.isEmpty()) {
            for (GT_ItemStack g : mNuts) {
                mList_Master_FruitVege.put(g.toStack());
            }
        }
        if (!mSeeds.isEmpty()) {
            for (GT_ItemStack g : mSeeds) {
                mList_Master_Seeds.put(g.toStack());
            }
        }
    }

    private static void processOreDictEntry(String aOreName, HashSet<GT_ItemStack> mfruits2) {
        ArrayList aTemp = OreDictionary.getOres((String)aOreName);
        if (!aTemp.isEmpty()) {
            for (ItemStack stack : aTemp) {
                mfruits2.add(new GT_ItemStack(stack));
            }
        }
    }

    private static void recipeFermentationBase() {
        BioRecipes.processFermentationOreDict();
        AutoMap<ItemStack> aFruitVege = mList_Master_FruitVege;
        AutoMap<ItemStack> aSeeds = mList_Master_Seeds;
        ArrayList aMap = OreDictionary.getOres((String)"cropSugarbeet");
        for (ItemStack a : aFruitVege) {
            if (aMap.contains(a) || !ItemUtils.checkForInvalidItems(a)) continue;
            CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(2), ItemUtils.getSimpleStack(a, 10)}, new FluidStack[]{FluidUtils.getFluidStack(mDistilledWater, 1000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mFermentationBase, 200)}, 1200, 2L, 0);
        }
        for (ItemStack a : aSeeds) {
            if (!ItemUtils.checkForInvalidItems(a)) continue;
            CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(3), ItemUtils.getSimpleStack(a, 20)}, new FluidStack[]{FluidUtils.getFluidStack(mDistilledWater, 1000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mFermentationBase, 50)}, 1200, 2L, 0);
        }
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(4), ItemUtils.getSimpleStack(Items.field_151120_aE, 16)}, new FluidStack[]{FluidUtils.getFluidStack(mDistilledWater, 1000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mFermentationBase, 75)}, 1800, 30L, 0);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(5), ItemUtils.getSimpleStack(Items.field_151120_aE, 32), ItemUtils.getSimpleStack(ModItems.dustCalciumCarbonate, 4)}, new FluidStack[]{FluidUtils.getFluidStack(mThermalWater, 2000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mFermentationBase, 150)}, 2400, 30L, 0);
        if (OreDictUtils.containsValidEntries("cropSugarbeet")) {
            CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(4), ItemUtils.getItemStackOfAmountFromOreDict("cropSugarbeet", 8)}, new FluidStack[]{FluidUtils.getFluidStack(mDistilledWater, 1000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mFermentationBase, 75)}, 1200, 30L, 0);
            CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(5), ItemUtils.getItemStackOfAmountFromOreDict("cropSugarbeet", 16), ItemUtils.getSimpleStack(ModItems.dustCalciumCarbonate, 4)}, new FluidStack[]{FluidUtils.getFluidStack(mThermalWater, 2000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mFermentationBase, 150)}, 1800, 30L, 0);
        }
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(5), ItemUtils.getItemStackOfAmountFromOreDict("cellFermentationBase", 48), ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownCelluloseFiber, 16), ItemUtils.getSimpleStack(AgriculturalChem.mRedCelluloseFiber, 16)}, new FluidStack[0], new ItemStack[]{ItemUtils.getItemStackOfAmountFromOreDict("cellButanol", 6), ItemUtils.getItemStackOfAmountFromOreDict("cellAcetone", 3), ItemUtils.getItemStackOfAmountFromOreDict("cellEthanol", 1), CI.emptyCells(38)}, new FluidStack[0], 9000, 32L, 1);
    }

    private static void recipePropionicAcid() {
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getGreenCatalyst(0)}, new FluidStack[]{FluidUtils.getFluidStack(mEthylene, 500), FluidUtils.getFluidStack(mCarbonMonoxide, 500), FluidUtils.getFluidStack(mDistilledWater, 2000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mPropionicAcid, 250)}, 400, 60L, 1);
    }

    private static void recipeEthanol() {
        CORE.RA.addDistilleryRecipe(BioRecipes.getBioChip(2), FluidUtils.getFluidStack(mFermentationBase, 1000), FluidUtils.getFluidStack(mEthanol, 100), null, 400, 60, false);
    }

    private static void recipeGoldenBrownCelluloseFiber() {
        CORE.RA.addFluidExtractionRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownCelluloseFiber, 20), FluidUtils.getFluidStack(mAmmonia, 50), 600, 120);
    }

    private static void recipeRedCelluloseFiber() {
        CORE.RA.addExtractorRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mRedCelluloseFiber, 20), ItemUtils.getSimpleStack(ModItems.dustCalciumCarbonate, 5), 600, 240);
    }

    private static void recipeSodiumHydroxide() {
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(4)}, new FluidStack[]{FluidUtils.getFluidStack(mSalineWater, 1000)}, new ItemStack[]{ItemUtils.getSimpleStack(AgriculturalChem.mSodiumHydroxide, 1)}, new FluidStack[]{FluidUtils.getFluidStack(mChlorine, 400), FluidUtils.getFluidStack(mHydrogen, 600)}, 6000, 120L, 1);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(5), ItemUtils.getItemStackOfAmountFromOreDict("dustSodium", 5)}, new FluidStack[]{FluidUtils.getFluidStack(mDistilledWater, 5000)}, new ItemStack[]{ItemUtils.getSimpleStack(AgriculturalChem.mSodiumHydroxide, 5)}, new FluidStack[]{FluidUtils.getFluidStack(mHydrogen, 5000)}, 1200, 60L, 1);
    }

    private static void recipeSodiumCarbonate() {
        if (OreDictUtils.containsValidEntries("fuelCoke")) {
            CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(18), ItemUtils.getItemStackOfAmountFromOreDict("fuelCoke", 3), ItemUtils.getSimpleStack(AgriculturalChem.mSodiumCarbonate, 3), ItemUtils.getSimpleStack(AgriculturalChem.mAluminiumPellet, 6)}, new FluidStack[]{FluidUtils.getFluidStack(mDistilledWater, 1000)}, new ItemStack[]{ItemUtils.getSimpleStack(AgriculturalChem.mSodiumAluminate, 18)}, new FluidStack[]{FluidUtils.getFluidStack(mHydrogen, 200), FluidUtils.getFluidStack(mCarbonDioxide, 1600)}, 2400, 120L, 1);
        }
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(18), ItemUtils.getItemStackOfAmountFromOreDict("dustCoal", 6), ItemUtils.getSimpleStack(AgriculturalChem.mSodiumCarbonate, 4), ItemUtils.getSimpleStack(AgriculturalChem.mAluminiumPellet, 6)}, new FluidStack[]{FluidUtils.getFluidStack(mDistilledWater, 1000)}, new ItemStack[]{ItemUtils.getSimpleStack(AgriculturalChem.mSodiumAluminate, 16)}, new FluidStack[]{FluidUtils.getFluidStack(mHydrogen, 100), FluidUtils.getFluidStack(mCarbonDioxide, 1750)}, 3600, 120L, 1);
    }

    private static void recipePelletMold() {
        GregtechItemList.Pellet_Mold.set(ItemUtils.getSimpleStack(AgriculturalChem.mPelletMold, 1));
        GT_Values.RA.addLatheRecipe(ALLOY.TUMBAGA.getBlock(1), GregtechItemList.Pellet_Mold.get(1L, new Object[0]), null, 9000, 90);
    }

    private static void recipeAluminiumPellet() {
        AutoMap<String> aOreNames = new AutoMap<String>();
        aOreNames.put("Lazurite");
        aOreNames.put("Bauxite");
        aOreNames.put("Grossular");
        aOreNames.put("Pyrope");
        aOreNames.put("Sodalite");
        aOreNames.put("Spodumene");
        aOreNames.put("Ruby");
        aOreNames.put("Sapphire");
        aOreNames.put("GreenSapphire");
        HashMap<String, Integer> aOreData1 = new HashMap<String, Integer>();
        HashMap<String, Integer> aOreData2 = new HashMap<String, Integer>();
        HashMap<String, Integer> aOreData3 = new HashMap<String, Integer>();
        aOreData1.put("Lazurite", 120);
        aOreData1.put("Bauxite", 90);
        aOreData1.put("Grossular", 90);
        aOreData1.put("Pyrope", 90);
        aOreData1.put("Sodalite", 90);
        aOreData1.put("Spodumene", 90);
        aOreData1.put("Ruby", 60);
        aOreData1.put("Sapphire", 30);
        aOreData1.put("GreenSapphire", 30);
        aOreData2.put("Lazurite", 14);
        aOreData2.put("Bauxite", 39);
        aOreData2.put("Grossular", 20);
        aOreData2.put("Pyrope", 20);
        aOreData2.put("Sodalite", 11);
        aOreData2.put("Spodumene", 10);
        aOreData2.put("Ruby", 6);
        aOreData2.put("Sapphire", 5);
        aOreData2.put("GreenSapphire", 5);
        aOreData3.put("Lazurite", 3);
        aOreData3.put("Bauxite", 16);
        aOreData3.put("Grossular", 2);
        aOreData3.put("Pyrope", 2);
        aOreData3.put("Sodalite", 3);
        aOreData3.put("Spodumene", 1);
        aOreData3.put("Ruby", 2);
        aOreData3.put("Sapphire", 2);
        aOreData3.put("GreenSapphire", 2);
        HashMap<String, ItemStack> aOreCache = new HashMap<String, ItemStack>();
        Iterator iterator = aOreNames.iterator();
        while (iterator.hasNext()) {
            String aOreName;
            String aTemp = aOreName = (String)iterator.next();
            aOreName = "crushedPurified" + aOreName;
            if (!ItemUtils.doesOreDictHaveEntryFor(aOreName)) continue;
            aOreCache.put(aTemp, ItemUtils.getItemStackOfAmountFromOreDict(aOreName, 1));
        }
        for (String aOreName : aOreNames) {
            CORE.RA.addChemicalPlantRecipe(new ItemStack[]{CI.getNumberedBioCircuit(14), ItemUtils.getSimpleStack((ItemStack)aOreCache.get(aOreName), (int)((Integer)aOreData2.get(aOreName)))}, new FluidStack[]{FluidUtils.getSteam(2000 * (Integer)aOreData2.get(aOreName))}, new ItemStack[]{ItemUtils.getSimpleStack(AgriculturalChem.mCleanAluminiumMix, (int)Math.ceil((double)((Integer)aOreData3.get(aOreName)).intValue() * 1.4))}, new FluidStack[]{FluidUtils.getFluidStack(AgriculturalChem.RedMud, 100 * (int)Math.ceil((double)((Integer)aOreData3.get(aOreName)).intValue() * 1.4))}, 1200, ((Integer)aOreData1.get(aOreName)).intValue(), aOreName.equals("Bauxite") ? 2 : 1);
        }
        GT_Values.RA.addExtruderRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mCleanAluminiumMix, 3), ItemUtils.getSimpleStack(AgriculturalChem.mPelletMold, 0), ItemUtils.getSimpleStack(AgriculturalChem.mAluminiumPellet, 4), 600, 64);
    }

    private static void recipeAlumina() {
        GT_Values.RA.addBlastRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mSodiumAluminate, 24), ItemUtils.getSimpleStack(AgriculturalChem.mSodiumHydroxide, 3), FluidUtils.getFluidStack(mCarbonDioxide, 6000), GT_Values.NF, ItemUtils.getSimpleStack(AgriculturalChem.mAlumina, 24), ItemUtils.getSimpleStack(AgriculturalChem.mSodiumCarbonate, 2), 2400, 120, 1200);
    }

    private static void recipeAluminium() {
        GT_Values.RA.addBlastRecipe(ItemUtils.getSimpleStack(AgriculturalChem.mAlumina, 24), ItemUtils.getItemStackOfAmountFromOreDict("dustCarbon", 4), GT_Values.NF, GT_Values.NF, ItemUtils.getItemStackOfAmountFromOreDict("dustAluminium", 24), null, 2400, 120, 1600);
    }

    private static void recipeCalciumCarbonate() {
    }

    private static void recipeLithiumChloride() {
        if (OreDictUtils.containsValidEntries("dustRockSalt")) {
            GT_Values.RA.addElectrolyzerRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustRockSalt", 8), ItemUtils.getSimpleStack(AgriculturalChem.mLithiumChloride, 10), FluidUtils.getFluidStack(mAir, 4000), FluidUtils.getFluidStack(mChlorine, 500), ItemUtils.getItemStackOfAmountFromOreDict("dustLithium", 2), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallLithium", 3), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallLithium", 3), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyLithium", 5), ItemUtils.getItemStackOfAmountFromOreDict("dustPotassium", 2), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallPotassium", 5), new int[]{7500, 8000, 8500, 9000, 7500, 8500}, 1800, 60);
        }
        if (OreDictUtils.containsValidEntries("dustPotash")) {
            GT_Values.RA.addElectrolyzerRecipe(ItemUtils.getItemStackOfAmountFromOreDict("dustPotash", 10), ItemUtils.getSimpleStack(AgriculturalChem.mLithiumChloride, 16), FluidUtils.getFluidStack(mThermalWater, 2000), FluidUtils.getFluidStack(mChlorine, 250), ItemUtils.getItemStackOfAmountFromOreDict("dustLithium", 3), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallLithium", 5), ItemUtils.getItemStackOfAmountFromOreDict("dustSmallLithium", 5), ItemUtils.getItemStackOfAmountFromOreDict("dustTinyLithium", 7), ItemUtils.getItemStackOfAmountFromOreDict("dustAsh", 2), ItemUtils.getItemStackOfAmountFromOreDict("dustAsh", 2), new int[]{7500, 8000, 8500, 9000, 9000, 9000}, 1350, 90);
        }
    }

    private static void recipeAlginicAcid() {
    }

    private static void recipeSulfuricAcid() {
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(7), ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownCelluloseFiber, 10), ItemUtils.getSimpleStack(AgriculturalChem.mBrownAlgaeBiosmass, 30)}, new FluidStack[]{FluidUtils.getFluidStack(mDistilledWater, 2000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mSulfuricAcid, 50)}, 1200, 60L, 1);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(7), ItemUtils.getSimpleStack(AgriculturalChem.mRedCelluloseFiber, 5), ItemUtils.getSimpleStack(AgriculturalChem.mRedAlgaeBiosmass, 30)}, new FluidStack[]{FluidUtils.getFluidStack(mDistilledWater, 2000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mSulfuricAcid, 250)}, 1200, 120L, 2);
    }

    private static void recipeUrea() {
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(9)}, new FluidStack[]{FluidUtils.getFluidStack(mAmmonia, 600), FluidUtils.getFluidStack(mCarbonDioxide, 400)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mUrea, 400), FluidUtils.getFluidStack(mDistilledWater, 600)}, 2400, 30L, 1);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(9)}, new FluidStack[]{FluidUtils.getFluidStack(mUrea, 200), FluidUtils.getFluidStack(mFormaldehyde, 200)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mLiquidResin, 200)}, 2400, 30L, 1);
    }

    private static void recipeRawBioResin() {
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(3), ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 10), ItemUtils.getSimpleStack(Blocks.field_150346_d, 20)}, new FluidStack[]{FluidUtils.getFluidStack(mDistilledWater, 1000)}, new ItemStack[]{ItemUtils.getSimpleStack(AgriculturalChem.mRawBioResin, 1)}, new FluidStack[0], 1200, 30L, 1);
    }

    private static void recipeLiquidResin() {
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(3), ItemUtils.getSimpleStack(AgriculturalChem.mRawBioResin, 1)}, new FluidStack[]{FluidUtils.getFluidStack(mEthanol, 200)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mLiquidResin, 50)}, 1200, 30L, 1);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(3), ItemUtils.getSimpleStack(AgriculturalChem.mCellulosePulp, 8)}, new FluidStack[]{FluidUtils.getFluidStack(mLiquidResin, 144)}, new ItemStack[]{ItemUtils.getSimpleStack(Ic2Items.resin, 1)}, new FluidStack[0], 2400, 30L, 1);
    }

    private static void recipeCompost() {
        ItemStack aFert;
        if (LoadedMods.Forestry) {
            aFert = ItemUtils.getSimpleStack(AgriculturalChem.aFertForestry, 2);
            CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(11), ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 16), ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 8)}, new FluidStack[]{FluidUtils.getFluidStack(mUrea, 500)}, new ItemStack[]{aFert}, new FluidStack[0], 2400, 60L, 1);
        }
        aFert = ItemUtils.getSimpleStack(AgriculturalChem.aFertIC2, 2);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(12), ItemUtils.getSimpleStack(AgriculturalChem.mGreenAlgaeBiosmass, 16), ItemUtils.getSimpleStack(AgriculturalChem.mCompost, 8)}, new FluidStack[]{FluidUtils.getFluidStack(mUrea, 500)}, new ItemStack[]{aFert}, new FluidStack[0], 2400, 60L, 1);
    }

    private static void recipeMethane() {
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(12), ItemUtils.getSimpleStack(AgriculturalChem.mAlgaeBiosmass, 20)}, new FluidStack[]{FluidUtils.getFluidStack(mDistilledWater, 500)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mMethane, 20)}, 400, 8L, 1);
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(13), ItemUtils.getSimpleStack(AgriculturalChem.mCelluloseFiber, 64), ItemUtils.getSimpleStack(AgriculturalChem.mGoldenBrownCelluloseFiber, 48), ItemUtils.getSimpleStack(AgriculturalChem.mRedCelluloseFiber, 32)}, new FluidStack[]{FluidUtils.getFluidStack(mMethane, 2000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mEthylene, 1250)}, 1200, 60L, 1);
    }

    private static void recipeBenzene() {
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(19), CI.getGreenCatalyst(0)}, new FluidStack[]{FluidUtils.getFluidStack(mMethane, 1000)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mBenzene, 500)}, 160, 120L, 2);
    }

    private static void recipeStyrene() {
        CORE.RA.addChemicalPlantRecipe(new ItemStack[]{BioRecipes.getBioChip(20), CI.getGreenCatalyst(0)}, new FluidStack[]{FluidUtils.getFluidStack(mEthylbenzene, 100)}, new ItemStack[0], new FluidStack[]{FluidUtils.getFluidStack(mStyrene, 25)}, 320, 480L, 2);
    }

    private static void recipeBioChip() {
        GT_ModHandler.addShapelessCraftingRecipe((ItemStack)GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 0L, new Object[0]), (long)0L, (Object[])new Object[]{OrePrefixes.circuit.get((Object)Materials.Primitive)});
        long bits = 0L;
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 1L, new Object[0]), bits, new Object[]{"d  ", " P ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 2L, new Object[0]), bits, new Object[]{" d ", " P ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 3L, new Object[0]), bits, new Object[]{"  d", " P ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 4L, new Object[0]), bits, new Object[]{"   ", " Pd", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 5L, new Object[0]), bits, new Object[]{"   ", " P ", "  d", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 6L, new Object[0]), bits, new Object[]{"   ", " P ", " d ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 7L, new Object[0]), bits, new Object[]{"   ", " P ", "d  ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 8L, new Object[0]), bits, new Object[]{"   ", "dP ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 9L, new Object[0]), bits, new Object[]{"P d", "   ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 10L, new Object[0]), bits, new Object[]{"P  ", "  d", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 11L, new Object[0]), bits, new Object[]{"P  ", "   ", "  d", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 12L, new Object[0]), bits, new Object[]{"P  ", "   ", " d ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 13L, new Object[0]), bits, new Object[]{"  P", "   ", "  d", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 14L, new Object[0]), bits, new Object[]{"  P", "   ", " d ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 15L, new Object[0]), bits, new Object[]{"  P", "   ", "d  ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 16L, new Object[0]), bits, new Object[]{"  P", "d  ", "   ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 17L, new Object[0]), bits, new Object[]{"   ", "   ", "d P", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 18L, new Object[0]), bits, new Object[]{"   ", "d  ", "  P", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 19L, new Object[0]), bits, new Object[]{"d  ", "   ", "  P", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 20L, new Object[0]), bits, new Object[]{" d ", "   ", "  P", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 21L, new Object[0]), bits, new Object[]{"d  ", "   ", "P  ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 22L, new Object[0]), bits, new Object[]{" d ", "   ", "P  ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 23L, new Object[0]), bits, new Object[]{"  d", "   ", "P  ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
        BioRecipes.addCraftingRecipe(GregtechItemList.Circuit_BioRecipeSelector.getWithDamage(1L, 24L, new Object[0]), bits, new Object[]{"   ", "  d", "P  ", Character.valueOf('P'), GregtechItemList.Circuit_BioRecipeSelector.getWildcard(1L, new Object[0])});
    }

    public static boolean addCraftingRecipe(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        Method mAddRecipe = ReflectionUtils.getMethod(GT_ModHandler.class, "addCraftingRecipe", ItemStack.class, Enchantment[].class, int[].class, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Boolean.TYPE, Object[].class);
        boolean didInvoke = false;
        if (mAddRecipe != null) {
            try {
                didInvoke = (Boolean)mAddRecipe.invoke(null, aResult, new Enchantment[0], new int[0], false, false, false, false, false, false, false, false, false, false, false, false, true, aRecipe);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return didInvoke;
    }

    static {
        mFruits = new HashSet();
        mVege = new HashSet();
        mNuts = new HashSet();
        mSeeds = new HashSet();
        mList_Master_FruitVege = new AutoMap();
        mList_Master_Seeds = new AutoMap();
    }
}

