/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.nei.GTPP_NEI_DefaultHandler;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class GT_NEI_MultiTreeGrowthSimulator
extends GTPP_NEI_DefaultHandler {
    private static final HashMap<Integer, Pair<Integer, Integer>> mInputSlotMap;
    private static final HashMap<Integer, Pair<Integer, Integer>> mOutputSlotMap;

    public GT_NEI_MultiTreeGrowthSimulator() {
        super(GTPP_Recipe.GTPP_Recipe_Map.sTreeSimFakeRecipes);
    }

    @Override
    public TemplateRecipeHandler newInstance() {
        return new GT_NEI_MultiTreeGrowthSimulator();
    }

    @Override
    public GTPP_NEI_DefaultHandler.CachedDefaultRecipe createCachedRecipe(GT_Recipe aRecipe) {
        return new TreeSimDefaultRecipe(aRecipe);
    }

    @Override
    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)-4, (int)-8, (int)1, (int)3, (int)174, (int)89);
    }

    @Override
    public String getGuiTexture() {
        return "gregtech:textures/gui/basicmachines/FissionFuel.png";
    }

    @Override
    public void drawExtras(int aRecipeIndex) {
        if (ModItems.fluidFertBasic != null) {
            GT_NEI_MultiTreeGrowthSimulator.drawText(5, 90, "Chance of Sapling output if", -16777216);
            GT_NEI_MultiTreeGrowthSimulator.drawText(5, 100, "" + ModItems.fluidFertBasic.getLocalizedName() + " is provided.", -16777216);
            GT_NEI_MultiTreeGrowthSimulator.drawText(5, 110, "This is optional.", -16777216);
        }
    }

    @Override
    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack aStack, List<String> currenttip, int aRecipeIndex) {
        TemplateRecipeHandler.CachedRecipe tObject = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(aRecipeIndex);
        if (tObject instanceof GTPP_NEI_DefaultHandler.CachedDefaultRecipe) {
            GTPP_NEI_DefaultHandler.CachedDefaultRecipe tRecipe = (GTPP_NEI_DefaultHandler.CachedDefaultRecipe)tObject;
            for (PositionedStack tStack : tRecipe.mOutputs) {
                if (aStack != tStack.item) continue;
                if (!(tStack instanceof GTPP_NEI_DefaultHandler.FixedPositionedStack) || ((GTPP_NEI_DefaultHandler.FixedPositionedStack)tStack).mChance <= 0 || ((GTPP_NEI_DefaultHandler.FixedPositionedStack)tStack).mChance == 10000 || ModItems.fluidFertBasic == null) break;
                currenttip.add("Chance output if " + ModItems.fluidFertBasic.getLocalizedName() + " is provided.");
                break;
            }
        }
        return currenttip;
    }

    static {
        int x;
        int y;
        mInputSlotMap = new HashMap();
        mOutputSlotMap = new HashMap();
        int[] aSlotX = new int[]{12, 30, 48};
        int[] aSlotY = new int[]{5, 23, 41, 64};
        int aIndex = 0;
        for (y = 0; y < aSlotY.length; ++y) {
            for (x = 0; x < aSlotX.length; ++x) {
                mInputSlotMap.put(aIndex++, new Pair<Integer, Integer>(aSlotX[x], aSlotY[y]));
            }
        }
        aSlotX = new int[]{102, 120, 138};
        aIndex = 0;
        for (y = 0; y < aSlotY.length; ++y) {
            for (x = 0; x < aSlotX.length; ++x) {
                mOutputSlotMap.put(aIndex++, new Pair<Integer, Integer>(aSlotX[x], aSlotY[y]));
            }
        }
    }

    public class TreeSimDefaultRecipe
    extends GTPP_NEI_DefaultHandler.CachedDefaultRecipe {
        public TreeSimDefaultRecipe(GT_Recipe aRecipe) {
            super(aRecipe);
        }

        @Override
        public void handleSlots() {
            ItemStack aRepStack;
            int y;
            int x;
            int i;
            int aInputItemsCount = this.mRecipe.mInputs.length;
            int aInputFluidsCount = this.mRecipe.mFluidInputs.length;
            int aOutputItemsCount = this.mRecipe.mOutputs.length;
            int aInputSlotsUsed = 0;
            int aOutputSlotsUsed = 0;
            int aSlotToCheck = 0;
            if (this.mRecipe.mSpecialItems != null) {
                this.mInputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(this.mRecipe.mSpecialItems, 120, 52));
            }
            if (aInputItemsCount > 0) {
                if (aInputItemsCount > 9) {
                    aInputItemsCount = 9;
                }
                for (i = 0; i < aInputItemsCount; ++i) {
                    x = (Integer)((Pair)mInputSlotMap.get(aInputSlotsUsed)).getKey();
                    y = (Integer)((Pair)mInputSlotMap.get(aInputSlotsUsed)).getValue();
                    if ((aRepStack = this.mRecipe.getRepresentativeInput(aSlotToCheck++)) == null) continue;
                    this.mInputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(aRepStack, x, y));
                    ++aInputSlotsUsed;
                }
            }
            aSlotToCheck = 0;
            if (aOutputItemsCount > 0) {
                if (aOutputItemsCount > 9) {
                    aOutputItemsCount = 9;
                }
                for (i = 0; i < aOutputItemsCount; ++i) {
                    x = (Integer)((Pair)mOutputSlotMap.get(aOutputSlotsUsed)).getKey();
                    y = (Integer)((Pair)mOutputSlotMap.get(aOutputSlotsUsed)).getValue();
                    aRepStack = this.mRecipe.getOutput(aSlotToCheck);
                    if (aRepStack != null) {
                        this.mOutputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(aRepStack, x, y, this.mRecipe.getOutputChance(aSlotToCheck)));
                        ++aOutputSlotsUsed;
                    }
                    ++aSlotToCheck;
                }
            }
            aSlotToCheck = aInputSlotsUsed = 9;
            if (aInputFluidsCount > 0) {
                for (i = 0; i < aInputFluidsCount; ++i) {
                    x = (Integer)((Pair)mInputSlotMap.get(aSlotToCheck)).getKey();
                    y = (Integer)((Pair)mInputSlotMap.get(aSlotToCheck)).getValue();
                    this.mInputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidInputs[i], (boolean)true), x, y));
                    ++aSlotToCheck;
                    ++aInputSlotsUsed;
                }
            }
        }
    }
}

