/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import gregtech.api.enums.ItemList;
import gregtech.api.util.GTPP_Recipe;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.nei.GTPP_NEI_DefaultHandler;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class GT_NEI_FluidReactor
extends GTPP_NEI_DefaultHandler {
    public GT_NEI_FluidReactor() {
        super(GTPP_Recipe.GTPP_Recipe_Map.sChemicalPlantRecipes);
    }

    @Override
    public TemplateRecipeHandler newInstance() {
        return new GT_NEI_FluidReactor();
    }

    @Override
    public GTPP_NEI_DefaultHandler.CachedDefaultRecipe createCachedRecipe(GT_Recipe aRecipe) {
        return new ChemPlantDefaultRecipe(aRecipe);
    }

    @Override
    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack aStack, List<String> currenttip, int aRecipeIndex) {
        TemplateRecipeHandler.CachedRecipe tObject = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(aRecipeIndex);
        if (tObject instanceof ChemPlantDefaultRecipe) {
            ChemPlantDefaultRecipe tRecipe = (ChemPlantDefaultRecipe)tObject;
            for (PositionedStack tStack : tRecipe.mOutputs) {
                if (aStack != tStack.item) continue;
                if (!(tStack instanceof GTPP_NEI_DefaultHandler.FixedPositionedStack) || ((GTPP_NEI_DefaultHandler.FixedPositionedStack)tStack).mChance <= 0 || ((GTPP_NEI_DefaultHandler.FixedPositionedStack)tStack).mChance == 10000) break;
                currenttip.add("Chance: " + ((GTPP_NEI_DefaultHandler.FixedPositionedStack)tStack).mChance / 100 + "." + (((GTPP_NEI_DefaultHandler.FixedPositionedStack)tStack).mChance % 100 < 10 ? "0" + ((GTPP_NEI_DefaultHandler.FixedPositionedStack)tStack).mChance % 100 : Integer.valueOf(((GTPP_NEI_DefaultHandler.FixedPositionedStack)tStack).mChance % 100)) + "%");
                break;
            }
            for (PositionedStack tStack : tRecipe.mInputs) {
                if (!GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)tStack.item)) continue;
                if (ItemList.Display_Fluid.isStackEqual((Object)tStack.item, true, true) || tStack.item.field_77994_a != 0) break;
                if (ItemUtils.isCatalyst(aStack)) {
                    currenttip.add("Does not always get consumed in the process");
                    currenttip.add("Higher tier pipe casings allow this item to last longer");
                    break;
                }
                if (!ItemUtils.isControlCircuit(aStack)) break;
                currenttip.add("Does not get consumed in the process");
                break;
            }
        }
        return currenttip;
    }

    @Override
    public void drawExtras(int aRecipeIndex) {
        long tEUt = ((ChemPlantDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mEUt;
        int tDuration = ((ChemPlantDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mDuration;
        if (tEUt != 0L) {
            GT_NEI_FluidReactor.drawText(10, 73, "Total: " + MathUtils.formatNumbers((long)tDuration * tEUt) + " EU", -16777216);
            if (this.mRecipeMap.mShowVoltageAmperageInNEI) {
                GT_NEI_FluidReactor.drawText(10, 83, "Voltage: " + MathUtils.formatNumbers(tEUt / (long)this.mRecipeMap.mAmperage) + " EU/t", -16777216);
                GT_NEI_FluidReactor.drawText(10, 93, "Amperage: " + this.mRecipeMap.mAmperage, -16777216);
            } else {
                GT_NEI_FluidReactor.drawText(10, 93, "Voltage: unspecified", -16777216);
                GT_NEI_FluidReactor.drawText(10, 103, "Amperage: unspecified", -16777216);
            }
        }
        if (tDuration > 0) {
            GT_NEI_FluidReactor.drawText(10, 103, "Time: " + (tDuration < 20 ? "< 1" : MathUtils.formatNumbers(0.05 * (double)tDuration)) + " secs", -16777216);
        }
        if (GT_Utility.isStringValid((Object)this.mRecipeMap.mNEISpecialValuePre) || GT_Utility.isStringValid((Object)this.mRecipeMap.mNEISpecialValuePost)) {
            int aTier = ((ChemPlantDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mSpecialValue;
            String aTierMaterial = " - ";
            if (aTier <= 0) {
                aTierMaterial = aTierMaterial + "Bronze";
            } else if (aTier == 1) {
                aTierMaterial = aTierMaterial + "Steel";
            } else if (aTier == 2) {
                aTierMaterial = aTierMaterial + "Aluminium";
            } else if (aTier == 3) {
                aTierMaterial = aTierMaterial + "Stainless Steel";
            } else if (aTier == 4) {
                aTierMaterial = aTierMaterial + "Titanium";
            } else if (aTier == 5) {
                aTierMaterial = aTierMaterial + "Tungsten Steel";
            } else if (aTier == 6) {
                aTierMaterial = aTierMaterial + "Laurenium";
            } else if (aTier == 7) {
                aTierMaterial = aTierMaterial + "Botmium";
            }
            GT_NEI_FluidReactor.drawText(10, 113, this.mRecipeMap.mNEISpecialValuePre + ((ChemPlantDefaultRecipe)((Object)this.arecipes.get((int)aRecipeIndex))).mRecipe.mSpecialValue * this.mRecipeMap.mNEISpecialValueMultiplier + aTierMaterial, -16777216);
        }
    }

    public class ChemPlantDefaultRecipe
    extends GTPP_NEI_DefaultHandler.CachedDefaultRecipe {
        public ChemPlantDefaultRecipe(GT_Recipe aRecipe) {
            super(aRecipe);
        }

        @Override
        public void handleSlots() {
            int tStartIndex = 0;
            if (this.mRecipe.getRepresentativeInput(tStartIndex) != null) {
                this.mInputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 3, -4));
            }
            if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                this.mInputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 21, -4));
            }
            if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                this.mInputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 39, -4));
            }
            if (this.mRecipe.getRepresentativeInput(++tStartIndex) != null) {
                this.mInputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(this.mRecipe.getRepresentativeInput(tStartIndex), 57, -4));
            }
            ++tStartIndex;
            if (this.mRecipe.mSpecialItems != null) {
                this.mInputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(this.mRecipe.mSpecialItems, 120, 52));
            }
            if (this.mRecipe.getOutput(tStartIndex = 0) != null) {
                this.mOutputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 5, this.mRecipe.getOutputChance(tStartIndex)));
            }
            if (this.mRecipe.getOutput(++tStartIndex) != null) {
                this.mOutputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 5, this.mRecipe.getOutputChance(tStartIndex)));
            }
            if (this.mRecipe.getOutput(++tStartIndex) != null) {
                this.mOutputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 102, 23, this.mRecipe.getOutputChance(tStartIndex)));
            }
            if (this.mRecipe.getOutput(++tStartIndex) != null) {
                this.mOutputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(this.mRecipe.getOutput(tStartIndex), 120, 23, this.mRecipe.getOutputChance(tStartIndex)));
            }
            ++tStartIndex;
            if (this.mRecipe.mFluidInputs.length >= 1) {
                if (this.mRecipe.mFluidInputs[0] != null && this.mRecipe.mFluidInputs[0].getFluid() != null) {
                    this.mInputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidInputs[0], (boolean)true), 3, 31));
                }
                if (this.mRecipe.mFluidInputs.length > 1 && this.mRecipe.mFluidInputs[1] != null && this.mRecipe.mFluidInputs[1].getFluid() != null) {
                    this.mInputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidInputs[1], (boolean)true), 21, 31));
                }
                if (this.mRecipe.mFluidInputs.length > 2 && this.mRecipe.mFluidInputs[2] != null && this.mRecipe.mFluidInputs[2].getFluid() != null) {
                    this.mInputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidInputs[2], (boolean)true), 39, 31));
                }
                if (this.mRecipe.mFluidInputs.length > 3 && this.mRecipe.mFluidInputs[3] != null && this.mRecipe.mFluidInputs[3].getFluid() != null) {
                    this.mInputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidInputs[3], (boolean)true), 57, 31));
                }
            }
            if (this.mRecipe.mFluidOutputs.length > 0) {
                if (this.mRecipe.mFluidOutputs[0] != null && this.mRecipe.mFluidOutputs[0].getFluid() != null) {
                    this.mOutputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidOutputs[0], (boolean)true), 138, 5));
                }
                if (this.mRecipe.mFluidOutputs.length > 1 && this.mRecipe.mFluidOutputs[1] != null && this.mRecipe.mFluidOutputs[1].getFluid() != null) {
                    this.mOutputs.add(new GTPP_NEI_DefaultHandler.FixedPositionedStack(GT_Utility.getFluidDisplayStack((FluidStack)this.mRecipe.mFluidOutputs[1], (boolean)true), 138, 23));
                }
            }
        }
    }
}

